/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RHForeignKeyAttr
extends RowHandler {
    public static final String OBJECT_TYPE = "FOREIGN_KEY_ATTR";
    Map fkMap = new HashMap();

    public RHForeignKeyAttr(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addForeignKey(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    public void processOutOfChain(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addForeignKey(line);
        }
    }

    public void cleanMap() {
        this.fkMap = new HashMap();
    }

    private void addForeignKey(VarFileLine line) {
        String id = this.getField(line, "general_id");
        String name = this.getField(line, "FOREIGN_KEY_NAME");
        Attribute delegate = (Attribute)this.getAllCreatedObjects().get(this.getField(line, "FOREIGN_KEY_REL_ATTR"));
        if (delegate == null) {
            String fkid = this.getField(line, "FOREIGN_KEY_REL_FK");
            delegate = (Attribute)this.getAllCreatedObjects().get(fkid);
            if (delegate == null) {
                delegate = (Attribute)this.fkMap.get(fkid);
            }
        }
        Iterator it = this.getAllSelectedLines().iterator();
        boolean foundIt = false;
        block0: while (it.hasNext() && !foundIt) {
            KeyObject pk;
            Attribute fk;
            int i;
            String fkID;
            VarFileLine selectedLine = (VarFileLine)it.next();
            if (!selectedLine.getType().equalsIgnoreCase("PARTNERSHIPFOREIGN") && !selectedLine.getType().equalsIgnoreCase("PARTNERSHIPFOREIG2") || !id.equalsIgnoreCase(fkID = this.getField(selectedLine, "FOREIGN_KEY_PS_FOREIGN"))) continue;
            String relID = this.getField(selectedLine, "general_id");
            Relation relation = (Relation)this.getAllCreatedObjects().get(relID);
            if (relation == null) continue;
            Entity entity = relation.getTargetEntity();
            Attribute[] attributes = relation.getFKAttributes(entity);
            for (i = 0; i < attributes.length; ++i) {
                fk = attributes[i];
                if (delegate != fk.getDelegate()) continue;
                fk.setName(name);
                this.fkMap.put(id, fk);
                foundIt = true;
                if (!relation.belongsToTargetPK() || (pk = entity.getPK()) == null || pk.contains(fk)) break;
                pk.add(fk);
                break;
            }
            entity = relation.getSourceEntity();
            attributes = relation.getFKAttributes(entity);
            for (i = 0; i < attributes.length; ++i) {
                fk = attributes[i];
                if (delegate != fk.getDelegate()) continue;
                fk.setName(name);
                this.fkMap.put(id, fk);
                foundIt = true;
                if (!relation.belongsToSourcePK() || (pk = entity.getPK()) == null || pk.contains(fk)) continue block0;
                pk.add(fk);
                continue block0;
            }
        }
        this.removeSelectedLine(line);
    }
}

