/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHAttributeSynonym;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;

public class RHAttribute
extends RowHandler {
    public static final String OBJECT_TYPE = "ATTRIBUTE";
    List lines = new ArrayList();

    public RHAttribute(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
            this.lines.add(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAttribute(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createAttribute(VarFileLine line) {
        String entityKey = this.getField(line, "attribute_entity_id").trim();
        if (entityKey.equalsIgnoreCase("0")) {
            this.removeSelectedLine(line);
        } else {
            Entity entity = (Entity)this.getCreatedObject(entityKey);
            if (entity != null) {
                Domain domain;
                Attribute attribute = entity.createAttribute(this.getField(line, "attribute_name"));
                this.setCreatorChanger(attribute, line);
                if (this.getField(line, "attribute_nulls_allowed").equalsIgnoreCase("Y")) {
                    attribute.setNullsAllowed(true);
                } else {
                    attribute.setNullsAllowed(false);
                }
                String keyDomain = this.getField(line, "attribute_domain").trim();
                if ("0".equalsIgnoreCase(keyDomain)) {
                    keyDomain = this.getDomainKeyFromDimension(line);
                }
                if ((domain = this.getDomain(keyDomain)) != null) {
                    attribute.setDomain(domain);
                }
                attribute.setComment(this.getComment(line));
                attribute.setNotes(this.getNotes(line, "note_attr_id"));
                attribute.setSynonym(this.getSynonym(line));
                attribute.setSource(this.getField(line, "ATTRIBUTE_SOURCE"));
                String type = this.getField(line, "ATTRIBUTE_TYPE");
                if ("S".equalsIgnoreCase(type)) {
                    attribute.setSourceType("System");
                } else if ("M".equalsIgnoreCase(type)) {
                    attribute.setSourceType("Manual");
                } else if ("D".equalsIgnoreCase(type)) {
                    attribute.setSourceType("Derived");
                } else if ("A".equalsIgnoreCase(type)) {
                    attribute.setSourceType("Aggregate");
                }
                this.addCreatedObject(this.getField(line, "general_id").trim(), attribute);
                this.removeSelectedLine(line);
            }
        }
    }

    private Domain getDomain(String keyDomain) {
        return (Domain)this.getAllCreatedObjects().get(keyDomain);
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "ATTRIBUTE_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHAttributeSynonym.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID = this.getField(selectedLine, "general_id");
            if (!id.equalsIgnoreCase(lineID) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }

    private String getDomainKeyFromDimension(VarFileLine line) {
        String domainKey = "0";
        String dimensionID = this.getField(line, "ATTRIBUTE_DIMENSION");
        VarFileLine dimensionLine = this.getCommentLine(dimensionID, "DIMENSION");
        if (dimensionLine != null) {
            domainKey = this.getField(dimensionLine, "DIMENSION_DOMAIN_ID");
        }
        return domainKey;
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }
}

