/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.OptimizerHint;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOTable;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOView
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "VIEW";
    private Map aliases = new HashMap();
    private List<String> sequences = new ArrayList<String>();
    private ODOTable tableHandler = null;
    private static final Logger LOGGER = new Logger(ODOView.class);
    PreparedStatement s_statement;
    PreparedStatement wh_statement;
    PreparedStatement col_statement;
    PreparedStatement colref_statement;
    PreparedStatement hints_statement;
    PreparedStatement tr_statement;
    PreparedStatement vstatement;
    PreparedStatement alias_statement;

    public ODOView(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            String objRef;
            String ivid;
            String id;
            String tableName;
            StringBuffer buffer;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                rs = null;
                if (nvstatement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid,ORACLE_OBJECT_TYPE_REFERENCE, OID_ATTRIBUTE_LIST, OVERRIDE_SELECT_TEXT_FLAG, a.REMARK ");
                    buffer.append("from CI_VIEW_DEFINITIONS a,sdd_folder_members b , i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    nvstatement = sqlConnection.prepareStatement(buffer.toString());
                }
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOTable.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    objRef = rs.getString(4);
                    String oid_list = rs.getString(5);
                    String flag = rs.getString(6);
                    String remark = rs.getString(7);
                    if (oid_list != null && oid_list.length() > 0) {
                        oid_list = oid_list.trim();
                    }
                    ODObject odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    odTable.setDescription(remark);
                    odTable.objectReference = objRef;
                    odTable.oid_list = oid_list;
                    if ("Y".equals(flag)) {
                        odTable.overrideSelectText = true;
                    }
                    odTable.containerType = odNext.containerType;
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            if (statement == null) {
                buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid,ORACLE_OBJECT_TYPE_REFERENCE,OVERRIDE_SELECT_TEXT_FLAG, a.REMARK ");
                buffer.append("from CI_VIEW_DEFINITIONS a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM CI_VIEW_DEFINITIONS F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOView.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                objRef = rs.getString(4);
                String flag = rs.getString(5);
                String remark = rs.getString(6);
                ODObject odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                odTable.setDescription(remark);
                odTable.objectReference = objRef;
                if ("Y".equals(flag)) {
                    odTable.overrideSelectText = true;
                }
                odTable.containerType = odNext.containerType;
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        ArrayList<Helper> list = new ArrayList<Helper>();
        this.s_statement = null;
        this.wh_statement = null;
        this.col_statement = null;
        this.tr_statement = null;
        this.vstatement = null;
        this.alias_statement = null;
        for (ODObject odObject : selectedObjects) {
            TableViewProxyOracle tableViewProxy;
            List<OptimizerHint> hints;
            List<String> unfoundRefs;
            String whereStm;
            String selectStm;
            String createStm;
            if (!OBJECT_TYPE.equalsIgnoreCase(odObject.getType())) continue;
            String id = odObject.getIrid();
            TableView tableView = null;
            DesignObject obj = this.getDesign().getDesignObject(id);
            if (obj instanceof TableView) {
                tableView = (TableView)obj;
            }
            if (tableView == null) {
                tableView = this.getDesign().getRelationalDesign().createTableView();
                if (obj == null) {
                    tableView.setObjectID(id);
                }
            }
            tableView.setName(odObject.getName());
            this.setNotesAndComments(sqlConnection, tableView, id, odObject.ivid);
            tableView.setCommentInRDBMS(odObject.getDescription());
            this.createDBSynonyms(sqlConnection, odObject.getName(), odObject.ivid);
            this.getExtractionHandler().addToImportedObjects(id, tableView);
            this.initAliasesMap(sqlConnection, id, odObject.ivid, this.aliases, this.sequences);
            Helper help = null;
            if (!this.aliases.isEmpty()) {
                help = new Helper(tableView, new HashMap(this.aliases), new ArrayList<String>(this.sequences));
                list.add(help);
            }
            StructuredType st = null;
            if (odObject.objectReference != null) {
                st = (StructuredType)this.getExtractionHandler().getImportedObject(odObject.objectReference);
            }
            if (odObject.oid_list != null && odObject.oid_list.length() > 0) {
                tableView.setOidText(odObject.oid_list);
            }
            if (st != null) {
                tableView.setBasedOnStructuredType(st);
                if (odObject.overrideSelectText) {
                    createStm = "CREATE OR REPLACE VIEW " + odObject.getName() + " AS";
                    selectStm = this.getSelectStatement(sqlConnection, id, odObject.ivid);
                    whereStm = this.getWhereStatement(sqlConnection, id, true, odObject.ivid);
                    unfoundRefs = this.initViewColumns(sqlConnection, tableView, id, odObject.ivid);
                    selectStm = this.addUnfoundTablesOrViews(selectStm, unfoundRefs, this.sequences);
                    hints = this.getOptimizerHints(sqlConnection, id, odObject.ivid);
                    tableView.setOptimizerHints(hints);
                    selectStm = this.addOptimizerHints(selectStm, hints);
                    tableView.setUserDefined(true);
                    if (selectStm.endsWith("\n")) {
                        tableView.setUserDefinedSQL((String)createStm + "\n" + selectStm + whereStm);
                    } else {
                        tableView.setUserDefinedSQL((String)createStm + "\n" + selectStm + "\n" + whereStm);
                    }
                }
            } else if (odObject.overrideSelectText) {
                createStm = "CREATE OR REPLACE VIEW " + odObject.getName() + " AS";
                selectStm = this.getSelectStatement(sqlConnection, id, odObject.ivid);
                whereStm = this.getWhereStatement(sqlConnection, id, true, odObject.ivid);
                unfoundRefs = this.initViewColumns(sqlConnection, tableView, id, odObject.ivid);
                selectStm = this.addUnfoundTablesOrViews(selectStm, unfoundRefs, this.sequences);
                hints = this.getOptimizerHints(sqlConnection, id, odObject.ivid);
                tableView.setOptimizerHints(hints);
                selectStm = this.addOptimizerHints(selectStm, hints);
                tableView.setUserDefined(true);
                if (selectStm.endsWith("\n")) {
                    tableView.setUserDefinedSQL(createStm + "\n" + selectStm + whereStm);
                } else {
                    tableView.setUserDefinedSQL(createStm + "\n" + selectStm + "\n" + whereStm);
                }
            } else {
                List<String> unfoundRefs2 = this.initViewColumns(sqlConnection, tableView, id, odObject.ivid);
                List<OptimizerHint> hints2 = this.getOptimizerHints(sqlConnection, id, odObject.ivid);
                tableView.setWhere(this.getWhereStatement(sqlConnection, id, false, odObject.ivid));
                if (this.aliases.isEmpty()) {
                    tableView.setOptimizerHints(hints2);
                    String genSQL = this.addUnfoundTablesOrViews(tableView.generateSQL(), unfoundRefs2, this.sequences);
                    tableView.setUserDefinedSQL(genSQL);
                    tableView.setUserDefined(true);
                } else if (help != null) {
                    help.setUnfoundRefs(unfoundRefs2);
                    help.setOptimizerHints(hints2);
                }
            }
            if (this.tableHandler != null) {
                this.tableHandler.initPK_UK(sqlConnection, tableView, id, odObject.ivid);
            }
            if ((tableViewProxy = (TableViewProxyOracle)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID())) != null) {
                tableViewProxy.setForce("YES");
            }
            this.initViewTriggers(sqlConnection, tableView, id, odObject.ivid, odObject.branch);
            importLog.incrementImportedStatements();
        }
        for (Helper h : list) {
            for (Map.Entry entry : h.aliasMap.entrySet()) {
                ContainerObject co = (ContainerObject)this.getExtractionHandler().getImportedObject((String)entry.getKey());
                if (co == null) continue;
                h.view.addToContainers(co, (String)entry.getValue());
            }
            if (h.view.getUserDefined()) continue;
            for (ColumnView cv : h.view.getElementsCollection()) {
                ColumnView cob = (ColumnView)cv.getReferencedColumnView();
                if (cob == null || cv.getView() != null) continue;
                cv.setView((AbstractView)cob.getContainer());
            }
            h.view.setOptimizerHints(h.getOptimizerHints());
            String genSQL = this.addUnfoundTablesOrViews(h.view.generateSQL(), h.getUnfoundRefs(), h.seqList);
            h.view.setUserDefinedSQL(genSQL);
            h.view.setUserDefined(true);
        }
        if (this.s_statement != null) {
            this.s_statement.close();
        }
        if (this.wh_statement != null) {
            this.wh_statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.tr_statement != null) {
            this.tr_statement.close();
        }
        if (this.vstatement != null) {
            this.vstatement.close();
        }
        if (this.alias_statement != null) {
            this.alias_statement.close();
        }
        if (this.tableHandler != null) {
            this.tableHandler.clearPK_Statements();
        }
    }

    private List<String> initViewColumns(Connection sqlConnection, TableView tableView, String viewID, String ivid) throws Exception {
        ArrayList<String> baseRefs = new ArrayList<String>();
        if (this.col_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("base_column_reference").append(',');
            buffer.append("NAME").append(' ').append("alias_in_view").append(' ').append(", ID, DATATYPE, EXPRESSION_TEXT,RELATION_SELECTION_REFERENCE, REMARK ");
            buffer.append("FROM").append(' ');
            buffer.append("ci_columns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLE_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid ").append('=').append(" ? ");
            buffer.append(" order by  SEQUENCE_NUMBER");
            this.col_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.col_statement.setString(1, viewID);
            this.col_statement.setString(2, ivid);
            rs = this.col_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOView.initViewColumns(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String columnID = rs.getString("base_column_reference");
                String alias = rs.getString("alias_in_view");
                String id = rs.getString("ID");
                String datatype = rs.getString("DATATYPE");
                String expr = rs.getString("EXPRESSION_TEXT");
                String remark = rs.getString("REMARK");
                ContainedObject column = null;
                if (columnID != null) {
                    column = (ContainedObject)this.getExtractionHandler().getImportedObject(columnID);
                }
                ColumnView columnView = new ColumnView(tableView.getDesignPart());
                columnView.setDesign(tableView.getDesign());
                columnView.setContainer(tableView);
                if (column != null) {
                    columnView.setName(column.getName());
                    if (column instanceof Column) {
                        if (expr != null) {
                            columnView.setExpression(expr);
                        } else {
                            columnView.setReferencedColumn((Column)column);
                        }
                        columnView.setDataType(((Column)column).getDataType().toString());
                        columnView.setTable((Table)column.getContainer());
                    } else {
                        if (expr != null) {
                            columnView.setExpression(expr);
                        } else {
                            columnView.setReferencedColumnView((FKElement)column);
                        }
                        columnView.setDataType(((AbstractViewElement)column).getDataType().toString());
                        columnView.setView((AbstractView)column.getContainer());
                    }
                } else {
                    if (expr != null) {
                        columnView.setExpression(expr);
                    } else {
                        String colExpr = this.deriveExpression(sqlConnection, columnID);
                        if (!"".equals(colExpr)) {
                            columnView.setExpression(colExpr);
                            String baseRef = "";
                            String baseColumn = colExpr;
                            if (colExpr.indexOf(46) > -1) {
                                baseRef = colExpr.substring(0, colExpr.indexOf(46));
                                baseColumn = colExpr.substring(colExpr.indexOf(46) + 1);
                            }
                            if (!"".equals(alias)) {
                                columnView.setName(alias);
                            } else {
                                columnView.setName(baseColumn);
                            }
                            if (!"".equals(baseRef) && !baseRefs.contains(baseRef)) {
                                baseRefs.add(baseRef);
                            }
                        } else {
                            columnView.setReferencedColumnViewID(columnID);
                        }
                    }
                    if (datatype != null) {
                        columnView.setDataType(datatype);
                    }
                }
                this.setNotesAndComments(sqlConnection, columnView, id, ivid);
                columnView.setCommentInRDBMS(remark);
                tableView.add(columnView);
                if (alias != null) {
                    columnView.setAlias(alias);
                    columnView.setHeaderAlias(alias);
                }
                columnView.setObjectID(id);
                this.getExtractionHandler().addToImportedObjects(id, columnView);
            }
            rs.close();
        }
        return baseRefs;
    }

    private String deriveExpression(Connection sqlConnection, String columnID) throws Exception {
        Object expr = "";
        if (this.colref_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("a.").append("NAME").append(' ').append("COLUMN_NAME").append(',').append(' ');
            buffer.append("b.").append("NAME").append(' ').append("TABLE_NAME").append(',').append(' ');
            buffer.append("c.").append("NAME").append(' ').append("VIEW_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_columns").append(' ').append("a").append(',').append(' ');
            buffer.append("CI_TABLE_DEFINITIONS").append(' ').append("b").append(',').append(' ');
            buffer.append("CI_VIEW_DEFINITIONS").append(' ').append("c").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("a.").append("ID").append(' ').append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("b.").append("ID").append(' ').append("(+)").append(' ').append('=').append(' ').append("a.").append("TABLE_REFERENCE").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("b.").append("ivid").append(' ').append("(+)").append(' ').append('=').append(' ').append("a.").append("parent_ivid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("c.").append("ID").append(' ').append("(+)").append(' ').append('=').append(' ').append("a.").append("TABLE_REFERENCE").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("c.").append("ivid").append(' ').append("(+)").append(' ').append('=').append(' ').append("a.").append("parent_ivid").append(' ');
            this.colref_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.colref_statement.setString(1, columnID);
            rs = this.colref_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOView.initExpression(): " + e.getMessage());
        }
        if (rs != null && rs.next()) {
            String refColumnName = rs.getString("COLUMN_NAME");
            String refTableName = rs.getString("TABLE_NAME");
            String refViewName = rs.getString("VIEW_NAME");
            expr = refTableName != null ? refTableName + "." + refColumnName : (refViewName != null ? refViewName + "." + refColumnName : refColumnName);
        }
        return expr;
    }

    private String addUnfoundTablesOrViews(String oldSQL, List<String> unfoundTablesOrViews, List<String> seqList) {
        int i;
        if (unfoundTablesOrViews.isEmpty() && seqList.isEmpty()) {
            return oldSQL;
        }
        List<String> toBeAdded = unfoundTablesOrViews;
        ArrayList<String> fromTables = new ArrayList<String>();
        HashMap<String, String> fromMap = new HashMap<String, String>();
        String newSQL = oldSQL;
        boolean endsWith = false;
        if (oldSQL.endsWith(";")) {
            newSQL = oldSQL.substring(0, oldSQL.length() - 1);
            endsWith = true;
        }
        String beforeFrom = newSQL;
        String sqlUp = newSQL.toUpperCase();
        String fromString = "";
        boolean noFrom = false;
        String afterWhere = "";
        if (Token.hasToken(newSQL, "FROM")) {
            beforeFrom = Token.getStringBeforeToken(newSQL, "FROM");
            fromString = Token.getStringAfterToken(newSQL, "FROM");
        } else {
            noFrom = true;
            if (sqlUp.indexOf("WHERE") > -1) {
                beforeFrom = Token.getStringBeforeToken(newSQL, "WHERE");
                afterWhere = Token.getStringAfterToken(newSQL, "WHERE");
            }
        }
        if (fromString.indexOf("WHERE") > -1) {
            afterWhere = Token.getStringAfterToken(fromString, "WHERE");
            fromString = Token.getStringBefore(fromString, "WHERE");
        }
        StringTokenizer tokenizer = new StringTokenizer(fromString, ",");
        while (tokenizer.hasMoreTokens()) {
            String fromEntry;
            String alias = fromEntry = tokenizer.nextToken().trim();
            if (fromEntry.indexOf(" ") > -1) {
                alias = fromEntry.substring(fromEntry.indexOf(" ")).trim();
            }
            fromTables.add(alias);
            fromMap.put(alias, fromEntry);
            if (!toBeAdded.contains(alias)) continue;
            toBeAdded.remove(alias);
        }
        if (toBeAdded.isEmpty() && seqList.isEmpty()) {
            return oldSQL;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(beforeFrom).append(' ').append("FROM");
        for (i = 0; i < seqList.size(); ++i) {
            String seqTab = seqList.get(i);
            if (i > 0) {
                buffer.append(',');
            }
            if (fromTables.contains(seqTab)) {
                buffer.append(' ').append(fromMap.get(seqTab));
                fromTables.remove(seqTab);
            } else {
                buffer.append(' ').append(seqTab);
            }
            if (!toBeAdded.contains(seqTab)) continue;
            toBeAdded.remove(seqTab);
        }
        for (i = 0; i < fromTables.size(); ++i) {
            String fromTab = (String)fromTables.get(i);
            if (i > 0 || !seqList.isEmpty()) {
                buffer.append(',');
            }
            buffer.append(' ').append(fromMap.get(fromTab));
        }
        for (i = 0; i < toBeAdded.size(); ++i) {
            if (i > 0 || !seqList.isEmpty() || !fromTables.isEmpty()) {
                buffer.append(',');
            }
            buffer.append(' ').append(toBeAdded.get(i));
        }
        if (!"".equals(afterWhere)) {
            buffer.append(' ').append("WHERE").append(' ').append(afterWhere);
        }
        if (endsWith) {
            buffer.append(";");
        }
        return buffer.toString();
    }

    private List<OptimizerHint> getOptimizerHints(Connection sqlConnection, String viewID, String ivid) throws Exception {
        ArrayList<OptimizerHint> hints = new ArrayList<OptimizerHint>();
        if (this.hints_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("PAC_REF").append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("txt_type").append('=').append("'DBHINT'").append(' ');
            buffer.append(" and parent_ivid ").append('=').append(" ? ");
            buffer.append(' ').append("ORDER BY").append(' ').append("TXT_SEQ");
            this.hints_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.hints_statement.setString(1, viewID);
            this.hints_statement.setString(2, ivid);
            rs = this.hints_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOView.getOptimizerHints(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                hints.add(new OptimizerHint(rs.getString("txt_text")));
            }
            rs.close();
        }
        return hints;
    }

    private String addOptimizerHints(String oldSQL, List<OptimizerHint> hints) {
        if (hints.isEmpty()) {
            return oldSQL;
        }
        String beforeSelect = Token.getStringBeforeToken(oldSQL, "SELECT");
        String afterSelect = Token.getStringAfterToken(oldSQL, "SELECT");
        if (afterSelect.startsWith("/*+")) {
            return oldSQL;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(beforeSelect).append(' ').append("SELECT").append(' ').append("/*+");
        for (int i = 0; i < hints.size(); ++i) {
            String hint = hints.get(i).getHint();
            buffer.append(' ').append(hint);
        }
        buffer.append(' ').append("*/").append(' ').append(afterSelect);
        return buffer.toString();
    }

    private void initAliasesMap(Connection sqlConnection, String viewID, String viewIVID, Map aliasMap, List<String> seqList) throws Exception {
        aliasMap.clear();
        seqList.clear();
        if (this.alias_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
            buffer.append("a.").append("ALIAS").append(',').append(' ');
            buffer.append("a.").append("SEQUENCE_NUMBER").append(',').append(' ');
            buffer.append("a.").append("TABLE_REFERENCE").append(',').append(' ');
            buffer.append("b.").append("NAME").append(' ').append("TABLE_NAME").append(',').append(' ');
            buffer.append("c.").append("NAME").append(' ').append("VIEW_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("CI_RELATION_SELECTIONS").append(' ').append("a").append(',').append(' ');
            buffer.append("CI_TABLE_DEFINITIONS").append(' ').append("b").append(',').append(' ');
            buffer.append("CI_VIEW_DEFINITIONS").append(' ').append("c").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("a.").append("VIEW_REFERENCE").append(' ').append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("a.").append("PARENT_IVID").append(' ').append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("b.").append("ID").append(' ').append("(+)").append(' ').append('=').append(' ').append("a.").append("TABLE_REFERENCE").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("c.").append("ID").append(' ').append("(+)").append(' ').append('=').append(' ').append("a.").append("TABLE_REFERENCE").append(' ');
            buffer.append("ORDER BY").append(' ').append("a.").append("SEQUENCE_NUMBER");
            this.alias_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.alias_statement.setString(1, viewID);
            this.alias_statement.setString(2, viewIVID);
            rs = this.alias_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOView.initAliasesMap(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String alias = rs.getString("ALIAS");
                int seq = rs.getInt("SEQUENCE_NUMBER");
                String tref = rs.getString("TABLE_REFERENCE");
                String tname = rs.getString("TABLE_NAME");
                String vname = rs.getString("VIEW_NAME");
                if (alias != null && !"".equals(alias)) {
                    aliasMap.put(tref, alias);
                    seqList.add(alias);
                    continue;
                }
                if (tname != null && !"".equals(tname)) {
                    seqList.add(tname);
                    continue;
                }
                if (vname == null || "".equals(vname)) continue;
                seqList.add(vname);
            }
            rs.close();
        }
    }

    private String getSelectStatement(Connection sqlConnection, String viewID, String ivid) throws Exception {
        String sql;
        Object result = "";
        if (this.s_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("PAC_REF").append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("txt_type").append('=').append("'LGEXPR'").append(' ');
            buffer.append(" and parent_ivid ").append('=').append(" ? ");
            buffer.append(' ').append("ORDER BY").append(' ').append("TXT_SEQ");
            this.s_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.s_statement.setString(1, viewID);
            this.s_statement.setString(2, ivid);
            rs = this.s_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOView.getSelectStatement(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String text = rs.getString("txt_text");
                if ("".equalsIgnoreCase((String)result)) {
                    result = text;
                    continue;
                }
                result = (String)result + text;
            }
            rs.close();
        }
        if (!("".equalsIgnoreCase((String)result) || (sql = ((String)result).trim().toUpperCase()).startsWith("SELECT") || sql.startsWith("WITH"))) {
            result = "SELECT " + ((String)result).trim();
        }
        return result;
    }

    private String getWhereStatement(Connection sqlConnection, String viewID, boolean includeWhere, String ivid) throws Exception {
        Object result = "";
        if (this.wh_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("PAC_REF").append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("txt_type").append('=').append("'CDWHCL'").append(' ');
            buffer.append(" and parent_ivid ").append('=').append(" ? ");
            buffer.append(' ').append("ORDER BY").append(' ').append("TXT_SEQ");
            this.wh_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.wh_statement.setString(1, viewID);
            this.wh_statement.setString(2, ivid);
            rs = this.wh_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOView.getWhereStatement(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String text = rs.getString("txt_text");
                if ("".equalsIgnoreCase((String)result)) {
                    result = text;
                    continue;
                }
                result = (String)result + text;
            }
            rs.close();
        }
        if (!"".equalsIgnoreCase((String)result)) {
            if (includeWhere) {
                if (!((String)result).trim().toUpperCase().startsWith("WHERE")) {
                    result = "WHERE " + ((String)result).trim();
                }
            } else if (((String)result).trim().toUpperCase().startsWith("WHERE")) {
                result = ((String)result).trim().substring("WHERE".length()).trim();
            }
        }
        return result;
    }

    private void initViewTriggers(Connection sqlConnection, TableView table, String table_id, String ivid, ODExtractionHandler.Branch branch) throws Exception {
        if (this.tr_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select a.ID, a.COMPLETE_FLAG,a.DATABASE_TRIGGER_FOR, ");
            buffer.append(" a.ELEMENT_TYPE_NAME, a.ENABLED_FLAG, a.EXECUTE_TIME, ");
            buffer.append(" a.IRID, a.IVID, a.NAME, a.NEW_ALIAS,");
            buffer.append(" a.OLD_ALIAS, a.PARENT_IVID, a.PLSQL_MODULE_REFERENCE as module_id,");
            buffer.append(" a.TRIGGER_LEVEL, a.TRIGGER_ON_DELETE, a.TRIGGER_ON_INSERT, ");
            buffer.append(" a.TRIGGER_ON_UPDATE ");
            buffer.append(" from ci_database_triggers a ");
            buffer.append("where a.PARENT_IVID = ? ");
            this.tr_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.tr_statement.setString(1, ivid);
            rs = this.tr_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("ODOView.initTableTriggers():", e);
        }
        if (rs != null) {
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            TableViewProxy tableProxy = (TableViewProxy)storage.getTableViewProxySet().getProxy(table.getObjectID());
            while (rs.next()) {
                String newref = "NEW";
                String oldref = "OLD";
                String id = rs.getString(1);
                String trigName = rs.getString(9);
                newref = rs.getString(10);
                oldref = rs.getString(11);
                String module_id = rs.getString(13);
                String tr_level = rs.getString(14);
                String event_del = rs.getString(15);
                String event_ins = rs.getString(16);
                String event_upd = rs.getString(17);
                String whenClause = null;
                if (module_id != null) {
                    whenClause = this.getFromTextLines(sqlConnection, "CDIWHN", id, ivid);
                }
                String trBody = null;
                if (branch == null) {
                    trBody = this.getFromTextLines(sqlConnection, "CDIPLS", module_id);
                } else {
                    if (this.vstatement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("select ivid from i$sdd_object_versions v ");
                        buffer.append("  where ");
                        buffer.append("  v.irid = ? ");
                        buffer.append("  and branch_id = ? ");
                        buffer.append("  and sequence_in_branch  is not null ");
                        buffer.append("  and wastebasket='N' ");
                        buffer.append("  and sequence_in_branch = ");
                        buffer.append("   ( ");
                        buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                        buffer.append("     where ");
                        buffer.append("     v2.irid = ? ");
                        buffer.append("     and branch_id = ? ");
                        buffer.append("     and sequence_in_branch  is not null ");
                        buffer.append("     and wastebasket='N' ");
                        buffer.append("   ) ");
                        this.vstatement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    ResultSet vrs = null;
                    try {
                        this.vstatement.setString(1, module_id);
                        this.vstatement.setString(2, branch.getId());
                        this.vstatement.setString(3, module_id);
                        this.vstatement.setString(4, branch.getId());
                        vrs = this.vstatement.executeQuery();
                    }
                    catch (SQLException e) {
                        LOGGER.error("ODExtractionHandler.getApplicationSystems(): - get branches for app", e);
                    }
                    if (vrs != null) {
                        if (vrs.next()) {
                            String mod_ivid = vrs.getString(1);
                            trBody = this.getFromTextLines(sqlConnection, "CDIPLS", module_id, mod_ivid);
                        }
                        vrs.close();
                    }
                }
                TriggerOracle trigger = null;
                StorageObject obj = storage.getStorageObject(id);
                if (obj instanceof TriggerOracle) {
                    trigger = (TriggerOracle)obj;
                }
                if (trigger == null) {
                    trigger = storage.getTriggerSet().createTrigger();
                    if (obj == null) {
                        trigger.setObjectID(id);
                    }
                }
                trigger.setOwner(((TableViewProxyOracle)tableProxy).getUser());
                trigger.setName(trigName);
                trigger.setView((TableViewProxyOracle)tableProxy);
                if (tr_level != null) {
                    if (tr_level.indexOf("ROW") > -1) {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                    } else {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                    }
                }
                trigger.setTriggerTime("INSTEAD OF");
                if (event_ins.equalsIgnoreCase("Y")) {
                    trigger.setActions(Trigger.ACTION_TYPES[0]);
                }
                if (event_upd.equalsIgnoreCase("Y")) {
                    trigger.setActions(Trigger.ACTION_TYPES[1]);
                }
                if (event_del.equalsIgnoreCase("Y")) {
                    trigger.setActions(Trigger.ACTION_TYPES[2]);
                }
                if (newref != null && !"NEW".equalsIgnoreCase(newref)) {
                    trigger.setRef_NEW_AS(newref);
                }
                if (oldref != null && !"OLD".equalsIgnoreCase(oldref)) {
                    trigger.setRef_OLD_AS(oldref);
                }
                if (whenClause != null && !"".equalsIgnoreCase(whenClause)) {
                    trigger.setCondition(whenClause);
                }
                if (trBody != null) {
                    trigger.setBody(trBody);
                }
                this.setNotesAndComments(sqlConnection, trigger, id, ivid);
            }
            rs.close();
        }
    }

    public ODOTable getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(ODOTable tableHandler) {
        this.tableHandler = tableHandler;
    }

    class Helper {
        TableView view;
        Map aliasMap;
        List<String> seqList;
        List<String> unfoundRefs = new ArrayList<String>();
        List<OptimizerHint> optimizerHints = new ArrayList<OptimizerHint>();

        Helper(TableView view, Map aliasMap, List<String> seqList) {
            this.view = view;
            this.aliasMap = aliasMap;
            this.seqList = seqList;
        }

        public void setUnfoundRefs(List<String> unfoundRefs) {
            this.unfoundRefs = unfoundRefs;
        }

        public List<String> getUnfoundRefs() {
            return this.unfoundRefs;
        }

        public void setOptimizerHints(List<OptimizerHint> optimizerHints) {
            this.optimizerHints = optimizerHints;
        }

        public List<OptimizerHint> getOptimizerHints() {
            return this.optimizerHints;
        }
    }
}

