/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTablespaceUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTablespaceUDB.class);

    public MOHTablespaceUDB(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT  tbspace,tbspacetype managed_by,datatype, ");
                buffer.append("extentsize,prefetchsize,ts.pagesize,  ");
                buffer.append("ts.dbpgname,transferrate, ");
                buffer.append("drop_recovery,remarks comment,overhead,bp.bpname  ");
                buffer.append("from syscat.TABLESPACES ts,syscat.BUFFERPOOL bp ");
                buffer.append("WHERE tbspace = '").append(name).append("'");
                buffer.append(" and ts.bufferpoolid = bp.bufferpoolid");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTablespaceUDB.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    TableSpaceUDBv71 ts = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv71) {
                        StorageDesignUDBv71 storage = (StorageDesignUDBv71)storageDesign;
                        ts = (TableSpaceUDBv71)storage.getTableSpaceSet().getByName(name);
                        if (ts == null) {
                            BufferPoolUDBv71 bp;
                            String tbspace = rs.getString(1);
                            String managed = rs.getString(2);
                            String datatype = rs.getString(3);
                            int extentsize = rs.getInt(4);
                            int prefetchsize = rs.getInt(5);
                            int pagesize = rs.getInt(6);
                            String dbpgname = rs.getString(7);
                            float transferrate = rs.getFloat(8);
                            String drop_recovery = rs.getString(9);
                            String comment = rs.getString(10);
                            float overhead = rs.getFloat(11);
                            String bpname = rs.getString(12);
                            ts = (TableSpaceUDBv71)storage.getTableSpaceSet().createTableSpace();
                            ts.setName(tbspace);
                            ts.setDataType(datatype);
                            this.stampModelObject(ts, dbo);
                            if ("D".equalsIgnoreCase(managed)) {
                                ts.setManagedBy("DATABASE");
                            }
                            if ((bp = (BufferPoolUDBv71)storage.getBufferPoolSet().getByName(bpname)) != null) {
                                ts.setBufferPool(bp);
                            }
                            ts.setDataType(this.getDataTypeTB(datatype));
                            ts.setExtentSize(String.valueOf(extentsize));
                            ts.setPrefetchSize(String.valueOf(prefetchsize));
                            ts.setPageSize(pagesize);
                            ts.setOverhead(overhead);
                            ts.setTransferRate(transferrate);
                            NodeGroupUDBv71 group = (NodeGroupUDBv71)storage.getNodeGroupSet().getByName(dbpgname);
                            if (group == null) {
                                group = (NodeGroupUDBv71)storage.getNodeGroupSet().createNodeGroup();
                                group.setName(dbpgname);
                                this.stampModelObject((ModelObject)group, dbo.getSchema(), dbpgname);
                            }
                            ts.setNodeGroup(group);
                            if ("Y".equalsIgnoreCase(drop_recovery)) {
                                ts.setDroppedTableRecovery(true);
                            }
                            this.initTbprivileges(sqlConnection, ts);
                            ts.setCommentInRDBMS(comment);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT tbspace from syscat.TABLESPACES");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceUDB.extract(): ", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tsname = rs.getString(1);
                DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tsname, OBJECT_TYPE);
                list.add(dboTs);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    private String getDataTypeTB(String datatype) {
        if (datatype.equalsIgnoreCase("T")) {
            return "SYSTEM TEMPORARY";
        }
        if (datatype.equalsIgnoreCase("U")) {
            return "USER TEMPORARY";
        }
        return "REGULAR";
    }

    private void initTbprivileges(Connection sqlConnection, TableSpaceUDBv71 ts) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  grantee,granteetype,useauth ");
            buffer.append("from syscat.tbspaceauth ");
            buffer.append("WHERE tbspace = '").append(ts.getName()).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceUDB.initTbprivileges():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                NodeGroupUDBv71 group;
                String userOrGroup = rs.getString(1);
                String type = rs.getString(2);
                String grant = rs.getString(3);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71)) continue;
                StorageDesignUDBv71 storage = (StorageDesignUDBv71)storageDesign;
                if ("U".equalsIgnoreCase(type)) {
                    OwnerUDBv81 owner = (OwnerUDBv81)storage.getOwnerSet().getByName(userOrGroup);
                    if (owner != null) {
                        ts.setUsers(owner.getName());
                    }
                } else if ("G".equalsIgnoreCase(type) && (group = (NodeGroupUDBv71)storage.getNodeGroupSet().getByName(userOrGroup)) != null) {
                    ts.setGroups(group.getName());
                }
                if (!"Y".equalsIgnoreCase(grant)) continue;
                ts.setGrantOption("YES");
            }
            rs.close();
        }
        statement.close();
    }
}

