/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatabaseSqlServerv2k5
extends AbstractMOHandler {
    protected static final String OBJECT_TYPE = "DATABASE";
    private static final Logger LOGGER = new Logger(MOHDatabaseSqlServerv2k5.class);
    protected static final String UserAccess = "UserAccess";
    protected static final String Collation = "Collation";
    protected static final String IsCloseCursorsOnCommitEnabled = "IsCloseCursorsOnCommitEnabled";
    protected static final String IsLocalCursorsDefault = "IsLocalCursorsDefault";
    protected static final String IsAnsiNullsEnabled = "IsAnsiNullsEnabled";
    protected static final String IsAnsiPaddingEnabled = "IsAnsiPaddingEnabled";
    protected static final String IsAnsiWarningsEnabled = "IsAnsiWarningsEnabled";
    protected static final String IsArithmeticAbortEnabled = "IsArithmeticAbortEnabled";
    protected static final String IsAutoClose = "IsAutoClose";
    protected static final String IsAutoCreateStatistics = "IsAutoCreateStatistics";
    protected static final String IsAutoShrink = "IsAutoShrink";
    protected static final String IsAutoUpdateStatistics = "IsAutoUpdateStatistics";
    protected static final String IsNullConcat = "IsNullConcat";
    protected static final String IsNumericRoundAbortEnabled = "IsNumericRoundAbortEnabled";
    protected static final String IsQuotedIdentifiersEnabled = "IsQuotedIdentifiersEnabled";
    protected static final String IsRecursiveTriggersEnabled = "IsRecursiveTriggersEnabled";
    protected static final String IsTornPageDetectionEnabled = "IsTornPageDetectionEnabled";
    protected static final String Recovery = "Recovery";
    protected static final String PRIMARY = "PRIMARY";

    public MOHDatabaseSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        String defDBName = this.getDesign().getAppView().getSettings().getDefaultSqlServerDatabase();
        ((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).setDefaultDBImpoted(false);
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String uid = dbo.getId();
            String db = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            if (dbo.getName().equalsIgnoreCase(defDBName)) {
                ((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).setDefaultDBImpoted(true);
            }
            this.initDataBase(sqlConnection, db, uid);
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    protected void initDataBase(Connection sqlConnection, String db, String uid) throws SQLException, Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(UserAccess);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(UserAccess);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(Collation);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(Collation);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsCloseCursorsOnCommitEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsCloseCursorsOnCommitEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsLocalCursorsDefault);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsLocalCursorsDefault);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAnsiNullsEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAnsiNullsEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAnsiPaddingEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAnsiPaddingEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAnsiWarningsEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAnsiWarningsEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsArithmeticAbortEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsArithmeticAbortEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAutoClose);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAutoClose);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAutoCreateStatistics);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAutoCreateStatistics);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAutoShrink);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAutoShrink);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsAutoUpdateStatistics);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsAutoUpdateStatistics);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsNullConcat);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsNullConcat);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsNumericRoundAbortEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsNumericRoundAbortEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsQuotedIdentifiersEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsQuotedIdentifiersEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsRecursiveTriggersEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsRecursiveTriggersEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(IsTornPageDetectionEnabled);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(IsTornPageDetectionEnabled);
            buffer.append(',').append(' ');
            buffer.append("DATABASEPROPERTY").append(' ');
            buffer.append('(').append(' ');
            buffer.append('\'');
            buffer.append(db);
            buffer.append('\'');
            buffer.append(',').append(' ');
            buffer.append('\'');
            buffer.append(Recovery);
            buffer.append('\'');
            buffer.append(')').append(' ');
            buffer.append(Recovery);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.generate():", e);
        }
        if (rs != null && rs.next()) {
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().getByName(db);
                if (database == null) {
                    database = (DataBaseSqlServerv2k5)storage.getDataBaseSet().createDataBase();
                    database.setName(db);
                    database.setObjectID(uid);
                    this.stampModelObject((ModelObject)database, "", db);
                }
                this.setProperties(database, rs);
                this.initFilegroups(database, storage, sqlConnection);
                this.initLogfiles(database, storage, sqlConnection);
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    protected void initLogfiles(DataBaseSqlServer database, StorageDesignSqlServer storage, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("size").append(' ');
            buffer.append(',').append(' ');
            buffer.append("maxsize").append(' ');
            buffer.append(',').append(' ');
            buffer.append("growth").append(' ');
            buffer.append(',').append(' ');
            buffer.append("GROWTH_IN_PERCENTAGE = ");
            buffer.append("case status & 0x100000 ");
            buffer.append("when 0x100000 then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("filename").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(database.getName())).append('.').append("dbo.sysfiles").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("status & 0x40 = 0x40").append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("fileid").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1).trim();
                    int size = rs.getInt(2);
                    int maxsize = rs.getInt(3);
                    int growth = rs.getInt(4);
                    String percentage = rs.getString(5);
                    String filename = rs.getString(6).trim();
                    DataFileSqlServer df = storage.getDataFileSet().createDataFile();
                    df.setName(name);
                    df.setDataBase(database);
                    df.setFileName(filename);
                    df.setInitialSize(size);
                    this.stampModelObject((ModelObject)df, database, name);
                    if (percentage.equalsIgnoreCase("YES")) {
                        df.setGrowthMethod("By Percent");
                    } else {
                        df.setGrowthMethod("In MegaBytes");
                    }
                    df.setGrowthValue(growth);
                    if (maxsize == -1) {
                        df.setIsUnlimited(true);
                        continue;
                    }
                    df.setIsUnlimited(false);
                    df.setMaxSize(maxsize);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initLogfiles():", e);
        }
    }

    protected void initFilegroups(DataBaseSqlServer database, StorageDesignSqlServer storage, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("groupname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("groupid").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(database.getName())).append('.').append("dbo.sysfilegroups").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String groupName = rs.getString(1);
                    String groupId = rs.getString(2);
                    FileGroupSqlServer fg = (FileGroupSqlServer)database.getFilegroups().getByName(groupName);
                    if (fg == null) {
                        fg = storage.getFileGroupSet().createFileGroup();
                        fg.setName(groupName);
                        fg.setDataBase(database);
                        this.stampModelObject((ModelObject)fg, database, groupName);
                    }
                    this.initDatafiles(fg, groupId, database.getName(), storage, sqlConnection);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initFilegroups():", e);
        }
    }

    private void initDatafiles(FileGroupSqlServer fg, String groupId, String db, StorageDesignSqlServer storage, Connection sqlConnection) throws Exception {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("size").append(' ');
            buffer.append(',').append(' ');
            buffer.append("maxsize").append(' ');
            buffer.append(',').append(' ');
            buffer.append("growth").append(' ');
            buffer.append(',').append(' ');
            buffer.append("GROWTH_IN_PERCENTAGE = ");
            buffer.append("case status & 0x100000 ");
            buffer.append("when 0x100000 then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("filename").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysfiles").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("status & 0x2 = 0x2").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("groupid").append(' ');
            buffer.append('=').append(' ');
            buffer.append(groupId).append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("fileid").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1).trim();
                    int size = rs.getInt(2);
                    int maxsize = rs.getInt(3);
                    int growth = rs.getInt(4);
                    String percentage = rs.getString(5);
                    String filename = rs.getString(6).trim();
                    DataFileSqlServer df = storage.getDataFileSet().createDataFile();
                    df.setName(name);
                    df.setFileGroup(fg);
                    df.setFileName(filename);
                    df.setInitialSize(size);
                    this.stampModelObject((ModelObject)df, fg.getDataBase(), name);
                    if (percentage.equalsIgnoreCase("YES")) {
                        df.setGrowthMethod("By Percent");
                    } else {
                        df.setGrowthMethod("In MegaBytes");
                    }
                    df.setGrowthValue(growth);
                    if (maxsize == -1) {
                        df.setIsUnlimited(true);
                        continue;
                    }
                    df.setIsUnlimited(false);
                    df.setMaxSize(maxsize);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initDatafiles():", e);
        }
    }

    protected void setProperties(DataBaseSqlServer database, ResultSet rs) throws Exception {
        String access = rs.getString(UserAccess);
        String coll = rs.getString(Collation);
        int cursorClose = rs.getInt(IsCloseCursorsOnCommitEnabled);
        int cursorDef = rs.getInt(IsLocalCursorsDefault);
        int ansiNull = rs.getInt(IsAnsiNullsEnabled);
        int ansiPadding = rs.getInt(IsAnsiPaddingEnabled);
        int ansiWarning = rs.getInt(IsAnsiWarningsEnabled);
        int arithabort = rs.getInt(IsArithmeticAbortEnabled);
        int autoClose = rs.getInt(IsAutoClose);
        int autoStatistics = rs.getInt(IsAutoCreateStatistics);
        int autoShrink = rs.getInt(IsAutoShrink);
        int autoUpdateStatistics = rs.getInt(IsAutoUpdateStatistics);
        int nullConcat = rs.getInt(IsNullConcat);
        int roundAbort = rs.getInt(IsNumericRoundAbortEnabled);
        int quotedId = rs.getInt(IsQuotedIdentifiersEnabled);
        int recursiveTriggers = rs.getInt(IsRecursiveTriggersEnabled);
        int tornPage = rs.getInt(IsTornPageDetectionEnabled);
        String recovery = rs.getString(Recovery);
        database.setUserState(access);
        database.setCollationName(coll);
        if (cursorClose == 0) {
            database.setCursorCloseOnCommit("OFF");
        } else {
            database.setCursorCloseOnCommit("ON");
        }
        if (cursorDef == 0) {
            database.setCursorDefault("GLOBAL");
        } else {
            database.setCursorDefault("LOCAL");
        }
        if (ansiNull == 0) {
            database.setAnsiNulls("OFF");
        } else {
            database.setAnsiNulls("ON");
        }
        if (ansiPadding == 0) {
            database.setAnsiPadding("OFF");
        } else {
            database.setAnsiPadding("ON");
        }
        if (ansiWarning == 0) {
            database.setAnsiWarnings("OFF");
        } else {
            database.setAnsiWarnings("ON");
        }
        if (arithabort == 0) {
            database.setArithabort("OFF");
        } else {
            database.setArithabort("ON");
        }
        if (autoClose == 0) {
            database.setAutoClose("OFF");
        } else {
            database.setAutoClose("ON");
        }
        if (autoStatistics == 0) {
            database.setAutoCreateStatistics("OFF");
        } else {
            database.setAutoCreateStatistics("ON");
        }
        if (autoShrink == 0) {
            database.setAutoShrink("OFF");
        } else {
            database.setAutoShrink("ON");
        }
        if (autoUpdateStatistics == 0) {
            database.setAutoUpdateStatistics("OFF");
        } else {
            database.setAutoUpdateStatistics("ON");
        }
        if (nullConcat == 0) {
            database.setConcatNullYieldsNull("OFF");
        } else {
            database.setConcatNullYieldsNull("ON");
        }
        if (roundAbort == 0) {
            database.setNumericRoundabort("OFF");
        } else {
            database.setNumericRoundabort("ON");
        }
        if (quotedId == 0) {
            database.setQuotedIdentifier("OFF");
        } else {
            database.setQuotedIdentifier("ON");
        }
        if (recursiveTriggers == 0) {
            database.setRecursiveTriggers("OFF");
        } else {
            database.setRecursiveTriggers("ON");
        }
        if (tornPage == 0) {
            database.setTornPageDetection("OFF");
        } else {
            database.setTornPageDetection("ON");
        }
        database.setRecovery(recovery);
    }
}

