/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHMViewLog
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "MVIEW_LOG";
    private static final Logger LOGGER = new Logger(MOHMViewLog.class);
    public static String LOG_OWNER = "LOG_OWNER";
    public static String MASTER = "MASTER";
    public static String LOG_TABLE = "LOG_TABLE";
    public static String ROWIDS = "ROWIDS";
    public static String PRIMARY_KEY = "PRIMARY_KEY";
    public static String OBJECT_ID = "OBJECT_ID";
    public static String FILTER_COLUMNS = "FILTER_COLUMNS";
    public static String SEQUENCE = "SEQUENCE";
    public static String INCLUDE_NEW_VALUES = "INCLUDE_NEW_VALUES";
    public static String PURGE_ASYNCHRONOUS = "PURGE_ASYNCHRONOUS";
    public static String PURGE_DEFERRED = "PURGE_DEFERRED";
    public static String PURGE_START = "PURGE_START";
    public static String PURGE_INTERVAL = "PURGE_INTERVAL";
    public static String LAST_PURGE_DATE = "LAST_PURGE_DATE";
    public static String LAST_PURGE_STATUS = "LAST_PURGE_STATUS";
    public static String NUM_ROWS_PURGED = "NUM_ROWS_PURGED";
    public static String COMMIT_SCN_BASED = "COMMIT_SCN_BASED";
    protected boolean dbaUser;

    public MOHMViewLog(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHMViewLog(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = null;
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                try {
                    String filterCondition = this.getFilterConditionOracle("MASTER");
                    String sql = "SELECT\n    LOG_OWNER,\n    MASTER,\n    LOG_TABLE\n FROM\n" + (this.dbaUser ? " DBA_MVIEW_LOGS " : " ALL_MVIEW_LOGS ") + " WHERE LOG_OWNER = ? ";
                    if (filterCondition != null && !filterCondition.isEmpty()) {
                        sql = sql + " AND " + filterCondition;
                    }
                    sql = sql + " ORDER BY MASTER";
                    statement = sqlConnection.prepareStatement(sql);
                }
                catch (Exception e) {
                    System.out.println("MOHMViewLog.extract(): " + e.getMessage());
                    LOGGER.error("MOHMViewLog.extract():", e);
                }
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHMViewLog.extract(): " + e.getMessage());
                LOGGER.error("MOHMViewLog.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String schema = rs.getString(1);
                String tName = rs.getString(2);
                String logTable = rs.getString(3);
                DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tName, OBJECT_TYPE, schema);
                dboTs.setLogTable(logTable);
                list.add(dboTs);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    public void verifyLogTable(Connection sqlConnection, List<DBObject> dbos) throws Exception {
        Statement statement = null;
        for (DBObject dbo : dbos) {
            if (!dbo.isSelected() || !OBJECT_TYPE.equalsIgnoreCase(dbo.getType()) || dbo.getLogTable() != null) continue;
            if (statement == null) {
                try {
                    String sql = "SELECT\n    LOG_TABLE\n FROM\n" + (this.dbaUser ? " DBA_MVIEW_LOGS " : " ALL_MVIEW_LOGS ") + " WHERE LOG_OWNER = ?  AND MASTER = ?";
                    statement = sqlConnection.prepareStatement(sql);
                }
                catch (Exception e) {
                    System.out.println("MOHMViewLog.extract(): " + e.getMessage());
                    LOGGER.error("MOHMViewLog.extract():", e);
                }
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHMViewLog.extract(): " + e.getMessage());
                LOGGER.error("MOHMViewLog.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String logTable = rs.getString(1);
                dbo.setLogTable(logTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    public String getQuery(StorageDesign storageDesign) {
        String sql = "SELECT\n    LOG_OWNER,\n    MASTER,\n    LOG_TABLE,\n    ROWIDS,\n    PRIMARY_KEY,\n    OBJECT_ID,\n    FILTER_COLUMNS,\n    SEQUENCE,\n    INCLUDE_NEW_VALUES,\n    PURGE_ASYNCHRONOUS,\n    PURGE_DEFERRED,\n    to_char(PURGE_START,'YYYY-MM-DD HH24:MI:SS') PURGE_START,\n    PURGE_INTERVAL,\n    LAST_PURGE_DATE,\n    LAST_PURGE_STATUS,\n    NUM_ROWS_PURGED,\n    COMMIT_SCN_BASED\n FROM\n" + (this.dbaUser ? " DBA_MVIEW_LOGS " : " ALL_MVIEW_LOGS ") + " WHERE LOG_OWNER = ? AND MASTER = ?";
        return sql;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            ResultSet rs = null;
            try {
                try {
                    if (statement == null) {
                        String query = this.getQuery(storageDesign);
                        statement = sqlConnection.prepareStatement(query);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    rs = statement.executeQuery();
                }
                catch (SQLSyntaxErrorException e) {
                    LOGGER.error("MOHMViewLog.generate", e);
                }
                if (rs != null) {
                    if (rs.next()) {
                        if (storageDesign instanceof StorageDesignOracle) {
                            MaterializedViewLogOracle mvlog = ((StorageDesignOracle)storageDesign).createMaterializedViewLogOracle();
                            mvlog.setName(dbo.getName());
                            this.setProperties(mvlog, rs, dbo);
                            this.stampModelObject(mvlog, dbo);
                        } else {
                            LOGGER.error("Unable to find Storage Design!");
                        }
                    }
                    rs.close();
                }
            }
            catch (Exception e) {
                System.out.println("MOHMViewLog.generate(): " + e.getMessage());
                LOGGER.error("MOHMViewLog.generate():", e);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setProperties(MaterializedViewLogOracle mvlog, ResultSet rs, DBObject dbo) {
        TableProxyOracle tp;
        StorageDesign sd = mvlog.getStorageDesign();
        RelationalDesign rd = sd.getPhysicalDesign();
        Table masterTable = rd.getTableSet().getBySchemaAndName(dbo.getSchema(), dbo.getName());
        if (masterTable != null && (tp = (TableProxyOracle)sd.getStorageObject(masterTable.getObjectID())) != null) {
            mvlog.setTableProxy(tp);
        }
        try {
            String rowIDs = rs.getString(ROWIDS);
            String pk = rs.getString(PRIMARY_KEY);
            String objID = rs.getString(OBJECT_ID);
            String filterColumns = rs.getString(FILTER_COLUMNS);
            String sequence = rs.getString(SEQUENCE);
            String inclNewValues = rs.getString(INCLUDE_NEW_VALUES);
            String purgeAsync = rs.getString(PURGE_ASYNCHRONOUS);
            String purgeDeferred = rs.getString(PURGE_DEFERRED);
            String purgeStart = rs.getString(PURGE_START);
            String purgeInterval = rs.getString(PURGE_INTERVAL);
            String commitSCN = rs.getString(COMMIT_SCN_BASED);
            mvlog.setRowIDLogged(rowIDs);
            mvlog.setPkLogged(pk);
            mvlog.setSequenceLogged(sequence);
            mvlog.setNewValues(inclNewValues);
            Table logTable = rd.getTableSet().getBySchemaAndName(dbo.getSchema(), dbo.getLogTable());
            if (logTable != null) {
                logTable.setOracleLogTable(true);
                logTable.setTypeID("3");
                TableProxyOracle tp2 = (TableProxyOracle)sd.getStorageObject(logTable.getObjectID());
                if (tp2 != null) {
                    mvlog.setLogTableProxy(tp2);
                }
            }
            mvlog.setObjectIDLogged(objID);
            if ("YES".equalsIgnoreCase(commitSCN)) {
                mvlog.setCommitSCN(true);
            } else {
                mvlog.setCommitSCN(false);
            }
            if ("YES".equalsIgnoreCase(purgeDeferred)) {
                mvlog.setPurgeType("DEFERRED");
            } else if ("YES".equalsIgnoreCase(purgeAsync)) {
                mvlog.setPurgeType("DEFERRED");
            }
            if (purgeStart != null && !purgeStart.isEmpty()) {
                String pexpr = "TO_DATE('" + purgeStart + "','YYYY-MM-DD HH24:MI:SS')";
                mvlog.setPurgeSWExpression(pexpr);
            }
            if (purgeInterval != null && !purgeInterval.isEmpty()) {
                mvlog.setPurgeNextExpression(purgeInterval);
            }
            this.setColumns(mvlog);
        }
        catch (SQLException e) {
            LOGGER.error("MOHMViewLog.setProperties", e);
            e.printStackTrace();
        }
    }

    private void setColumns(MaterializedViewLogOracle mvlog) {
        TableProxyOracle ltp = mvlog.getLogTableProxy();
        TableProxyOracle mtp = mvlog.getTableProxy();
        if (ltp != null && mtp != null) {
            Table log = ltp.getTable();
            Table master = mtp.getTable();
            Object colIDs = "";
            Object colNames = "";
            for (Column col : master.getElementsCollection()) {
                ContainedObject c;
                if (col.isPKElement() || (c = log.getElementByName(col.getName())) == null) continue;
                if (((String)colIDs).isEmpty()) {
                    colIDs = col.getObjectID();
                    colNames = col.getName();
                    continue;
                }
                colIDs = (String)colIDs + "," + col.getObjectID();
                colNames = (String)colNames + "," + col.getName();
            }
            if (!((String)colIDs).isEmpty()) {
                mvlog.setColumns((String)colIDs);
                mvlog.setColumnNames((String)colNames);
            }
        }
    }

    @Override
    public void preGenerateProcessing(Connection sqlConnection, List<DBObject> selectedObject) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<DBObject> mvlogs = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObject) {
            if ("TABLE".equalsIgnoreCase(dbo.getType())) {
                map.put(dbo.getSchema() + "." + dbo.getName(), dbo);
                continue;
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            mvlogs.add(dbo);
        }
        StorageDesign sd = this.getStorageDesign();
        if (sd == null) {
            sd = this.getDesign().getRelationalDesign().getStorageDesign();
        }
        Iterator it = sd.getPhysicalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            DesignObject dobj = (DesignObject)it.next();
            String lname = dobj.getLongName();
            if (map.get(lname) != null) continue;
            map.put(lname, lname);
        }
        try {
            this.verifyLogTable(sqlConnection, mvlogs);
        }
        catch (Exception e) {
            LOGGER.error("MOHMViewLog - verifyLogTable", e);
        }
        for (DBObject dbo : mvlogs) {
            if (map.get(dbo.getSchema() + "." + dbo.getName()) == null) {
                selectedObject.add(new DBObject(true, dbo.getName(), "TABLE", dbo.getSchema()));
            }
            if (map.get(dbo.getSchema() + "." + dbo.getLogTable()) != null) continue;
            selectedObject.add(new DBObject(true, dbo.getLogTable(), "TABLE", dbo.getSchema()));
        }
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RelationalDesign rd = sd.getPhysicalDesign();
        if (sd != null) {
            if (sd.getMaterializedViewLogSet().size() > 0) {
                for (MaterializedViewLogOracle mvl : sd.getMaterializedViewLogSet()) {
                    Table table;
                    if (mvl.getLogTableProxy() != null) {
                        mvl.getLogTableProxy().setMarkedGenerate(false);
                        mvl.getLogTableProxy().getTable().setMarkedGenerate(false);
                    }
                    if (!"YES".equalsIgnoreCase(mvl.getPkLogged()) || (table = rd.getTableSet().getBySchemaAndName(mvl.getTableSchema(), "RUPD$_" + mvl.getTableName())) == null) continue;
                    table.setOracleLogTable(true);
                    table.setTypeID("3");
                    table.setMarkedGenerate(false);
                }
            }
            Iterator it = rd.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                String name = table.getName();
                if (!name.startsWith("RUPD$_") && !name.startsWith("MLOG$_")) continue;
                table.setOracleLogTable(true);
                table.setTypeID("3");
                table.setMarkedGenerate(false);
            }
        }
    }
}

