/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class Dependencies {
    static String PHYS_PROPS = "physicalProperties";
    static String LOCATIONS_AS_STRING = "locationsAsString";
    private static String webPath = "/WEB-INF/datamodeler";
    static String fact = ContainerObject.TYPE_FACT;
    static String dimension = ContainerObject.TYPE_DIMENSION;

    public static void main(String[] args) {
        File file = new File("d:/sales_mv_log.json");
        try {
            FileInputStream is = new FileInputStream(file);
            if (is != null) {
                Object jdoc = null;
                try {
                    Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/pdb1.osddm", "system", "system");
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
                    Dependencies.processTableDependenciesStarSchema(conn, out, "GLOBAL", "UNITS_FACT", true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processTableDependenciesStarSchema(Connection conn, Writer osw, String schema, String item, boolean dbaUser) {
        ArrayList<JoinsHelper> list = new ArrayList<JoinsHelper>();
        JoinsHelper h = new JoinsHelper(schema, item);
        list.add(h);
        HashMap<String, JoinsHelper> tables = new HashMap<String, JoinsHelper>();
        tables.put(h.getID(), h);
        Dependencies.processTableDependenciesStarSchemaFK(conn, osw, schema, item, list, tables, dbaUser);
        int ver = DBMExtractionHandlerOracle.getOracleVersionInt(conn);
        if (ver > 11) {
            // empty if block
        }
        if (ver > 12) {
            int cont_id = Dependencies.getContainerID(conn);
            Dependencies.processTableDependenciesStarSchemaAnalyticViews(conn, schema, item, list, tables, dbaUser, cont_id, null);
            Dependencies.processTableDependenciesStarSchemaOLAP(conn, schema, item, list, tables, dbaUser, null);
        }
        Dependencies.processTableDependenciesStarSchemaDimensions(conn, schema, item, list, tables, dbaUser, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaBJI(Connection conn, String schema, Map<String, ContainerObject> containers, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser, ProgressDialog pd) {
        String sql = "select distinct inner_table_owner fowner, inner_table_name ftable,inner_table_column fcolumn,outer_table_owner downer,outer_table_name dtable, outer_table_column dcolumn  , index_owner, index_name  from all_join_ind_columns  where inner_table_owner = ?  and (inner_table_owner, inner_table_name) not in (select distinct outer_table_owner,outer_table_name from all_join_ind_columns where outer_table_owner = ?)";
        if (dbaUser) {
            sql = "select distinct inner_table_owner fowner, inner_table_name ftable,inner_table_column fcolumn,outer_table_owner downer,outer_table_name dtable, outer_table_column dcolumn  , index_owner, index_name  from dba_join_ind_columns  where inner_table_owner = ?  and (inner_table_owner, inner_table_name) not in (select distinct outer_table_owner,outer_table_name from dba_join_ind_columns where outer_table_owner = ?)";
        }
        String type = "BitmapJoinIndex/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, schema);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    while (rs.next()) {
                        JoinsHelper h;
                        JoinsHelper h2;
                        String name;
                        if (pd != null && pd.isCancelled()) {
                            ps.cancel();
                            return;
                        }
                        String sch = rs.getString(1);
                        if (!Dependencies.contains(containers, sch, name = rs.getString(2))) continue;
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        JoinsHelper first = tables.get((schema + "." + name).toUpperCase());
                        if (first == null) {
                            first = new JoinsHelper(schema, name);
                            tables.put(first.getID(), first);
                        }
                        if (first.type.isEmpty()) {
                            first.type = fact;
                        }
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new JoinsHelper(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaMViews(Connection conn, String schema, Map<String, ContainerObject> containers, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser, ProgressDialog pd) {
        String sql = "select distinct detailobj1_owner, detailobj1_relation, detailobj1_column, detailobj2_owner, detailobj2_relation, detailobj2_column \n , owner, mview_name, operator  from all_mview_joins \n where detailobj1_owner = ? and (owner,mview_name) in (select distinct owner,mview_name from all_mview_aggregates where owner = ?)";
        if (dbaUser) {
            sql = "select distinct detailobj1_owner, detailobj1_relation, detailobj1_column, detailobj2_owner, detailobj2_relation, detailobj2_column \n , owner, mview_name, operator  from dba_mview_joins \n where detailobj1_owner = ? and (owner,mview_name) in (select distinct owner,mview_name from all_mview_aggregates where owner = ?)";
        }
        String type = "MView/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, schema);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    while (rs.next()) {
                        JoinsHelper h;
                        JoinsHelper h2;
                        String name;
                        if (pd != null && pd.isCancelled()) {
                            ps.cancel();
                            return;
                        }
                        String sch = rs.getString(1);
                        if (!Dependencies.contains(containers, sch, name = rs.getString(2))) continue;
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        JoinsHelper first = tables.get((schema + "." + name).toUpperCase());
                        if (first == null) {
                            first = new JoinsHelper(schema, name);
                            tables.put(first.getID(), first);
                        }
                        if (first.type.isEmpty()) {
                            first.type = fact;
                        }
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new JoinsHelper(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaDimensions(Connection conn, String schema, String item, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser, ProgressDialog pd) {
        String sql = "with level1_col as\n(select k.owner, k.dimension_name, k.level_name, k.column_name from all_dim_level_key k,all_dim_child_of c\nwhere c.position=1 and c.owner= ? and c.owner=k.owner and c.child_level_name=k.level_name),\ndim_keys as\n(select /*+ MATERIALIZE */ distinct  d.detailobj_owner towner, d.detailobj_name tname, l.column_name, l.owner downer, l.dimension_name dname from level1_col l, all_dim_levels d \nwhere d.owner= ? and d.owner = l.owner and d.dimension_name = l.dimension_name and d.level_name = l.level_name)\nselect c.owner, c.table_name,c.column_name, d.towner,d.tname, d.column_name,d.downer, d.dname from all_tab_columns c, dim_keys d\nwhere c.owner = ? and c.table_name = ? and c.column_name = d.column_name";
        if (dbaUser) {
            sql = "with level1_col as\n(select k.owner, k.dimension_name, k.level_name, k.column_name from dba_dim_level_key k,dba_dim_child_of c\nwhere c.position=1 and c.owner= ? and c.owner=k.owner and c.child_level_name=k.level_name),\ndim_keys as\n(select /*+ MATERIALIZE */ distinct  d.detailobj_owner towner, d.detailobj_name tname, l.column_name, l.owner downer, l.dimension_name dname from level1_col l, dba_dim_levels d \nwhere d.owner= ? and d.owner = l.owner and d.dimension_name = l.dimension_name and d.level_name = l.level_name)\nselect c.owner, c.table_name,c.column_name, d.towner,d.tname, d.column_name,d.downer, d.dname from dba_tab_columns c, dim_keys d\nwhere c.owner = ? and c.table_name = ? and c.column_name = d.column_name";
        }
        String type = "Dimension_ColName/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, schema);
            ps.setString(3, schema);
            ps.setString(4, item);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    JoinsHelper first = tables.get((schema + "." + item).toUpperCase());
                    if (first == null) {
                        first = new JoinsHelper(schema, item);
                        tables.put(first.getID(), first);
                    }
                    if (first.type.isEmpty()) {
                        first.type = fact;
                    }
                    while (rs.next()) {
                        JoinsHelper h;
                        JoinsHelper h2;
                        if (pd != null && pd.isCancelled()) {
                            ps.cancel();
                            return;
                        }
                        String sch = rs.getString(1);
                        String name = rs.getString(2);
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new JoinsHelper(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaOLAP(Connection conn, String schema, String item, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser, ProgressDialog pd) {
        String sql = "with cube as \n (select /*+ MATERIALIZE */ a.owner,a.d_top_obj_name cube, b.p_obj_owner downer,b.p_top_obj_name dim from all_cube_dependencies a, all_cube_dependencies b\n where a.d_obj_type = 'CUBE MAP' and a.p_obj_owner = ? and a.p_top_obj_name = ? and a.owner = b.owner \n  and a.d_top_obj_name = b.d_top_obj_name and b.d_obj_type = 'DIMENSIONALITY'),\n fact_fks as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim,a.p_obj_owner fowner,a.p_top_obj_name ftable,a.p_sub_obj_name1 fcol from all_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'COLUMN'),\n dim_level as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim, a.p_sub_obj_name2 lev from all_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'HIERARCHY LEVEL'\n ),\n level_keys as\n (select distinct l.owner, l.dim, a.p_obj_owner dtowner,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from all_cube_dependencies a, dim_level l\n where a.owner = l.owner and l.dim = a.d_top_obj_name and l.lev = a.d_sub_obj_name2 and a.d_obj_type = 'HIER LEVEL MAP' and a.p_obj_type = 'COLUMN'\n and a.dependency_type = 'KEY EXPRESSION'\n union\n select distinct l.downer, l.dim, a.p_obj_owner downer,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from all_cube_dependencies a, cube l\n where a.owner = l.downer and l.dim = a.d_top_obj_name  and a.d_obj_type = 'SOLVED VALUE HIER MAP' and a.dependency_type = 'KEY EXPRESSION')\n select fowner, ftable, f.fcol,k.dtowner, k.dtable,k.dcol, f.owner, f.cube, f.dim from fact_fks f, level_keys k\n where k.owner = f.owner and k.dim = f.dim";
        if (dbaUser) {
            sql = " with cube as \n (select /*+ MATERIALIZE */ a.owner,a.d_top_obj_name cube, b.p_obj_owner downer,b.p_top_obj_name dim from dba_cube_dependencies a, dba_cube_dependencies b\n where a.d_obj_type = 'CUBE MAP' and a.p_obj_owner = ? and a.p_top_obj_name = ? and a.owner = b.owner \n  and a.d_top_obj_name = b.d_top_obj_name and b.d_obj_type = 'DIMENSIONALITY'),\n fact_fks as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim,a.p_obj_owner fowner,a.p_top_obj_name ftable,a.p_sub_obj_name1 fcol from dba_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'COLUMN'),\n dim_level as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim, a.p_sub_obj_name2 lev from dba_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'HIERARCHY LEVEL'\n ),\n level_keys as\n (select distinct l.owner, l.dim, a.p_obj_owner dtowner,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from dba_cube_dependencies a, dim_level l\n where a.owner = l.owner and l.dim = a.d_top_obj_name and l.lev = a.d_sub_obj_name2 and a.d_obj_type = 'HIER LEVEL MAP' and a.p_obj_type = 'COLUMN'\n and a.dependency_type = 'KEY EXPRESSION'\n union\n select distinct l.downer, l.dim, a.p_obj_owner downer,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from dba_cube_dependencies a, cube l\n where a.owner = l.downer and l.dim = a.d_top_obj_name  and a.d_obj_type = 'SOLVED VALUE HIER MAP' and a.dependency_type = 'KEY EXPRESSION' )\n --select * from dim_level;\n select fowner, ftable, f.fcol,k.dtowner, k.dtable,k.dcol, f.owner, f.cube, f.dim from fact_fks f, level_keys k\n where k.owner = f.owner and k.dim = f.dim";
        }
        String type = "OLAP-Cube/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    JoinsHelper first = tables.get((schema + "." + item).toUpperCase());
                    if (first == null) {
                        first = new JoinsHelper(schema, item);
                        tables.put(first.getID(), first);
                    }
                    if (first.type.isEmpty()) {
                        first.type = fact;
                    }
                    while (rs.next()) {
                        JoinsHelper h;
                        JoinsHelper h2;
                        if (pd != null && pd.isCancelled()) {
                            ps.cancel();
                            return;
                        }
                        String sch = rs.getString(1);
                        String name = rs.getString(2);
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        String dim = rs.getString(9);
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname + "/" + dim);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new JoinsHelper(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() OLAP", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() OLAP", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processTableDependenciesStarSchemaAttributeClustering(Connection conn, String schema, Map<String, ContainerObject> containers, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser, ProgressDialog pd) {
        ResultSet rs;
        PreparedStatement ps;
        block24: {
            block23: {
                String sql = "select tab1_owner, tab1_name,tab1_column,tab2_owner, tab2_name,tab2_column, owner, table_name\n from all_clustering_joins\n where owner = ?";
                if (dbaUser) {
                    sql = "select tab1_owner, tab1_name,tab1_column,tab2_owner, tab2_name,tab2_column, owner, table_name\n from dba_clustering_joins\n where owner = ?";
                }
                String type = "AtrClustering/";
                ps = null;
                rs = null;
                try {
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, schema);
                    rs = ps.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            JoinsHelper h;
                            JoinsHelper h2;
                            String name;
                            if (pd != null && pd.isCancelled()) {
                                ps.cancel();
                                Closeables.close((Object)rs);
                                if (ps == null) return;
                                break block23;
                            }
                            String sch = rs.getString(1);
                            if (!Dependencies.contains(containers, sch, name = rs.getString(2))) continue;
                            String column = rs.getString(3);
                            String dsch = rs.getString(4);
                            String dname = rs.getString(5);
                            String dcolumn = rs.getString(6);
                            String isch = rs.getString(7);
                            String iname = rs.getString(8);
                            JoinsHelper first = tables.get((schema + "." + name).toUpperCase());
                            if (first == null) {
                                first = new JoinsHelper(schema, name);
                                tables.put(first.getID(), first);
                            }
                            if (first.type.isEmpty()) {
                                first.type = fact;
                            }
                            if (fact.equalsIgnoreCase(first.type)) {
                                Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                                join.addDiscoverySource(type + isch + "." + iname);
                                first.addJoin(join);
                            }
                            if ((h2 = tables.get((h = new JoinsHelper(dsch, dname)).getID())) == null) {
                                h.type = dimension;
                                list.add(h);
                                tables.put(h.getID(), h);
                                continue;
                            }
                            h2.type = dimension;
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                    break block24;
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                    return;
                }
            }
            try {
                ps.close();
                return;
            }
            catch (SQLException e) {
                Logger.error_("processTableDependencies() ", e);
            }
            return;
        }
        if (ps == null) return;
        try {
            ps.close();
            return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        finally {
            Closeables.close(rs);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processTableDependenciesStarSchemaAnalyticViews(Connection conn, String schema, String item, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser, int cont_id, ProgressDialog pd) {
        ResultSet rs;
        PreparedStatement ps;
        block24: {
            block23: {
                String type = "AnView/";
                String sql = "with fact_dim as\n (select v.table_owner fowner,v.table_name ftname, v.table_alias falias,v.owner vowner,v.analytic_view_name vname,\n  d.dimension_owner downer, d.dimension_name dname,d.dimension_alias dalias\n from all_analytic_views v, all_analytic_view_dimensions d\n where v.origin_con_id = ? and d.origin_con_id = v.origin_con_id and v.owner = d.owner and d.analytic_view_name = v.analytic_view_name\n  and v.table_owner = ? and v.table_name = ? ), \ndim_t as\n (select p.owner,p.dimension_name,p.table_owner, p.table_name, p.table_alias, a.attribute_name, a.column_name from all_attribute_dim_tables p, all_attribute_dim_attrs a\n where a.origin_con_id = ? and p.origin_con_id = a.origin_con_id and p.owner = a.owner and a.dimension_name = p.dimension_name\n  and a.table_alias = p.table_alias) \nselect distinct fowner,ftname,s.av_key_column fkcolumn,t.table_owner ref_table_owner,t.table_name ref_table_name, t.column_name ref_column,f.vowner,f.vname from fact_dim f, dim_t t, all_analytic_view_keys s\n where s.origin_con_id = ? and f.downer = t.owner and f.dname = t.dimension_name and f.vname = s.analytic_view_name and t.attribute_name=s.ref_dimension_attr \n  and dalias = s.dimension_alias and falias = s.av_key_table_alias ";
                if (dbaUser) {
                    sql = "with fact_dim as\n (select v.table_owner fowner,v.table_name ftname, v.table_alias falias,v.owner vowner,v.analytic_view_name vname,\n  d.dimension_owner downer, d.dimension_name dname,d.dimension_alias dalias\n from dba_analytic_views v, dba_analytic_view_dimensions d\n where v.origin_con_id = ? and d.origin_con_id = v.origin_con_id and v.owner = d.owner and d.analytic_view_name = v.analytic_view_name\n  and v.table_owner = ? and v.table_name = ? ), \ndim_t as\n (select p.owner,p.dimension_name,p.table_owner, p.table_name, p.table_alias, a.attribute_name, a.column_name from dba_attribute_dim_tables p, dba_attribute_dim_attrs a\n where a.origin_con_id = ? and p.origin_con_id = a.origin_con_id and p.owner = a.owner and a.dimension_name = p.dimension_name\n  and a.table_alias = p.table_alias) \nselect distinct fowner,ftname,s.av_key_column fkcolumn,t.table_owner ref_table_owner,t.table_name ref_table_name, t.column_name ref_column,f.vowner,f.vname from fact_dim f, dim_t t, dba_analytic_view_keys s\n where s.origin_con_id = ? and f.downer = t.owner and f.dname = t.dimension_name and f.vname = s.analytic_view_name and t.attribute_name=s.ref_dimension_attr \n  and dalias = s.dimension_alias and falias = s.av_key_table_alias ";
                }
                ps = null;
                rs = null;
                try {
                    ps = conn.prepareStatement(sql);
                    ps.setInt(1, cont_id);
                    ps.setString(2, schema);
                    ps.setString(3, item);
                    ps.setInt(4, cont_id);
                    ps.setInt(5, cont_id);
                    rs = ps.executeQuery();
                    if (rs != null) {
                        JoinsHelper first = tables.get((schema + "." + item).toUpperCase());
                        if (first == null) {
                            first = new JoinsHelper(schema, item);
                            tables.put(first.getID(), first);
                        }
                        if (first != null && first.type.isEmpty()) {
                            first.type = fact;
                        }
                        while (rs.next()) {
                            JoinsHelper h;
                            JoinsHelper h2;
                            if (pd != null && pd.isCancelled()) {
                                ps.cancel();
                                Closeables.close((Object)rs);
                                if (ps == null) return;
                                break block23;
                            }
                            String sch = rs.getString(1);
                            String name = rs.getString(2);
                            String column = rs.getString(3);
                            String dsch = rs.getString(4);
                            String dname = rs.getString(5);
                            String dcolumn = rs.getString(6);
                            String isch = rs.getString(7);
                            String iname = rs.getString(8);
                            if (fact.equalsIgnoreCase(first.type)) {
                                Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                                join.addDiscoverySource(type + isch + "." + iname);
                                first.addJoin(join);
                            }
                            if ((h2 = tables.get((h = new JoinsHelper(dsch, dname)).getID())) == null) {
                                h.type = dimension;
                                list.add(h);
                                tables.put(h.getID(), h);
                                continue;
                            }
                            h2.type = dimension;
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                    break block24;
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                    return;
                }
            }
            try {
                ps.close();
                return;
            }
            catch (SQLException e) {
                Logger.error_("processTableDependencies() ", e);
            }
            return;
        }
        if (ps == null) return;
        try {
            ps.close();
            return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        finally {
            Closeables.close(rs);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processTableDependenciesStarSchemaFK(Connection conn, Writer osw, String schema, String item, List<JoinsHelper> list, Map<String, JoinsHelper> tables, boolean dbaUser) {
        if (item == null) return;
        if (item.isEmpty()) return;
        StringBuffer sb = new StringBuffer();
        sb.append("with constr_join as \n");
        sb.append("  ( \n");
        sb.append("    select a.owner, \n");
        sb.append("      a.table_name, \n");
        sb.append("      a.CONSTRAINT_NAME, \n");
        sb.append("      a.R_OWNER, \n");
        sb.append("      a.R_CONSTRAINT_NAME, \n");
        sb.append("      B.TABLE_NAME as R_Table_name \n");
        if (dbaUser) {
            sb.append("    from DBA_CONSTRAINTS a, \n");
            sb.append("      DBA_CONSTRAINTS b \n");
        } else {
            sb.append("    from ALL_CONSTRAINTS a, \n");
            sb.append("      ALL_CONSTRAINTS b \n");
        }
        sb.append("    where A.R_OWNER = B.OWNER \n");
        sb.append("      and A.R_CONSTRAINT_NAME = B.CONSTRAINT_NAME \n");
        sb.append("  ) \n");
        sb.append("select R_OWNER, \n");
        sb.append("  R_TABLE_NAME \n");
        sb.append("from constr_join a \n");
        sb.append("where a.owner = ? \n");
        sb.append("  and a.table_name = ?");
        String sql = sb.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            rs = ps.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String sch = rs.getString(1);
                    String name = rs.getString(2);
                    JoinsHelper h = new JoinsHelper(sch, name);
                    if (schema.equals(sch) && item.equals(name)) continue;
                    list.add(h);
                    tables.put(h.getID(), h);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
            if (ps == null) return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        try {
            ps.close();
            return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        finally {
            Closeables.close(rs);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    static List<DBObject> getDBObjects(List<JoinsHelper> tables) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (JoinsHelper item : tables) {
            DBObject dbo = new DBObject(true, item.refName, "TABLE", item.refSchema);
            dbo.dwhType = item.type;
            if (item.joins.size() > 0) {
                dbo.joins = new ArrayList<Join>(item.joins.values());
            }
            list.add(dbo);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForExternalTables(Connection conn, List<DBObject> objects, boolean dbaUser) {
        Statement statement_ext = null;
        ResultSet rs_ext = null;
        try {
            if (statement_ext == null) {
                String sql = "select 1 from " + (dbaUser ? "DBA_EXTERNAL_TABLES" : "ALL_EXTERNAL_TABLES") + " WHERE owner = ? AND table_name = ?";
                statement_ext = conn.prepareStatement(sql);
            }
            for (DBObject dbo : objects) {
                if (!dbo.getType().equalsIgnoreCase("TABLE")) continue;
                statement_ext.setString(1, dbo.getSchema());
                statement_ext.setString(2, dbo.getName());
                rs_ext = statement_ext.executeQuery();
                if (rs_ext == null) continue;
                if (rs_ext.next()) {
                    dbo.setType("EXTERNAL TABLE");
                }
                rs_ext.close();
            }
        }
        catch (Exception e) {
            Logger.error_("checkForExternalTables() ", e);
        }
        finally {
            Closeables.close(rs_ext);
            if (statement_ext != null) {
                try {
                    statement_ext.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static void scanForJoins(Connection conn, List<Join> joins, RelationalDesign rd, boolean all, boolean sqlDim, boolean bJoin, boolean mviews, boolean atrClust, boolean olap, boolean anViewsd) {
        Dependencies.scanForJoins(conn, joins, rd, all, sqlDim, bJoin, mviews, atrClust, olap, anViewsd, null, null);
    }

    public static void scanForJoins(Connection conn, List<Join> joins, RelationalDesign rd, boolean all, boolean sqlDim, boolean bJoin, boolean mviews, boolean atrClust, boolean olap, boolean anViews, ProgressDialog pd, DPVRelational dpv) {
        boolean cancelled = false;
        boolean sleep = false;
        long time = 2000L;
        if (pd != null) {
            // empty if block
        }
        boolean dbaUser = DBMExtractionHandlerOracle.isDBAUser(conn);
        int ver = DBMExtractionHandlerOracle.getOracleVersionInt(conn);
        ArrayList<JoinsHelper> list = new ArrayList<JoinsHelper>();
        HashMap<String, JoinsHelper> tables = new HashMap<String, JoinsHelper>();
        Map<String, ContainerObject> containers = rd.getContainersMap(dpv);
        HashMap<String, String> sch = new HashMap<String, String>();
        for (ContainerObject co : containers.values()) {
            String schema = co.getSchema();
            if (sch.containsKey(schema)) continue;
            sch.put(schema, schema);
        }
        int k = 0;
        switch (k) {
            case 0: {
                ArrayList<String> schemas = new ArrayList<String>(sch.keySet());
                if (all || bJoin) {
                    if (pd != null) {
                        pd.setNote("Processing Bitmap Join Indexes");
                    }
                    Dependencies.processBJI(conn, schemas, list, tables, containers, dbaUser, pd);
                }
                if (pd != null) {
                    if (pd.isCancelled()) break;
                    pd.increaseProgress(10);
                    if (sleep) {
                        try {
                            Thread.sleep(time);
                        }
                        catch (InterruptedException schema) {
                            // empty catch block
                        }
                    }
                }
                if (all || mviews) {
                    if (pd != null) {
                        pd.setNote("Processing Materialized Views with  Aggregates");
                    }
                    Dependencies.processMViews(conn, schemas, list, tables, containers, dbaUser, pd);
                }
                if (pd != null) {
                    if (pd.isCancelled()) break;
                    pd.increaseProgress(10);
                    if (sleep) {
                        try {
                            Thread.sleep(time);
                        }
                        catch (InterruptedException schema) {
                            // empty catch block
                        }
                    }
                }
                if (ver > 11) {
                    if (all || atrClust) {
                        if (pd != null) {
                            pd.setNote("Processing Attribute Clustering");
                        }
                        Dependencies.processAttributeClustering(conn, schemas, list, tables, containers, dbaUser, pd);
                    }
                    if (pd != null) {
                        if (pd.isCancelled()) break;
                        pd.increaseProgress(10);
                        if (sleep) {
                            try {
                                Thread.sleep(time);
                            }
                            catch (InterruptedException schema) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (ver > 12) {
                    if (all || anViews) {
                        if (pd != null) {
                            pd.setNote("Processing Analytic Views");
                        }
                        Dependencies.processAnalyticViews(conn, schemas, list, tables, containers, dbaUser, pd);
                    }
                    if (pd != null) {
                        if (pd.isCancelled()) {
                            return;
                        }
                        pd.increaseProgress(10);
                        if (sleep) {
                            try {
                                Thread.sleep(time);
                            }
                            catch (InterruptedException schema) {
                                // empty catch block
                            }
                        }
                    }
                    if (all || olap) {
                        if (pd != null) {
                            pd.setNote("Processing OLAP Cubes");
                        }
                        Dependencies.processOLAP(conn, schemas, list, tables, containers, dbaUser, pd);
                        if (pd != null) {
                            if (pd.isCancelled()) {
                                return;
                            }
                            pd.increaseProgress(10);
                            if (sleep) {
                                try {
                                    Thread.sleep(time);
                                }
                                catch (InterruptedException schema) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (all || sqlDim) {
                    if (pd != null) {
                        pd.setNote("Processing SQL Dimensions");
                    }
                    Dependencies.processDimwensions(conn, schemas, list, tables, containers, dbaUser, pd);
                }
                if (pd == null) break;
                pd.increaseProgress(20);
            }
        }
        for (JoinsHelper jh : tables.values()) {
            if (!fact.equals(jh.type)) continue;
            joins.addAll(jh.joins.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getContainerID(Connection conn) {
        int cont_id = 0;
        String sql1 = "select SYS_CONTEXT('USERENV', 'CON_ID') ID FROM DUAL";
        PreparedStatement ps1 = null;
        ResultSet rs = null;
        try {
            ps1 = conn.prepareStatement(sql1);
            rs = ps1.executeQuery();
            if (rs != null && rs.next()) {
                cont_id = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                Logger.error_("Dependencies.Error in getting container ID", e);
            }
            catch (Throwable throwable) {
                Closeables.close(rs);
                if (ps1 != null) {
                    try {
                        ps1.close();
                    }
                    catch (Exception e2) {
                        Logger.error_("Dependencies.Error in getting container ID", e2);
                    }
                }
                throw throwable;
            }
            Closeables.close((Object)rs);
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (Exception e3) {
                    Logger.error_("Dependencies.Error in getting container ID", e3);
                }
            }
        }
        Closeables.close((Object)rs);
        if (ps1 != null) {
            try {
                ps1.close();
            }
            catch (Exception e) {
                Logger.error_("Dependencies.Error in getting container ID", e);
            }
        }
        return cont_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void processAnalyticViews(Connection conn, List<String> schemas, List<JoinsHelper> list, Map<String, JoinsHelper> tables, Map<String, ContainerObject> containers, boolean dbaUser, ProgressDialog pd) {
        ResultSet rs;
        PreparedStatement st;
        block11: {
            block10: {
                int cont_id = Dependencies.getContainerID(conn);
                String sql = "select distinct table_name from all_analytic_views where table_owner = ?";
                if (dbaUser) {
                    sql = "select distinct table_name from dba_analytic_views where table_owner = ?";
                }
                st = null;
                rs = null;
                try {
                    for (String sch : schemas) {
                        if (st == null) {
                            st = conn.prepareStatement(sql);
                        }
                        st.setString(1, sch);
                        rs = st.executeQuery();
                        if (rs == null) continue;
                        while (rs.next()) {
                            if (pd != null && pd.isCancelled()) {
                                st.cancel();
                                break block10;
                            }
                            String table_name = rs.getString(1);
                            if (!Dependencies.contains(containers, sch, table_name)) continue;
                            Dependencies.processTableDependenciesStarSchemaAnalyticViews(conn, sch, table_name, list, tables, dbaUser, cont_id, pd);
                        }
                        rs.close();
                    }
                    break block11;
                }
                catch (SQLException e) {
                    try {
                        Logger.error_("processAnalyticViews() ", e);
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, st});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, st});
                    return;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, st});
            return;
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, st});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void processOLAP(Connection conn, List<String> schemas, List<JoinsHelper> list, Map<String, JoinsHelper> tables, Map<String, ContainerObject> containers, boolean dbaUser, ProgressDialog pd) {
        ResultSet rs;
        PreparedStatement st;
        block11: {
            block10: {
                String sql = "select distinct a.p_top_obj_name from all_cube_dependencies a where a.d_obj_type = 'CUBE MAP' and a.p_obj_owner =  ?";
                if (dbaUser) {
                    sql = "select distinct a.p_top_obj_name from dba_cube_dependencies a where a.d_obj_type = 'CUBE MAP' and a.p_obj_owner = ?";
                }
                st = null;
                rs = null;
                try {
                    for (String sch : schemas) {
                        if (st == null) {
                            st = conn.prepareStatement(sql);
                        }
                        st.setString(1, sch);
                        rs = st.executeQuery();
                        if (rs == null) continue;
                        while (rs.next()) {
                            if (pd != null && pd.isCancelled()) {
                                st.cancel();
                                break block10;
                            }
                            String table_name = rs.getString(1);
                            if (!Dependencies.contains(containers, sch, table_name)) continue;
                            Dependencies.processTableDependenciesStarSchemaOLAP(conn, sch, table_name, list, tables, dbaUser, pd);
                        }
                        rs.close();
                    }
                    break block11;
                }
                catch (SQLException e) {
                    try {
                        Logger.error_("processAnalyticViews() ", e);
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, st});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, st});
                    return;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, st});
            return;
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, st});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processBJI(Connection conn, List<String> schemas, List<JoinsHelper> list, Map<String, JoinsHelper> tables, Map<String, ContainerObject> containers, boolean dbaUser, ProgressDialog pd) {
        try {
            for (String sch : schemas) {
                if (pd != null && pd.isCancelled()) {
                    return;
                }
                Dependencies.processTableDependenciesStarSchemaBJI(conn, sch, containers, list, tables, dbaUser, pd);
            }
        }
        catch (Exception e) {
            Logger.error_("processAnalyticViews() ", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processDimwensions(Connection conn, List<String> schemas, List<JoinsHelper> list, Map<String, JoinsHelper> tables, Map<String, ContainerObject> containers, boolean dbaUser, ProgressDialog pd) {
        try {
            for (ContainerObject co : containers.values()) {
                JoinsHelper jh;
                if (pd != null && pd.isCancelled()) {
                    return;
                }
                boolean isfact = "1".equals(((FKContainer)co).getTypeID());
                if (!isfact && (jh = tables.get(co.getLongName().toUpperCase())) != null) {
                    isfact = fact.equals(jh.type);
                }
                if (!isfact) continue;
                Dependencies.processTableDependenciesStarSchemaDimensions(conn, co.getSchema(), co.getName(), list, tables, dbaUser, pd);
            }
        }
        catch (Exception e) {
            Logger.error_("processAnalyticViews() ", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processMViews(Connection conn, List<String> schemas, List<JoinsHelper> list, Map<String, JoinsHelper> tables, Map<String, ContainerObject> containers, boolean dbaUser, ProgressDialog pd) {
        try {
            for (String sch : schemas) {
                if (pd != null && pd.isCancelled()) {
                    return;
                }
                Dependencies.processTableDependenciesStarSchemaMViews(conn, sch, containers, list, tables, dbaUser, pd);
            }
        }
        catch (Exception e) {
            Logger.error_("processAnalyticViews() ", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processAttributeClustering(Connection conn, List<String> schemas, List<JoinsHelper> list, Map<String, JoinsHelper> tables, Map<String, ContainerObject> containers, boolean dbaUser, ProgressDialog pd) {
        try {
            for (String sch : schemas) {
                if (pd != null && pd.isCancelled()) {
                    return;
                }
                Dependencies.processTableDependenciesStarSchemaAttributeClustering(conn, sch, containers, list, tables, dbaUser, pd);
            }
        }
        catch (Exception e) {
            Logger.error_("processAnalyticViews() ", e);
            e.printStackTrace();
        }
    }

    static boolean contains(Map map, String schema, String name) {
        return map.containsKey((schema + "." + name).toUpperCase());
    }

    public static class JoinsHelper {
        public String schema;
        public String name;
        public String refSchema;
        public String refName;
        public boolean selected = true;
        String type = "";
        Map<String, Join> joins = new TreeMap<String, Join>();

        JoinsHelper(String schema, String name) {
            this.schema = schema;
            this.name = name;
        }

        JoinsHelper(String schema, String name, String refSchema, String refName) {
            this.schema = schema;
            this.name = name;
            this.refSchema = refSchema;
            this.refName = refName;
        }

        String getID() {
            return (this.schema + "." + this.name).toUpperCase();
        }

        public String toString() {
            return this.getID();
        }

        public void addJoin(Join join) {
            Join t = this.joins.get(join.getID());
            if (t != null) {
                t.addDiscoverySource(join.getDiscoverySource());
            } else {
                this.joins.put(join.getID(), join);
            }
        }

        public String getReferredTableLongName() {
            return this.refSchema + "." + this.refName;
        }

        public String getTableLongName() {
            return this.schema + "." + this.name;
        }
    }

    static class Pair {
        String schema;
        String name;

        Pair() {
        }
    }
}

