/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.GenerationHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDBMExtractionHandler
implements GenerationHandler {
    protected String dbProductName = "";
    protected String dbProductVersion = "";
    protected int dbMajorVersion = -1;
    protected int dbMinorVersion = -1;
    private List showList = null;
    private static boolean allSelected = false;
    private static boolean schemaBased = true;
    protected StorageDesign storageDesign;
    private Design design;
    private RelationalDesign relationalDesign;
    private static final Logger LOGGER = new Logger(AbstractDBMExtractionHandler.class);

    public AbstractDBMExtractionHandler(StorageDesign sd) {
        this.storageDesign = sd;
        if (sd == null) {
            this.design = ApplicationView.getInstance().getCurrentDesign();
            this.relationalDesign = this.design.getRelationalDesign();
        }
    }

    public abstract RDBMSSite getRDBMSSite();

    public abstract List getMOHObjects(Connection var1);

    public String getDBProductVersion() {
        return this.dbProductVersion;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    public int getDBMajorVersion() {
        return this.dbMajorVersion;
    }

    public static boolean isAllSelected() {
        return allSelected;
    }

    public static void setAllSelected(boolean allSel) {
        allSelected = allSel;
    }

    public static boolean isSchemaBased() {
        return schemaBased;
    }

    public static void setSchemaBased(boolean schemaBase) {
        schemaBased = schemaBase;
    }

    protected void dumpResultSet(ResultSet rs) {
        try {
            while (rs.next()) {
                System.out.println("-----------------------------------------------");
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    System.out.println(rsmd.getColumnName(i) + " : " + rsmd.getColumnTypeName(i) + " = " + rs.getString(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getSchemas(Connection conn) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            boolean mvSet = false;
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                if (this.dbProductName.toUpperCase().indexOf("ORACLE") > -1) {
                    Statement st;
                    block15: {
                        st = conn.createStatement();
                        try {
                            ResultSet rs = st.executeQuery("select product, version from product_component_version where product like 'Oracle%'");
                            if (rs == null) break block15;
                            if (rs.next()) {
                                this.dbProductVersion = rs.getString(1);
                                String mv = rs.getString(2);
                                if (mv != null && mv.length() > 0) {
                                    try {
                                        String kv = mv.substring(0, mv.indexOf("."));
                                        this.dbMajorVersion = Integer.parseInt(kv);
                                        if (this.dbMajorVersion == 12 && (kv = mv.substring(mv.indexOf(".") + 1)).startsWith("2")) {
                                            this.dbMinorVersion = 2;
                                        }
                                        mvSet = true;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            rs.close();
                        }
                        catch (Exception e) {
                            this.dbProductVersion = dbmd.getDatabaseProductVersion();
                        }
                    }
                    if (st != null) {
                        st.close();
                    }
                } else {
                    this.dbProductVersion = dbmd.getDatabaseProductVersion();
                }
                if (!mvSet) {
                    this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                }
            }
            catch (Throwable e) {
                LOGGER.error(e);
                System.out.println(e.getMessage());
            }
            ResultSet resultSet = dbmd.getSchemas();
            while (resultSet.next()) {
                String schema = resultSet.getString(1);
                DBObject dbo = new DBObject(false, schema);
                list.add(dbo);
            }
            resultSet.close();
        }
        return list;
    }

    public List getDBObjects(Connection conn, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects(conn);
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                if (!moHandler.showObjects()) continue;
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    list.add((DBObject)obj);
                }
            }
        }
        return list;
    }

    @Override
    public List getDBObjects(Connection conn, List schemas, String type) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects(conn);
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                if (!type.equalsIgnoreCase(moHandler.getType())) continue;
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    list.add((DBObject)obj);
                }
            }
        }
        return list;
    }

    protected boolean isNullStorageDesign(StorageDesign sd) {
        if (sd instanceof StorageDesign.NullStorageDesign) {
            StorageDesign.NullStorageDesign nsd = (StorageDesign.NullStorageDesign)sd;
            LOGGER.error(nsd.getName());
            Iterator it = nsd.getMessage().iterator();
            while (it.hasNext()) {
                LOGGER.error((String)it.next());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        List mhoList = this.getMOHObjects(conn);
        if (selectedObjects.size() <= 0) return;
        if (mhoList.size() <= 0) return;
        if (conn == null) return;
        try {
            int counter = 0;
            double step = 10.0;
            int size = mhoList.size();
            for (AbstractMOHandler moHandler : mhoList) {
                moHandler.preGenerateProcessing(conn, selectedObjects);
            }
            for (AbstractMOHandler moHandler : mhoList) {
                TimeLog.log(moHandler.getType() + " +++++++++++ begin");
                moHandler.setSupportInformation_Schema(true);
                moHandler.generate(conn, selectedObjects, importLog);
                TimeLog.log(moHandler.getType() + " +++++++++++ end");
                moHandler.clearHandledObjects(selectedObjects);
                ++counter;
                step += 75.0 / (double)size;
                if (monitor == null) continue;
                monitor.setProgress((int)step);
            }
            TimeLog.log(" +++=============== Postgenerate processing begin");
            for (AbstractMOHandler moHandler : mhoList) {
                TimeLog.log(moHandler.getType() + " +++++++++++ begin");
                moHandler.postGenerateProcessing(conn);
                TimeLog.log(moHandler.getType() + " +++++++++++ end");
            }
            TimeLog.log(" +++=============== Postgenerate processing end");
            return;
        }
        catch (Exception e) {
            LOGGER.error("Error in database import:", e);
            MessageDialogs.showErrorMessage(ApplicationView.frame, e.getMessage() != null ? e.getMessage() : "An error occured while importing from database.\nSee the log file for more details.", true);
            return;
        }
        finally {
            try {
                if (conn.isClosed()) {
                    // empty if block
                }
            }
            catch (Exception ec) {
                LOGGER.error(ec.toString());
            }
        }
    }

    public boolean isSecondaryTables() {
        return ApplicationView.getInstance().getSettings().isImportSecondaryTables();
    }

    public void setSecondaryTables(boolean secondaryTables) {
        ApplicationView.getInstance().getSettings().setImportSecondaryTables(secondaryTables);
    }

    public boolean isSpatialProperties() {
        return ApplicationView.getInstance().getSettings().isImportSpatialProperties();
    }

    public void setSpatialProperties(boolean spatialProperties) {
        ApplicationView.getInstance().getSettings().setImportSpatialProperties(spatialProperties);
    }

    public List getShowList() {
        return this.showList;
    }

    public void setShowList(List showList) {
        this.showList = showList;
    }

    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                this.dbMinorVersion = dbmd.getDatabaseMinorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isPartitions() {
        return ApplicationView.getInstance().getSettings().isImportPartitions();
    }

    public void setPartitions(boolean partitions) {
        ApplicationView.getInstance().getSettings().setImportPartitions(partitions);
    }

    public boolean isTriggers() {
        return ApplicationView.getInstance().getSettings().isImportTriggers();
    }

    public void setTriggers(boolean triggers) {
        ApplicationView.getInstance().getSettings().setImportTriggers(triggers);
    }

    public boolean isStructuredTypesScan() {
        return ApplicationView.getInstance().getSettings().isScanForUsedStructuredTypes();
    }

    public void setStructuredTypesScan(boolean structuredTypesScan) {
        ApplicationView.getInstance().getSettings().setScanForUsedStructuredTypes(structuredTypesScan);
    }

    public AbstractMOHandler getTableHandler() {
        return null;
    }

    public StorageDesign getStorageDesign() {
        if (this.storageDesign == null) {
            RDBMSSite site = this.getRDBMSSite();
            this.storageDesign = site != null ? this.relationalDesign.getStorageDesign(site) : this.relationalDesign.getStorageDesign();
        }
        return this.storageDesign;
    }

    public RelationalDesign getRelationalDesign() {
        if (this.storageDesign != null) {
            return this.storageDesign.getPhysicalDesign();
        }
        return this.relationalDesign;
    }

    public Design getDesign() {
        if (this.storageDesign != null) {
            return this.storageDesign.getDesign();
        }
        return this.design;
    }

    public int getDbMinorVersion() {
        return this.dbMinorVersion;
    }

    public void setDbMinorVersion(int dbMinorVersion) {
        this.dbMinorVersion = dbMinorVersion;
    }
}

