/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.crest.imports.erwin.SAXAttributeHandler;
import oracle.dbtools.crest.imports.erwin.SAXElementHandler;
import oracle.dbtools.crest.imports.erwin.SAXEntityHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ERSAXHandler
extends DefaultHandler {
    private ApplicationView appView;
    private boolean inExistingDesign;
    private String designName;
    private Design design;
    private ProgressDialog monitor;
    private int monitorPercent;
    CharArrayWriter text = new CharArrayWriter();
    ERParseContext context = new ERParseContext();
    SAXElementHandler chain;
    protected Stack stack = null;

    public ERSAXHandler(ApplicationView appView, boolean inExistingDesign) {
        this.appView = appView;
        this.inExistingDesign = inExistingDesign;
        this.design = appView.getCurrentDesign();
        this.monitor = new ProgressDialog(appView, "Import ERwin 7.x", 0, 100);
        this.monitorPercent = 0;
        this.stack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.stack.push(qName);
        if (this.chain != null) {
            this.text.reset();
            this.chain.handleStartElement(uri, localName, qName, attributes, this.context);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stack.pop();
        if (this.chain != null) {
            this.chain.handleEndElement(uri, localName, qName, this.context);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }

    public String getText() {
        return this.text.toString().trim();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.monitor.close();
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.monitor.close();
        throw e;
    }

    public Design getDesign() {
        return this.design;
    }

    protected void setDesignName(String designName) {
        this.designName = !this.inExistingDesign ? designName : this.appView.getDesignName();
        this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.appView.designExists(designName)) {
            this.appView.deleteDesign(designName);
        }
        if (!this.inExistingDesign) {
            this.appView.setDesignName(designName);
        }
        if (!this.inExistingDesign) {
            this.design.setFileName(this.designName);
        }
    }

    public String deriveObjectID(String prefix, String ERwinID) {
        return prefix + ERwinID.substring(1, 37) + "_" + ERwinID.substring(39);
    }

    public void monitorProgress(String message, int increment) {
        this.monitor.setNote(message);
        if (increment < 0) {
            this.monitor.close();
            return;
        }
        if (increment == 0) {
            this.monitorPercent = 0;
        } else if (increment == 100) {
            this.monitorPercent = 100;
        } else {
            this.monitorPercent += increment;
            if (this.monitorPercent > 95) {
                this.monitorPercent = 95;
            }
        }
        this.monitor.setProgress(this.monitorPercent);
    }

    public void monitorClose() {
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    protected boolean isUTFString(String string) {
        int l = string.length();
        try {
            byte[] b = string.getBytes("UTF-8");
            return l < b.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    protected void createMappings(Design design, Map logicalObjects, Map relationalObjects) {
        for (Object key : logicalObjects.keySet()) {
            DesignObject logicalObject = (DesignObject)logicalObjects.get(key);
            DesignObject relationalObject = (DesignObject)relationalObjects.get(key);
            if (logicalObject == null || relationalObject == null || design.getExtendedMap().getMapping(logicalObject, relationalObject) != null || this.isDeleted(logicalObject) || this.isDeleted(relationalObject)) continue;
            XtdMapping mapping = design.getExtendedMap().createMapping(logicalObject, relationalObject);
            relationalObject.setGeneratorID(logicalObject.getObjectID());
            mapping.setCreationTime(System.currentTimeMillis());
        }
    }

    protected boolean isDeleted(DesignObject designObject) {
        if (designObject instanceof ContainedObject) {
            ContainedObject co = (ContainedObject)designObject;
            return co.getContainer() == null;
        }
        return false;
    }

    protected void initChain() {
        this.chain = new SAXEntityHandler(this);
        this.chain.add(new SAXAttributeHandler(this));
    }

    public static class ERParseContext {
        public Entity entity;
        public boolean inEntity;
        public Attribute attribute;
        public boolean inAttribute;
    }
}

