/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.domains;

import java.util.List;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;

public class DomainsImporter {
    private Design design;

    public DomainsImporter(Design design) {
        this.design = design;
    }

    public void importDomains(List domainSelection, String fileName) {
        for (EngineeringObjectSelection sel : domainSelection) {
            if (!sel.isSelected()) continue;
            this.processDomain(sel, fileName);
        }
    }

    private void processDomain(EngineeringObjectSelection sel, String fileName) {
        Domain domain = (Domain)sel.getObject();
        if (2 == sel.getStatus()) {
            Domain newDomain = this.design.getDomainSet().createDomain(domain.getObjectID());
            newDomain.setOwnerDesign(this.design);
            domain.copyTo(newDomain);
            newDomain.setFileName(fileName);
            newDomain.setImportedId(domain.getObjectID());
        } else {
            DomainPropertiesComparator comp = (DomainPropertiesComparator)sel.getPropertiesComparator();
            comp.copySelectedProperties();
            ((Domain)sel.getCorrespondentNode().getObject()).setImportedId(domain.getObjectID());
            ((Domain)sel.getCorrespondentNode().getObject()).setFileName(fileName);
        }
    }
}

