/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceUDBv81
extends DDLStatementHandler {
    private String userName;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateSequenceUDBv81.class);

    public SHCreateSequenceUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSequenceUDBv81.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "create sequence")) {
            this.parseSequence(statement);
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSequence(String statement) {
        SequenceUDBv81 sequence;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 stoDesign = (StorageDesignUDBv81)this.design.getStorageDesign(site);
        if (stoDesign != null && (sequence = (SequenceUDBv81)stoDesign.getSequenceSet().createSequence()) != null) {
            try {
                this.initName(sequence);
                this.initOwner(sequence, stoDesign);
                this.initDataType(sequence);
                this.initStartWith(sequence);
                this.initIncrementBy(sequence);
                this.initMaxValue(sequence);
                this.initMinValue(sequence);
                this.initCycle(sequence);
                this.initCache(sequence);
                this.initOrder(sequence);
                this.importLog.incrementImportedStatements();
                this.design.getRelationalDesign().stampModelObjectDDL(sequence);
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB 8.1 failed!", e);
                this.importLog.addFailedStatement(SHCreateSequenceUDBv81.FormatCR(this.line, "\n"));
            }
        }
    }

    private void initName(SequenceUDBv81 sequence) {
        String name = Token.getNameAfterToken(this.statement, "SEQUENCE", '\"', '\"').trim();
        if (name.indexOf(46) > 0) {
            this.userName = name.substring(0, name.indexOf(46)).trim();
            name = name.substring(name.indexOf(46) + 1).trim();
        }
        sequence.setName(name);
    }

    private void initOwner(SequenceUDBv81 sequence, StorageDesignUDBv81 storageDesign) {
        if (this.userName != null) {
            SchemaUDBv81 schema = (SchemaUDBv81)storageDesign.getSchemaSet().getByName(this.userName);
            if (schema == null) {
                schema = (SchemaUDBv81)storageDesign.getSchemaSet().createSchema();
                schema.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            sequence.setSchema(schema);
        }
    }

    private void initDataType(SequenceUDBv81 sequence) throws ParseException {
        if (!Token.hasString(this.statement, "AS")) {
            this.importLog.addWarning("Wrong datatype in statement " + this.statement);
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initDataType: ");
        }
        String datatype = Token.getTokenAfter(this.statement, "AS").trim();
        sequence.setDatatype(datatype);
    }

    private void initStartWith(SequenceUDBv81 sequence) throws ParseException {
        String str;
        if (Token.hasString(this.statement, "START")) {
            str = Token.getTokenAfter(this.statement, "WITH").trim();
            if (!sequence.checkSeqValue(str)) {
                this.importLog.addWarning("Wrong START WITH format in statement " + this.statement);
                throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : START WITH = " + str);
            }
        } else {
            this.importLog.addWarning("Wrong START WITH format in statement " + this.statement);
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : ");
        }
        sequence.setStartWith(str);
    }

    private void initIncrementBy(SequenceUDBv81 sequence) {
        if (Token.hasToken(this.statement, "BY")) {
            String str = Token.getTokenAfter(this.statement, "BY").trim();
            if (sequence.checkSeqValue(str)) {
                sequence.setIncrementBy(str);
            } else {
                this.importLog.addWarning("Wrong INCREMENT BY format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSequenceDB2v80.initIncrementBy : INCREMENT BY = " + str);
            }
        }
    }

    private void initMaxValue(SequenceUDBv81 sequence) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MAXVALUE").equalsIgnoreCase("NO")) {
                String str = Token.getTokenAfter(this.statement, "MAXVALUE").trim();
                if (sequence.checkSeqValue(str)) {
                    sequence.setMaxValue(str);
                } else {
                    this.importLog.addWarning("Wrong MAX VALUE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateSequenceOracle.initMaxValue : MAXVALUE = " + str);
                }
            } else {
                sequence.setMaxValue("NO");
            }
        } else {
            sequence.setMaxValue("NO");
        }
    }

    private void initMinValue(SequenceUDBv81 sequence) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MINVALUE").equalsIgnoreCase("NO")) {
                String str = Token.getTokenAfter(this.statement, "MINVALUE").trim();
                if (sequence.checkSeqValue(str)) {
                    sequence.setMinValue(str);
                } else {
                    this.importLog.addWarning("Wrong MIN VALUE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initMinValue : MINVALUE = " + str);
                }
            } else {
                sequence.setMinValue("NO");
            }
        } else {
            sequence.setMinValue("NO");
        }
    }

    private void initCycle(SequenceUDBv81 sequence) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            if (!Token.getTokenBefore(this.statement, "CYCLE").equalsIgnoreCase("NO")) {
                sequence.setCycle("YES");
            } else {
                sequence.setCycle("NO");
            }
        } else {
            sequence.setCycle("NO");
        }
    }

    private void initCache(SequenceUDBv81 sequence) {
        if (Token.hasToken(this.statement, "CACHE")) {
            if (!Token.getTokenBefore(this.statement, "CACHE").equalsIgnoreCase("NO")) {
                String str = Token.getTokenAfter(this.statement, "CACHE").trim();
                try {
                    int value = Integer.parseInt(str);
                    sequence.setCache(value);
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong CACHE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initCache : " + e.getMessage());
                }
            } else {
                sequence.setCache(0);
            }
        } else {
            sequence.setCache(0);
        }
    }

    private void initOrder(SequenceUDBv81 sequence) {
        if (Token.hasToken(this.statement, "ORDER")) {
            if (!Token.getTokenBefore(this.statement, "ORDER").equalsIgnoreCase("NO")) {
                sequence.setOrder("YES");
            } else {
                sequence.setOrder("NO");
            }
        } else {
            sequence.setOrder("NO");
        }
    }
}

