/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTypeUDB
extends DDLStatementHandler {
    private String ownerName = null;
    private static final Logger LOGGER = new Logger(SHCreateTypeUDB.class);

    public SHCreateTypeUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTypeUDB.clearCR(line);
        if (Token.startsWithString(statement, "create type")) {
            try {
                this.parseCreateType(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateTypeUDB.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "alter type")) {
            try {
                this.parseAlterType(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateTypeUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseCreateType(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB stoDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            StructuredTypeProxyUDB typeProxy;
            StructuredType type;
            String name = Token.getNameAfterToken(this.statement, "TYPE", '\"', '\"').trim();
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                this.ownerName = Token.getValBeforeCharacter(name, '.');
                name = Token.getValAfterCharacter(name, '.');
            }
            if (this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name) != null) {
                type = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name);
                typeProxy = (StructuredTypeProxyUDB)stoDesign.getStructuredTypeProxySet().getProxy(type.getObjectID());
            } else {
                type = this.design.getDesign().getDataTypesDesign().createStructuredType();
                type.setName(name);
                this.design.getRelationalDesign().stampModelObjectDDL(type);
                this.initSuperType(type);
                typeProxy = (StructuredTypeProxyUDB)stoDesign.getProxy(type.getObjectID());
            }
            if (typeProxy != null) {
                this.initOwner(typeProxy);
                this.initElements(type, typeProxy);
                this.initInstantiable(type);
                this.initInlineLength(typeProxy);
                this.initFinal(type);
                this.initWithFunctionAccess(typeProxy);
                this.initRefUsingType(typeProxy);
                this.initCastFunctions(typeProxy);
                this.initMethods(type, typeProxy);
            }
        }
    }

    private void initOwner(StructuredTypeProxyUDB typeProxy) {
        if (this.ownerName != null) {
            SchemaUDB owner = (SchemaUDB)((StorageDesignUDB)typeProxy.getStorageDesign()).getSchemaSet().getByName(this.ownerName);
            if (owner == null) {
                owner = ((StorageDesignUDB)typeProxy.getStorageDesign()).getSchemaSet().createSchema();
                owner.setName(this.ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            typeProxy.setSchema(owner);
        }
    }

    private void initSuperType(StructuredType type) {
        if (Token.hasToken(this.statement, "UNDER")) {
            StructuredType superType;
            String superTypeName = Token.getTokenAfter(this.statement, "UNDER");
            if (this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(superTypeName) != null) {
                superType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(superTypeName);
            } else {
                superType = this.design.getDesign().getDataTypesDesign().createStructuredType();
                superType.setName(superTypeName);
                this.design.getRelationalDesign().stampModelObjectDDL(type);
            }
            type.setParentType(superType, false);
        }
    }

    private void initElements(StructuredType type, StructuredTypeProxyUDB typeProxy) {
        String elementsString;
        if (Token.hasToken(this.statement, "AS") && (elementsString = Token.getStringAfter(this.statement, "AS").trim()).startsWith("(")) {
            elementsString = Token.getValBetweenBrackets(this.statement, 1).trim();
            StringTokenizer st = new StringTokenizer(elementsString, ",");
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                String name = Token.getFirstToken(element);
                String datatype = Token.cutFirstToken(element);
                TypeElement typeElement = new TypeElement(type.getDesignPart(), type);
                typeElement.setName(name);
                typeElement.setDesign(type.getDesign());
                this.initDatatype(datatype, typeElement);
                type.add(typeElement);
                typeElement.updateReferenceNew();
                this.design.getRelationalDesign().stampModelObjectDDL(typeElement);
            }
        }
    }

    private void initInstantiable(StructuredType type) {
        if (Token.hasString(this.statement, "NOT INSTANTIABLE")) {
            type.setInstantiable(false);
        } else if (Token.hasToken(this.statement, "INSTANTIABLE")) {
            type.setInstantiable(true);
        }
    }

    private void initInlineLength(StructuredTypeProxyUDB typeProxy) {
        if (Token.hasString(this.statement, "INLINE LENGTH")) {
            String length = Token.getStringAfter(this.statement, "INLINE LENGTH").trim();
            length = Token.getFirstToken(length).trim();
            typeProxy.setInlineLength(length);
        }
    }

    private void initFinal(StructuredType type) {
        if (Token.hasString(this.statement, "NOT FINAL")) {
            type.setFinal(false);
        } else {
            type.setFinal(true);
        }
    }

    private void initWithFunctionAccess(StructuredTypeProxyUDB typeProxy) {
        if (Token.hasString(this.statement, "FUNCTION ACCESS")) {
            typeProxy.setWithFunctionAccess("YES");
        }
    }

    private void initRefUsingType(StructuredTypeProxyUDB typeProxy) {
        if (Token.hasString(this.statement, "REF USING")) {
            String usingType = Token.getStringAfter(this.statement, "REF USING").trim();
            usingType = Token.getFirstToken(usingType).trim();
            this.initDatatype(usingType, typeProxy);
        }
    }

    private void initCastFunctions(StructuredTypeProxyUDB typeProxy) {
        if (Token.hasToken(this.statement, "CAST")) {
            String castFunction = Token.getStringAfterToken(this.statement, "CAST").trim();
            if (castFunction.startsWith("(SOURCE AS REF)")) {
                castFunction = Token.getToken(castFunction, 5).trim();
                typeProxy.setRefType2RefCastFunction(castFunction);
            } else if (castFunction.startsWith("(REF AS SOURCE)")) {
                castFunction = Token.getToken(castFunction, 5).trim();
                typeProxy.setRef2RefTypeCastFunction(castFunction);
            }
        }
    }

    private void initMethods(StructuredType type, StructuredTypeProxyUDB typeProxy) {
    }

    private void initDatatype(String datatype, DataTypeObject datatypeObject) {
        String usedDatatype;
        String datatypeName = datatype;
        String size = "";
        int precision = 0;
        int scale = 0;
        if (Token.hasCloseAndOpenBrackets(datatype)) {
            datatypeName = datatype.substring(0, datatype.indexOf("(")).trim();
            String params = Token.getValBetweenBrackets(datatype, 1);
            int positionKomma = params.indexOf(44);
            if (positionKomma > -1) {
                size = "";
                try {
                    precision = Integer.parseInt(params.substring(0, positionKomma).trim());
                }
                catch (NumberFormatException e) {
                    precision = 0;
                }
                try {
                    scale = Integer.parseInt(params.substring(positionKomma + 1).trim());
                }
                catch (NumberFormatException e) {
                    scale = 0;
                }
            } else if (datatypeName.equalsIgnoreCase("DECIMAL") || datatypeName.equalsIgnoreCase("NUMERIC")) {
                size = "";
                scale = 0;
                try {
                    precision = Integer.parseInt(params.trim());
                }
                catch (NumberFormatException e) {
                    precision = 0;
                }
            } else {
                scale = 0;
                precision = 0;
                size = params.trim();
            }
        }
        if ("UNKNOWN".equalsIgnoreCase(usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatypeName))) {
            StructuredType st = (StructuredType)datatypeObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(datatypeName);
            if (st != null) {
                datatypeObject.setType(st);
            }
        } else {
            LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
            if (logicalDT != null) {
                datatypeObject.setType(logicalDT);
                datatypeObject.setSize(size);
                datatypeObject.setScale(scale);
                datatypeObject.setPrecision(precision);
            }
        }
    }

    private void parseAlterType(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB stoDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String name = Token.getNameAfterToken(this.statement, "TYPE", '\"', '\"').trim();
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                this.ownerName = Token.getValBeforeCharacter(name, '.');
                name = Token.getValAfterCharacter(name, '.');
            }
            if (this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name) != null) {
                StructuredType type = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name);
                StructuredTypeProxyUDB typeProxy = (StructuredTypeProxyUDB)stoDesign.getStructuredTypeProxySet().getByName(name);
                if (typeProxy != null) {
                    this.initDefinition(type, typeProxy);
                }
            } else {
                LOGGER.error("Unable to find required Structured Type: " + name);
            }
        }
    }

    private void initDefinition(StructuredType type, StructuredTypeProxyUDB typeProxy) {
        if (Token.hasToken(this.statement, "ADD")) {
            String element = Token.getTokenAfter(this.statement, "ADD").trim();
            if ("ATTRIBUTE".equalsIgnoreCase(element)) {
                this.initAttribute(type, typeProxy);
            } else if ("METHOD".equalsIgnoreCase(element)) {
                this.initMethod(type, typeProxy);
            }
        }
    }

    private void initAttribute(StructuredType type, StructuredTypeProxyUDB typeProxy) {
        String element = Token.getStringAfterToken(this.statement, "ATTRIBUTE");
        String name = Token.getFirstToken(element);
        String datatype = Token.cutFirstToken(element);
        TypeElement typeElement = new TypeElement(type.getDesignPart(), type);
        typeElement.setName(name);
        typeElement.setDesign(type.getDesign());
        this.initDatatype(datatype, typeElement);
        type.add(typeElement);
        this.design.getRelationalDesign().stampModelObjectDDL(typeElement);
    }

    private void initMethod(StructuredType type, StructuredTypeProxyUDB typeProxy) {
        String name = Token.getTokenAfter(this.statement, "METHOD").trim();
        Method method = new Method(type.getDesignPart(), type);
        method.setName(name);
        method.setDesign(type.getDesign());
        type.addMethod(method);
        this.design.getRelationalDesign().stampModelObjectDDL(method);
        String params = Token.getStringAfter(this.statement, name).trim();
        if (params.startsWith("(")) {
            params = Token.getValBetweenBrackets(this.statement, 1).trim();
            if (Token.hasCloseAndOpenBrackets(params)) {
                int closeBRIndex = Token.getCloseBracketIndex(params);
                String param = params.substring(0, closeBRIndex + 1);
                String afterParams = params.substring(closeBRIndex + 1);
                this.initMethodParam(type, typeProxy, method, param);
                while (afterParams != null && !afterParams.equalsIgnoreCase("")) {
                    String nextParam;
                    int closeNextBRIndex = Token.getCloseBracketIndex(afterParams = Token.getStringAfter(afterParams, ","));
                    if (closeNextBRIndex != -1) {
                        nextParam = afterParams.substring(0, closeNextBRIndex + 1);
                        this.initMethodParam(type, typeProxy, method, nextParam);
                        afterParams = afterParams.substring(closeNextBRIndex + 1);
                        continue;
                    }
                    nextParam = Token.getStringBefore(afterParams, ",");
                    if (!nextParam.equalsIgnoreCase("")) {
                        this.initMethodParam(type, typeProxy, method, nextParam);
                    } else {
                        this.initMethodParam(type, typeProxy, method, afterParams);
                    }
                    afterParams = Token.getStringAfter(afterParams, nextParam);
                }
            } else {
                this.initMethodParam(type, typeProxy, method, params);
            }
        }
        this.initReturns(method);
        MethodProxyUDB methodProxy = (MethodProxyUDB)typeProxy.getStorageDesign().getMethodProxySet().getByName(method.getName());
        if (methodProxy != null) {
            this.initSpecific(methodProxy);
            this.initSelfAsResult(methodProxy);
            this.initLanguage(methodProxy);
            this.initParameterStyle(methodProxy);
            this.initDeterministic(methodProxy);
            this.initExternalAction(methodProxy);
            this.initSqlStatementType(methodProxy);
            this.initNullParametersTreatment(methodProxy);
            this.initFederated(methodProxy);
            this.initFenced(methodProxy);
            this.initScratchpad(methodProxy);
            this.initFinalCall(methodProxy);
            this.initParallelInvocation(methodProxy);
            this.initDBInfo(methodProxy);
        }
    }

    private void initReturns(Method method) {
        if (Token.hasToken(this.statement, "RETURNS")) {
            String datatype = Token.getTokenAfter(this.statement, "RETURNS").trim();
            MethodParam methodParam = new MethodParam(method.getDesignPart());
            methodParam.setDesign(method.getDesign());
            this.initDatatype(datatype, methodParam);
            method.setReturnValue(methodParam);
        }
    }

    private void initSpecific(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "SPECIFIC")) {
            String specificName = Token.getTokenAfter(this.statement, "SPECIFIC").trim();
            methodProxy.setSpecificName(specificName);
        }
    }

    private void initSelfAsResult(MethodProxyUDB methodProxy) {
        if (Token.hasString(this.statement, "SELF AS RESULT")) {
            methodProxy.setReturnSelfAsResult("YES");
        }
    }

    private void initLanguage(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "LANGUAGE")) {
            String language = Token.getTokenAfter(this.statement, "LANGUAGE").trim();
            methodProxy.setLanguage(language.toUpperCase());
        }
    }

    private void initParameterStyle(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "STYLE")) {
            String paramStyle = Token.getTokenAfter(this.statement, "STYLE").trim();
            methodProxy.setExt_R_ParameterStyle(paramStyle.toUpperCase());
        }
    }

    private void initDeterministic(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "DETERMINISTIC")) {
            if (Token.getTokenBefore(this.statement, "DETERMINISTIC").trim().equalsIgnoreCase("NOT")) {
                methodProxy.setDeterministic("NO");
            } else {
                methodProxy.setDeterministic("YES");
            }
        }
    }

    private void initExternalAction(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "EXTERNAL")) {
            if (Token.getTokenBefore(this.statement, "EXTERNAL").trim().equalsIgnoreCase("NO")) {
                methodProxy.setExternalAction("NO");
            } else {
                methodProxy.setExternalAction("YES");
            }
        }
    }

    protected void initSqlStatementType(MethodProxyUDB methodProxy) {
        if (Token.hasString(this.statement, "READS SQL DATA")) {
            methodProxy.setSqlStatementType("READS SQL DATA");
        } else if (Token.hasString(this.statement, "CONTAINS SQL")) {
            methodProxy.setSqlStatementType("CONTAINS SQL");
        }
    }

    private void initNullParametersTreatment(MethodProxyUDB methodProxy) {
        if (Token.hasString(this.statement, "RETURNS NULL ON NULL INPUT")) {
            methodProxy.setNullParametersTreatment("RETURNS NULL ON NULL INPUT");
        }
    }

    private void initFederated(MethodProxyUDB methodProxy) {
        if (Token.hasString(this.statement, "FEDERATED")) {
            methodProxy.setFederated("YES");
        }
    }

    protected void initFenced(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "FENCED")) {
            if (Token.getTokenBefore(this.statement, "FENCED").trim().equalsIgnoreCase("NOT")) {
                methodProxy.setExt_R_Safeness("NOT FENCED");
            } else {
                methodProxy.setExt_R_Safeness("FENCED");
            }
        }
    }

    private void initScratchpad(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "SCRATCHPAD") && !Token.getTokenBefore(this.statement, "SCRATCHPAD").trim().equalsIgnoreCase("NO")) {
            String scratchpad = Token.getTokenAfter(this.statement, "SCRATCHPAD").trim();
            methodProxy.setExt_R_Scratchpad(scratchpad);
        }
    }

    private void initFinalCall(MethodProxyUDB methodProxy) {
        if (Token.hasString(this.statement, "NO FINAL CALL")) {
            methodProxy.setExt_R_FinalCall("NO");
        } else if (Token.hasString(this.statement, "FINAL CALL")) {
            methodProxy.setExt_R_FinalCall("YES");
        }
    }

    private void initParallelInvocation(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "DISALLOW")) {
            methodProxy.setExt_R_ParallelInvocation("DISALLOW");
        }
    }

    private void initDBInfo(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "DBINFO")) {
            methodProxy.setExt_R_DBInfo("YES");
        }
    }

    private void initMethodParam(StructuredType type, StructuredTypeProxyUDB typeProxy, Method method, String param) {
        MethodParamProxyUDB paramProxy;
        String paramName = Token.getFirstToken(param).trim();
        String datatype = Token.cutFirstToken(param);
        datatype = Token.getFirstToken(datatype);
        MethodParam methodParam = new MethodParam(type.getDesignPart());
        methodParam.setName(paramName);
        methodParam.setDesign(type.getDesign());
        this.initDatatype(datatype, methodParam);
        method.addParameter(methodParam);
        if (Token.hasToken(param, "LOCATOR") && (paramProxy = (MethodParamProxyUDB)typeProxy.getStorageDesign().getMethodParamProxySet().getByName(paramName)) != null) {
            paramProxy.setAsLocator(true);
        }
    }
}

