/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSchemaUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSchemaUDB.class);

    public SHCreateSchemaUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSchemaUDB.clearCR(line);
        if (Token.startsWithString(statement, "create schema")) {
            try {
                this.parseSchema(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateSchemaUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSchema(String statement) {
        this.statement = statement;
        String schemaName = Token.getTokenAfter(this.statement, "SCHEMA").trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        SchemaUDB schema = storageDesign.getSchemaSet().createSchema();
        if (schema != null) {
            schema.setName(schemaName);
            this.design.getRelationalDesign().stampModelObjectDDL(schema);
            if (Token.hasToken(this.statement, "AUTHORIZATION")) {
                String authorization = Token.getTokenAfter(this.statement, "AUTHORIZATION").trim();
                OwnerUDB owner = (OwnerUDB)storageDesign.getOwnerSet().getByName(authorization);
                if (owner == null) {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(authorization);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                schema.setOwner(owner);
            }
        }
    }
}

