/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseUDB
extends DDLStatementHandler {
    private DataBaseUDB database;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseUDB.class);

    public SHCreateDatabaseUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDatabaseUDB.clearCR(line);
        if ((Token.startsWithString(statement, "create database") || Token.startsWithString(statement, "create db")) && statement.toLowerCase().indexOf("create database partition group") == -1) {
            try {
                this.parseDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateDatabaseUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB stoDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            this.database = stoDesign.getDataBaseSet().createDataBase();
            String nameDB = this.initDatabaseName();
            this.database.setName(nameDB);
            this.initAutomaticStorage();
            this.initOnPath();
            this.initAlias();
            this.initCodeSet();
            this.initTerritory();
            this.initCollate();
            this.initNumSegs();
            this.initDFTExtentSize();
            this.initCatalogTableSpace();
            this.initUserTableSpace();
            this.initTempTableSpace();
            this.design.getRelationalDesign().stampModelObjectDDL(this.database);
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    public DataBaseUDB getDatabase() {
        return this.database;
    }

    private void initAutomaticStorage() {
        if (Token.hasToken(this.statement, "AUTOMATIC") && Token.hasToken(this.statement, "STORAGE")) {
            String autoStorage = Token.getTokenAfter(this.statement, "STORAGE");
            this.database.setAutomaticStorage(autoStorage);
        }
    }

    private void initOnPath() {
        if (Token.hasToken(this.statement, "ON")) {
            String nextToken;
            StringBuffer buf = new StringBuffer(Token.getTokenAfter(this.statement, "ON"));
            String pathsEtc = Token.getStringAfterToken(this.statement, "ON");
            while (buf.toString().endsWith(",")) {
                pathsEtc = pathsEtc.substring(pathsEtc.indexOf(",") + 1);
                String nextPath = Token.getFirstToken(pathsEtc);
                buf.append(' ').append(nextPath);
            }
            this.database.setOnPath(buf.toString());
            if (Token.hasToken(pathsEtc, "DBPATH") && (nextToken = Token.getTokenAfter(pathsEtc, "DBPATH")).equals("ON")) {
                String dbPath = Token.getTokenAfter(pathsEtc, "ON");
                this.database.setDBPathOn(dbPath);
            }
        }
    }

    private void initAlias() {
        if (Token.hasToken(this.statement, "ALIAS")) {
            String alias = Token.getTokenAfter(this.statement, "ALIAS");
            this.database.setAlias(alias);
        }
    }

    private void initCodeSet() {
        if (Token.hasToken(this.statement, "CODESET")) {
            String codeSet = Token.getTokenAfter(this.statement, "CODESET");
            this.database.setCodeSet(codeSet);
        }
    }

    private void initTerritory() {
        if (Token.hasToken(this.statement, "TERRITORY")) {
            String territory = Token.getTokenAfter(this.statement, "TERRITORY");
            this.database.setTerritory(territory);
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String collate = Token.getStringAfterToken(this.statement, "COLLATE");
            collate = Token.getTokenAfter(collate, "USING");
            String[] colSeq = DataBaseUDB.getAvailableCollatingSequences();
            for (int i = 0; i < colSeq.length; ++i) {
                if (!colSeq[i].equalsIgnoreCase(collate)) continue;
                this.database.setCollatingSequence(colSeq[i]);
                break;
            }
        }
    }

    private void initNumSegs() {
        if (Token.hasToken(this.statement, "NUMSEGS")) {
            try {
                int numSegs = Integer.parseInt(Token.getTokenAfter(this.statement, "NUMSEGS"));
                this.database.setSegmentNumber(numSegs);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong NUMSEGS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initNumSegs : " + e.getMessage());
            }
        }
    }

    private void initDFTExtentSize() {
        if (Token.hasToken(this.statement, "DFT_EXTENT_SZ")) {
            try {
                int dftExtSize = Integer.parseInt(Token.getTokenAfter(this.statement, "DFT_EXTENT_SZ"));
                this.database.setDefaultExtentSize(dftExtSize);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong DFT_EXTENT_SZ format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initDFTExtentSize : " + e.getMessage());
            }
        }
    }

    private void initCatalogTableSpace() {
        if (Token.hasToken(this.statement, "CATALOG")) {
            String part = this.statement.substring(this.statement.indexOf("CATALOG") + "CATALOG".length()).trim();
            TableSpaceUDB tableSpace = ((StorageDesignUDB)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpace.setName("CatalogTS_For_" + this.database.getName());
            this.database.setCatalogTableSpace(tableSpace);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
            if (Token.hasToken(part, "USER")) {
                part = part.substring(0, part.indexOf("USER")).trim();
            } else if (Token.hasToken(part, "TEMPORARY")) {
                part = part.substring(0, part.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(part, tableSpace);
        }
    }

    private void initUserTableSpace() {
        if (Token.hasToken(this.statement, "USER")) {
            String part = this.statement.substring(this.statement.indexOf("USER") + "USER".length()).trim();
            TableSpaceUDB tableSpace = ((StorageDesignUDB)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpace.setName("UserTS_For_" + this.database.getName());
            this.database.setUserTableSpace(tableSpace);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
            if (Token.hasToken(part, "TEMPORARY")) {
                part = part.substring(0, part.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(part, tableSpace);
        }
    }

    private void initTempTableSpace() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            String part = this.statement.substring(this.statement.indexOf("TEMPORARY") + "TEMPORARY".length()).trim();
            TableSpaceUDB tableSpace = ((StorageDesignUDB)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpace.setName("TempTS_For_" + this.database.getName());
            this.database.setTemporaryTableSpace(tableSpace);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
            this.initTableSpaceOptions(part, tableSpace);
        }
    }

    private void initTableSpaceOptions(String part, TableSpaceUDB tableSpace) {
        String dropped;
        tableSpace.setDBDefOnly(true);
        if (Token.hasToken(part, "BY")) {
            String managedBy = Token.getTokenAfter(part, "BY").trim();
            tableSpace.setManagedBy(managedBy);
        }
        if (Token.hasToken(part, "USING") && Token.getTokenAfter(part, "USING").trim().startsWith("(")) {
            String temp = part;
            while (temp.indexOf("USING") > -1 && Token.getTokenAfter(part, "USING").trim().startsWith("(")) {
                String val = Token.getValBetweenBrackets(temp, 1);
                temp = Token.getValAfterBrackets(temp, 1);
                ContainerUDB container = ((StorageDesignUDB)tableSpace.getStorageDesign()).getContainerSet().createContainer();
                if (container == null) continue;
                container.setTableSpace(tableSpace);
                container.setContainers(val);
                this.design.getRelationalDesign().stampModelObjectDDL(container);
            }
        }
        if (Token.hasToken(part, "EXTENTSIZE")) {
            tableSpace.setExtentSize(Token.getTokenAfter(part, "EXTENTSIZE"));
        }
        if (Token.hasToken(part, "PREFETCHSIZE")) {
            tableSpace.setPrefetchSize(Token.getTokenAfter(part, "PREFETCHSIZE"));
        }
        if (Token.hasToken(part, "OVERHEAD")) {
            try {
                float overhead = Float.parseFloat(Token.getTokenAfter(part, "OVERHEAD"));
                tableSpace.setOverhead(overhead);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions : " + e.getMessage());
            }
        }
        if (Token.hasToken(part, "TRANSFERRATE")) {
            try {
                float transferRate = Float.parseFloat(Token.getTokenAfter(part, "TRANSFERRATE"));
                tableSpace.setTransferRate(transferRate);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions: " + e.getMessage());
            }
        }
        if (Token.hasToken(part, "RECOVERY") && "ON".equalsIgnoreCase(dropped = Token.getTokenAfter(part, "RECOVERY").trim())) {
            tableSpace.setDroppedTableRecovery(true);
        }
    }
}

