/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreatePartitionFunctionSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreatePartitionFunctionSqlServerv2k5.class);
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreatePartitionFunctionSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreatePartitionFunctionSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create partition function")) {
            try {
                this.parseFunction(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreatePartitionFunctionSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseFunction(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String name = this.initFunctionName(statement);
            String inputType = Token.getValBetweenBrackets(statement, 1);
            String range = Token.getTokenAfter(statement, "RANGE");
            PartitionFunctionSqlServerv2k5 partFunc = (PartitionFunctionSqlServerv2k5)this.storageDesign.getPartitionFunctionSet().createPartitionFunction();
            partFunc.setName(name);
            partFunc.setDatabase(this.getCurrentDB());
            partFunc.setInputType(inputType);
            partFunc.setRangeType(range);
            this.design.getRelationalDesign().stampModelObjectDDL(partFunc);
            this.initBoundaryValues(partFunc, Token.getStringAfter(statement, "VALUES"));
        }
    }

    private void initBoundaryValues(PartitionFunctionSqlServerv2k5 partFunc, String stringAfter) {
        String boundaryValues = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "VALUES"));
        StringTokenizer st = new StringTokenizer(boundaryValues, ",");
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            value = Token.getValBetweenQuotes(value);
            partFunc.setBoundaryValues(value);
            partFunc.setBoundaryValues("");
        }
    }

    private String initFunctionName(String statement) {
        String name = Token.getTokenAfter(statement, "FUNCTION");
        return name;
    }
}

