/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAddDataTypeSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHColumnElementsSqlServerv2k5;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class DomainHandlerReadDDLSqlServerv2k5
implements StatementsConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;
    private static final Logger LOGGER = new Logger(DomainHandlerReadDDLSqlServerv2k5.class);

    public DomainHandlerReadDDLSqlServerv2k5(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList statements) {
        ArrayList forDelete = new ArrayList();
        for (Object next : statements) {
            String statement = DDLStatementHandler.clearCR((String)next);
            if (Token.startsWithString(statement, "exec sp_addtype")) {
                SHAddDataTypeSqlServer addTypes = new SHAddDataTypeSqlServer(this.design, this.factoryLogical);
                try {
                    addTypes.addDataType(statement);
                    forDelete.add(next);
                }
                catch (Exception e) {
                    LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                }
            }
            if (!Token.startsWithString(statement, "create table")) continue;
            ArrayList columns = this.getColumns(statement);
            for (String oneColumn : columns) {
                this.createOneDomain(oneColumn);
            }
        }
        statements.removeAll(forDelete);
    }

    private ArrayList getColumns(String statement) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        String columnStatement = Token.getValBetweenBrackets(statement, 1);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracket(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracket(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString();
                }
            }
            tableColumns.add(oneColumn.trim());
        }
        return tableColumns;
    }

    private void createOneDomain(String statement) {
        SHColumnElementsSqlServerv2k5 columnElements = new SHColumnElementsSqlServerv2k5(this.design);
        Map elements = columnElements.getElementsColumn(statement);
        String columnName = (String)elements.get("columnname");
        if (!"".equalsIgnoreCase(columnName)) {
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("precision"), (String)elements.get("scale"), (String)elements.get("size")};
            if (datatype != null) {
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                LogicalDatatype logicalDT = null;
                logicalDT = ApplicationView.getInstance().getCurrentDesign().getSelectedRDBMSSite().getTypeID() == 13 ? MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k12.RDBMS_TYPE, nameDatatype) : (ApplicationView.getInstance().getCurrentDesign().getSelectedRDBMSSite().getTypeID() == 12 ? MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k8.RDBMS_TYPE, nameDatatype) : (ApplicationView.getInstance().getCurrentDesign().getSelectedRDBMSSite().getTypeID() == 13 ? MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k12.RDBMS_TYPE, nameDatatype) : MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k8.RDBMS_TYPE, nameDatatype)));
                this.factory.getInstance(this.design, logicalDT, null, 2, parameters, null);
            }
        }
    }
}

