/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ASMDiskOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDiskGroupOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDiskGroupOraclev10g.class);
    private StorageDesignOraclev10g storageDesign;
    private DiskGroupOraclev10g diskGroup;
    private FailGroupOraclev10g failGroup;
    private ASMDiskOraclev10g asmDisk;
    private String line;

    public SHCreateDiskGroupOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDiskGroupOraclev10g.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "CREATE DISKGROUP")) {
            this.parseDiskGroup(statement.replaceAll("\"", ""));
        } else {
            this.nextHandler(line);
        }
    }

    private void parseDiskGroup(String statement) {
        try {
            this.statement = statement;
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(site);
            if (this.storageDesign != null) {
                this.diskGroup = this.storageDesign.getDiskGroupSet().createDiskGroup();
                if (this.diskGroup != null) {
                    this.initName();
                    this.initRedundancy();
                    this.initFailGroups();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.diskGroup);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
            this.importLog.addFailedStatement(SHCreateDiskGroupOraclev10g.FormatCR(this.line, "\n"));
        }
    }

    private void initFailGroups() {
        String restOfStatement = Token.getStringAfter(this.statement, "DISKGROUP");
        while (Token.hasToken(restOfStatement, "FAILGROUP")) {
            this.failGroup = this.storageDesign.getFailGroupSet().createFailGroup();
            if (this.failGroup != null) {
                String failGroupName = Token.getQuotedNameAfterToken(restOfStatement, "FAILGROUP");
                this.failGroup.setName(failGroupName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.failGroup);
                this.failGroup.setDiskGroup(this.diskGroup);
                if (!Token.getStringAfterToken(restOfStatement, "DISK").equalsIgnoreCase("")) {
                    this.initASMDisks(restOfStatement);
                }
            }
            restOfStatement = Token.getStringAfter(restOfStatement, "DISK");
        }
    }

    private void initASMDisks(String disks) {
        this.asmDisk = this.storageDesign.getASMDiskSet().createASMDisk();
        if (this.asmDisk != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(this.asmDisk);
            String searchString = Token.getTokenAfter(disks, "DISK");
            searchString = Token.getValBetweenQuotationMarks(searchString);
            this.asmDisk.setSearchString(searchString);
            disks = !"".equalsIgnoreCase(searchString) ? Token.getStringAfter(disks, searchString) : Token.getStringAfter(disks, "FAILGROUP");
            if (Token.hasToken(disks, "NAME")) {
                String asmDiskName = Token.getQuotedNameAfterToken(disks, "NAME");
                this.asmDisk.setName(asmDiskName);
                this.asmDisk.setFailGroup(this.failGroup);
            }
            if (Token.hasToken(disks, "SIZE")) {
                String sizeString = Token.getTokenAfter(disks, "SIZE");
                try {
                    int size = Integer.parseInt(this.removeMeasureUnit(sizeString));
                    this.asmDisk.setSize(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateDiskGroupOraclev10g.initSize() : " + e.getMessage());
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                String measureUnit = this.getMeasureUnit(sizeString, disks);
                this.asmDisk.setSizeMeasurementUnit(measureUnit);
                disks = Token.getStringAfter(disks, "SIZE");
            }
            if (Token.hasToken(disks, "FORCE")) {
                this.asmDisk.setForce("YES");
            } else if (Token.hasToken(disks, "NOFORCE")) {
                this.asmDisk.setForce("NO");
            }
        }
    }

    private void initRedundancy() {
        if (Token.hasToken(this.statement, "REDUNDANCY")) {
            String redundancy = Token.getTokenBefore(this.statement, "REDUNDANCY");
            this.diskGroup.setRedundancy(redundancy.toUpperCase());
        }
    }

    private void initName() {
        String name = Token.getQuotedNameAfterToken(this.statement, "DISKGROUP").trim();
        this.diskGroup.setName(name);
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            return sizeStr.substring(sizeStr.length() - 1);
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase();
        if (sizeStr.equals("K") || sizeStr.equals("M") || sizeStr.equals("G") || sizeStr.equals("T") || sizeStr.equals("P") || sizeStr.equals("E")) {
            return sizeStr;
        }
        return "";
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

