/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRollbackSegment
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateRollbackSegment.class);

    public SHCreateRollbackSegment(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateRollbackSegment.clearCR(line);
        if (Token.startsWithString(statement, "CREATE ROLLBACK SEGMENT") || Token.startsWithString(statement, "CREATE PUBLIC ROLLBACK SEGMENT")) {
            try {
                this.parseRollbackSegment(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateRollbackSegment.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseRollbackSegment(String statement) {
        RollbackSegmentOracle segment;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (stoDesign != null && (segment = stoDesign.getRollbackSegmentSet().createRollbackSegment()) != null) {
            this.initName(segment);
            this.initTablespaces(segment);
            this.initStorage(segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
        }
    }

    private void initName(RollbackSegmentOracle segment) {
        String name = Token.getQuotedNameAfterToken(this.statement, "SEGMENT").trim();
        segment.setName(name);
        if (Token.hasToken(this.statement, "PUBLIC")) {
            segment.setPub("YES");
        }
    }

    private void initTablespaces(RollbackSegmentOracle segment) {
        int index = this.statement.indexOf("TABLESPACE");
        if (index > -1) {
            String tablespaces = this.statement.substring(index);
            while (tablespaces.indexOf("TABLESPACE") > -1) {
                String currTablespace;
                if (tablespaces.indexOf("TABLESPACE", 10) > -1) {
                    currTablespace = tablespaces.substring(0, tablespaces.indexOf("TABLESPACE", 10));
                    tablespaces = tablespaces.substring(tablespaces.indexOf("TABLESPACE", 10));
                    currTablespace = Token.cutFirstToken(currTablespace);
                } else {
                    currTablespace = Token.getTokenAfter(tablespaces, "TABLESPACE");
                    tablespaces = "";
                }
                currTablespace = Token.getName(currTablespace);
                segment.setTablespaces(segment.convertTSNamesToIDs(currTablespace));
            }
        }
    }

    private void initStorage(RollbackSegmentOracle segment) {
        String line;
        if (Token.hasToken(this.statement, "STORAGE") && Token.getFirstToken(line = Token.getStringAfter(this.statement, "STORAGE")).equalsIgnoreCase("(")) {
            line = Token.getValBetweenBrackets(line, 1).trim();
            this.initInitial(line, segment);
            this.initNext(line, segment);
            this.initMinExtents(line, segment);
            this.initMaxExtents(line, segment);
            this.initOptimal(line, segment);
        }
    }

    private void initInitial(String line, RollbackSegmentOracle segment) {
        if (Token.hasToken(line, "INITIAL") && segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            String nextToken;
            String sizeStr;
            String sizeClause = Token.getStringAfter(line, "INITIAL").toUpperCase();
            String sizeDigits = sizeStr = Token.getFirstToken(sizeClause);
            String measureUnit = "";
            if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
                sizeDigits = sizeStr.substring(0, sizeStr.length() - 1);
                measureUnit = sizeStr.substring(sizeStr.length() - 1);
            }
            try {
                segment.setSCInitialExtent(Integer.parseInt(sizeDigits));
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateRollbackSegment.initInitial: " + e.getMessage());
            }
            if ("".equalsIgnoreCase(measureUnit) && ((nextToken = Token.getTokenAfter(sizeClause, sizeStr)).equals("K") || nextToken.equals("M") || nextToken.equals("G") || nextToken.equals("T") || nextToken.equals("P") || nextToken.equals("E"))) {
                measureUnit = nextToken;
            }
            segment.setInitialSizeUnit(measureUnit);
        }
    }

    private void initNext(String line, RollbackSegmentOracle segment) {
        if (Token.hasToken(line, "NEXT") && segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            String nextToken;
            String sizeStr;
            String sizeClause = Token.getStringAfter(line, "NEXT").toUpperCase();
            String sizeDigits = sizeStr = Token.getFirstToken(sizeClause);
            String measureUnit = "";
            if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
                sizeDigits = sizeStr.substring(0, sizeStr.length() - 1);
                measureUnit = sizeStr.substring(sizeStr.length() - 1);
            }
            try {
                segment.setSCNextExtent(Integer.parseInt(sizeDigits));
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateRollbackSegment.initNext: " + e.getMessage());
            }
            if ("".equalsIgnoreCase(measureUnit) && ((nextToken = Token.getTokenAfter(sizeClause, sizeStr)).equals("K") || nextToken.equals("M") || nextToken.equals("G") || nextToken.equals("T") || nextToken.equals("P") || nextToken.equals("E"))) {
                measureUnit = nextToken;
            }
            segment.setNextSizeUnit(measureUnit);
        }
    }

    private void initMinExtents(String line, RollbackSegmentOracle segment) {
        if (Token.hasToken(line, "MINEXTENTS") && segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int value = Integer.parseInt(str);
                segment.setSCMinExtents(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateRollbackSegment.initMinExtents: " + e.getMessage());
            }
        }
    }

    private void initMaxExtents(String line, RollbackSegmentOracle segment) {
        if (Token.hasToken(line, "MAXEXTENTS") && segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            segment.setSCMaxExtents(str);
        }
    }

    private void initOptimal(String line, RollbackSegmentOracle segment) {
        if (Token.hasToken(line, "OPTIMAL") && segment.getAppView().getSettings().isIncludeOptimalInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "OPTIMAL").trim());
            try {
                Long.parseLong(str);
                segment.setScOptimal(str);
            }
            catch (NumberFormatException e) {
                segment.setScOptimal("");
            }
        }
    }
}

