/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTable
extends DDLStatementHandler
implements AlterTableHandler {
    protected Table table;
    protected List statemensList = new ArrayList();
    protected static final Logger LOGGER = new Logger(SHAlterTable.class);
    protected String name = "";

    public SHAlterTable(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterTable.clearCR(line);
        if (Token.startsWithString(statement, "alter table") && (this.isUK(statement) || this.isPK(statement) || this.isFK(statement) || this.isCheck(statement))) {
            try {
                if (this.isPK(statement) || this.isUK(statement) || this.isCheck(statement) || this.isFK(statement)) {
                    this.parseAlterTable(statement);
                } else {
                    this.statemensList.add(statement);
                }
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for DB2 failed!", e);
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseAlterTable(String statement2) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (!storageDesign.importStorageObjectsOnly()) {
            this.initTable(statement2);
            if (this.table != null) {
                String[] splittedConstr = statement2.split(" ADD ");
                if (splittedConstr.length == 1) {
                    splittedConstr = statement2.split(" add ");
                }
                for (String statement2 : Arrays.asList(splittedConstr)) {
                    if (this.isPK(statement2)) {
                        this.initPK(statement2);
                        continue;
                    }
                    if (this.isUK(statement2)) {
                        this.initUnique(statement2);
                        continue;
                    }
                    if (this.isFK(statement2)) {
                        this.initForeignKey(statement2);
                        continue;
                    }
                    if (!this.isCheck(statement2)) continue;
                    this.initCheck(statement2);
                }
            }
        }
    }

    protected void initTable(String statement) {
        String name = Token.getNameAfterToken(statement, "TABLE", '\"', '\"').trim();
        String tableName = this.getNameFor(name);
        this.table = this.getTableFor(tableName);
    }

    protected void initForeignKey(String statement) {
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean hasForeignKey = false;
        String stringWithFK = statement;
        hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        while (hasForeignKey) {
            int positionForeign = stringWithFK.indexOf("FOREIGN");
            String fkString = stringWithFK.substring(positionForeign);
            Object nameFK = "FK_ASS";
            String fkName = Token.getTokenBefore(stringWithFK, "FOREIGN");
            if (!"".equalsIgnoreCase(fkName)) {
                nameFK = fkName;
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 13) {
                    tableName = tableName.substring(0, 13);
                }
                nameFK = tableName + "_FK" + this.table.getFKAssociationsCount();
            }
            this.name = nameFK;
            int positionBracket = fkString.indexOf(41);
            String firstBrackets = fkString.substring(0, positionBracket + 1).trim();
            String columns = Token.getValBetweenBrackets(firstBrackets);
            List columnNames = this.getColumnNames(columns);
            ArrayList<Column> columnsRef = new ArrayList<Column>();
            Column[] columnSet = (Column[])this.table.getElements();
            for (String name : columnNames) {
                for (int ci = 0; ci < columnSet.length; ++ci) {
                    String colname = columnSet[ci].getName().trim();
                    if (!name.equalsIgnoreCase(colname)) continue;
                    columnsRef.add(columnSet[ci]);
                }
            }
            int positionReference = fkString.indexOf("REFERENCES");
            String nameReferenced = Token.getTokenAfter(fkString = fkString.substring(positionReference), "REFERENCES");
            String nameRef = this.getNameFor(nameReferenced);
            Table tableRef = this.getTableFor(nameRef);
            if (tableRef != null) {
                boolean hasBrackets = Token.hasString(fkString, "(");
                if (hasBrackets) {
                    String columnsReferenced = Token.getValBetweenBrackets(fkString);
                    List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                    if (index != null) {
                        FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                        fkass.setName((String)nameFK);
                        this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                        fkass.getLocalFKIndex().setName((String)nameFK);
                        if (this.design.isPropagatePKChahges()) {
                            this.replaceAllColumns(fkass, columnsRef, index);
                        } else {
                            this.fixFKColumns(fkass, columnsRef, index);
                        }
                        boolean hasOnDelete = Token.hasToken(fkString, "DELETE");
                        if (hasOnDelete) {
                            String onDelete = Token.getTokenAfter(fkString, "DELETE").trim();
                            if ("SET".equalsIgnoreCase(onDelete)) {
                                onDelete = "SET NULL";
                            }
                            String[] choisesDelete = fkass.getDeleteRuleChoices();
                            for (int choise = 0; choise < choisesDelete.length; ++choise) {
                                if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                                fkass.setDeleteRule(choisesDelete[choise]);
                                break;
                            }
                        }
                    }
                } else {
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    Index index = (Index)tableRef.getPK();
                    if (index != null) {
                        FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                        fkass.setName((String)nameFK);
                        this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                        fkass.getLocalFKIndex().setName((String)nameFK);
                        if (this.design.isPropagatePKChahges()) {
                            this.replaceAllColumns(fkass, columnsRef, index);
                        } else {
                            this.fixFKColumns(fkass, columnsRef, index);
                        }
                        boolean hasOnDelete = Token.hasToken(fkString, "DELETE");
                        if (hasOnDelete) {
                            String onDelete = Token.getTokenAfter(fkString, "DELETE").trim();
                            if ("SET".equalsIgnoreCase(onDelete)) {
                                onDelete = "SET NULL";
                            }
                            if ("NO".equalsIgnoreCase(onDelete)) {
                                onDelete = "NO ACTION";
                            }
                            String[] choisesDelete = fkass.getDeleteRuleChoices();
                            for (int choise = 0; choise < choisesDelete.length; ++choise) {
                                if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                                fkass.setDeleteRule(choisesDelete[choise]);
                                break;
                            }
                        }
                    }
                }
            }
            stringWithFK = fkString;
            hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        }
    }

    protected boolean isCheck(String sqlStatement) {
        return Token.hasToken(sqlStatement, "CHECK");
    }

    private void initCheck(String constr) {
        this.statement = constr;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        Object constrName = null;
        if (Token.hasToken(this.statement.toUpperCase(), "CHECK")) {
            String ckName = Token.getTokenBefore(this.statement, "CHECK").trim();
            if (!"".equalsIgnoreCase(ckName)) {
                constrName = ckName;
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 13) {
                    tableName = tableName.substring(0, 13);
                }
                constrName = tableName + "_CK" + this.table.getCheckConstraints().size();
            }
        }
        String condition = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        TableLevelConstraint constraint = this.table.createCheckConstraint((String)constrName, condition);
        this.table.addCheckConstraint(constraint);
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
    }

    protected List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            columns.add(token.trim());
        }
        return columns;
    }

    protected String getNameFor(String name) {
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private Column getColumnFor(Table table, String name) {
        Column column = null;
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            Column temp = columns[i];
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            column = temp;
            break;
        }
        return column;
    }

    protected void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        Column[] indCol = (Column[])index.getElements();
        if (pkCol.length != columnsRef.size()) {
            this.importLog.addError("Foreign key columns don't match Primary key columns\ntab_ch " + index.getContainerWithKeyObject().getName() + " index " + index.getName() + "  parent_tab " + pk.getContainerWithKeyObject().getName());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = indCol[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append("  parent_tab ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(msg.toString());
            this.importLog.addError(msg.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    protected boolean isPK(String sqlStatement) {
        return Token.hasToken(sqlStatement, "PRIMARY");
    }

    protected boolean isUK(String sqlStatement) {
        return Token.hasToken(sqlStatement, "UNIQUE");
    }

    protected boolean isFK(String statement) {
        return Token.hasToken(statement, "FOREIGN");
    }

    protected void initPK(String statement) {
        String columnsStr;
        List columnNames;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        if ((columnNames = this.getColumnNames(columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "PRIMARY KEY"), 1).trim())).size() > 0) {
            Index indexPK = this.table.createIndex();
            indexPK.makePK();
            String pkString = Token.getTokenBefore(statement, "PRIMARY");
            if (!"".equalsIgnoreCase(pkString)) {
                indexPK.setName(pkString);
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 15) {
                    tableName = tableName.substring(0, 15);
                }
                indexPK.setName(tableName + "_PK");
            }
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName);
                if (column == null) continue;
                indexPK.add(column);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexPK);
        }
    }

    protected void initUnique(String statement) {
        String columnsStr;
        List columnNames;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        if ((columnNames = this.getColumnNames(columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "UNIQUE"), 1).trim())).size() > 0) {
            Index indexUnique = this.table.createIndex();
            indexUnique.setUnique(true);
            String ukString = Token.getTokenBefore(statement, "UNIQUE");
            if (!"".equalsIgnoreCase(ukString)) {
                indexUnique.setName(ukString);
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 13) {
                    tableName = tableName.substring(0, 13);
                }
                indexUnique.setName(tableName + "_UK" + this.table.getUKeys().size());
            }
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName = Token.getName(colName));
                if (column == null) continue;
                indexUnique.add(column);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexUnique);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    protected Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        for (String alterStatement : this.statemensList) {
            this.parseAlterTable(alterStatement);
        }
    }
}

