/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.BaseDDLFileHandler;
import oracle.dbtools.crest.imports.parser.SQLCommand;
import oracle.dbtools.crest.imports.parser.ScriptParser;
import oracle.dbtools.crest.util.logging.Logger;

public class NewDDLFileHandler
extends BaseDDLFileHandler {
    private File file;
    private static final Logger LOGGER = new Logger(NewDDLFileHandler.class);

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public List getDDLStatements(int dbType) {
        LinkedList<String> statements = new LinkedList<String>();
        try {
            FileInputStream in = new FileInputStream(this.file);
            ScriptParser s = new ScriptParser(in, dbType);
            s.parse();
            SQLCommand[] stmts = s.getSqlStatements();
            for (int i = 0; i < stmts.length; ++i) {
                if (stmts[i].isComment()) continue;
                statements.add(stmts[i].getSql());
            }
        }
        catch (IOException e) {
            LOGGER.error("ERROR reading file in NewDDLFileHandler", e);
        }
        return statements;
    }
}

