/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DDLFilesCollector
extends CustomDialog {
    private JList list;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private JButton okButton;
    private JButton btnRemove;
    private JComboBox cbImportTo;
    private JCheckBox chbReverseTarget;
    private JCheckBox chbSkipMerge;
    private int minWidth = 440;
    private int minHeight = 350;
    private static List<File> allFiles = new ArrayList<File>();
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(DDLFilesCollector.class);

    public DDLFilesCollector(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        this.add(this.initMainPanel());
        this.addAllFiles();
    }

    private JPanel initMainPanel() {
        URLFilter filter = new URLFilter(){

            public boolean accept(URL url) {
                File file = new File(url.getPath());
                String fn = file.getName().toLowerCase();
                return fn.endsWith(".ddl") || fn.endsWith(".sql") || fn.endsWith(".xml") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("DDLFilesCollector.DDLFiles");
            }
        };
        final URLChooser fileChooser = DialogUtil.newURLChooser();
        fileChooser.clearChooseableURLFilters();
        fileChooser.setSelectionScope(2);
        fileChooser.setSelectionMode(2);
        fileChooser.setShowJarsAsDirs(false);
        fileChooser.setURLFilter(filter);
        JPanel jpanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
        btnAdd.setToolTipText(Messages.getString("DDLFilesCollector.AddDDLFiles"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File selected;
                    if (lastFolder != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                    } else {
                        String lastDir = DDLFilesCollector.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = DDLFilesCollector.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFilesCollector.SelectDDLFiles"));
                    if (status == 0 && (selected = new File(fileChooser.getSelectedURL().getPath())) != null) {
                        lastFolder = selected.getParentFile();
                        URL[] urls = fileChooser.getSelectedURLs();
                        for (int i = 0; i < urls.length; ++i) {
                            File file = new File(urls[i].getPath());
                            if (DDLFilesCollector.containsFile(file)) continue;
                            allFiles.add(file);
                            DDLFilesCollector.this.listModel.addElement(file);
                        }
                    }
                    DDLFilesCollector.this.okButton.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
                    DDLFilesCollector.this.btnRemove.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
                }
                catch (Exception error) {
                    LOGGER.error("Error adding DDL files!", error);
                }
            }
        });
        this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.setToolTipText(Messages.getString("DDLFilesCollector.RemoveDDLFiles"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selected = DDLFilesCollector.this.list.getSelectedValues();
                for (int i = 0; i < selected.length; ++i) {
                    DDLFilesCollector.this.listModel.removeElement(selected[i]);
                    allFiles.remove(selected[i]);
                }
                DDLFilesCollector.this.okButton.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
                DDLFilesCollector.this.btnRemove.setEnabled(!DDLFilesCollector.this.listModel.isEmpty());
            }
        });
        toolBar.add(btnAdd);
        toolBar.add(this.btnRemove);
        jpanel.add((Component)toolBar, "North");
        JPanel relationalPanel = new JPanel(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JScrollPane sp = new JScrollPane(this.list);
        sp.setPreferredSize(new Dimension(360, 150));
        relationalPanel.add((Component)sp, "Center");
        JPanel pnOptions = new JPanel(new FlowLayout(0));
        JPanel pnGrid = new JPanel(new GridLayout(0, 1, 10, 10));
        pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("DDLFilesCollector.Options")));
        Dimension defaultLbSize = new Dimension(180, 20);
        Dimension defaultCBSize = new Dimension(220, 20);
        JLabel lbImportTo = new JLabel(Messages.getString("DDLFilesCollector.ImportTo"));
        lbImportTo.setPreferredSize(defaultLbSize);
        this.cbImportTo = new JComboBox();
        this.cbImportTo.setPreferredSize(defaultCBSize);
        pnGrid.add(this.createRow(lbImportTo, this.cbImportTo));
        RelationalDesign empty = null;
        for (RelationalDesign rd : this.getApplicationView().getCurrentDesign().getRelationalDesigns()) {
            this.cbImportTo.addItem(rd);
            if (!rd.isEmpty() || empty != null) continue;
            empty = rd;
        }
        this.cbImportTo.addItem(Messages.getString("DDLFilesCollector.NewRelationalModel"));
        if (empty != null) {
            this.cbImportTo.setSelectedItem(empty);
        }
        JLabel lbSwapTarget = new JLabel();
        this.chbReverseTarget = new JCheckBox(this.removeLastDots(Messages.getString("DDLFilesCollector.SwapTargetModel")));
        this.chbReverseTarget.setEnabled(!this.emptySelected());
        pnGrid.add(this.createRow(this.chbReverseTarget, lbSwapTarget));
        pnOptions.add(pnGrid);
        relationalPanel.add((Component)pnOptions, "South");
        JLabel lbSkipMerge = new JLabel();
        this.chbSkipMerge = new JCheckBox(this.removeLastDots(Messages.getString("DDLFilesCollector.SkipMergeDialog")));
        this.chbSkipMerge.setEnabled(this.emptySelected());
        pnGrid.add(this.createRow(this.chbSkipMerge, lbSkipMerge));
        JButton bnMapping = new JButton(Messages.getString("DDLFilesCollector.ViewCompareMapping"));
        bnMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareMappingDialog dialog = new CompareMappingDialog(DDLFilesCollector.this.getApplicationView(), DDLFilesCollector.this.getDesign());
                dialog.show();
            }
        });
        JLabel lbCompareMapping = new JLabel(Messages.getString("DDLFilesCollector.CompareMapping"));
        lbCompareMapping.setPreferredSize(defaultLbSize);
        pnGrid.add(this.createRow(lbCompareMapping, bnMapping));
        this.cbImportTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLFilesCollector.this.chbReverseTarget.setEnabled(!DDLFilesCollector.this.emptySelected());
                if (!DDLFilesCollector.this.chbReverseTarget.isEnabled()) {
                    DDLFilesCollector.this.chbReverseTarget.setSelected(false);
                }
                DDLFilesCollector.this.chbSkipMerge.setEnabled(DDLFilesCollector.this.emptySelected());
                if (!DDLFilesCollector.this.chbSkipMerge.isEnabled()) {
                    DDLFilesCollector.this.chbSkipMerge.setSelected(false);
                }
            }
        });
        jpanel.add((Component)relationalPanel, "Center");
        JPanel bottom = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(Messages.getString("DDLFilesCollector.OK"));
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLFilesCollector.this.result = true;
                DDLFilesCollector.this.close();
            }
        });
        bottom.add(this.okButton);
        JButton cancelButton = new JButton(Messages.getString("DDLFilesCollector.Cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLFilesCollector.this.result = false;
                DDLFilesCollector.this.close();
            }
        });
        bottom.add(cancelButton);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bottom.add(bnHelp);
        this.okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)bottom, "South");
        return jpanel;
    }

    private boolean emptySelected() {
        if (this.cbImportTo.getSelectedItem() instanceof RelationalDesign) {
            return ((RelationalDesign)this.cbImportTo.getSelectedItem()).isEmpty();
        }
        return true;
    }

    private String removeLastDots(String str) {
        String temp = str.trim();
        if (temp.endsWith(":")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    @Override
    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DDLFilesCollector.SelectDDLFiles"));
            this.dialog.setModal(true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DDLFilesCollector.this.dialog.getWidth();
                    int h = DDLFilesCollector.this.dialog.getHeight();
                    w = Math.max(DDLFilesCollector.this.minWidth, w);
                    h = Math.max(DDLFilesCollector.this.minHeight, h);
                    DDLFilesCollector.this.dialog.setSize(w, h);
                }
            });
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_DDL_FILES_DIALOG";
    }

    public boolean showDialog() {
        this.result = false;
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public Object[] getDDLFiles() {
        return this.listModel.toArray();
    }

    public RelationalDesign getSelectedModel() {
        Object selected = this.cbImportTo.getSelectedItem();
        if (selected instanceof RelationalDesign) {
            return (RelationalDesign)selected;
        }
        return null;
    }

    public boolean swapTargetModel() {
        return this.chbReverseTarget.isSelected();
    }

    public boolean skipMergeDialog() {
        return this.chbSkipMerge.isSelected();
    }

    private static boolean containsFile(File file) {
        for (File next : allFiles) {
            if (!next.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private void addAllFiles() {
        for (File next : allFiles) {
            if (!next.exists()) continue;
            this.listModel.addElement(next);
        }
        this.okButton.setEnabled(!this.listModel.isEmpty());
        this.btnRemove.setEnabled(!this.listModel.isEmpty());
    }

    public static void clearFileList() {
        allFiles.clear();
    }
}

