/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class CWDBusinessInfoDesign
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DATATYPE_DESIGN";

    public CWDBusinessInfoDesign(CWDExtractionHandler handler, ApplicationView view) {
        super(handler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(List selectedObjects, ImportLogger importLog) throws Exception {
        this.importDocuments();
        this.importEmails();
        this.importPhones();
        this.importLocations();
        this.importResources();
        this.importContacts();
        this.importPhones();
    }

    private void importContacts() {
        for (int h = 0; h < this.getDesign().getBusinessInfoDesign().getContactSet().size(); ++h) {
            BIContact newContact;
            BIContact contact = (BIContact)this.getDesign().getBusinessInfoDesign().getContactSet().getElement(h);
            if (this.getOldDesign().getBusinessInfoDesign().getContactSet().getByName(contact.getName()) != null) {
                newContact = this.getOldDesign().getBusinessInfoDesign().createContact();
                contact.copy(newContact);
                this.getCwdExtractionHandler().addToImportedObjects(contact.getObjectID(), newContact);
                newContact.setImportedDesign(this.getDesign());
                newContact.setImportedId(contact.getObjectID());
                continue;
            }
            newContact = this.getOldDesign().getBusinessInfoDesign().createContact();
            contact.copy(newContact);
            this.getCwdExtractionHandler().addToImportedObjects(contact.getObjectID(), newContact);
            newContact.setImportedDesign(this.getDesign());
            newContact.setImportedId(contact.getObjectID());
        }
    }

    private void importResources() {
        for (int h = 0; h < this.getDesign().getBusinessInfoDesign().getUrlSet().size(); ++h) {
            BIResourceLocator newResource;
            BIResourceLocator resource = (BIResourceLocator)this.getDesign().getBusinessInfoDesign().getUrlSet().getElement(h);
            if (this.getOldDesign().getBusinessInfoDesign().getResPartySet().getByName(resource.getName()) != null) {
                newResource = this.getOldDesign().getBusinessInfoDesign().createUrl();
                resource.copy(newResource);
                resource.setName(this.getPrefix() + resource.getName());
                newResource.setImportedDesign(this.getDesign());
                newResource.setImportedId(resource.getObjectID());
                continue;
            }
            newResource = this.getOldDesign().getBusinessInfoDesign().createUrl();
            resource.copy(newResource);
            this.getCwdExtractionHandler().addToImportedObjects(resource.getObjectID(), newResource);
            newResource.setImportedDesign(this.getDesign());
            newResource.setImportedId(resource.getObjectID());
        }
    }

    private void importLocations() {
        for (int h = 0; h < this.getDesign().getBusinessInfoDesign().getLocationSet().size(); ++h) {
            BILocation newLocation;
            BILocation location = (BILocation)this.getDesign().getBusinessInfoDesign().getLocationSet().getElement(h);
            if (this.getOldDesign().getBusinessInfoDesign().getLocationSet().getByName(location.getName()) != null) {
                newLocation = this.getOldDesign().getBusinessInfoDesign().createLocation();
                location.copy(newLocation);
                location.setName(this.getPrefix() + location.getName());
                newLocation.setImportedDesign(this.getDesign());
                newLocation.setImportedId(location.getObjectID());
                continue;
            }
            newLocation = this.getOldDesign().getBusinessInfoDesign().createLocation();
            location.copy(newLocation);
            newLocation.setImportedDesign(this.getDesign());
            newLocation.setImportedId(location.getObjectID());
        }
    }

    private void importPhones() {
        for (int h = 0; h < this.getDesign().getBusinessInfoDesign().getPhoneSet().size(); ++h) {
            BIPhone newPhone;
            BIPhone phone = (BIPhone)this.getDesign().getBusinessInfoDesign().getPhoneSet().getElement(h);
            if (this.getOldDesign().getBusinessInfoDesign().getPhoneSet().getByName(phone.getName()) != null) {
                newPhone = this.getOldDesign().getBusinessInfoDesign().createPhone();
                phone.copy(newPhone);
                newPhone.setImportedDesign(this.getDesign());
                newPhone.setImportedId(phone.getObjectID());
                continue;
            }
            newPhone = this.getOldDesign().getBusinessInfoDesign().createPhone();
            phone.copy(newPhone);
            newPhone.setImportedDesign(this.getDesign());
            newPhone.setImportedId(phone.getObjectID());
        }
    }

    private void importEmails() {
        for (int h = 0; h < this.getDesign().getBusinessInfoDesign().getEmailSet().size(); ++h) {
            BIEmail newEmail;
            BIEmail email = (BIEmail)this.getDesign().getBusinessInfoDesign().getEmailSet().getElement(h);
            if (this.getOldDesign().getBusinessInfoDesign().getEmailSet().getByName(email.getName()) != null) {
                newEmail = this.getOldDesign().getBusinessInfoDesign().createEmail();
                email.copy(newEmail);
                newEmail.setName(this.getPrefix() + email.getName());
                newEmail.setImportedDesign(this.getDesign());
                newEmail.setImportedId(email.getObjectID());
                continue;
            }
            newEmail = this.getOldDesign().getBusinessInfoDesign().createEmail();
            email.copy(newEmail);
            newEmail.setImportedDesign(this.getDesign());
            newEmail.setImportedId(email.getObjectID());
        }
    }

    private void importDocuments() {
        for (int h = 0; h < this.getDesign().getBusinessInfoDesign().getDocumentSet().size(); ++h) {
            BIDocument newDoc;
            BIDocument doc = (BIDocument)this.getDesign().getBusinessInfoDesign().getDocumentSet().getElement(h);
            if (this.getOldDesign().getBusinessInfoDesign().getDocumentSet().getByName(doc.getName()) != null) {
                newDoc = this.getOldDesign().getBusinessInfoDesign().createDocument();
                doc.copy(newDoc);
                newDoc.setName(this.getPrefix() + doc.getName());
                this.getCwdExtractionHandler().addToImportedObjects(doc.getObjectID(), newDoc);
                newDoc.setImportedDesign(this.getDesign());
                newDoc.setImportedId(doc.getObjectID());
                continue;
            }
            newDoc = this.getOldDesign().getBusinessInfoDesign().createDocument();
            doc.copy(newDoc);
            this.getCwdExtractionHandler().addToImportedObjects(doc.getObjectID(), newDoc);
            newDoc.setImportedDesign(this.getDesign());
            newDoc.setImportedId(doc.getObjectID());
        }
    }

    @Override
    public List extract(List appSystems) throws Exception {
        if (!this.getDesign().getBusinessInfoDesign().isLoaded()) {
            if (this.getDesign().isOldRepositoryType()) {
                this.getDesign().getBusinessInfoDesign().load();
            } else {
                this.getDesign().getAppView().getXMLTransformationManager().openDesignPart(this.getDesign().getBusinessInfoDesign());
            }
        }
        return new ArrayList();
    }
}

