/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.headless;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.headless.HeadlessResources;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;

public class DDLCommandProcessor
implements HeadlessCommandProcessor {
    private static final String ARG_DESIGN = "-DESIGN";
    private static final String ARG_REL_MODEL = "-RELMODEL";
    private static final String ARG_OUTPUT_FILE = "-OUTPUTFILE";

    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headless, String ... args) throws InvalidCommandArgumentException {
        if (args.length > 0) {
            String designFileName = null;
            String relModelName = null;
            String outputFileName = null;
            int a = 0;
            while (a < args.length - 1 && args[a].startsWith("-")) {
                String option = args[a++];
                String value = args[a++];
                if (ARG_DESIGN.equalsIgnoreCase(option)) {
                    designFileName = value;
                    continue;
                }
                if (ARG_REL_MODEL.equalsIgnoreCase(option)) {
                    relModelName = value;
                    continue;
                }
                if (ARG_OUTPUT_FILE.equalsIgnoreCase(option)) {
                    outputFileName = value;
                    continue;
                }
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", option));
            }
            if (designFileName == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_DESIGN));
            }
            if (relModelName == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_REL_MODEL));
            }
            if (outputFileName == null) {
                throw new InvalidCommandArgumentException(HeadlessResources.format("INVALID_ARGUMENT", ARG_OUTPUT_FILE));
            }
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put(ARG_DESIGN, designFileName);
            arguments.put(ARG_REL_MODEL, relModelName);
            arguments.put(ARG_OUTPUT_FILE, outputFileName);
            return new DDLCommandTask(headless, arguments);
        }
        headless.printMessage(new String[]{this.getUsageString()});
        return null;
    }

    public String getUsageString() {
        return HeadlessResources.getString("DDL_USAGE_STRING");
    }

    public static class DDLCommandTask
    extends HeadlessTask<Void> {
        private HeadlessCore headless;
        private String designFileName;
        private String relModelName;
        private String outputFileName;

        protected DDLCommandTask(HeadlessCore headless, Map<String, String> arguments) {
            super("ddl");
            this.headless = headless;
            this.designFileName = arguments.get(DDLCommandProcessor.ARG_DESIGN);
            this.relModelName = arguments.get(DDLCommandProcessor.ARG_REL_MODEL);
            this.outputFileName = arguments.get(DDLCommandProcessor.ARG_OUTPUT_FILE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doWork() throws TaskException {
            try {
                File designFile = new File(this.designFileName);
                if (!designFile.exists()) {
                    this.headless.printErrorMessage(new String[]{HeadlessResources.getString("DESIGN_NOT_EXISTS")});
                    return null;
                }
                String designPath = designFile.getParent();
                String fullDesignName = designFile.getName();
                int idx = fullDesignName.indexOf(".");
                if (idx == -1) {
                    this.headless.printMessage(new String[]{HeadlessResources.getString("DDL_USAGE_STRING")});
                    return null;
                }
                String designName = fullDesignName.substring(0, idx);
                String designExt = fullDesignName.substring(idx);
                ApplicationView.dmInternalsDistDir = Extension.getBaseDir();
                ApplicationView app = ApplicationView.getInstance(false, null);
                app.getCurrentDesign().setDesignPath(designPath);
                ApplicationView.loading = true;
                ApplicationView.canLogging = false;
                try {
                    Design design = app.getCurrentDesign();
                    design.setPropagatePKChahges(false);
                    design.setDisableTreeUpdate(true);
                    app.setImporting(true);
                    app.getSettings().setUseVersioningFunctionality(false);
                    ApplicationView.canLogging = false;
                    if (design.cliOpenRelationalModel(designName, designExt, this.relModelName)) {
                        RelationalDesign relModel = design.getRelationalDesign();
                        DDLFileMaker fm = new DDLFileMaker(design, relModel);
                        fm.setStorageDesign(relModel.getStorageDesign());
                        fm.clearContent();
                        fm.generateDDLContent(null, null, false);
                        String content = fm.getContent();
                        this.saveLocalCopy(new File(this.outputFileName), content);
                        return null;
                    }
                    this.headless.printErrorMessage(new String[]{HeadlessResources.getString("CAN_NOT_OPEN_RELATIONAL_MODEL")});
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ApplicationView.canLogging = true;
                    ApplicationView.loading = false;
                }
            }
            catch (Exception ex) {
                throw new TaskException((Throwable)ex);
            }
        }

        private boolean saveLocalCopy(File file, String content) throws IOException {
            file.getParentFile().mkdirs();
            file.createNewFile();
            EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, environOptions.getEncoding());
            osw.write(content);
            osw.close();
            return true;
        }
    }
}

