/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.vhv.VHVCommand;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVQuery;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCommand;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVHVCompareOther;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVHVComparePrevious;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVersionTree;
import oracle.jdevimpl.vcs.svn.versiontree.SVNVHVQuery;

public class SVNVersionTreeCommand
extends VersionTreeCommand {
    public static final String COMMAND_ID = Extension.isDataModeler() ? SVNOperationVersionTree.class.getName() : SVNVersionTreeCommand.class.getName();
    public static final int TREE_CMD_ID = Ide.findOrCreateCmdID((String)COMMAND_ID);
    private static final Logger LOGGER = new Logger(SVNVersionTreeCommand.class);
    private static final IdeAction ACTION = DataModelerAddin.overrideAction(SVNOperationVersionTree.class.getName(), SVNVersionTreeCommand.class.getName());
    private JCheckBox chbSkipMessage = new JCheckBox(Messages.getString("SVNVersionTreeCommand.SkipMessage"));

    public SVNVersionTreeCommand() {
        super(TREE_CMD_ID);
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    public boolean isAvailable() {
        return DataModelerAddin.getVCSClientHelper().actionsEnabled(null, this.getContext(), true, true, false, false, false, true, false, true);
    }

    public int doitImpl() throws Exception {
        DisplayableLocatableNode[] selection = VCSClientHelper.getSelection(this.getContext().getView());
        if (selection != null && selection.length > 0) {
            String fileName;
            URL url = selection[0].getURL();
            Object versionPath = this.getVersionPath(url);
            File selectedFile = null;
            selectedFile = ((String)versionPath).startsWith("file://") && ((String)versionPath).charAt(7) != '/' ? new File(((String)versionPath).substring(7)) : (((String)versionPath).startsWith("file:/") && ((String)versionPath).charAt(6) != '/' ? new File(((String)versionPath).substring(5)) : new File((String)versionPath));
            if (selectedFile != null && !selectedFile.exists() && (fileName = selectedFile.getName()).toLowerCase().endsWith(".xml")) {
                Object objectFileName = FileUtils.removeExt(fileName);
                objectFileName = (String)objectFileName + ".xmlz";
                selectedFile = new File(selectedFile.getParent() + File.separator + (String)objectFileName);
                versionPath = (String)versionPath + "z";
            }
            if (SVNClientHelper.getInstance().isVersioned(selectedFile)) {
                VHVQuery query = this.createQuery();
                if (((String)versionPath).startsWith("file://") && ((String)versionPath).charAt(7) != '/') {
                    versionPath = ((String)versionPath).substring(0, 7) + File.separator + ((String)versionPath).substring(7);
                } else if (((String)versionPath).startsWith("file:/") && ((String)versionPath).charAt(6) != '/') {
                    versionPath = ((String)versionPath).substring(0, 6) + File.separator + ((String)versionPath).substring(6);
                }
                try {
                    VHVCommand.show((URL)new URL((String)versionPath), (VHVQuery)query, null, (String)versionPath);
                }
                catch (Exception e) {
                    LOGGER.error(e);
                    throw e;
                }
                return 0;
            }
            String message = MessageFormat.format(Messages.getString("SVNVersionTreeCommand.NotWorkingCopy"), new File(new File(selection[0].getURL().getFile()).getParent()).getAbsoluteFile());
            Object[] params = new Object[]{message, this.chbSkipMessage};
            if (!this.chbSkipMessage.isSelected()) {
                JOptionPane.showConfirmDialog(null, params, Messages.getString("SVNVersionTreeCommand.Error"), -1, 1);
            }
            return 1;
        }
        return 1;
    }

    protected VHVQuery createQuery() {
        return new SVNVHVQuery();
    }

    protected String getVersionPath(URL url) {
        return url == null ? "" : url.toExternalForm();
    }

    protected VHVCustomizer createCustomizer() {
        VHVCustomizer customizer = new VHVCustomizer();
        customizer.setComparePreviousCommand(SVNOperationVHVComparePrevious.COMMAND_ID);
        customizer.setCompareOtherCommand(SVNOperationVHVCompareOther.COMMAND_ID);
        return customizer;
    }
}

