/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;

public class SVNImportCommand
extends AbstractSVNOperation {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.import" : SVNImportCommand.class.getName();
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNImportCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
        VCSControlCache.getInstance().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg != null && arg.equals("oracle.jdeveloper.subversion")) {
                    Design currentDesign = ApplicationView.getInstance().getCurrentDesign();
                    if (currentDesign != null) {
                        SVN_CLIENT_HELPER.checkVersioned(currentDesign);
                    }
                    SVNChangeListWindow.addToScope(ApplicationView.getInstance().getDesigns());
                }
            }
        });
    }

    public boolean isAvailable() {
        return true;
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        if (new SVNImportWizard().runWizard((Component)VCSWindowUtils.getCurrentWindow(), this.getContext())) {
            return 1;
        }
        return 0;
    }
}

