/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.svn.RelationalModelEstimates;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNEstimatedPhysicalModelObjectsQuantityDialog;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesignEstimates;
import oracle.dbtools.crest.model.design.logical.LogicalDesignEstimates;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignEstimates;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.io.IntegersFilter;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.controls.SpringUtilities;

public class SVNEstimatedModelObjectsQuantityDialog
extends CustomDialog {
    private JDialog dialog;
    private Frame owner;
    private final ApplicationView appView;
    private static final Logger LOGGER = new Logger(SVNEstimatedModelObjectsQuantityDialog.class);
    private RelationalDesign selectedRelationalDesign;
    private JLabel schemas = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Schemas"), 4);
    private JLabel tables = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Tables"), 4);
    private JLabel arcs = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Arcs"), 4);
    private JLabel foreignKeys = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.ForeignKeys"), 4);
    private JLabel views = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Views"), 4);
    private JLabel subViews = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.SubViews"), 4);
    private JLabel structuredTypes = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.StructuredTypes"), 4);
    private JLabel collectionTypes = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.CollectionTypes"), 4);
    private JLabel distinctTypes = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.DistinctTypes"), 4);
    private JLabel logicalEntities = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.LogicalEntities"), 11);
    private JLabel logicalRelations = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.LogicalRelations"), 11);
    private JLabel logicalViews = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.LogicalViews"), 11);
    private JLabel logicalArcs = new JLabel(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.LogicalArcs"), 11);
    private String initialValue = new Integer(SegmentNameManager.seg_size).toString();
    private JTextField tfLogicalEntities = new JTextField(this.initialValue, 12);
    private JTextField tfLogicalRelations = new JTextField(this.initialValue, 12);
    private JTextField tfLogicalViews = new JTextField(this.initialValue, 12);
    private JTextField tfLogicalArcs = new JTextField(this.initialValue, 12);
    private JTextField tfTables = new JTextField(this.initialValue, 12);
    private JTextField tfViews = new JTextField(this.initialValue, 12);
    private JTextField tfForeignKeys = new JTextField(this.initialValue, 12);
    private JTextField tfSchemas = new JTextField(this.initialValue, 12);
    private JTextField tfSubViews = new JTextField(this.initialValue, 12);
    private JTextField tfArcs = new JTextField(this.initialValue, 12);
    private JTextField tfStructuredTypes = new JTextField(this.initialValue, 12);
    private JTextField tfCollectionTypes = new JTextField(this.initialValue, 12);
    private JTextField tfDistinctTypes = new JTextField(this.initialValue, 12);
    private RelationalDesign[] relationalDesigns;
    private List<String> rdbmsSitesNames = new ArrayList<String>();
    private List<JCheckBox> rdbmsSitesCheckBoxes = new ArrayList<JCheckBox>();
    private List<RelationalModelEstimates> relationalModelsEstimatesList = new ArrayList<RelationalModelEstimates>();
    private JTree tree;
    private String LOGICALMODEL_GROUP = "1";
    private String EMPTY_GROUP = "2";
    private String DATATYPESMODEL_GROUP = "3";
    private String RELOBJECTS_GROUP = "4";
    private String PHYSICALMODELS_GROUP = "5";
    private JButton bnOK = new JButton(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.OK"));
    private JButton bnCancel = new JButton(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Cancel"));
    private JButton bnHelp = new JButton(this.getHelpAction());
    private JTable tablePhysicalModelsTable;
    private Design design = null;

    public SVNEstimatedModelObjectsQuantityDialog(final ApplicationView appView) {
        super(appView);
        this.appView = appView;
        this.owner = appView != null ? appView.getFrame() : new Frame();
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnHelp.setMnemonic(72);
        this.setLayout(new BorderLayout());
        this.design = ApplicationView.getInstance().getCurrentDesign();
        LogicalDesignEstimates logicalDesignEstimates = this.design.getLogicalDesign().getLogicalDesignEstimates();
        ((AbstractDocument)this.tfLogicalEntities.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfLogicalEntities.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(logicalDesignEstimates.getEntitiesQuantity()).toString();
        this.tfLogicalEntities.setText(this.initialValue);
        ((AbstractDocument)this.tfLogicalRelations.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfLogicalRelations.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(logicalDesignEstimates.getRelationsQuantity()).toString();
        this.tfLogicalRelations.setText(this.initialValue);
        ((AbstractDocument)this.tfLogicalViews.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfLogicalViews.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(logicalDesignEstimates.getViewsQuantity()).toString();
        this.tfLogicalViews.setText(this.initialValue);
        ((AbstractDocument)this.tfLogicalArcs.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfLogicalArcs.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(logicalDesignEstimates.getArcsQuantity()).toString();
        this.tfLogicalArcs.setText(this.initialValue);
        ((AbstractDocument)this.tfTables.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfTables.setMaximumSize(new Dimension(140, 16));
        ((AbstractDocument)this.tfViews.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfViews.setMaximumSize(new Dimension(140, 16));
        ((AbstractDocument)this.tfForeignKeys.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfForeignKeys.setMaximumSize(new Dimension(140, 16));
        ((AbstractDocument)this.tfSchemas.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfSchemas.setMaximumSize(new Dimension(140, 16));
        ((AbstractDocument)this.tfSubViews.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfSubViews.setMaximumSize(new Dimension(140, 16));
        ((AbstractDocument)this.tfArcs.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfArcs.setMaximumSize(new Dimension(140, 16));
        this.loadRelationalDesignEstimates(this.design.getRelationalDesign());
        DataTypesDesignEstimates dataTypesDesignEstimates = this.design.getDataTypesDesign().getDataTypesDesignEstimates();
        ((AbstractDocument)this.tfStructuredTypes.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfStructuredTypes.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(dataTypesDesignEstimates.getStructuredTypesQuantity()).toString();
        this.tfStructuredTypes.setText(this.initialValue);
        ((AbstractDocument)this.tfCollectionTypes.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfCollectionTypes.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(dataTypesDesignEstimates.getCollectionTypesQuantity()).toString();
        this.tfCollectionTypes.setText(this.initialValue);
        ((AbstractDocument)this.tfDistinctTypes.getDocument()).setDocumentFilter(new IntegersFilter());
        this.tfDistinctTypes.setMaximumSize(new Dimension(140, 16));
        this.initialValue = new Integer(dataTypesDesignEstimates.getDistinctTypesQuantity()).toString();
        this.tfDistinctTypes.setText(this.initialValue);
        JPanel dataTypesModelGroup = new JPanel(new SpringLayout());
        dataTypesModelGroup.setBorder(BorderFactory.createTitledBorder(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.EstimatedDataTypesModelObjects")));
        dataTypesModelGroup.add(this.structuredTypes);
        this.structuredTypes.setLabelFor(this.tfStructuredTypes);
        dataTypesModelGroup.add(this.tfStructuredTypes);
        dataTypesModelGroup.add(this.collectionTypes);
        this.collectionTypes.setLabelFor(this.tfCollectionTypes);
        dataTypesModelGroup.add(this.tfCollectionTypes);
        dataTypesModelGroup.add(this.distinctTypes);
        this.distinctTypes.setLabelFor(this.tfDistinctTypes);
        dataTypesModelGroup.add(this.tfDistinctTypes);
        SpringUtilities.makeCompactGrid((Container)dataTypesModelGroup, (int)3, (int)2, (int)6, (int)6, (int)6, (int)6);
        JPanel logicalModelGroup = new JPanel(new SpringLayout());
        logicalModelGroup.setBorder(BorderFactory.createTitledBorder(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.EstimatedLogicalObjects")));
        logicalModelGroup.add(this.logicalEntities);
        this.logicalEntities.setLabelFor(this.tfLogicalEntities);
        logicalModelGroup.add(this.tfLogicalEntities);
        logicalModelGroup.add(this.logicalRelations);
        this.logicalRelations.setLabelFor(this.tfLogicalRelations);
        logicalModelGroup.add(this.tfLogicalRelations);
        logicalModelGroup.add(this.logicalViews);
        this.logicalViews.setLabelFor(this.tfLogicalViews);
        logicalModelGroup.add(this.tfLogicalViews);
        logicalModelGroup.add(this.logicalArcs);
        this.logicalArcs.setLabelFor(this.tfLogicalArcs);
        logicalModelGroup.add(this.tfLogicalArcs);
        SpringUtilities.makeCompactGrid((Container)logicalModelGroup, (int)4, (int)2, (int)6, (int)6, (int)6, (int)6);
        JPanel emptyGroup = new JPanel(new SpringLayout());
        JPanel relObjectsGroup = new JPanel(new SpringLayout());
        relObjectsGroup.setBorder(BorderFactory.createTitledBorder(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.EstimatedRelObjects")));
        relObjectsGroup.add(this.tables);
        this.tables.setLabelFor(this.tfTables);
        relObjectsGroup.add(this.tfTables);
        relObjectsGroup.add(this.views);
        this.views.setLabelFor(this.tfViews);
        relObjectsGroup.add(this.tfViews);
        relObjectsGroup.add(this.foreignKeys);
        this.foreignKeys.setLabelFor(this.tfForeignKeys);
        relObjectsGroup.add(this.tfForeignKeys);
        relObjectsGroup.add(this.schemas);
        this.schemas.setLabelFor(this.tfSchemas);
        relObjectsGroup.add(this.tfSchemas);
        relObjectsGroup.add(this.arcs);
        this.arcs.setLabelFor(this.tfArcs);
        relObjectsGroup.add(this.tfArcs);
        SpringUtilities.makeCompactGrid((Container)relObjectsGroup, (int)5, (int)2, (int)6, (int)6, (int)6, (int)6);
        TablePhysicalModelsModel tablePhysicalModelsModel = new TablePhysicalModelsModel();
        this.tablePhysicalModelsTable = new JTable(tablePhysicalModelsModel);
        this.tablePhysicalModelsTable.getTableHeader().setReorderingAllowed(true);
        this.tablePhysicalModelsTable.setSelectionMode(0);
        this.tablePhysicalModelsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int col = SVNEstimatedModelObjectsQuantityDialog.this.tablePhysicalModelsTable.getSelectedColumn();
                    int row = SVNEstimatedModelObjectsQuantityDialog.this.tablePhysicalModelsTable.getSelectedRow();
                    if (row != -1 && col == 0) {
                        SVNEstimatedPhysicalModelObjectsQuantityDialog svnEstimatedPhysicalModelObjectsQuantityDialog = new SVNEstimatedPhysicalModelObjectsQuantityDialog(appView, SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign, row, SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesCheckBoxes.get(row).isSelected());
                        svnEstimatedPhysicalModelObjectsQuantityDialog.getDialog().setVisible(true);
                        svnEstimatedPhysicalModelObjectsQuantityDialog.getDialog().setAlwaysOnTop(true);
                    }
                }
            }
        });
        JScrollPane physicalModelsScrollpane = new JScrollPane(this.tablePhysicalModelsTable);
        JPanel physicalModelsGroup = new JPanel(new SpringLayout());
        physicalModelsGroup.setBorder(BorderFactory.createTitledBorder(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.EstimatedPhysModels")));
        physicalModelsScrollpane.setPreferredSize(new Dimension(228, 319));
        physicalModelsGroup.add(physicalModelsScrollpane);
        RDBMSSite[] rdbmsSiteSet = (RDBMSSite[])this.design.getRDBMSSiteSet().toArray();
        int numberOfRDBMSSites = rdbmsSiteSet.length;
        for (int i = 0; i < numberOfRDBMSSites; ++i) {
            JCheckBox chbPhysModel = new JCheckBox();
            boolean chbSelected = this.isPhysicalModelCreated(this.design.getRelationalDesign(), i);
            this.rdbmsSitesNames.add(rdbmsSiteSet[i].getName());
            chbPhysModel.setSelected(chbSelected);
            this.rdbmsSitesCheckBoxes.add(chbPhysModel);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Design"));
        DefaultMutableTreeNode designNode = new DefaultMutableTreeNode(this.design);
        DefaultMutableTreeNode logicalModelNode = new DefaultMutableTreeNode(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.LogicalModel"));
        DefaultMutableTreeNode relationalModelsNode = new DefaultMutableTreeNode(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.RelationalModels"));
        this.relationalDesigns = (RelationalDesign[])this.design.getRelationalDesigns().toArray();
        for (int i = 0; i < this.relationalDesigns.length; ++i) {
            DefaultMutableTreeNode relationalModelNode = new DefaultMutableTreeNode(this.relationalDesigns[i]);
            DefaultMutableTreeNode physicalModelsNode = new DefaultMutableTreeNode(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.PhysicalModels"));
            relationalModelNode.add(physicalModelsNode);
            relationalModelsNode.add(relationalModelNode);
        }
        DefaultMutableTreeNode dataTypesModelNode = new DefaultMutableTreeNode(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.DataTypesModel"));
        designNode.add(logicalModelNode);
        designNode.add(relationalModelsNode);
        designNode.add(dataTypesModelNode);
        root.add(designNode);
        this.tree = new JTree(root);
        ImageIcon imageIcon = new ImageIcon();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(imageIcon);
        this.tree.setCellRenderer(renderer);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setSelectionRow(0);
        JPanel selPanel = new JPanel();
        selPanel.setPreferredSize(new Dimension(183, 352));
        JScrollPane selectionTreeScrollpane = new JScrollPane(this.tree);
        selectionTreeScrollpane.setPreferredSize(new Dimension(173, 332));
        selPanel.add(new JScrollPane(selectionTreeScrollpane));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(3);
        JPanel estimatesPanel = new JPanel(flowLayout);
        estimatesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.EstimatedQuantities")));
        final CardLayout cardLayout = new CardLayout();
        final JPanel cardLayoutPanel = new JPanel(cardLayout);
        cardLayoutPanel.setPreferredSize(new Dimension(238, 340));
        cardLayoutPanel.add((Component)emptyGroup, this.EMPTY_GROUP);
        cardLayoutPanel.add((Component)logicalModelGroup, this.LOGICALMODEL_GROUP);
        cardLayoutPanel.add((Component)dataTypesModelGroup, this.DATATYPESMODEL_GROUP);
        cardLayoutPanel.add((Component)relObjectsGroup, this.RELOBJECTS_GROUP);
        cardLayoutPanel.add((Component)physicalModelsGroup, this.PHYSICALMODELS_GROUP);
        estimatesPanel.add(selPanel);
        estimatesPanel.add(cardLayoutPanel);
        this.add(estimatesPanel);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)SVNEstimatedModelObjectsQuantityDialog.this.tree.getLastSelectedPathComponent();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
                if (parentNode != null) {
                    RelationalModelEstimates currentRelationalModelEstimates;
                    if (SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign != null) {
                        SVNEstimatedModelObjectsQuantityDialog.this.storeRelationalDesignEstimates(SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign, new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfTables.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfForeignKeys.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSchemas.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSubViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfArcs.getText()));
                        currentRelationalModelEstimates = this.findCurrentRelationalModelEstimates();
                        if (currentRelationalModelEstimates != null) {
                            currentRelationalModelEstimates.setRDBMSSitesCheckBoxes(SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesCheckBoxes);
                            currentRelationalModelEstimates.setEstimatedRelationalModelObjectNumbers(SVNEstimatedModelObjectsQuantityDialog.this.tfTables.getText(), SVNEstimatedModelObjectsQuantityDialog.this.tfSchemas.getText(), SVNEstimatedModelObjectsQuantityDialog.this.tfForeignKeys.getText(), SVNEstimatedModelObjectsQuantityDialog.this.tfViews.getText(), SVNEstimatedModelObjectsQuantityDialog.this.tfSubViews.getText(), SVNEstimatedModelObjectsQuantityDialog.this.tfArcs.getText());
                        }
                    }
                    if (selectedNode.getUserObject() instanceof RelationalDesign || parentNode.getUserObject() instanceof RelationalDesign) {
                        SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign = selectedNode.getUserObject() instanceof RelationalDesign ? (RelationalDesign)selectedNode.getUserObject() : (RelationalDesign)parentNode.getUserObject();
                        SVNEstimatedModelObjectsQuantityDialog.this.loadRelationalDesignEstimates(SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign);
                        currentRelationalModelEstimates = this.findCurrentRelationalModelEstimates();
                        if (currentRelationalModelEstimates != null) {
                            currentRelationalModelEstimates.getRDBMSSitesCheckBoxes(SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesCheckBoxes);
                            SVNEstimatedModelObjectsQuantityDialog.this.tablePhysicalModelsTable.updateUI();
                        }
                    }
                }
                if (selectedNode.getUserObject() instanceof Design || selectedNode.getUserObject().toString().compareTo(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.RelationalModels")) == 0) {
                    cardLayout.show(cardLayoutPanel, SVNEstimatedModelObjectsQuantityDialog.this.EMPTY_GROUP);
                } else if (selectedNode.getUserObject().toString().compareTo(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.DataTypesModel")) == 0) {
                    cardLayout.show(cardLayoutPanel, SVNEstimatedModelObjectsQuantityDialog.this.DATATYPESMODEL_GROUP);
                } else if (selectedNode.getUserObject() instanceof RelationalDesign) {
                    cardLayout.show(cardLayoutPanel, SVNEstimatedModelObjectsQuantityDialog.this.RELOBJECTS_GROUP);
                } else if (selectedNode.getUserObject().toString().compareTo(Messages.getString("SVNEstimatedModelObjectsQuantityDialog.PhysicalModels")) == 0) {
                    cardLayout.show(cardLayoutPanel, SVNEstimatedModelObjectsQuantityDialog.this.PHYSICALMODELS_GROUP);
                } else {
                    cardLayout.show(cardLayoutPanel, SVNEstimatedModelObjectsQuantityDialog.this.LOGICALMODEL_GROUP);
                }
            }

            private RelationalModelEstimates findCurrentRelationalModelEstimates() {
                RelationalModelEstimates relationalModelEstimates = null;
                for (int i = 0; i < SVNEstimatedModelObjectsQuantityDialog.this.relationalModelsEstimatesList.size(); ++i) {
                    if (SVNEstimatedModelObjectsQuantityDialog.this.relationalModelsEstimatesList.get((int)i).relationalDesign != SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign) continue;
                    relationalModelEstimates = SVNEstimatedModelObjectsQuantityDialog.this.relationalModelsEstimatesList.get(i);
                    break;
                }
                return relationalModelEstimates;
            }
        });
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(this.bnOK);
        bottomPanel.add(this.bnCancel);
        bottomPanel.add(this.bnHelp);
        this.add((Component)bottomPanel, "South");
        this.initRelationalModelsEstimates();
    }

    private void initRelationalModelsEstimates() {
        for (int i = 0; i < this.relationalDesigns.length; ++i) {
            RelationalModelEstimates relationalModelEstimates = new RelationalModelEstimates(this.relationalDesigns[i], this.rdbmsSitesCheckBoxes.size());
            relationalModelEstimates.setEstimatedRelationalModelObjectNumbers(this.tfTables.getText(), this.tfSchemas.getText(), this.tfForeignKeys.getText(), this.tfViews.getText(), this.tfSubViews.getText(), this.tfArcs.getText());
            this.relationalModelsEstimatesList.add(relationalModelEstimates);
        }
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.owner, Messages.getString("SVNEstimatedModelObjectsQuantityDialog.EstimatedModelObjects") + ApplicationView.getInstance().getCurrentDesign().getName());
            this.dialog.setContentPane(this);
            this.dialog.setSize(452, 440);
            this.dialog.setResizable(false);
            this.setDefaultActions(this.dialog);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private void storeLogicalDesignEstimates(int entities, int relations, int views, int arcs) {
        if (this.design != null) {
            LogicalDesignEstimates logicalDesignEstimates = this.design.getLogicalDesign().getLogicalDesignEstimates();
            logicalDesignEstimates.setEntitiesQuantity(entities);
            logicalDesignEstimates.setRelationsQuantity(relations);
            logicalDesignEstimates.setViewsQuantity(views);
            logicalDesignEstimates.setArcsQuantity(arcs);
        }
    }

    private void storeDataTypesDesignEstimates(int structuredTypes, int collectionTypes, int distinctTypes) {
        if (this.design != null) {
            DataTypesDesignEstimates dataTypesDesignEstimates = this.design.getDataTypesDesign().getDataTypesDesignEstimates();
            dataTypesDesignEstimates.setStructuredTypesQuantity(structuredTypes);
            dataTypesDesignEstimates.setCollectionTypesQuantity(collectionTypes);
            dataTypesDesignEstimates.setDistinctTypesQuantity(distinctTypes);
        }
    }

    private void storeRelationalDesignEstimates(RelationalDesign relationalDesign, int tables, int views, int foreignKeys, int schemas, int subviews, int arcs) {
        if (relationalDesign != null) {
            RelationalDesignEstimates relationalDesignEstimates = relationalDesign.getRelationalDesignEstimates();
            relationalDesignEstimates.setTablesQuantity(tables);
            relationalDesignEstimates.setViewsQuantity(views);
            relationalDesignEstimates.setForeignKeysQuantity(foreignKeys);
            relationalDesignEstimates.setSchemasQuantity(schemas);
            relationalDesignEstimates.setSubviewsQuantity(subviews);
            relationalDesignEstimates.setArcsQuantity(arcs);
        }
    }

    private void loadRelationalDesignEstimates(RelationalDesign relationalDesign) {
        RelationalDesignEstimates relationalDesignEstimates = relationalDesign.getRelationalDesignEstimates();
        this.initialValue = new Integer(relationalDesignEstimates.getTablesQuantity()).toString();
        this.tfTables.setText(this.initialValue);
        this.initialValue = new Integer(relationalDesignEstimates.getViewsQuantity()).toString();
        this.tfViews.setText(this.initialValue);
        this.initialValue = new Integer(relationalDesignEstimates.getForeignKeysQuantity()).toString();
        this.tfForeignKeys.setText(this.initialValue);
        this.initialValue = new Integer(relationalDesignEstimates.getSchemasQuantity()).toString();
        this.tfSchemas.setText(this.initialValue);
        this.initialValue = new Integer(relationalDesignEstimates.getSubviewsQuantity()).toString();
        this.tfSubViews.setText(this.initialValue);
        this.initialValue = new Integer(relationalDesignEstimates.getArcsQuantity()).toString();
        this.tfArcs.setText(this.initialValue);
    }

    private void createSegmentFolders(String storagePath, String subfolderName, int entitiesNumber, boolean isDesignVersioned) {
        if (entitiesNumber > 0) {
            File rootSegmentsDirectory = new File(storagePath + File.separator + subfolderName);
            if (!rootSegmentsDirectory.exists()) {
                rootSegmentsDirectory.mkdirs();
            }
            if (rootSegmentsDirectory.exists()) {
                int segNumber = entitiesNumber / SegmentNameManager.seg_size;
                if (entitiesNumber % SegmentNameManager.seg_size > 0) {
                    ++segNumber;
                }
                for (int i = 0; i < segNumber; ++i) {
                    File segDirectory = new File(storagePath + File.separator + subfolderName + File.separator + SegmentNameManager.NAME_PREFIX + i);
                    if (segDirectory.exists()) continue;
                    try {
                        segDirectory.mkdirs();
                    }
                    catch (SecurityException se) {
                        LOGGER.error(se);
                    }
                    if (!isDesignVersioned) continue;
                    this.AddToVersionControl(segDirectory);
                }
            }
        }
    }

    private void createPhysicalModelsSegmentFolders() {
        if (this.selectedRelationalDesign != null) {
            Design design = this.selectedRelationalDesign.getDesign();
            RDBMSSite[] rdbmsSiteSet = (RDBMSSite[])design.getRDBMSSiteSet().toArray();
            int numberOfRDBMSSites = rdbmsSiteSet.length;
            for (int i = 0; i < numberOfRDBMSSites; ++i) {
                StorageDesign sd;
                if (!this.rdbmsSitesCheckBoxes.get(i).isSelected() || (sd = this.selectedRelationalDesign.getStorageDesign(rdbmsSiteSet[i])) == null) continue;
                if (rdbmsSiteSet[i].getType().isChildOf(StorageDesignOraclev9i.RDBMS_TYPE)) {
                    this.createOracleStorageDesignSegmentFolders(sd);
                    continue;
                }
                if (rdbmsSiteSet[i].getType().equals(StorageDesignSqlServerv2k12.RDBMS_TYPE) || rdbmsSiteSet[i].getType().equals(StorageDesignSqlServerv2k8.RDBMS_TYPE) || rdbmsSiteSet[i].getType().equals(StorageDesignSqlServerv2k5.RDBMS_TYPE) || rdbmsSiteSet[i].getType().equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
                    this.createSqlServerStorageDesignSegmentFolders(sd);
                    continue;
                }
                if (rdbmsSiteSet[i].getType().equals(StorageDesignDB2v70.RDBMS_TYPE) || rdbmsSiteSet[i].getType().equals(StorageDesignDB2v80.RDBMS_TYPE)) {
                    this.createDB2StorageDesignSegmentFolders(sd);
                    continue;
                }
                if (!rdbmsSiteSet[i].getType().equals(StorageDesignUDBv71.RDBMS_TYPE) && !rdbmsSiteSet[i].getType().equals(StorageDesignUDBv81.RDBMS_TYPE) && !rdbmsSiteSet[i].getType().equals(StorageDesignUDBv9.RDBMS_TYPE)) continue;
                this.createDB2UDBStorageDesignSegmentFolders(sd);
            }
        }
    }

    private void createLogicalModelsSegmentFolders(Design design) {
        if (design != null) {
            String logicalModelPath = design.getLogicalDesign().getStoragePath();
            boolean isDesignVersioned = design.isSVNVersioned();
            int entitiesNumber = 0;
            if (this.tfLogicalEntities.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfLogicalEntities.getText());
                this.createSegmentFolders(logicalModelPath, "entity", entitiesNumber, isDesignVersioned);
            }
            if (this.tfLogicalRelations.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfLogicalRelations.getText());
                this.createSegmentFolders(logicalModelPath, "relation", entitiesNumber, isDesignVersioned);
            }
            if (this.tfLogicalViews.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfLogicalViews.getText());
                this.createSegmentFolders(logicalModelPath, "view", entitiesNumber, isDesignVersioned);
            }
            if (this.tfLogicalArcs.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfLogicalArcs.getText());
                this.createSegmentFolders(logicalModelPath, "arc", entitiesNumber, isDesignVersioned);
            }
        }
    }

    private void createDTModelSegmentFolders(Design design) {
        if (design != null) {
            int entitiesNumber = 0;
            if (this.tfStructuredTypes.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfStructuredTypes.getText());
                this.createRelationalModelDTSegmentFolders(design, "structuredtype", entitiesNumber);
            }
            if (this.tfCollectionTypes.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfCollectionTypes.getText());
                this.createRelationalModelDTSegmentFolders(design, "collectiontype", entitiesNumber);
            }
            if (this.tfDistinctTypes.getText().length() > 0) {
                entitiesNumber = new Integer(this.tfDistinctTypes.getText());
                this.createRelationalModelDTSegmentFolders(design, "distincttype", entitiesNumber);
            }
        }
    }

    private void createOracleStorageDesignSegmentFolders(StorageDesign sd) {
        String structuredTypesFolder = "SType";
        String tablesFolder = "Table";
        String UsersFolder = "User";
        int entitiesNumber = 0;
        File storagePath = new File(sd.getStoragePath());
        if (storagePath.exists()) {
            entitiesNumber = new Integer(this.tfSchemas.getText());
            this.createSegmentFolders(sd.getStoragePath(), UsersFolder, entitiesNumber, sd.getDesign().isSVNVersioned());
            entitiesNumber = new Integer(this.tfStructuredTypes.getText());
            this.createSegmentFolders(sd.getStoragePath(), structuredTypesFolder, entitiesNumber, sd.getDesign().isSVNVersioned());
            entitiesNumber = new Integer(this.tfTables.getText());
            this.createSegmentFolders(sd.getStoragePath(), tablesFolder, entitiesNumber, sd.getDesign().isSVNVersioned());
        }
    }

    private void createSqlServerStorageDesignSegmentFolders(StorageDesign sd) {
        int entitiesNumber = 0;
        File storagePath = new File(sd.getStoragePath());
        if (storagePath.exists()) {
            entitiesNumber = new Integer(this.tfSchemas.getText());
            this.createSegmentFolders(sd.getStoragePath(), "User", entitiesNumber, sd.getDesign().isSVNVersioned());
            entitiesNumber = new Integer(this.tfTables.getText());
            this.createSegmentFolders(sd.getStoragePath(), "Table", entitiesNumber, sd.getDesign().isSVNVersioned());
            entitiesNumber = new Integer(this.tfTables.getText());
            this.createSegmentFolders(sd.getStoragePath(), "View", entitiesNumber, sd.getDesign().isSVNVersioned());
            entitiesNumber = new Integer(this.tfSchemas.getText());
            this.createSegmentFolders(sd.getStoragePath(), "Role", entitiesNumber, sd.getDesign().isSVNVersioned());
        }
    }

    private void createDB2StorageDesignSegmentFolders(StorageDesign sd) {
        int entitiesNumber = 0;
        File storagePath = new File(sd.getStoragePath());
        if (storagePath.exists()) {
            entitiesNumber = new Integer(this.tfTables.getText());
            this.createSegmentFolders(sd.getStoragePath(), "BufPool", entitiesNumber, sd.getDesign().isSVNVersioned());
        }
    }

    private void createDB2UDBStorageDesignSegmentFolders(StorageDesign sd) {
        int entitiesNumber = 0;
        File storagePath = new File(sd.getStoragePath());
        if (storagePath.exists()) {
            entitiesNumber = new Integer(this.tfTables.getText());
            this.createSegmentFolders(sd.getStoragePath(), "Table", entitiesNumber, sd.getDesign().isSVNVersioned());
        }
    }

    private void AddToVersionControl(File filePath) {
        File parentPath;
        SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
        if (!svnClientHelper.isVersioned(parentPath = filePath.getParentFile())) {
            svnClientHelper.doAdd(parentPath, true);
            svnClientHelper.doCommit(new File[]{parentPath}, Messages.getString("SVNEstimatedModelObjectsQuantityDialog.CommitSegFoldersMessage"), true, true);
        } else {
            svnClientHelper.doAdd(filePath, true);
            svnClientHelper.doCommit(new File[]{filePath}, Messages.getString("SVNEstimatedModelObjectsQuantityDialog.CommitSegFoldersMessage"), true, true);
        }
    }

    private void createRelationalModelDTSegmentFolders(Design design, String subfolderName, int entitiesNumber) {
        if (entitiesNumber > 0) {
            int segNumber = entitiesNumber / SegmentNameManager.seg_size;
            if (entitiesNumber % SegmentNameManager.seg_size > 0) {
                ++segNumber;
            }
            for (int i = 0; i < segNumber; ++i) {
                File segDirectory = new File(design.getStoragePath() + File.separator + "datatypes" + File.separator + subfolderName + File.separator + SegmentNameManager.NAME_PREFIX + i);
                if (segDirectory.exists()) continue;
                segDirectory.mkdirs();
                if (!design.isSVNVersioned()) continue;
                this.AddToVersionControl(segDirectory);
            }
        }
    }

    private boolean isPhysicalModelCreated(RelationalDesign relationalDesign, int rdbmsSiteIndex) {
        RDBMSSite[] rdbmsSiteArray = (RDBMSSite[])relationalDesign.getDesign().getRDBMSSiteSet().toArray();
        StorageDesign[] storageDesignArray = (StorageDesign[])relationalDesign.getSorageDesigns().toArray();
        for (int i = 0; i < storageDesignArray.length; ++i) {
            StorageDesign sd = storageDesignArray[i];
            if (!sd.getRDBMSSite().getLongName().equalsIgnoreCase(rdbmsSiteArray[rdbmsSiteIndex].getLongName())) continue;
            return true;
        }
        return false;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SVNEstimatedModelObjectsQuantityDialog.this.storeLogicalDesignEstimates(new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalEntities.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalRelations.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalArcs.getText()));
            SVNEstimatedModelObjectsQuantityDialog.this.storeDataTypesDesignEstimates(new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfStructuredTypes.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfCollectionTypes.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfDistinctTypes.getText()));
            SVNEstimatedModelObjectsQuantityDialog.this.storeRelationalDesignEstimates(SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign, new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfTables.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfForeignKeys.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSchemas.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSubViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfArcs.getText()));
            SVNEstimatedModelObjectsQuantityDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isDesignVersioned = false;
            int entitiesNumber = 0;
            if (SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign != null) {
                String storagePath = SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign.getStoragePath();
                isDesignVersioned = SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign.getDesign().isSVNVersioned();
                entitiesNumber = 0;
                SVNEstimatedModelObjectsQuantityDialog.this.createLogicalModelsSegmentFolders(SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign.getDesign());
                if (SVNEstimatedModelObjectsQuantityDialog.this.tfSchemas.getText().length() > 0) {
                    entitiesNumber = new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSchemas.getText());
                    SVNEstimatedModelObjectsQuantityDialog.this.createSegmentFolders(storagePath, "schema", entitiesNumber, isDesignVersioned);
                }
                if (SVNEstimatedModelObjectsQuantityDialog.this.tfTables.getText().length() > 0) {
                    entitiesNumber = new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfTables.getText());
                    SVNEstimatedModelObjectsQuantityDialog.this.createSegmentFolders(storagePath, "table", entitiesNumber, isDesignVersioned);
                }
                if (SVNEstimatedModelObjectsQuantityDialog.this.tfArcs.getText().length() > 0) {
                    entitiesNumber = new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfArcs.getText());
                    SVNEstimatedModelObjectsQuantityDialog.this.createSegmentFolders(storagePath, "arc", entitiesNumber, isDesignVersioned);
                }
                if (SVNEstimatedModelObjectsQuantityDialog.this.tfForeignKeys.getText().length() > 0) {
                    entitiesNumber = new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfForeignKeys.getText());
                    SVNEstimatedModelObjectsQuantityDialog.this.createSegmentFolders(storagePath, "foreignkey", entitiesNumber, isDesignVersioned);
                }
                if (SVNEstimatedModelObjectsQuantityDialog.this.tfSubViews.getText().length() > 0) {
                    entitiesNumber = new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSubViews.getText());
                    SVNEstimatedModelObjectsQuantityDialog.this.createSegmentFolders(storagePath, "subviews", entitiesNumber, isDesignVersioned);
                }
                if (SVNEstimatedModelObjectsQuantityDialog.this.tfViews.getText().length() > 0) {
                    entitiesNumber = new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfViews.getText());
                    SVNEstimatedModelObjectsQuantityDialog.this.createSegmentFolders(storagePath, "view", entitiesNumber, isDesignVersioned);
                }
                SVNEstimatedModelObjectsQuantityDialog.this.createDTModelSegmentFolders(SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign.getDesign());
                SVNEstimatedModelObjectsQuantityDialog.this.createPhysicalModelsSegmentFolders();
            } else if (SVNEstimatedModelObjectsQuantityDialog.this.design != null) {
                SVNEstimatedModelObjectsQuantityDialog.this.createLogicalModelsSegmentFolders(SVNEstimatedModelObjectsQuantityDialog.this.design);
                SVNEstimatedModelObjectsQuantityDialog.this.createDTModelSegmentFolders(SVNEstimatedModelObjectsQuantityDialog.this.design);
            }
            SVNEstimatedModelObjectsQuantityDialog.this.storeLogicalDesignEstimates(new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalEntities.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalRelations.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfLogicalArcs.getText()));
            SVNEstimatedModelObjectsQuantityDialog.this.storeDataTypesDesignEstimates(new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfStructuredTypes.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfCollectionTypes.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfDistinctTypes.getText()));
            SVNEstimatedModelObjectsQuantityDialog.this.storeRelationalDesignEstimates(SVNEstimatedModelObjectsQuantityDialog.this.selectedRelationalDesign, new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfTables.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfForeignKeys.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSchemas.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfSubViews.getText()), new Integer(SVNEstimatedModelObjectsQuantityDialog.this.tfArcs.getText()));
            SVNEstimatedModelObjectsQuantityDialog.this.close();
        }
    }

    public class TablePhysicalModelsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SVNEstimatedModelObjectsQuantityDialog.PhysicalModels");
            }
            if (column == 1) {
                return Messages.getString("SVNEstimatedModelObjectsQuantityDialog.Created");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesCheckBoxes.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesNames.get(row);
            }
            if (col == 1) {
                return new Boolean(SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesCheckBoxes.get(row).isSelected());
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            JCheckBox obj = SVNEstimatedModelObjectsQuantityDialog.this.rdbmsSitesCheckBoxes.get(row);
            if (col == 1) {
                obj.setSelected((Boolean)aValue);
            }
        }
    }
}

