/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.RXMLRDBMSSiteSet;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class VersioningTreeNode
extends DisplayableLocatableNode {
    private static final ApplicationView APPLICATION_VIEW = ApplicationView.getInstance();
    private static final Settings SETTINGS = APPLICATION_VIEW.getSettings();
    private static final XMLTransformationManager XML_TRANSFORMATION_MANAGER = APPLICATION_VIEW.getXMLTransformationManager();
    private static final ProcessModelNodesComparator PROCESS_MODEL_NODES_COMPARATOR = new ProcessModelNodesComparator();
    private static final Logger LOGGER = new Logger(VersioningTreeNode.class);
    private static final String NOT_ABLE_TO_DELETE_MESSAGE = Messages.getString("VersioningTreeNode.NotAbleToDelete");
    private StorableObjectStatus storableObjectStatus;
    private boolean conflicted;
    private VersioningTreeNode dependingOn;
    private File dependantFilePath;
    String textStatus = "";
    private boolean recursuve = false;

    public VersioningTreeNode(String name, File filePath) {
        super(name, filePath, null);
    }

    public VersioningTreeNode(String name, File filePath, Class objectClass) {
        super(name, filePath, objectClass);
    }

    public VersioningTreeNode(StorableObjectStatus storableObjectStatus) {
        super(storableObjectStatus.getStorableObjectName(), null, null);
        this.setStorableObjectStatus(storableObjectStatus);
    }

    @Override
    public StorableObject getStorableObject() {
        return this.storableObjectStatus != null ? this.storableObjectStatus.getStorableObject() : null;
    }

    public StorableObjectStatus getStorableObjectStatus() {
        return this.storableObjectStatus;
    }

    public void setStorableObjectStatus(StorableObjectStatus storableObjectStatus) {
        this.storableObjectStatus = storableObjectStatus;
        this.filePath = storableObjectStatus.getFilePath();
        this.setObjectClass(storableObjectStatus.getObjectClass());
        if ("C".equals(storableObjectStatus.getTextStatus()) || storableObjectStatus.isInconflict()) {
            this.propagateConflicted(this);
        }
    }

    @Override
    public void setObjectClass(Class objectClass) {
        VersioningTreeNode depn;
        this.objectClass = objectClass;
        if (Design.class.equals((Object)objectClass) || StorageDesign.class.equals((Object)objectClass) || VersioningTreeNode.isMultiModel(objectClass)) {
            this.setDependingOn(null);
            this.propagateDependances(this);
            this.setDependantFilePath(StorageDesign.class.equals((Object)objectClass) ? this.filePath.getParentFile() : new File(FileUtils.removeExt(this.filePath.getPath())));
        } else if (this.getParent() != null && (depn = ((VersioningTreeNode)this.getParent()).getDependingOn()) != null) {
            this.setDependingOn(depn);
        }
    }

    @Override
    public Icon getIcon() {
        return VCSClientHelper.getIcon(this.objectClass);
    }

    @Override
    public Class getObjectClass() {
        return this.objectClass;
    }

    public static void refresh(List<VersioningTreeNode> nodes, boolean revert) {
        VersioningTreeNode.refresh(nodes, revert, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(List<VersioningTreeNode> nodes, boolean revert, boolean removeLocalFilesWhenFinished) {
        HashMap<String, DesignPart> dpMap = new HashMap<String, DesignPart>();
        HashMap sites = new HashMap();
        Design design = null;
        try {
            ApplicationView.loading = true;
            for (VersioningTreeNode node : nodes) {
                DesignPart designPart;
                String clstr;
                StorableObjectStatus st = node.getStorableObjectStatus();
                if (st != null && st.getObjectClass() == null && st.filePath != null && st.filePath.isFile() && st.filePath.exists() && (clstr = GitClientHelper.getClassFromXMLFile(st.filePath)) != null && !clstr.isEmpty()) {
                    try {
                        Class<?> cl = Class.forName(clstr);
                        node.setObjectClass(cl);
                        node.setObjectClass(cl);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if ((designPart = node.getStorableObjectStatus().getDesignPart()) != null) {
                    design = designPart.getDesign();
                }
                if (designPart == null || !node.getStorableObjectStatus().isAdded() && !node.getStorableObjectStatus().isDeleted()) continue;
                dpMap.put(designPart.getObjectID(), designPart);
                RDBMSSite site = node.getStorableObjectStatus().getRdbmsSite();
                if (site == null) continue;
                ArrayList<RDBMSSite> list = (ArrayList<RDBMSSite>)sites.get(designPart);
                if (list == null) {
                    list = new ArrayList<RDBMSSite>();
                    sites.put(designPart, list);
                }
                if (list.contains(site)) continue;
                list.add(site);
            }
            Map<Object, List<VersioningTreeNode>> systemFileNodes = VersioningTreeNode.splitSystemNodes(nodes);
            VersioningTreeNode.refreshSystemFiles(systemFileNodes);
            ArrayList dfDesigns = new ArrayList();
            ArrayList dimensionalModels = new ArrayList();
            ArrayList packages = new ArrayList();
            HashMap trTasks = new HashMap();
            VersioningTreeNode.refreshMultiDesignParts(nodes, revert, dfDesigns, dimensionalModels, packages, trTasks);
            Map nodesByDesignPartClassAndDesignAndTypeAndStatus = VersioningTreeNode.splitNodes(nodes);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(Design.class), revert);
            Map changeRequests = (Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(ChangeRequest.class);
            if (changeRequests != null) {
                VersioningTreeNode.refreshNodes(changeRequests, revert);
                VersioningTreeNode.refreshChangeRequestsList(DataModelerChangeList.getSelectedDesign());
            }
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(BusinessInfoDesign.class), revert);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(DataTypesDesign.class), revert);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(LogicalDesign.class), revert);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(RelationalDesign.class), revert);
            VersioningTreeNode.refreshExtendedMaps(systemFileNodes);
            VersioningTreeNode.addNewDimensionalModels(dimensionalModels);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(MultidimensionalDesign.class), revert);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(ProcessModel.class), revert);
            VersioningTreeNode.addNewPackages(packages);
            VersioningTreeNode.addNewTransformationTasks(trTasks);
            ArrayList list = new ArrayList();
            VersioningTreeNode.addAndPreProcessDFDs(dfDesigns, list);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(DataFlowDesign.class), revert, true, list);
            VersioningTreeNode.refreshNodes((Map)nodesByDesignPartClassAndDesignAndTypeAndStatus.get(TransformationTask.class), revert);
            if (DataModelerChangeList.getSelectedDesign() != null) {
                DataModelerChangeList.getSelectedDesign().getProcessModel().updateObjects();
            }
        }
        finally {
            if (removeLocalFilesWhenFinished) {
                // empty if block
            }
            ApplicationView.loading = false;
            if (design != null) {
                design.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(design);
            }
        }
    }

    private static void addNewTransformationTasks(Map tasks) {
        for (VersioningTreeNode node : tasks.values()) {
            TransformationPackage tp;
            TransformationTask tt;
            String parentID;
            File filePath;
            Class objectClass = node.getObjectClass();
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            String id = storableObjectStatus.getStorableObjectID();
            Design design = node.getStorableObjectStatus().getDesign();
            if (objectClass == null || !TransformationTask.class.isAssignableFrom(objectClass) || !(filePath = storableObjectStatus.getFilePath()).exists() || (parentID = storableObjectStatus.getStorableObjectParentID()) == null || "".equals(parentID) || (tt = (TransformationTask)(tp = (TransformationPackage)design.getProcessModel().getTransformationPackageSet().getObjectByID(parentID)).getTransformationTaskSet().getObjectByID(id)) != null) continue;
            tt = tp.createTransformationTask(id);
            XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(tt, filePath, design.isCompressedDesign());
            XML_TRANSFORMATION_MANAGER.loadTransformationTask(tt);
            design.createLocalDP_Map();
        }
    }

    private static void addAndPreProcessDFDs(List dfDesigns, List sortedDFDs) {
        Design design = null;
        for (VersioningTreeNode node : dfDesigns) {
            File filePath;
            Class objectClass = node.getObjectClass();
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            design = node.getStorableObjectStatus().getDesign();
            if (objectClass == null || !DataFlowDesign.class.isAssignableFrom(objectClass) || !(filePath = storableObjectStatus.getFilePath()).exists()) continue;
            DataFlowDesign dfd = design.getProcessModel().getObjectID().equals(storableObjectStatus.getStorableObjectParentID()) ? design.getProcessModel().addDataFlowDesign(storableObjectStatus.getStorableObjectName(), true) : design.getProcessModel().addDataFlowDesign(storableObjectStatus.getStorableObjectName());
            try {
                XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(dfd, filePath, design.isCompressedDesign());
            }
            catch (Exception ex) {
                Design.openFailed();
                LOGGER.error("Error in loading of " + filePath, ex);
            }
        }
        if (design != null) {
            design.createLocalDP_Map();
            design.getProcessModel().getDataFlowDesigns().addOrderedDataFlowDesigns(sortedDFDs);
        }
    }

    private static void addNewPackages(List packages) {
        for (VersioningTreeNode node : packages) {
            File filePath;
            Class objectClass = node.getObjectClass();
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            Design design = node.getStorableObjectStatus().getDesign();
            if (objectClass == null || !TransformationPackage.class.isAssignableFrom(objectClass) || !(filePath = storableObjectStatus.getFilePath()).exists()) continue;
            TransformationPackage tp = design.getProcessModel().createTransformationPackage(storableObjectStatus.getStorableObjectID());
            try {
                XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(tp, filePath, design.isCompressedDesign());
            }
            catch (Exception ex) {
                Design.openFailed();
                LOGGER.error("Error in loading of " + filePath, ex);
            }
            design.getProcessModel().setTransformationPackage(tp);
            XML_TRANSFORMATION_MANAGER.loadTransformationPackage(tp);
            design.createLocalDP_Map();
        }
    }

    private static void addNewDimensionalModels(List models) {
        for (VersioningTreeNode node : models) {
            File filePath;
            Class objectClass = node.getObjectClass();
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            Design design = node.getStorableObjectStatus().getDesign();
            if (objectClass == null || !MultidimensionalDesign.class.isAssignableFrom(objectClass) || !(filePath = storableObjectStatus.getFilePath()).exists()) continue;
            MultidimensionalDesign model = design.addMultidimensionalDesign(storableObjectStatus.getStorableObjectID());
            XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(model, filePath, design.isCompressedDesign());
            design.createLocalDP_Map();
            XML_TRANSFORMATION_MANAGER.openDesignPart(model);
        }
    }

    private static void refreshMultiDesignParts(List<VersioningTreeNode> nodes, boolean revert, List dfDesigns, List dimensionalModels, List packages, Map trTasks) {
        ArrayList<VersioningTreeNode> processedNodes = new ArrayList<VersioningTreeNode>();
        Collections.sort(nodes, PROCESS_MODEL_NODES_COMPARATOR);
        for (VersioningTreeNode node : nodes) {
            Class objectClass = node.getObjectClass();
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            Design design = node.getStorableObjectStatus().getDesign();
            if (objectClass == null) continue;
            if (VersioningTreeNode.isMultiModel(objectClass) && (revert && storableObjectStatus.isAdded() || !revert && storableObjectStatus.isDeleted())) {
                DesignPart model;
                DesignPart designPart = node.getStorableObjectStatus().getDesignPart();
                if (designPart instanceof RelationalDesign) {
                    RelationalDesign relationalDesign = (RelationalDesign)designPart;
                    if (node.getObjectClass() == StorageDesign.class) {
                        StorageDesign sd;
                        RDBMSSite site;
                        if (relationalDesign.isLoaded() && (site = relationalDesign.getDesign().getRDBMSSiteByShortID(node.getFilePath().getName())) != null && (sd = relationalDesign.getStorageDesign(site)) != null) {
                            relationalDesign.getStorageDesignFactory().removeStorageDesign(sd);
                        }
                    } else {
                        design.removeRelationalDesign(relationalDesign);
                    }
                } else if (designPart instanceof MultidimensionalDesign) {
                    model = (MultidimensionalDesign)designPart;
                    design.removeMultidimensionalDesign((MultidimensionalDesign)model);
                } else if (designPart instanceof DataFlowDesign) {
                    model = (DataFlowDesign)designPart;
                    design.getProcessModel().removeDataFlowDesign((DataFlowDesign)model);
                } else if (designPart instanceof TransformationTask) {
                    model = (TransformationTask)designPart;
                    ((TransformationTask)model).getTransformationPackage().removeTransformationTask((TransformationTask)model);
                }
                design.removeDeletedDesignParts(false);
                design.createLocalDP_Map();
                processedNodes.add(node);
                continue;
            }
            if (!VersioningTreeNode.isMultiModel(objectClass) && !TransformationPackage.class.isAssignableFrom(objectClass) || (!revert || !storableObjectStatus.isDeleted()) && (revert || !storableObjectStatus.isAdded())) continue;
            File filePath = storableObjectStatus.getFilePath();
            if (filePath.exists()) {
                Class<? extends DesignPart> dpClass = storableObjectStatus.getDesignPartClass();
                RelationalDesign model = null;
                if (RelationalDesign.class.isAssignableFrom(dpClass) && storableObjectStatus.getObjectClass() == RelationalDesign.class) {
                    model = design.addRelationalDesign(storableObjectStatus.getStorableObjectID());
                    model.setLoaded(false);
                } else if (RelationalDesign.class.isAssignableFrom(dpClass) && StorageDesign.class.isAssignableFrom(storableObjectStatus.getObjectClass())) {
                    DesignPart designPart = node.getStorableObjectStatus().getDesignPart();
                    if (designPart != null && designPart instanceof RelationalDesign) {
                        StorageDesign stoDes;
                        RDBMSSite site;
                        RelationalDesign relModel = (RelationalDesign)designPart;
                        String siteID = storableObjectStatus.getStorableObjectIDString();
                        if (siteID == null) {
                            siteID = storableObjectStatus.getStorableObjectID();
                        }
                        if ((site = designPart.getDesign().getRDBMSSiteSet().getByShortObjectIDString(siteID)) != null && (stoDes = relModel.getStorageDesign(site)) != null) {
                            stoDes.setOpen(false);
                            stoDes.setTempModel(false);
                        }
                    }
                } else if (MultidimensionalDesign.class.isAssignableFrom(dpClass)) {
                    dimensionalModels.add(node);
                } else if (DataFlowDesign.class.isAssignableFrom(dpClass)) {
                    dfDesigns.add(node);
                } else if (TransformationPackage.class.isAssignableFrom(objectClass)) {
                    packages.add(node);
                } else if (TransformationTask.class.isAssignableFrom(dpClass)) {
                    trTasks.put(storableObjectStatus.getStorableObjectID(), node);
                } else if (InfoStore.class.isAssignableFrom(objectClass)) {
                    ((ProcessModel)storableObjectStatus.getDesignPart()).getInfoStoreSet().createInfoStore(storableObjectStatus.getStorableObjectID());
                }
                if (model != null && !(model instanceof RelationalDesign)) {
                    XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(model, filePath, design.isCompressedDesign());
                    design.createLocalDP_Map();
                    XML_TRANSFORMATION_MANAGER.openDesignPart(model);
                } else if (model != null && model instanceof RelationalDesign) {
                    XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(model, filePath, design.isCompressedDesign());
                    design.createLocalDP_Map();
                    model.setLoaded(false);
                }
            }
            processedNodes.add(node);
        }
        VersioningTreeNode.removeProcessedNodes(nodes, processedNodes);
    }

    private static void removeProcessedNodes(List<VersioningTreeNode> nodes, List<VersioningTreeNode> processedDesignPartNodes) {
        nodes.removeAll(processedDesignPartNodes);
        for (VersioningTreeNode designPartNode : processedDesignPartNodes) {
            DesignPart designPart = designPartNode.getStorableObjectStatus().getDesignPart();
            for (int i = nodes.size() - 1; i >= 0; --i) {
                VersioningTreeNode node = nodes.get(i);
                if (designPart != null && designPart.equals(node.getStorableObjectStatus().getDesignPart())) {
                    if (designPart instanceof ProcessModel) continue;
                    nodes.remove(i);
                    continue;
                }
                if (!designPartNode.equals(node.getDependingOn())) continue;
                nodes.remove(i);
            }
        }
    }

    private static Map splitNodes(List<VersioningTreeNode> allNodes) {
        HashMap nodesByDesignPartAndDesignAndTypeAndStatus = new HashMap();
        HashSet<DesignPart> removeObjectsDesignParts = new HashSet<DesignPart>();
        HashSet<DesignPart> removeDiagramsDesignParts = new HashSet<DesignPart>();
        HashSet<StorageDesign> removeObjectsStorageDesigns = new HashSet<StorageDesign>();
        for (VersioningTreeNode node : allNodes) {
            ArrayList<VersioningTreeNode> nodesList;
            HashMap<String, ArrayList<VersioningTreeNode>> nodesByStatus;
            HashMap nodesByTypeAndStatus;
            HashMap nodesByDesignAndTypeAndStatus;
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            DesignPart designPart = storableObjectStatus.getDesignPart();
            RDBMSSite rdbmsSite = storableObjectStatus.getRdbmsSite();
            StorageDesign storageDesign = null;
            if (rdbmsSite != null && storableObjectStatus.getDesignPart() instanceof RelationalDesign) {
                storageDesign = ((RelationalDesign)storableObjectStatus.getDesignPart()).getStorageDesign(rdbmsSite);
            }
            Class designPartClass = storableObjectStatus.getDesignPartClass();
            String status = storableObjectStatus.getTextStatus();
            if (storageDesign != null) {
                if (removeObjectsStorageDesigns.contains(storageDesign)) continue;
                removeObjectsStorageDesigns.add(storageDesign);
                continue;
            }
            if (designPart != null && !designPart.isLoaded() && ("A".equals(status) || "D".equals(status))) {
                Class objectClass = storableObjectStatus.getObjectClass();
                if (objectClass != null && DesignPartView.class.isAssignableFrom(objectClass)) {
                    removeDiagramsDesignParts.add(designPart);
                    continue;
                }
                removeObjectsDesignParts.add(designPart);
                continue;
            }
            String type = storableObjectStatus.getObjectType();
            if (type == null) {
                type = storableObjectStatus.getClass().toString();
            }
            if (designPartClass == null) {
                designPartClass = storableObjectStatus.getObjectClass();
            }
            if ((nodesByDesignAndTypeAndStatus = (HashMap)nodesByDesignPartAndDesignAndTypeAndStatus.get(designPartClass)) == null) {
                nodesByDesignAndTypeAndStatus = new HashMap();
                nodesByDesignPartAndDesignAndTypeAndStatus.put(designPartClass, nodesByDesignAndTypeAndStatus);
            }
            if ((nodesByTypeAndStatus = (HashMap)nodesByDesignAndTypeAndStatus.get(designPart)) == null) {
                nodesByTypeAndStatus = new HashMap();
                nodesByDesignAndTypeAndStatus.put(designPart, nodesByTypeAndStatus);
            }
            if ((nodesByStatus = (HashMap<String, ArrayList<VersioningTreeNode>>)nodesByTypeAndStatus.get(type)) == null) {
                nodesByStatus = new HashMap<String, ArrayList<VersioningTreeNode>>();
                nodesByTypeAndStatus.put(type, nodesByStatus);
            }
            if ((nodesList = (ArrayList<VersioningTreeNode>)nodesByStatus.get(status)) == null) {
                nodesList = new ArrayList<VersioningTreeNode>();
                nodesByStatus.put(status, nodesList);
            }
            nodesList.add(node);
        }
        return nodesByDesignPartAndDesignAndTypeAndStatus;
    }

    private static void refreshNodes(Map nodesByDesignAndTypeAndStatus, boolean revert) {
        VersioningTreeNode.refreshNodes(nodesByDesignAndTypeAndStatus, revert, false);
    }

    private static void refreshNodes(Map nodesByDesignAndTypeAndStatus, boolean revert, boolean processParents) {
        if (nodesByDesignAndTypeAndStatus != null) {
            Map nodesWithoutDesignPart = (Map)nodesByDesignAndTypeAndStatus.remove(null);
            if (nodesWithoutDesignPart != null) {
                VersioningTreeNode.refreshNodesWithoutDesignPart(nodesWithoutDesignPart, revert);
            }
            VersioningTreeNode.refreshNodesWithDesignPart(nodesByDesignAndTypeAndStatus, revert, processParents);
        }
    }

    private static void refreshNodes(Map nodesByDesignAndTypeAndStatus, boolean revert, boolean processParents, List processingOrder) {
        if (nodesByDesignAndTypeAndStatus != null) {
            Map nodesWithoutDesignPart = (Map)nodesByDesignAndTypeAndStatus.remove(null);
            if (nodesWithoutDesignPart != null) {
                VersioningTreeNode.refreshNodesWithoutDesignPart(nodesWithoutDesignPart, revert);
            }
            VersioningTreeNode.refreshNodesWithDesignPart(nodesByDesignAndTypeAndStatus, revert, processParents, processingOrder);
        }
    }

    private static void refreshNodesWithoutDesignPart(Map nodesByTypeAndStatus, boolean revert) {
        VersioningTreeNode.refresh(nodesByTypeAndStatus, nodesByTypeAndStatus.keySet(), revert, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshNodesWithDesignPart(Map nodesByDesignAndTypeAndStatus, boolean revert, boolean processParents) {
        for (Object key : nodesByDesignAndTypeAndStatus.keySet()) {
            DesignPart designPart = (DesignPart)key;
            if (!designPart.isLoaded()) continue;
            designPart.getDesign().setPropagatePKChahges(false);
            try {
                Map nodesByTypeAndStatus = (Map)nodesByDesignAndTypeAndStatus.get(designPart);
                List orderedTypes = designPart.getOrderedTypes(new ArrayList(nodesByTypeAndStatus.keySet()));
                VersioningTreeNode.refresh(nodesByTypeAndStatus, orderedTypes, revert, processParents, nodesByDesignAndTypeAndStatus);
                designPart.executeTasks();
                designPart.createFilesMap();
                if (designPart instanceof RelationalDesign) {
                    StorageDesign[] storageDesigns;
                    for (StorageDesign storageDesign : storageDesigns = ((RelationalDesign)designPart).getStorageDesignFactory().getOpenStorageDesigns()) {
                        storageDesign.synchronizeFilesMap(false);
                    }
                }
                XML_TRANSFORMATION_MANAGER.saveObjectsAndDiagramsList(designPart);
                designPart.doAfterLoad();
            }
            finally {
                designPart.getDesign().setPropagatePKChahges(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshNodesWithDesignPart(Map nodesByDesignAndTypeAndStatus, boolean revert, boolean processParents, List processingOrder) {
        for (DesignPart designPart : processingOrder) {
            if (designPart instanceof DataFlowDesign && !designPart.isLoaded()) {
                XML_TRANSFORMATION_MANAGER.openDesignPart(designPart);
                designPart.sortCollections();
            }
            if (!designPart.isLoaded()) continue;
            designPart.getDesign().setPropagatePKChahges(false);
            try {
                Map nodesByTypeAndStatus = (Map)nodesByDesignAndTypeAndStatus.get(designPart);
                List orderedTypes = designPart.getOrderedTypes(new ArrayList(nodesByTypeAndStatus.keySet()));
                VersioningTreeNode.refresh(nodesByTypeAndStatus, orderedTypes, revert, processParents, nodesByDesignAndTypeAndStatus);
                designPart.executeTasks();
                designPart.createFilesMap();
                if (designPart instanceof RelationalDesign) {
                    StorageDesign[] storageDesigns;
                    for (StorageDesign storageDesign : storageDesigns = ((RelationalDesign)designPart).getStorageDesignFactory().getOpenStorageDesigns()) {
                        storageDesign.synchronizeFilesMap(false);
                    }
                }
                XML_TRANSFORMATION_MANAGER.saveObjectsAndDiagramsList(designPart);
                designPart.doAfterLoad();
            }
            finally {
                designPart.getDesign().setPropagatePKChahges(true);
            }
        }
    }

    private static void refresh(Map nodesByTypeAndStatus, Collection<String> typeOrder, boolean revert, boolean processParents, Map nodesByDesignAndTypeAndStatus) {
        ArrayList<VersioningTreeNode> clearDirtyStatusNodes = new ArrayList<VersioningTreeNode>();
        for (String type : typeOrder) {
            List conflicted;
            Map nodesByStatus = (Map)nodesByTypeAndStatus.get(type);
            if (nodesByStatus == null) continue;
            if (revert) {
                List missing;
                List added = (List)nodesByStatus.get("A");
                VersioningTreeNode.removeObjects(added, processParents, nodesByDesignAndTypeAndStatus, revert);
                ArrayList<VersioningTreeNode> deleted = (ArrayList<VersioningTreeNode>)nodesByStatus.get("D");
                if (deleted == null) {
                    deleted = new ArrayList<VersioningTreeNode>();
                }
                if ((missing = (List)nodesByStatus.get("MI")) != null) {
                    deleted.addAll(missing);
                }
                if ((missing = (List)nodesByStatus.get("!")) != null) {
                    deleted.addAll(missing);
                }
                VersioningTreeNode.createObjects(deleted, processParents, nodesByDesignAndTypeAndStatus, revert);
                conflicted = (List)nodesByStatus.get("C");
                VersioningTreeNode.refreshObjects(conflicted, processParents, nodesByDesignAndTypeAndStatus, revert);
                List modified = (List)nodesByStatus.get("M");
                VersioningTreeNode.refreshObjects(modified, processParents, nodesByDesignAndTypeAndStatus, revert);
                VersioningTreeNode.addNodes(added, clearDirtyStatusNodes);
                VersioningTreeNode.addNodes(deleted, clearDirtyStatusNodes);
                VersioningTreeNode.addNodes(conflicted, clearDirtyStatusNodes);
                VersioningTreeNode.addNodes(modified, clearDirtyStatusNodes);
                continue;
            }
            List deleted = (List)nodesByStatus.get("D");
            VersioningTreeNode.removeObjects(deleted, processParents, nodesByDesignAndTypeAndStatus, revert);
            List added = (List)nodesByStatus.get("A");
            VersioningTreeNode.createObjects(added, processParents, nodesByDesignAndTypeAndStatus, revert);
            List modified = (List)nodesByStatus.get("M");
            VersioningTreeNode.refreshObjects(modified, processParents, nodesByDesignAndTypeAndStatus, revert);
            conflicted = (List)nodesByStatus.get("C");
            VersioningTreeNode.refreshObjects(conflicted, processParents, nodesByDesignAndTypeAndStatus, revert);
            VersioningTreeNode.addNodes(added, clearDirtyStatusNodes);
            VersioningTreeNode.addNodes(modified, clearDirtyStatusNodes);
            VersioningTreeNode.addNodes(conflicted, clearDirtyStatusNodes);
        }
        VersioningTreeNode.clearDirtyStatus(clearDirtyStatusNodes);
    }

    private static Map<Object, List<VersioningTreeNode>> splitSystemNodes(List<VersioningTreeNode> nodes) {
        HashMap<Object, List<VersioningTreeNode>> result = new HashMap<Object, List<VersioningTreeNode>>();
        for (VersioningTreeNode node : nodes) {
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            String storableObjectName = storableObjectStatus.getStorableObjectName();
            Class storableObjectClass = storableObjectStatus.getObjectClass();
            if (storableObjectClass == null) {
                storableObjectClass = node.getObjectClass();
            }
            if ("defaultRDBMSSites.xml".equalsIgnoreCase(storableObjectName)) {
                VersioningTreeNode.addToNodesList(result, "defaultRDBMSSites.xml", node);
                continue;
            }
            if ("types.xml".equalsIgnoreCase(storableObjectName)) {
                VersioningTreeNode.addToNodesList(result, "types.xml", node);
                continue;
            }
            if ("defaultdomains.xml".equalsIgnoreCase(storableObjectName)) {
                VersioningTreeNode.addToNodesList(result, "defaultdomains.xml", node);
                continue;
            }
            if ("dr_custom_scripts.xml".equalsIgnoreCase(storableObjectName)) {
                VersioningTreeNode.addToNodesList(result, "dr_custom_scripts.xml", node);
                continue;
            }
            if (storableObjectClass == null) continue;
            if (storableObjectClass.isAssignableFrom(RDBMSSite.class)) {
                VersioningTreeNode.addToNodesList(result, RDBMSSite.class, node);
                continue;
            }
            if (storableObjectClass.isAssignableFrom(DomainFileWrapper.class)) {
                VersioningTreeNode.addToNodesList(result, DomainFileWrapper.class, node);
                continue;
            }
            if (storableObjectClass.isAssignableFrom(DesignLevelSettings.class)) {
                VersioningTreeNode.addToNodesList(result, DesignLevelSettings.class, node);
                continue;
            }
            if (storableObjectClass.isAssignableFrom(ExtendedMap.class)) {
                VersioningTreeNode.addToNodesList(result, ExtendedMap.class, node);
                continue;
            }
            if (storableObjectClass.isAssignableFrom(RMExtendedMap.class)) {
                VersioningTreeNode.addToNodesList(result, ExtendedMap.class, node);
                continue;
            }
            if (!storableObjectClass.isAssignableFrom(RMDeletedMap.class)) continue;
            VersioningTreeNode.addToNodesList(result, ExtendedMap.class, node);
        }
        for (List systemNodes : result.values()) {
            nodes.removeAll(systemNodes);
        }
        return result;
    }

    private static void addToNodesList(Map<Object, List<VersioningTreeNode>> nodesMap, Object key, VersioningTreeNode value) {
        List<VersioningTreeNode> nodesList = nodesMap.get(key);
        if (nodesList == null) {
            nodesList = new ArrayList<VersioningTreeNode>();
            nodesMap.put(key, nodesList);
        }
        nodesList.add(value);
    }

    private static void addNodes(List<VersioningTreeNode> nodes, List<VersioningTreeNode> allNodes) {
        if (nodes != null) {
            allNodes.addAll(nodes);
        }
    }

    private static void clearDirtyStatus(List<VersioningTreeNode> nodes) {
        for (VersioningTreeNode versioningTreeNode : nodes) {
            StorableObject storableObject = versioningTreeNode.getStorableObject();
            if (storableObject == null) continue;
            XML_TRANSFORMATION_MANAGER.clearDirtyStatus(storableObject);
        }
    }

    private static void createObjects(List<VersioningTreeNode> nodes, boolean processParents, Map nodesByDesignAndTypeAndStatus, boolean revert) {
        if (nodes != null) {
            for (VersioningTreeNode versioningTreeNode : nodes) {
                VersioningTreeNode.createObject(versioningTreeNode, processParents, nodesByDesignAndTypeAndStatus, revert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createObject(VersioningTreeNode versioningTreeNode, boolean processParents, Map nodesByDesignAndTypeAndStatus, boolean revert) {
        File filePath = versioningTreeNode.getFilePath();
        if (filePath.exists()) {
            StorableObject storableObject = null;
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            String objectType = storableObjectStatus.getObjectType();
            Class storableObjectClass = storableObjectStatus.getObjectClass();
            DesignPart designPart = storableObjectStatus.getDesignPart();
            if (processParents) {
                VersioningTreeNode.processParent(storableObjectStatus.getStorableObjectParentID(), nodesByDesignAndTypeAndStatus, revert);
            }
            if (storableObjectClass != null && DesignPartView.class.isAssignableFrom(storableObjectClass)) {
                storableObject = designPart.createDesignPartSubView();
            } else if (storableObjectClass != null && StorageObject.class.isAssignableFrom(storableObjectClass)) {
                StorageDesign storageDesign;
                RDBMSSite rdbmsSite = storableObjectStatus.getRdbmsSite();
                if (rdbmsSite != null && rdbmsSite != null && storableObjectStatus.getDesignPart() instanceof RelationalDesign && (storageDesign = ((RelationalDesign)storableObjectStatus.getDesignPart()).getStorageDesign(rdbmsSite)).isOpen()) {
                    StorageObjectSet storageObjectSetForType = storageDesign.getStorageObjectSetForType(objectType);
                    if (storageObjectSetForType == null) {
                        return;
                    }
                    storableObject = storageObjectSetForType.createElement(storableObjectStatus.getStorableObjectID());
                }
            } else if (storableObjectClass != null && StorageDesign.class.isAssignableFrom(storableObjectClass)) {
                XML_TRANSFORMATION_MANAGER.loadExistingPhysicalModels((RelationalDesign)designPart);
            } else if (objectType != null) {
                storableObject = designPart.createObject(objectType, storableObjectStatus.getStorableObjectID(), null);
            }
            boolean loading = ApplicationView.loading;
            if (storableObject instanceof DesignPartView) {
                ApplicationView.loading = false;
            }
            try {
                VersioningTreeNode.transformFromXMLToObject(storableObject, filePath, storableObjectStatus);
            }
            finally {
                ApplicationView.loading = loading;
            }
        }
    }

    private static void transformFromXMLToObject(StorableObject storableObject, File filePath, StorableObjectStatus storableObjectStatus) {
        if (storableObject != null) {
            Relation relation;
            XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(storableObject, filePath, storableObject.getDesign().isCompressedDesign());
            storableObject.setLoadedCompletely(true);
            if (storableObject instanceof FKIndexAssociation) {
                FKIndexAssociation fk = (FKIndexAssociation)storableObject;
                XML_TRANSFORMATION_MANAGER.clearDirtyStatus(fk.getTable());
            } else if (storableObject instanceof Relation && ((relation = (Relation)storableObject).getSourceEntity() == null || relation.getTargetEntity() == null)) {
                relation.remove();
            }
            storableObjectStatus.setStorableObject(storableObject);
            XML_TRANSFORMATION_MANAGER.clearDirtyStatus(storableObject);
        }
    }

    private static void refreshObjects(List<VersioningTreeNode> nodes, boolean processParents, Map nodesByDesignAndTypeAndStatus, boolean revert) {
        if (nodes != null) {
            for (VersioningTreeNode versioningTreeNode : nodes) {
                VersioningTreeNode.refreshObject(versioningTreeNode, processParents, nodesByDesignAndTypeAndStatus, revert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshObject(VersioningTreeNode versioningTreeNode, boolean processParents, Map nodesByDesignAndTypeAndStatus, boolean revert) {
        StorableObject storableObject = versioningTreeNode.getStorableObject();
        if (storableObject != null) {
            if (processParents) {
                VersioningTreeNode.processParent(versioningTreeNode.getStorableObjectStatus().getStorableObjectParentID(), nodesByDesignAndTypeAndStatus, revert);
            }
            boolean loading = ApplicationView.loading;
            if (storableObject instanceof DesignPartView) {
                ApplicationView.loading = false;
            }
            try {
                DesignPartView dpv;
                XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(storableObject, versioningTreeNode.getFilePath(), storableObject.getDesign().isCompressedDesign());
                if (storableObject instanceof DesignPartView && (dpv = (DesignPartView)storableObject).getMainPanel().isVisible()) {
                    dpv.setVisible(true);
                    for (DesignPartView sdpv : dpv.getSubordinateViews()) {
                        sdpv.setVisible(true);
                    }
                }
            }
            finally {
                ApplicationView.loading = loading;
            }
        }
    }

    private static void refreshSystemFiles(Map<Object, List<VersioningTreeNode>> systemFilesNodesMap) {
        VersioningTreeNode.refreshRDBMSSites(systemFilesNodesMap);
        VersioningTreeNode.refreshDefaultTypes(systemFilesNodesMap);
        VersioningTreeNode.refreshDefaultDomains(systemFilesNodesMap);
        VersioningTreeNode.refreshDesignLevelDomains(systemFilesNodesMap);
        VersioningTreeNode.refreshDesignLevelSettings(systemFilesNodesMap);
        VersioningTreeNode.refreshCustomDesignRules(systemFilesNodesMap);
    }

    private static void refreshExtendedMaps(Map systemFilesNodesMap) {
        List systemFilesNodes = (List)systemFilesNodesMap.get(ExtendedMap.class);
        if (systemFilesNodes != null) {
            for (VersioningTreeNode systemFileNode : systemFilesNodes) {
                RelationalDesign rd;
                StorableObjectStatus storableObjectStatus = systemFileNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String id = storableObjectStatus.getStorableObjectID();
                if (id.startsWith("ExtendedMap_RM")) {
                    int ind = id.toUpperCase().indexOf(".XML");
                    if (ind > 0) {
                        id = id.substring(0, ind);
                    }
                    id = id.substring("ExtendedMap_RM".length());
                    rd = (RelationalDesign)design.getRelationalDesigns().getObjectByID(id);
                    if (rd == null || !rd.isLoaded()) continue;
                    rd.getRMExtendedMap().clearMappings();
                    design.getAppView().getXMLTransformationManager().transformFromXMLToObject(rd.getRMExtendedMap(), new File(rd.getRMExtendedMap().getStorageName()), design.isCompressedDesign());
                    continue;
                }
                if (id.startsWith("DeletedMap_RM")) {
                    int ind = id.toUpperCase().indexOf(".XML");
                    if (ind > 0) {
                        id = id.substring(0, ind);
                    }
                    id = id.substring("DeletedMap_RM".length());
                    rd = (RelationalDesign)design.getRelationalDesigns().getObjectByID(id);
                    if (rd == null || !rd.isLoaded()) continue;
                    design.getAppView().getXMLTransformationManager().transformFromXMLToObject(rd.getRMDeletedMap(), new File(rd.getRMDeletedMap().getStorageName()), design.isCompressedDesign());
                    continue;
                }
                ExtendedMap extendedMap = design.getExtendedMap();
                extendedMap.clearMappingsMaps();
                if (design.isOldRepositoryType()) {
                    extendedMap.load();
                    continue;
                }
                design.getAppView().getXMLTransformationManager().transformFromXMLToObject(extendedMap, new File(extendedMap.getStorageName()), design.isCompressedDesign());
            }
        }
    }

    private static void refreshRDBMSSites(Map systemFilesNodesMap) {
        List systemFilesNodes = (List)systemFilesNodesMap.get(RDBMSSite.class);
        if (systemFilesNodes != null) {
            for (VersioningTreeNode systemFileNode : systemFilesNodes) {
                StorableObjectStatus storableObjectStatus = systemFileNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String filePath = storableObjectStatus.getFilePath().getPath();
                XMLPersistenceManager pm = design.getAppView().getPersistenceManager();
                new RXMLRDBMSSiteSet(pm).readNoneDefaultRDBMSSites(filePath, design, design.getRDBMSSiteSet());
            }
        }
    }

    private static void refreshDesignLevelSettings(Map systemFilesNodesMap) {
        List systemFilesNodes = (List)systemFilesNodesMap.get(DesignLevelSettings.class);
        if (systemFilesNodes != null) {
            for (VersioningTreeNode systemFileNode : systemFilesNodes) {
                StorableObjectStatus storableObjectStatus = systemFileNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                if (design == null) continue;
                design.getDesignLevelSettings().loadDesignLevelSettingsFile(design.getStoragePath());
            }
        }
    }

    private static void refreshDefaultTypes(Map systemFilesNodesMap) {
        if (systemFilesNodesMap.get("types.xml") != null) {
            SETTINGS.refreshDefaultTypes();
        }
    }

    private static void refreshDefaultDomains(Map systemFilesNodesMap) {
        if (systemFilesNodesMap.get("defaultdomains.xml") != null) {
            SETTINGS.refreshDefaultDomains();
        }
    }

    private static void refreshDesignLevelDomains(Map systemFilesNodesMap) {
        List systemFilesNodes = (List)systemFilesNodesMap.get(DomainFileWrapper.class);
        if (systemFilesNodes != null) {
            for (VersioningTreeNode systemFileNode : systemFilesNodes) {
                StorableObjectStatus storableObjectStatus = systemFileNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String filePath = storableObjectStatus.getFilePath().getPath();
                ApplicationView appView = design.getAppView();
                if (design.isOldRepositoryType()) {
                    appView.getPersistenceManager().readDomainFile(filePath, design, false);
                    continue;
                }
                appView.getXMLTransformationManager().loadDomainFile(new File(filePath), design);
            }
        }
    }

    private static void refreshCustomDesignRules(Map systemFilesNodesMap) {
        if (systemFilesNodesMap.get("dr_custom_scripts.xml") != null) {
            APPLICATION_VIEW.loadCustomDRScripts();
        }
    }

    private static void removeObjects(List<VersioningTreeNode> nodes, boolean processParents, Map nodesByDesignAndTypeAndStatus, boolean revert) {
        if (nodes != null) {
            for (VersioningTreeNode versioningTreeNode : nodes) {
                VersioningTreeNode.removeObject(versioningTreeNode, processParents, nodesByDesignAndTypeAndStatus, revert);
            }
        }
    }

    private static void removeObject(VersioningTreeNode versioningTreeNode, boolean processParents, Map nodesByDesignAndTypeAndStatus, boolean revert) {
        StorableObject storableObject = versioningTreeNode.getStorableObject();
        if (storableObject != null) {
            if (processParents) {
                VersioningTreeNode.processParent(versioningTreeNode.getStorableObjectStatus().getStorableObjectParentID(), nodesByDesignAndTypeAndStatus, revert);
            }
            if (storableObject instanceof RelationalObjectProxy) {
                String filePath = ((RelationalObjectProxy)storableObject).getSegmentedStorageName();
                ArrayList<String> filePaths = new ArrayList<String>(1);
                filePaths.add(filePath);
                storableObject.getDesign().getAppView().getXMLTransformationManager().deleteFiles(filePaths);
            } else if (storableObject instanceof StorageDesign) {
                StorageDesign storageDesign = (StorageDesign)storableObject;
                storageDesign.delete(false);
            } else if (storableObject instanceof ModelIDObject) {
                ((ModelIDObject)storableObject).remove();
            } else if (storableObject instanceof DesignPartView) {
                DesignPartView designPartView = (DesignPartView)storableObject;
                designPartView.getDesignPart().deleteSubview(designPartView);
            }
        }
    }

    private static void processParent(String parentID, Map<DesignPart, Map> nodesByDesignAndTypeAndStatus, boolean revert) {
        if (parentID != null) {
            VersioningTreeNode parentNode = VersioningTreeNode.searchForParent(parentID, "A", nodesByDesignAndTypeAndStatus);
            if (parentNode != null) {
                if (revert) {
                    VersioningTreeNode.removeObject(parentNode, true, nodesByDesignAndTypeAndStatus, revert);
                } else {
                    VersioningTreeNode.createObject(parentNode, true, nodesByDesignAndTypeAndStatus, revert);
                }
                return;
            }
            parentNode = VersioningTreeNode.searchForParent(parentID, "D", nodesByDesignAndTypeAndStatus);
            if (parentNode != null) {
                if (revert) {
                    VersioningTreeNode.createObject(parentNode, true, nodesByDesignAndTypeAndStatus, revert);
                } else {
                    VersioningTreeNode.removeObject(parentNode, true, nodesByDesignAndTypeAndStatus, revert);
                }
                return;
            }
            parentNode = VersioningTreeNode.searchForParent(parentID, "M", nodesByDesignAndTypeAndStatus);
            if (parentNode != null) {
                VersioningTreeNode.refreshObject(parentNode, true, nodesByDesignAndTypeAndStatus, revert);
                return;
            }
            if (revert && (parentNode = VersioningTreeNode.searchForParent(parentID, "C", nodesByDesignAndTypeAndStatus)) != null) {
                VersioningTreeNode.refreshObject(parentNode, true, nodesByDesignAndTypeAndStatus, revert);
            }
        }
    }

    private static VersioningTreeNode searchForParent(String parentID, String status, Map<DesignPart, Map> nodesByDesignAndTypeAndStatus) {
        for (DesignPart designPart : nodesByDesignAndTypeAndStatus.keySet()) {
            Map nodesByTypeAndStatus = nodesByDesignAndTypeAndStatus.get(designPart);
            for (Object type : nodesByTypeAndStatus.keySet()) {
                Map nodesByStatus = (Map)nodesByTypeAndStatus.get(type);
                List nodes = (List)nodesByStatus.get(status);
                if (nodes == null) continue;
                for (int i = nodes.size() - 1; i >= 0; --i) {
                    VersioningTreeNode node = (VersioningTreeNode)nodes.get(i);
                    StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
                    if (storableObjectStatus == null || !parentID.equals(storableObjectStatus.getStorableObjectID())) continue;
                    nodes.remove(i);
                    if (nodes.isEmpty()) {
                        nodesByStatus.remove(status);
                    }
                    return node;
                }
            }
        }
        return null;
    }

    public void setConflicted(boolean conflicted) {
        this.conflicted = conflicted;
    }

    public boolean isConflicted() {
        return this.conflicted;
    }

    public VersioningTreeNode getDependingOn() {
        return this.dependingOn;
    }

    public void setDependingOn(VersioningTreeNode dependingOn) {
        this.dependingOn = dependingOn;
    }

    public File getDependantFilePath() {
        return this.dependantFilePath;
    }

    public void setDependantFilePath(File dependantFilePath) {
        this.dependantFilePath = dependantFilePath;
    }

    private void propagateConflicted(VersioningTreeNode node) {
        node.setConflicted(true);
        VersioningTreeNode parent = (VersioningTreeNode)node.getParent();
        if (parent != null) {
            this.propagateConflicted(parent);
        }
    }

    private void propagateDependances(VersioningTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            VersioningTreeNode child = (VersioningTreeNode)node.getChildAt(i);
            this.setDependances(child);
            this.propagateDependances(child);
        }
    }

    private void setDependances(VersioningTreeNode node) {
        if (this.objectClass != null && VersioningTreeNode.isMultiModel(this.objectClass) && this.storableObjectStatus != null && !"M".equals(this.storableObjectStatus.getTextStatus())) {
            node.setDependingOn(this);
        } else if (this.objectClass == null && node.getObjectClass() == null) {
            node.setDependingOn(this);
        } else {
            VersioningTreeNode depn = this.getDependingOn();
            if (depn == null && this.storableObjectStatus != null && "D".equals(this.storableObjectStatus.getTextStatus()) && node.getObjectClass() == null) {
                node.setDependingOn(this);
            } else if (depn != null && node.getObjectClass() != null) {
                node.setDependingOn(depn);
            }
        }
    }

    @Override
    public void add(MutableTreeNode newChild) {
        VersioningTreeNode node = (VersioningTreeNode)newChild;
        super.add(newChild);
        if (node.isConflicted()) {
            this.propagateConflicted(this);
        }
        this.setDependances(node);
    }

    private static boolean isMultiModel(Class aClass) {
        return aClass != null && (RelationalDesign.class.isAssignableFrom(aClass) || MultidimensionalDesign.class.isAssignableFrom(aClass) || DataFlowDesign.class.isAssignableFrom(aClass) || TransformationTask.class.isAssignableFrom(aClass) || StorageDesign.class.isAssignableFrom(aClass));
    }

    private static void refreshChangeRequestsList(Design design) {
        File file = new File(design.getStoragePath(), "ChangeRequests.local");
        if (file.exists() && !file.delete()) {
            LOGGER.warn(NOT_ABLE_TO_DELETE_MESSAGE + file.getPath());
        }
        design.synchronizeChangeRequestsMap();
        XML_TRANSFORMATION_MANAGER.openChangeRequestList(design);
    }

    public String getTextStatus() {
        if (this.storableObjectStatus != null) {
            return this.storableObjectStatus.getTextStatus();
        }
        return this.textStatus;
    }

    public void setTextStatus(String textStatus) {
        this.textStatus = textStatus;
    }

    public boolean isRecursuve() {
        return this.recursuve;
    }

    public void setRecursuve(boolean recursuve) {
        this.recursuve = recursuve;
    }

    private static class ProcessModelNodesComparator
    implements Comparator<VersioningTreeNode> {
        private ProcessModelNodesComparator() {
        }

        @Override
        public int compare(VersioningTreeNode node1, VersioningTreeNode node2) {
            return this.calculateWeight(node1) - this.calculateWeight(node2);
        }

        private int calculateWeight(VersioningTreeNode node) {
            Class nodeObjectClass = node.getObjectClass();
            if (nodeObjectClass == null) {
                return -1;
            }
            if (ProcessModel.class.isAssignableFrom(nodeObjectClass)) {
                return 0;
            }
            if (InfoStore.class.isAssignableFrom(nodeObjectClass)) {
                return 1;
            }
            return 2;
        }
    }
}

