/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.DBMEncodedString;
import oracle.dbtools.crest.imports.metadata.DBType;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.thirdparty.db2.DMDB2ConnectionPanel;
import oracle.dbtools.thirdparty.sqlserver.DMSQLServerConnectionPanel;
import oracle.dbtools.thirdparty.udb.DMUDBConnectionPanel;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class OldConnection
extends TreeMap<String, Object>
implements Comparable {
    public static final String PROP_TYPE = "connection_type";
    public static final String PROP_NAME = "connection_name";
    public static final String PROP_HOST = "connection_host";
    public static final String PROP_PORT = "connection_port";
    public static final String PROP_SID = "connection_sid";
    public static final String PROP_SERVICE_NAME = "oracle_basic_service";
    public static final String PROP_USERNAME = "connection_username";
    public static final String PROP_PASSWORD = "connection_password";
    public static final String PROP_URL = "connection_url";
    public static final String PROP_URLBASE = "URLBASE";
    public static final String PROP_SAVEPASSWORD = "connection_save_password";
    public static final String PROP_DRIVERCLASS = "connection_driver_class";
    public static final String PROP_CONNECTIONS_LIST = "PROP_CONNECTIONS_LIST";
    public static final String PROP_OBJECT_ID = "PROP_OBJECT_ID";
    public static final String DEFAULT_NAME = "";
    public static final String DEFAULT_HOST = "localhost";
    public static final String PROP_DB2_DATABASE = "db2_data_source_name";
    public static final String PROP_ORACLE_CONN_TYPE = "oracle_connection_type";
    public static final String PROP_ORACLE_TNS_ALIAS = "oracle_tns_network_alias";
    public static final String PROP_ORACLE_ROLE = "oracle_role";
    public static final String PROP_JDBC_ALIAS = "odbc_data_source_alias";
    private static List dbmConnectionList = new ArrayList();
    private static List odConnectionList = new ArrayList();
    private static List rsConnectionList = new ArrayList();

    public OldConnection() {
        this.put(PROP_TYPE, DBType.TYPE_ORACLE);
        this.put(PROP_NAME, DEFAULT_NAME);
        this.put(PROP_HOST, DEFAULT_HOST);
        this.put(PROP_PORT, DBType.TYPE_ORACLE.getDefaultPort().toString());
        this.put(PROP_SID, DEFAULT_NAME);
        this.put(PROP_SERVICE_NAME, DEFAULT_NAME);
        this.put(PROP_USERNAME, DEFAULT_NAME);
        this.put(PROP_PASSWORD, new DBMEncodedString(new char[0]));
        this.put(PROP_URL, DEFAULT_NAME);
        this.put(PROP_DRIVERCLASS, DBType.TYPE_ORACLE.getDriverClass());
        this.put(PROP_SAVEPASSWORD, Boolean.FALSE);
        this.put(PROP_CONNECTIONS_LIST, null);
        this.put(PROP_OBJECT_ID, new GUID().toString());
    }

    public String getClassPath() {
        return (String)this.get(PROP_DRIVERCLASS);
    }

    public String getHost() {
        String host = (String)this.get(PROP_HOST);
        if (host == null) {
            host = DEFAULT_HOST;
        }
        return host;
    }

    public String getName() {
        return (String)this.get(PROP_NAME);
    }

    public boolean savePassword() {
        Boolean spw = (Boolean)this.get(PROP_SAVEPASSWORD);
        if (spw == null) {
            return false;
        }
        return spw;
    }

    public String getPassword() {
        Object passwordObj = this.get(PROP_PASSWORD);
        String password = DEFAULT_NAME;
        if (passwordObj instanceof DBMEncodedString) {
            password = ((DBMEncodedString)passwordObj).decode();
        } else if (passwordObj instanceof String) {
            password = (String)passwordObj;
        }
        if (password == null) {
            password = DEFAULT_NAME;
        }
        return password;
    }

    public int getPort() {
        Object portObj = this.get(PROP_PORT);
        if (portObj instanceof Number) {
            return ((Number)portObj).intValue();
        }
        if (portObj instanceof String) {
            int portNum;
            String portString = (String)this.get(PROP_PORT);
            try {
                portNum = portString == null ? 0 : Integer.parseInt(portString.trim());
            }
            catch (NumberFormatException e) {
                portNum = 0;
            }
            return portNum;
        }
        return 0;
    }

    public String getJDBCAlias() {
        return (String)this.get(PROP_JDBC_ALIAS);
    }

    public String getSid() {
        return (String)this.get(PROP_SID);
    }

    public String getDatabase() {
        return (String)this.get(PROP_DB2_DATABASE);
    }

    public String getServiceName() {
        return (String)this.get(PROP_SERVICE_NAME);
    }

    public DBType getType() {
        return (DBType)((Object)this.get(PROP_TYPE));
    }

    public String getTypeString() {
        return this.getType() == null ? "UNKNOWN" : this.getType().getFullName();
    }

    public String getUserName() {
        return (String)this.get(PROP_USERNAME);
    }

    public String getUrl() {
        String url = (String)this.get(PROP_URL);
        return url;
    }

    public String getOracleConnType() {
        String url = (String)this.get(PROP_ORACLE_CONN_TYPE);
        return url;
    }

    public String getOracleTNSAlias() {
        String url = (String)this.get(PROP_ORACLE_TNS_ALIAS);
        return url;
    }

    public String getOracleRole() {
        String url = (String)this.get(PROP_ORACLE_ROLE);
        return url;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        return 0;
    }

    public static List<OldConnection> getDBMConnections() {
        return dbmConnectionList;
    }

    public static List<OldConnection> getODConnections() {
        return odConnectionList;
    }

    public static List<OldConnection> getRSConnections() {
        return rsConnectionList;
    }

    public static void importConnections() {
        OldConnection.importConnections(dbmConnectionList);
        OldConnection.importConnections(odConnectionList);
        OldConnection.importConnections(rsConnectionList);
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    private static void importConnections(List list) {
        for (OldConnection oc : list) {
            String name = oc.getName();
            Properties props = new Properties();
            props.setProperty("ConnName", name);
            props.setProperty("user", oc.getUserName());
            if (oc.savePassword()) {
                props.setProperty("password", oc.getPassword());
                props.setProperty("SavePassword", String.valueOf(oc.savePassword()));
            }
            props.setProperty("hostname", oc.getHost());
            props.setProperty("port", String.valueOf(oc.getPort()));
            if (OldConnection.isNotEmpty(oc.getServiceName())) {
                props.setProperty("serviceName", oc.getServiceName());
            }
            if (OldConnection.isNotEmpty(oc.getSid())) {
                props.setProperty("sid", oc.getSid());
            }
            props.setProperty("driver", oc.getClassPath());
            props.setProperty("customUrl", DEFAULT_NAME);
            DBType type = oc.getType();
            if (type == DBType.TYPE_ORACLE) {
                props.setProperty("subtype", "oraJDBC");
                props.setProperty("RaptorConnectionType", "Oracle");
                props.setProperty("oraDriverType", "thin");
                props.setProperty("OracleConnectionType", oc.getOracleConnType());
                if (OldConnection.isNotEmpty(oc.getOracleTNSAlias())) {
                    props.setProperty("customUrl", oc.getOracleTNSAlias());
                }
                if (OldConnection.isNotEmpty(oc.getOracleRole())) {
                    props.setProperty("role", oc.getOracleRole());
                }
            } else if (type == DBType.TYPE_SQL_SERVER_2000 || type == DBType.TYPE_SQL_SERVER_2005) {
                props.setProperty("subtype", DMSQLServerConnectionPanel.SUBTYPE_SQL_SERVER);
                props.setProperty("RaptorConnectionType", "Microsoft SQL Server");
                props.setProperty("customUrl", oc.getUrl());
            } else if (type == DBType.TYPE_DB2) {
                props.setProperty("subtype", DMDB2ConnectionPanel.SUBTYPE_DB2);
                props.setProperty("RaptorConnectionType", DMDB2ConnectionPanel.CONNECTION_TYPE);
                props.setProperty("dataSourceName", oc.getDatabase());
            } else if (type == DBType.TYPE_UDB) {
                props.setProperty("subtype", DMUDBConnectionPanel.SUBTYPE_UDB);
                props.setProperty("RaptorConnectionType", DMUDBConnectionPanel.CONNECTION_TYPE);
                props.setProperty("dataSourceName", oc.getDatabase());
            } else if (type == DBType.TYPE_ODBC) {
                props.setProperty("subtype", "JDBC");
                props.setProperty("RaptorConnectionType", "JDBC");
                if (OldConnection.isNotEmpty(oc.getJDBCAlias())) {
                    props.setProperty("dataSourceName", oc.getJDBCAlias());
                }
                props.setProperty("customUrl", oc.getUrl());
            }
            try {
                DatabaseConnections.getInstance().addConnection(name, props);
            }
            catch (ConnectionException e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

