/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelLogicalPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class ModelLogicalPP
extends AbstractPP {
    private static final long serialVersionUID = 6864529153340657983L;
    private JCheckBox chbSourceOptional;
    private JCheckBox chbTargetOptional;
    private JCheckBox chbFirstUniqueForIdentifyingRelation;
    private JCheckBox chbKeepFKNamesSynchronized;
    private JCheckBox chbPropagatePKAttributeNotes;
    private JCheckBox chbUseSurrgateKey;
    private JCheckBox chbCreateSurrgateKey;

    public ModelLogicalPP() {
        this.setHelpID("MODEL_LOGICAL_PREFS_PANEL");
        this.createRelationCardinality();
        this.createIdentifyingRelationships();
        this.createFKAttributeNameSychronization();
        this.createSurrogateKey();
    }

    public void onEntry(TraversableContext tc) {
        this.chbSourceOptional.setSelected(settings.isSourceOptional());
        this.chbTargetOptional.setSelected(settings.isTargetOptional());
        this.chbFirstUniqueForIdentifyingRelation.setSelected(settings.isUseFirstUniqueForIdentifyingRelation());
        this.chbKeepFKNamesSynchronized.setSelected(settings.isKeepFKNamesSynchronized());
        this.chbCreateSurrgateKey.setSelected(settings.isDefaultCreateSurrogateKey());
        this.chbUseSurrgateKey.setSelected(settings.isDefaultUseSurrogateKey());
        this.chbPropagatePKAttributeNotes.setSelected(settings.isPropagatePKAttrNotes());
    }

    public void onExit(TraversableContext tc) {
        settings.setSourceOptional(this.chbSourceOptional.isSelected());
        settings.setTargetOptional(this.chbTargetOptional.isSelected());
        settings.setUseFirstUniqueForIdentifyingRelation(this.chbFirstUniqueForIdentifyingRelation.isSelected());
        settings.setDefaultCreateSurrogateKey(this.chbCreateSurrgateKey.isSelected());
        settings.setDefaultUseSurrogateKey(this.chbUseSurrgateKey.isSelected());
        settings.setPropagatePKAttrNotes(this.chbPropagatePKAttributeNotes.isSelected());
        ModelLogicalPreferences preferences = this.getModelLogicalPreferences(tc);
        preferences.setSourceOptional(this.chbSourceOptional.isSelected());
        preferences.setTargetOptional(this.chbTargetOptional.isSelected());
        preferences.setUseFirstUniqueForIdentifyingRelation(this.chbFirstUniqueForIdentifyingRelation.isSelected());
        preferences.setCreateSurrogateKey(this.chbCreateSurrgateKey.isSelected());
        preferences.setUseSurrogateKey(this.chbUseSurrgateKey.isSelected());
        preferences.setPropagatePKAttrNotes(this.chbPropagatePKAttributeNotes.isSelected());
        settings.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
        preferences.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
    }

    private void createRelationCardinality() {
        JPanel cardinalityPanel = new JPanel(new GridBagLayout());
        cardinalityPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.RelationCardinality")));
        this.chbSourceOptional = new JCheckBox(Messages.getString("OptionsDialog.SourceOptional"));
        this.addItem(cardinalityPanel, this.chbSourceOptional, 0, 0, 1, 1, 17, 1, 100);
        this.chbTargetOptional = new JCheckBox(Messages.getString("OptionsDialog.TargetOptional"));
        this.addItem(cardinalityPanel, this.chbTargetOptional, 0, 1, 1, 1, 17, 1, 100);
        this.add(cardinalityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private void createSurrogateKey() {
        JPanel surrogateKeyPanel = new JPanel(new GridBagLayout());
        surrogateKeyPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultsSurrogateKey")));
        this.chbCreateSurrgateKey = new JCheckBox(Messages.getString("OptionsDialog.EntityCreateSurrogateKey"));
        this.addItem(surrogateKeyPanel, this.chbCreateSurrgateKey, 0, 0, 1, 1, 17, 1, 100);
        this.chbUseSurrgateKey = new JCheckBox(Messages.getString("OptionsDialog.RelationUseSurrogateKey"));
        this.addItem(surrogateKeyPanel, this.chbUseSurrgateKey, 0, 1, 1, 1, 17, 1, 100);
        this.add(surrogateKeyPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private void createIdentifyingRelationships() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.PKOptionForIdentifyingRelationships")));
        this.chbFirstUniqueForIdentifyingRelation = new JCheckBox(Messages.getString("OptionsDialog.UseAndSetfirstUKAsPK"));
        this.addItem(jpanel, this.chbFirstUniqueForIdentifyingRelation, 0, 0, 1, 1, 17, 1, 100);
        this.add(jpanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private void createFKAttributeNameSychronization() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.FKAttributeSynchronization")));
        this.chbKeepFKNamesSynchronized = new JCheckBox(Messages.getString("OptionsDialog.KeepAsNameOfOriginatingAttribute"));
        this.addItem(jpanel, this.chbKeepFKNamesSynchronized, 0, 0, 1, 1, 17, 1, 100);
        this.chbPropagatePKAttributeNotes = new JCheckBox(Messages.getString("OptionsDialog.PropagateFKAttributeNotes"));
        this.addItem(jpanel, this.chbPropagatePKAttributeNotes, 0, 1, 1, 1, 17, 1, 100);
        this.add(jpanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private ModelLogicalPreferences getModelLogicalPreferences(TraversableContext tc) {
        return ModelLogicalPreferences.getInstance(tc.getPropertyStorage());
    }
}

