/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesReader;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.util.logging.Logger;

public class SubordinateTables
extends SubordinateTablesReader {
    private static final Logger LOGGER = new Logger(SubordinateTables.class);

    public SubordinateTables(Connection connection, List selectedObjects) {
        super(connection, selectedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjectsFromOracleDB() {
        Statement statement = null;
        if (this.tableObjects.size() > 0) {
            try {
                DBObject dboTable;
                String table_name;
                String owner;
                ResultSet rs;
                DBObject dbo;
                int step;
                String sql = "select a.owner,a.table_name from sys.all_constraints a, (select owner,constraint_name from sys.all_constraints where owner = ? and table_name = ? and constraint_type in ('P','U')) b where a.constraint_type = 'R' and a.r_constraint_name = b.constraint_name and a.r_owner = b.owner";
                ArrayList tables = new ArrayList();
                tables.addAll(this.tableObjects);
                statement = this.connection.prepareStatement(sql);
                for (step = 0; step < tables.size(); ++step) {
                    dbo = (DBObject)tables.get(step);
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    rs = null;
                    rs = statement.executeQuery();
                    if (rs == null) continue;
                    while (rs.next()) {
                        owner = rs.getString(1);
                        if (this.hasDBObject(this.tableObjects, owner, table_name = rs.getString(2))) continue;
                        dboTable = new DBObject(true, table_name, "TABLE", owner);
                        this.tableObjects.add(dboTable);
                        this.selectedObjects.add(dboTable);
                    }
                    rs.close();
                }
                sql = "select a.owner,a.table_name from sys.all_constraints a, (select r_owner,r_constraint_name from sys.all_constraints where r_owner = ? and table_name = ? and constraint_type = 'R') b where a.constraint_type in ('P','U') and a.constraint_name = b.r_constraint_name and a.owner = b.r_owner";
                statement = this.connection.prepareStatement(sql);
                for (step = 0; step < tables.size(); ++step) {
                    dbo = (DBObject)tables.get(step);
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    rs = null;
                    rs = statement.executeQuery();
                    if (rs == null) continue;
                    while (rs.next()) {
                        owner = rs.getString(1);
                        if (this.hasDBObject(this.tableObjects, owner, table_name = rs.getString(2))) continue;
                        dboTable = new DBObject(true, table_name, "TABLE", owner);
                        this.tableObjects.add(dboTable);
                        this.selectedObjects.add(dboTable);
                    }
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTables.getAllObjectsFromOracleDB():", e);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("SubordinateTables.getAllObjectsFromOracleDB():", e);
                    }
                }
            }
        }
        return this.selectedObjects;
    }

    public void generateFKs_fromChilds(Connection sqlConnection, List selectedObjects, Design design, RDBMSSite site) {
        if (site.getType().getManufacturerName().equalsIgnoreCase("ORACLE")) {
            this.generateOracleFKs_fromChilds(sqlConnection, selectedObjects, design, site);
        } else {
            this.generateJDBCFKs_fromChilds(sqlConnection, selectedObjects, design, site);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOracleFKs_fromChilds(Connection sqlConnection, List selectedObjects, Design design, RDBMSSite site) {
        ArrayList<DBObject> tableObjects = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObjects) {
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            tableObjects.add(dbo);
        }
        Statement statement = null;
        Statement col_statement = null;
        if (tableObjects.size() > 0) {
            try {
                String sql = "select a.owner,a.table_name, a.constraint_name, a.delete_rule,a.r_constraint_name, a.deferred, a.deferrable from sys.all_constraints a, (select owner,constraint_name from sys.all_constraints where owner = ? and table_name = ? and constraint_type in ('P','U')) b where a.constraint_type = 'R' and a.r_constraint_name = b.constraint_name and a.r_owner = b.owner";
                ArrayList<DBObject> tables = new ArrayList<DBObject>();
                tables.addAll(tableObjects);
                statement = sqlConnection.prepareStatement(sql);
                for (int step = 0; step < tables.size(); ++step) {
                    DBObject dbo = (DBObject)tables.get(step);
                    Table table = this.getTable(dbo.getSchema(), dbo.getName(), design, site);
                    if (table == null) continue;
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    ResultSet rs = null;
                    rs = statement.executeQuery();
                    if (rs == null) continue;
                    while (rs.next()) {
                        Index index;
                        String table_name;
                        String owner = rs.getString(1);
                        Table ch_table = this.getTable(owner, table_name = rs.getString(2), design, site);
                        if (ch_table == null) continue;
                        String constr_name = rs.getString(3);
                        String delete_rule = rs.getString(4);
                        String key_name = rs.getString(5);
                        Index ref_key = table.getIndexByName(key_name);
                        if (ref_key == null || (index = ch_table.getIndexByName(constr_name)) != null) continue;
                        FKIndexAssociation fk = ch_table.addFK(ref_key);
                        fk.setName(constr_name);
                        fk.getLocalFKIndex().setName(constr_name);
                        fk.setDeleteRule(delete_rule);
                        if (col_statement == null) {
                            String col_sql = "select column_name from all_cons_columns where owner = ? and table_name = ? and constraint_name = ? order by position";
                            col_statement = sqlConnection.prepareStatement(col_sql);
                        }
                        col_statement.setString(1, owner);
                        col_statement.setString(2, table_name);
                        col_statement.setString(3, constr_name);
                        ResultSet crs = null;
                        crs = col_statement.executeQuery();
                        if (crs != null) {
                            int k = 0;
                            while (crs.next()) {
                                String colName = crs.getString(1);
                                Column column = (Column)ch_table.getElementByName(colName);
                                Column refCol = null;
                                try {
                                    refCol = (Column)ref_key.getElement(k);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                if (column != null && refCol != null) {
                                    column.addFKAssociation(refCol, fk);
                                    fk.getLocalFKIndex().add(column);
                                }
                                ++k;
                            }
                            crs.close();
                        }
                        fk.resetMandatoryUsingColumns();
                        fk.resetEdgeParams();
                    }
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTables.generateFKs_fromChilds():", e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (col_statement != null) {
                        col_statement.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("SubordinateTables.generateFKs_fromChilds():", e);
                }
            }
        }
    }

    private Table getTable(String schema, String name, Design design, RDBMSSite site) {
        RelationalDesign rd = design.getRelationalDesign();
        if (rd != null) {
            return rd.getTableSet().getBySchemaAndName(schema, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjectsFromJDBC(String dbType) {
        if (this.tableObjects.size() > 0) {
            try {
                DBObject dboTable;
                String owner;
                String fkTable_Name;
                String fkTable_Schema;
                String fkTable_Catalog;
                ResultSet rs;
                DBObject dbo;
                int step;
                DatabaseMetaData dbmd = this.connection.getMetaData();
                ArrayList tables = new ArrayList();
                tables.addAll(this.tableObjects);
                for (step = 0; step < tables.size(); ++step) {
                    dbo = (DBObject)tables.get(step);
                    rs = null;
                    try {
                        rs = this.getExportedKeys(dbmd, dbo.getCatalog(), dbo.getSchema(), dbo.getName());
                    }
                    catch (Exception e) {
                        LOGGER.error("SubordinateTables.getAllObjectsFromJDBC():", e);
                    }
                    if (rs == null) continue;
                    while (rs.next()) {
                        fkTable_Catalog = rs.getString(5);
                        fkTable_Schema = rs.getString(6);
                        fkTable_Name = rs.getString(7);
                        owner = dbo.getSchema();
                        if (fkTable_Schema != null && !"".equals(fkTable_Schema)) {
                            owner = fkTable_Schema;
                        } else if (fkTable_Catalog != null && !"".equals(fkTable_Catalog)) {
                            owner = fkTable_Catalog;
                        }
                        if (this.hasDBObject(this.tableObjects, owner, fkTable_Name)) continue;
                        if ("MICROSOFT".equals(dbType)) {
                            dboTable = new DBObjectSqlServer(true, fkTable_Name, "TABLE", owner);
                            ((DBObjectSqlServer)dboTable).setDb(fkTable_Catalog);
                            dboTable.setCatalog(fkTable_Catalog);
                        } else {
                            dboTable = new DBObject(true, fkTable_Name, "TABLE", owner);
                        }
                        this.tableObjects.add(dboTable);
                        this.selectedObjects.add(dboTable);
                    }
                    rs.close();
                }
                for (step = 0; step < tables.size(); ++step) {
                    dbo = (DBObject)tables.get(step);
                    rs = null;
                    try {
                        rs = this.getImportedKeys(dbmd, dbo.getCatalog(), dbo.getSchema(), dbo.getName());
                    }
                    catch (Exception e) {
                        LOGGER.error("SubordinateTables.getAllObjectsFromJDBC():", e);
                    }
                    if (rs == null) continue;
                    while (rs.next()) {
                        fkTable_Catalog = rs.getString(1);
                        fkTable_Schema = rs.getString(2);
                        fkTable_Name = rs.getString(3);
                        owner = dbo.getSchema();
                        if (fkTable_Schema != null && !"".equals(fkTable_Schema)) {
                            owner = fkTable_Schema;
                        } else if (fkTable_Catalog != null && !"".equals(fkTable_Catalog)) {
                            owner = fkTable_Catalog;
                        }
                        if (this.hasDBObject(this.tableObjects, owner, fkTable_Name)) continue;
                        if ("MICROSOFT".equals(dbType)) {
                            dboTable = new DBObjectSqlServer(true, fkTable_Name, "TABLE", owner);
                            ((DBObjectSqlServer)dboTable).setDb(fkTable_Catalog);
                            dboTable.setCatalog(fkTable_Catalog);
                        } else {
                            dboTable = new DBObject(true, fkTable_Name, "TABLE", owner);
                        }
                        this.tableObjects.add(dboTable);
                        this.selectedObjects.add(dboTable);
                    }
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTables.getAllObjectsFromJDBC():", e);
            }
        }
        return this.selectedObjects;
    }

    protected ResultSet getExportedKeys(DatabaseMetaData dbmd, String catalog, String schema, String tableName) throws Exception {
        return dbmd.getExportedKeys(catalog, schema, tableName);
    }

    protected ResultSet getImportedKeys(DatabaseMetaData dbmd, String catalog, String schema, String tableName) throws Exception {
        return dbmd.getImportedKeys(catalog, schema, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateJDBCFKs_fromChilds(Connection sqlConnection, List selectedObjects, Design design, RDBMSSite site) {
        ArrayList<DBObject> tableObjects = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObjects) {
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            tableObjects.add(dbo);
        }
        if (tableObjects.size() > 0) {
            try {
                DatabaseMetaData dbmd = sqlConnection.getMetaData();
                for (int step = 0; step < tableObjects.size(); ++step) {
                    DBObject dbo = (DBObject)tableObjects.get(step);
                    ResultSet rs = null;
                    try {
                        rs = this.getExportedKeys(dbmd, dbo.getCatalog(), dbo.getSchema(), dbo.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArrayList<FKHelper> fkHelpers = new ArrayList<FKHelper>();
                    Table table = this.getTable(dbo.getSchema(), dbo.getName(), design, site);
                    if (table == null) continue;
                    if (rs != null) {
                        while (rs.next()) {
                            Table ch_table;
                            String pkCOLUMN_NAME = rs.getString(4);
                            String fkTable_Catalog = rs.getString(5);
                            String fkTable_Schema = rs.getString(6);
                            String fkTable_Name = rs.getString(7);
                            String fkCOLUMN_NAME = rs.getString(8);
                            String fkDELETE_RULE = rs.getString(11);
                            String fk_NAME = rs.getString(12);
                            String pk_NAME = rs.getString(13);
                            String owner = dbo.getSchema();
                            if (fkTable_Schema != null && !"".equals(fkTable_Schema)) {
                                owner = fkTable_Schema;
                            } else if (fkTable_Catalog != null && !"".equals(fkTable_Catalog)) {
                                owner = fkTable_Catalog;
                            }
                            if ((ch_table = this.getTable(owner, fkTable_Name, design, site)) == null) continue;
                            FKHelper fkHelper = this.getFKHelperForChildTable(ch_table, fkHelpers, fk_NAME);
                            fkHelper.fk_NAME = fk_NAME;
                            fkHelper.pk_NAME = pk_NAME;
                            fkHelper.pkTable = table;
                            fkHelper.fkDELETE_RULE = fkDELETE_RULE;
                            if (fkCOLUMN_NAME != null) {
                                fkHelper.fkColNames.add(fkCOLUMN_NAME);
                                fkHelper.pkColNames.add(pkCOLUMN_NAME);
                                continue;
                            }
                            System.out.println("Unable to find FK column!");
                        }
                        rs.close();
                    }
                    for (FKHelper next : fkHelpers) {
                        Table pkTable = next.pkTable;
                        Table chTable = next.chTable;
                        Index fkIndex = null;
                        if (chTable != null) {
                            fkIndex = chTable.getIndexByName(next.fk_NAME);
                        }
                        if (pkTable == null || chTable == null || fkIndex != null) continue;
                        Index index = null;
                        index = next.pk_NAME == null ? SHAlterTableOraclev10g.getUniqueIndexForColumnNames(pkTable, next.pkColNames) : pkTable.getIndexByName(next.pk_NAME);
                        FKIndexAssociation fkass = null;
                        Column column = null;
                        if (index != null) {
                            for (int f = 0; f < next.fkColNames.size(); ++f) {
                                String fkName;
                                String fkColumnName;
                                Column fkColumn;
                                String pkColumnName = (String)next.pkColNames.get(f);
                                if (pkColumnName != null && (column = (Column)pkTable.getElementByName(pkColumnName)) == null) {
                                    column = pkTable.createColumn();
                                    column.setName(pkColumnName);
                                    index.add(column);
                                }
                                if ((fkColumn = (Column)chTable.getElementByName(fkColumnName = (String)next.fkColNames.get(f))) == null) {
                                    fkColumn = chTable.createColumn();
                                    fkColumn.setName(fkColumnName);
                                }
                                if ((fkName = next.fk_NAME) != null) {
                                    FKIndexAssociation[] fkis = chTable.getFKAssociations();
                                    for (int j = 0; j < fkis.length; ++j) {
                                        FKIndexAssociation fkia = fkis[j];
                                        if (!fkia.getLocalFKIndex().getName().equalsIgnoreCase(fkName)) continue;
                                        fkass = fkia;
                                        break;
                                    }
                                }
                                if (fkass == null) {
                                    int deleteRule;
                                    fkass = chTable.addFK(index);
                                    if (fkName != null) {
                                        fkass.setName(fkName);
                                        fkass.getLocalFKIndex().setName(fkName);
                                    }
                                    try {
                                        deleteRule = Integer.valueOf(next.fkDELETE_RULE);
                                    }
                                    catch (Exception e) {
                                        deleteRule = 3;
                                    }
                                    switch (deleteRule) {
                                        case 3: {
                                            fkass.setDeleteRule("NO ACTION");
                                            break;
                                        }
                                        case 0: {
                                            fkass.setDeleteRule("CASCADE");
                                            break;
                                        }
                                        case 2: {
                                            fkass.setDeleteRule("SET NULL");
                                            break;
                                        }
                                        case 1: {
                                            fkass.setDeleteRule("RESTRICT");
                                        }
                                    }
                                }
                                fkColumn.addFKAssociation(column, fkass);
                                fkass.getLocalFKIndex().add(fkColumn);
                            }
                        }
                        if (fkass == null) continue;
                        fkass.resetMandatoryUsingColumns();
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTables.generateJDBCFKs_fromChilds():", e);
            }
        }
    }

    private FKHelper getFKHelperForChildTable(Table chTable, List<FKHelper> list, String fkName) {
        for (FKHelper next : list) {
            if (next.chTable != chTable) continue;
            if (fkName != null && !"".equals(fkName)) {
                if (!fkName.equalsIgnoreCase(next.fk_NAME)) continue;
                return next;
            }
            return next;
        }
        FKHelper fkHelper = new FKHelper();
        fkHelper.chTable = chTable;
        list.add(fkHelper);
        return fkHelper;
    }

    private static class FKHelper {
        public List pkColNames = new ArrayList();
        public List fkColNames = new ArrayList();
        public String fkDELETE_RULE = "";
        public String fk_NAME = null;
        public String pk_NAME = null;
        public Table pkTable = null;
        public Table chTable = null;

        private FKHelper() {
        }
    }
}

