/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;

public class RSTelephones
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<BIPhone> list = new ArrayList<BIPhone>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TELEPHONES (Telephone_ID, Telephone_OVID, Telephone_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Phone_Number, Phone_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getPhoneSet().iterator();
        while (it.hasNext()) {
            BIPhone phone2 = (BIPhone)it.next();
            String phoneOVID = RSTelephones.getOrCreateOVID(map, phone2.getObjectID());
            stmt.setString(1, phone2.getObjectID());
            stmt.setString(2, phoneOVID);
            stmt.setString(3, phone2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            stmt.setString(7, phone2.getPhoneNumber());
            stmt.setString(8, phone2.getPhoneType());
            stmt.setString(9, designOVID);
            stmt.addBatch();
            list.add(phone2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (BIPhone phone2 : list) {
                RSComments.export(map, connection, phone2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (BIPhone phone : list) {
                RSComments.export(map, connection, phone);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

