/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.swingui.ApplicationView;

public class RSTSDPPolicies
extends RSGeneral {
    public static void export(ApplicationView appView, Map map, Connection connection) throws Exception {
        String checkQuery = "SELECT COUNT(*) FROM DMRS_TSDP_POLICIES WHERE Object_ID = ? ";
        String insertQuery = "INSERT INTO DMRS_TSDP_POLICIES (Object_OVID, Object_ID, TSDP_Policy_Name) VALUES (?, ?, ?)";
        String updateQuery = "UPDATE DMRS_TSDP_POLICIES SET TSDP_Policy_Name = ? WHERE Object_ID = ?";
        PreparedStatement stmtCheck = connection.prepareStatement(checkQuery);
        PreparedStatement insertStmt = connection.prepareStatement(insertQuery);
        PreparedStatement updateStmt = connection.prepareStatement(updateQuery);
        for (TSDPPolicy p : appView.getTSDPPolicySet()) {
            stmtCheck.setString(1, p.getObjectID());
            ResultSet rsCheck = stmtCheck.executeQuery();
            while (rsCheck.next()) {
                String count = rsCheck.getString(1);
                if (count.equals("0")) {
                    String ovid = RSTSDPPolicies.getOrCreateOVID(map, p.getObjectID());
                    map.put(p.getObjectID(), ovid);
                    insertStmt.setString(1, ovid);
                    insertStmt.setString(2, p.getObjectID());
                    insertStmt.setString(3, p.getName());
                    insertStmt.executeUpdate();
                    continue;
                }
                updateStmt.setString(1, p.getName());
                updateStmt.setString(2, p.getObjectID());
                updateStmt.executeUpdate();
            }
            RSObjectNotes.export(map, connection, p);
            RSComments.export(map, connection, p);
            RSCommentsInRDBMS.export(map, connection, p);
        }
        stmtCheck.close();
        stmtCheck = null;
        insertStmt.close();
        insertStmt = null;
        updateStmt.close();
        updateStmt = null;
    }
}

