/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;

public class RSStructuredTypesAttributes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign model, String modelOVID) throws Exception {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query_attr = "INSERT INTO DMRS_STRUCT_TYPE_ATTRS (Attribute_ID, Attribute_OVID, Attribute_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Mandatory, Reference, T_Size, T_Precision, T_Scale, Type_ID, Type_OVID, Type_Name, Design_OVID, Char_Units, DataType_Kind, Domain_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt_attr = connection.prepareStatement(query_attr);
        Iterator attrs = model.getTypeElementSet().iterator();
        while (attrs.hasNext()) {
            TypeElement attr2 = (TypeElement)attrs.next();
            stmt_attr.setString(1, attr2.getObjectID());
            stmt_attr.setString(2, RSStructuredTypesAttributes.getOrCreateOVID(map, attr2.getObjectID()));
            stmt_attr.setString(3, attr2.getName());
            stmt_attr.setString(4, attr2.getStructuredType().getObjectID());
            stmt_attr.setString(5, (String)map.get(attr2.getStructuredType().getObjectID()));
            stmt_attr.setString(6, attr2.getStructuredType().getName());
            stmt_attr.setString(7, attr2.isMandatory() ? "Y" : "N");
            stmt_attr.setString(8, attr2.isReference() ? "Y" : "N");
            if (attr2.getType() != null) {
                stmt_attr.setString(12, attr2.getType().getObjectID());
                stmt_attr.setString(13, RSStructuredTypesAttributes.getOrCreateOVID(map, attr2.getType().getObjectID()));
                stmt_attr.setString(14, attr2.getType().getName());
            } else {
                stmt_attr.setString(12, null);
                stmt_attr.setString(13, null);
                stmt_attr.setString(14, null);
            }
            stmt_attr.setString(15, designOVID);
            DesignObject dtType = attr2.getType();
            if (dtType == null) {
                stmt_attr.setString(9, null);
                stmt_attr.setString(10, null);
                stmt_attr.setString(11, null);
                stmt_attr.setString(16, null);
                stmt_attr.setString(17, null);
                stmt_attr.setString(18, null);
            } else if (dtType instanceof Domain) {
                stmt_attr.setInt(9, RSStructuredTypesAttributes.getIntValue(attr2.getDomain().getSize()));
                stmt_attr.setInt(10, RSStructuredTypesAttributes.getIntValue(attr2.getDomain().getPrecision()));
                stmt_attr.setInt(11, RSStructuredTypesAttributes.getIntValue(attr2.getDomain().getScale()));
                stmt_attr.setString(16, attr2.getDomain().getUnits());
                stmt_attr.setString(17, "Domain");
                stmt_attr.setString(18, attr2.getDomain().getName());
            } else if (dtType instanceof LogicalDatatype) {
                stmt_attr.setString(9, attr2.getSize());
                stmt_attr.setInt(10, attr2.getPrecision());
                stmt_attr.setInt(11, attr2.getScale());
                stmt_attr.setString(16, attr2.getUnits());
                stmt_attr.setString(17, "Logical Type");
                stmt_attr.setString(18, null);
            } else if (dtType instanceof DistinctType) {
                DistinctType dt = (DistinctType)dtType;
                stmt_attr.setInt(9, RSStructuredTypesAttributes.getIntValue(dt.getSize()));
                stmt_attr.setInt(10, dt.getPrecision());
                stmt_attr.setInt(11, dt.getScale());
                stmt_attr.setString(16, null);
                stmt_attr.setString(17, "Distinct Type");
                stmt_attr.setString(18, null);
            } else if (dtType instanceof StructuredType) {
                stmt_attr.setString(9, null);
                stmt_attr.setString(10, null);
                stmt_attr.setString(11, null);
                stmt_attr.setString(16, null);
                stmt_attr.setString(17, "Structured Type");
                stmt_attr.setString(18, null);
            } else if (dtType instanceof CollectionType) {
                stmt_attr.setString(9, null);
                stmt_attr.setString(10, null);
                stmt_attr.setString(11, null);
                stmt_attr.setString(16, null);
                stmt_attr.setString(17, "Collection Type");
                stmt_attr.setString(18, null);
            }
            stmt_attr.addBatch();
            list.add(attr2);
            if (++count != 1000) continue;
            count = 0;
            stmt_attr.executeBatch();
            for (TypeElement attr2 : list) {
                RSObjectNotes.export(map, connection, attr2);
                RSComments.export(map, connection, attr2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt_attr.executeBatch();
            for (TypeElement attr : list) {
                RSObjectNotes.export(map, connection, attr);
                RSComments.export(map, connection, attr);
            }
            list.clear();
        }
        stmt_attr.close();
        stmt_attr = null;
    }
}

