/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.util.GUID;

public class RSStructuredTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign model, String modelOVID) throws Exception {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query = "INSERT INTO DMRS_STRUCTURED_TYPES (Design_ID, Design_OVID, Design_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Super_Type_ID, Super_Type_OVID, Super_Type_Name, Predefined, ST_Final, ST_Instantiable, Model_OVID, Model_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType type2 = (StructuredType)it.next();
            String ovid = new GUID().toString();
            map.put(type2.getObjectID(), ovid);
            stmt.setString(1, design.getObjectID());
            stmt.setString(2, designOVID);
            stmt.setString(3, design.getName());
            stmt.setString(4, type2.getObjectID());
            stmt.setString(5, ovid);
            stmt.setString(6, type2.getName());
            if (type2.getParentType() != null) {
                stmt.setString(7, type2.getParentType().getObjectID());
                stmt.setString(8, (String)map.get(type2.getParentType().getObjectID()));
                stmt.setString(9, type2.getParentType().getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            stmt.setString(10, type2.isPredefined() ? "Y" : "N");
            stmt.setString(11, type2.isFinal() ? "Y" : "N");
            stmt.setString(12, type2.isInstantiable() ? "Y" : "N");
            stmt.setString(13, modelOVID);
            stmt.setString(14, type2.getDesignPart().getName());
            stmt.addBatch();
            list.add(type2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (StructuredType type2 : list) {
                RSObjectNotes.export(map, connection, type2);
                RSComments.export(map, connection, type2);
                RSDynamicProperties.export(design, map, connection, type2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (StructuredType type : list) {
                RSObjectNotes.export(map, connection, type);
                RSComments.export(map, connection, type);
                RSDynamicProperties.export(design, map, connection, type);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

