/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;

public class RSHierarchies
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>(1000);
        int count = 0;
        ArrayList<Hierarchy> hierarchiesCollection = new ArrayList<Hierarchy>();
        String query = "INSERT INTO DMRS_HIERARCHIES (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Model_ID, Model_Name, Model_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Default_Hierarchy, Is_Ragged_Hierarchy, Is_Value_Based_Hierarchy, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (MultidimensionalDesign model : design.getMultidimensionalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            hierarchiesCollection.clear();
            Iterator it = model.getHierarchySet().iterator();
            while (it.hasNext()) {
                Hierarchy hier2 = (Hierarchy)it.next();
                String hierOVID = RSHierarchies.getOrCreateOVID(map, hier2.getObjectID());
                hierarchiesCollection.add(hier2);
                Dimension dim = hier2.getDimension();
                stmt.setString(1, hier2.getObjectID());
                stmt.setString(2, hier2.getName());
                stmt.setString(3, hierOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (dim != null) {
                    stmt.setString(7, dim.getObjectID());
                    stmt.setString(8, dim.getName());
                    stmt.setString(9, RSHierarchies.getOrCreateOVID(map, dim.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                stmt.setString(10, hier2.getOracleLongName());
                stmt.setString(11, hier2.getOraclePluralName());
                stmt.setString(12, hier2.getOracleShortName());
                stmt.setString(13, hier2.isDefaultHierarchy() ? "Y" : "N");
                stmt.setString(14, hier2.isRaggedHierarchy() ? "Y" : "N");
                stmt.setString(15, hier2.isValueBasedHierarchy() ? "Y" : "N");
                stmt.setString(16, hier2.getDescription());
                stmt.setString(17, designOVID);
                stmt.addBatch();
                list.add(hier2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Hierarchy hier2 : list) {
                    RSObjectNotes.export(map, connection, hier2);
                    RSComments.export(map, connection, hier2);
                    RSDynamicProperties.export(design, map, connection, hier2);
                }
                list.clear();
            }
            RSHierarchies.exportLevels(map, connection, hierarchiesCollection, designOVID);
            RSHierarchies.exportRollupLinks(map, connection, hierarchiesCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Hierarchy hier : list) {
                RSObjectNotes.export(map, connection, hier);
                RSComments.export(map, connection, hier);
                RSDynamicProperties.export(design, map, connection, hier);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportLevels(Map map, Connection connection, List hierarchies, String designOVID) throws Exception {
        int count = 0;
        String levelQuery = "INSERT INTO DMRS_HIERARCHY_LEVELS (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement levelStmt = connection.prepareStatement(levelQuery);
        for (Hierarchy hier : hierarchies) {
            for (Level level : hier.getLevels()) {
                String levelOVID = RSHierarchies.getOrCreateOVID(map, level.getObjectID());
                levelStmt.setString(1, hier.getObjectID());
                levelStmt.setString(2, hier.getName());
                levelStmt.setString(3, (String)map.get(hier.getObjectID()));
                levelStmt.setString(4, level.getObjectID());
                levelStmt.setString(5, level.getName());
                levelStmt.setString(6, levelOVID);
                levelStmt.setString(7, designOVID);
                levelStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                levelStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            levelStmt.executeBatch();
        }
        levelStmt.close();
        levelStmt = null;
    }

    private static void exportRollupLinks(Map map, Connection connection, List hierarchies, String designOVID) throws Exception {
        int count = 0;
        String linkQuery = "INSERT INTO DMRS_HIERARCHY_ROLLUP_LINKS (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement linkStmt = connection.prepareStatement(linkQuery);
        for (Hierarchy hier : hierarchies) {
            for (RollupLink link : hier.getLinks()) {
                String linkOVID = RSHierarchies.getOrCreateOVID(map, link.getObjectID());
                linkStmt.setString(1, hier.getObjectID());
                linkStmt.setString(2, hier.getName());
                linkStmt.setString(3, (String)map.get(hier.getObjectID()));
                linkStmt.setString(4, link.getObjectID());
                linkStmt.setString(5, link.getName());
                linkStmt.setString(6, linkOVID);
                linkStmt.setString(7, designOVID);
                linkStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                linkStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            linkStmt.executeBatch();
        }
        linkStmt.close();
        linkStmt = null;
    }
}

