/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;

public class RSDynamicProperties
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, ModelIDObject modelIDObject) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_DYNAMIC_PROPERTIES (Design_OVID, Object_ID, Object_OVID, Object_Name, Object_Type, Name, Value) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = modelIDObject.getPropertyNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = modelIDObject.getProperty(name);
            stmt.setString(1, (String)map.get(design.getObjectID()));
            stmt.setString(2, modelIDObject.getObjectID());
            stmt.setString(3, (String)map.get(modelIDObject.getObjectID()));
            stmt.setString(4, modelIDObject.getName());
            stmt.setString(5, modelIDObject.getObjectTypeName());
            stmt.setString(6, name);
            stmt.setString(7, value);
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

