/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.util.GUID;

public class RSCollectionTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign model, String modelOVID) throws Exception {
        ArrayList<CollectionType> list = new ArrayList<CollectionType>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getDesign().getObjectID());
        String query = "INSERT INTO DMRS_COLLECTION_TYPES (Design_ID, Design_OVID, Design_Name, Collection_Type_ID, Collection_Type_OVID, Collection_Type_Name, C_Type, DataType_ID, DataType_OVID, DataType_Name, DT_Type, DT_Ref, Max_Element, Predefined,Char_Units, T_Size, T_Precision, T_Scale, DataType_Kind, Domain_Name, Model_OVID, model_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType type2 = (CollectionType)it.next();
            String ovid = new GUID().toString();
            map.put(type2.getObjectID(), ovid);
            stmt.setString(1, design.getObjectID());
            stmt.setString(2, designOVID);
            stmt.setString(3, design.getName());
            stmt.setString(4, type2.getObjectID());
            stmt.setString(5, ovid);
            stmt.setString(6, type2.getName());
            stmt.setString(7, type2.getType());
            if (type2.getDataType() != null) {
                stmt.setString(8, type2.getDataType().getObjectID());
                stmt.setString(9, (String)map.get(type2.getDataType().getObjectID()));
                stmt.setString(10, type2.getDataType().getName());
                stmt.setString(11, type2.getDataType().getObjectTypeName());
            } else {
                stmt.setString(8, null);
                stmt.setString(9, null);
                stmt.setString(10, null);
                stmt.setString(11, null);
            }
            stmt.setString(12, type2.getElementType().isReference() ? "Y" : "N");
            stmt.setInt(13, type2.getMaxElement());
            stmt.setString(14, type2.isPredefined() ? "Y" : "N");
            DesignObject dtType = type2.getDataType();
            if (dtType == null) {
                stmt.setString(15, null);
                stmt.setString(16, null);
                stmt.setString(17, null);
                stmt.setString(18, null);
                stmt.setString(19, null);
                stmt.setString(20, null);
            } else if (dtType instanceof Domain) {
                Domain dom = (Domain)dtType;
                stmt.setString(15, dom.getUnits());
                stmt.setInt(16, RSCollectionTypes.getIntValue(dom.getSize()));
                stmt.setInt(17, RSCollectionTypes.getIntValue(dom.getPrecision()));
                stmt.setInt(18, RSCollectionTypes.getIntValue(dom.getScale()));
                stmt.setString(19, "Domain");
                stmt.setString(20, dom.getName());
            } else if (dtType instanceof LogicalDatatype) {
                TypeElement elType = type2.getElementType();
                stmt.setString(15, elType.getUnits());
                stmt.setString(16, elType.getSize());
                stmt.setInt(17, elType.getPrecision());
                stmt.setInt(18, elType.getScale());
                stmt.setString(19, "Logical Type");
                stmt.setString(20, null);
            } else if (dtType instanceof DistinctType) {
                stmt.setString(15, null);
                stmt.setString(16, null);
                stmt.setString(17, null);
                stmt.setString(18, null);
                stmt.setString(19, "Distinct Type");
                stmt.setString(20, null);
            } else if (dtType instanceof StructuredType) {
                stmt.setString(15, null);
                stmt.setString(16, null);
                stmt.setString(17, null);
                stmt.setString(18, null);
                stmt.setString(19, "Structured Type");
                stmt.setString(20, null);
            } else if (dtType instanceof CollectionType) {
                stmt.setString(15, null);
                stmt.setString(16, null);
                stmt.setString(17, null);
                stmt.setString(18, null);
                stmt.setString(19, "Collection Type");
                stmt.setString(20, null);
            }
            stmt.setString(21, modelOVID);
            stmt.setString(22, type2.getDesignPart().getName());
            stmt.addBatch();
            list.add(type2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (CollectionType type2 : list) {
                RSObjectNotes.export(map, connection, type2);
                RSComments.export(map, connection, type2);
                RSDynamicProperties.export(design, map, connection, type2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (CollectionType type : list) {
                RSObjectNotes.export(map, connection, type);
                RSComments.export(map, connection, type);
                RSDynamicProperties.export(design, map, connection, type);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

