/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;

public class RSChangeRequests
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<ChangeRequest> list = new ArrayList<ChangeRequest>(1000);
        int count = 0;
        ArrayList<ChangeRequest> crCollection = new ArrayList<ChangeRequest>();
        String query = "INSERT INTO DMRS_CHANGE_REQUESTS (Design_ID, Design_OVID, Design_Name, Change_Request_ID, Change_Request_OVID, Change_Request_Name, Request_Status, Request_Date_String, Completion_Date_String, Is_Completed, Reason) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String designOVID = (String)map.get(design.getObjectID());
        Iterator it = design.getChangeRequestSet().iterator();
        while (it.hasNext()) {
            ChangeRequest req2 = (ChangeRequest)it.next();
            String reqOVID = RSChangeRequests.getOrCreateOVID(map, req2.getObjectID());
            crCollection.add(req2);
            stmt.setString(1, design.getObjectID());
            stmt.setString(2, designOVID);
            stmt.setString(3, design.getName());
            stmt.setString(4, req2.getObjectID());
            stmt.setString(5, reqOVID);
            stmt.setString(6, req2.getName());
            stmt.setString(7, req2.getStatus());
            stmt.setString(8, req2.getRequestDate());
            stmt.setString(9, req2.getCompletionDate());
            stmt.setString(10, req2.isCompleted() ? "Y" : "N");
            stmt.setString(11, req2.getReason());
            stmt.addBatch();
            list.add(req2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (ChangeRequest req2 : list) {
                RSObjectNotes.export(map, connection, req2);
                RSComments.export(map, connection, req2);
                RSChangeRequests.exportImplementationNote(map, connection, req2);
            }
            list.clear();
        }
        RSChangeRequests.exportElements(map, connection, crCollection, designOVID);
        if (count > 0) {
            stmt.executeBatch();
            for (ChangeRequest req : list) {
                RSObjectNotes.export(map, connection, req);
                RSComments.export(map, connection, req);
                RSChangeRequests.exportImplementationNote(map, connection, req);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportImplementationNote(Map map, Connection connection, ChangeRequest req) throws Exception {
        String text = req.getImplDescription().trim();
        if (text != null && !"".equalsIgnoreCase(text)) {
            String textQuery = "INSERT INTO DMRS_Large_Text (Object_ID, OVID, Object_Name, Type, Text, Design_OVID) VALUES (?, ?, ?, ?, ?, ?)";
            PreparedStatement textStmt = connection.prepareStatement(textQuery);
            textStmt.setString(1, req.getObjectID());
            textStmt.setString(2, (String)map.get(req.getObjectID()));
            textStmt.setString(3, req.getName());
            textStmt.setString(4, "Implementation Note");
            textStmt.setCharacterStream(5, (Reader)new StringReader(text), text.length());
            textStmt.setString(6, (String)map.get(req.getDesign().getObjectID()));
            textStmt.executeUpdate();
            textStmt.close();
            textStmt = null;
        }
    }

    private static void exportElements(Map map, Connection connection, List changeRequests, String designOVID) throws Exception {
        int count1 = 0;
        String elemQuery = "INSERT INTO DMRS_CHANGE_REQUEST_ELEMENTS (Change_Request_ID, Change_Request_OVID, Change_Request_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID, Element_Model_Name ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement elemStmt = connection.prepareStatement(elemQuery);
        for (ChangeRequest req : changeRequests) {
            for (DesignObject elem : req.getObjects()) {
                String elemOVID = RSChangeRequests.getOrCreateOVID(map, elem.getObjectID());
                elemStmt.setString(1, req.getObjectID());
                elemStmt.setString(2, (String)map.get(req.getObjectID()));
                elemStmt.setString(3, req.getName());
                elemStmt.setString(4, elem.getObjectID());
                elemStmt.setString(5, elemOVID);
                elemStmt.setString(6, elem.getName());
                elemStmt.setString(7, elem.getObjectTypeName());
                elemStmt.setString(8, designOVID);
                elemStmt.setString(9, elem.getDesignPart().getName());
                elemStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                elemStmt.executeBatch();
            }
        }
        if (count1 > 0) {
            count1 = 0;
            elemStmt.executeBatch();
        }
        elemStmt.close();
        elemStmt = null;
    }
}

