/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StoredProcedureUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStoredProcedureUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StoredProcedureUDBv81 proc = (StoredProcedureUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, proc);
        this.appendCreate(buffer, proc);
        this.appendBody(buffer, proc, prettyPrint);
        SSBStoredProcedureUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureUDBv81.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateProc();
        if (proc.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, proc, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, StoredProcedureUDBv81 proc, boolean prettyPrint) {
        SSBStoredProcedureUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, "PROCEDURE");
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getLongNameDDL()));
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, "IS");
        SSBStoredProcedureUDBv81.appendString(buffer, '\'');
        SSBStoredProcedureUDBv81.appendString(buffer, proc.getCommentInRDBMS());
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, '\'');
        SSBStoredProcedureUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureUDBv81.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreate(StringBuffer buffer, StoredProcedureUDBv81 proc) {
        this.appendCreate(buffer);
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, "PROCEDURE");
        if (proc.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBStoredProcedureUDBv81.appendString(buffer, this.storageDesign.getFormatedName(proc.getSchema().getName()));
            SSBStoredProcedureUDBv81.appendString(buffer, ".");
        }
        SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getName()));
    }

    private void appendBody(StringBuffer buffer, StoredProcedureUDBv81 proc, boolean prettyPrint) {
        SSBStoredProcedureUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (proc.getBody() != null && !proc.getBody().trim().equalsIgnoreCase("")) {
            SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, proc.getBody());
        } else {
            SSBStoredProcedureUDBv81.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StoredProcedureUDBv81 && ((StoredProcedureUDBv81)object).isMarkedGenerate();
    }
}

