/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDBPartitionGroupUDBv81
extends AbstractSSBUDB {
    public static final String DBPARTITIONNUMS = "DBPARTITIONNUMS";
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DBPartitionGroupUDBv81 && ((DBPartitionGroupUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DBPartitionGroupUDBv81 group = (DBPartitionGroupUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, group);
        this.appendCreate(buffer, group);
        this.appendNodes(buffer, group, prettyPrint);
        SSBDBPartitionGroupUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBDBPartitionGroupUDBv81.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateDbPartitionGroup();
        if (group.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, group, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, DBPartitionGroupUDBv81 group, boolean prettyPrint) {
        String commentOn = group.getCommentInRDBMS().trim();
        if (!"".equalsIgnoreCase(commentOn)) {
            SSBDBPartitionGroupUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "DATABASE PARTITION GROUP");
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(group.getLongNameDDL()));
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "IS");
            SSBDBPartitionGroupUDBv81.appendString(buffer, '\'');
            SSBDBPartitionGroupUDBv81.appendString(buffer, commentOn);
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, '\'');
            SSBDBPartitionGroupUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBDBPartitionGroupUDBv81.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendCreate(StringBuffer buffer, DBPartitionGroupUDBv81 group) {
        this.appendCreate(buffer);
        SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "DATABASE");
        SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "PARTITION");
        SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "GROUP");
        SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(group.getName()));
    }

    protected void appendNodes(StringBuffer buffer, DBPartitionGroupUDBv81 group, boolean prettyPrint) {
        SSBDBPartitionGroupUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (group.getScope().equalsIgnoreCase("ON ALL DBPARTITIONNUMS")) {
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "ON ALL DBPARTITIONNUMS");
        } else {
            String nn = group.getNodeNumbers().trim();
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "ON");
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, DBPARTITIONNUMS);
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, '(');
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, nn);
            SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, ')');
            if ("".equalsIgnoreCase(nn)) {
                SSBDBPartitionGroupUDBv81.appendNewLine(buffer, true, 0);
                SSBDBPartitionGroupUDBv81.appendStringWithSpace(buffer, "--  ERROR: No partition numbers are defined!");
                SSBDBPartitionGroupUDBv81.appendNewLine(buffer, true, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }
}

