/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.InstanceUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBInstanceUDBv71
extends AbstractSSBUDB {
    public static final String AUTHENTICATION_TYPE = "-a";
    public static final String PORT_NAME = "-p";
    public static final String TYPE = "-s";
    public static final String WORD_WIDTH = "-w";
    public static final String FENCED_ID = "-u";
    public static final String USER_NAME = "-u";
    public static final String PROFILE_PATH = "-p";
    public static final String CLUSTER_NAME = "-c";
    public static final String HOST_NAME = "-h";
    public static final String PORT_RANGE = "-r";
    public static final String CREATE_INSTANCE = "DB2ICRT";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof InstanceUDBv71 && ((InstanceUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        InstanceUDBv71 instance = (InstanceUDBv71)object;
        this.storageDesign = instance.getStorageDesign();
        if (instance.getOperatingSystem().equalsIgnoreCase("Windows Based")) {
            this.appendForWindowsBasedSystems(buffer, instance, prettyPrint);
        }
        if (instance.getOperatingSystem().equalsIgnoreCase("OS/2 Based")) {
            this.appendForWindowsBasedSystems(buffer, instance, prettyPrint);
        }
        if (instance.getOperatingSystem().equalsIgnoreCase("Unix Based")) {
            this.appendForUnixBasedSystems(buffer, instance, prettyPrint);
        }
    }

    protected void appendForWindowsBasedSystems(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        SSBInstanceUDBv71.appendStringWithSpace(buffer, CREATE_INSTANCE);
        this.appendType(buffer, instance, prettyPrint);
        this.appendUserName(buffer, instance, prettyPrint);
        this.appendProfilePath(buffer, instance, prettyPrint);
        this.appendClusterName(buffer, instance, prettyPrint);
        this.appendHostName(buffer, instance, prettyPrint);
        this.appendPortRange(buffer, instance, prettyPrint);
        SSBInstanceUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instance.getName()));
        SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBInstanceUDBv71.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateInstance();
    }

    protected void appendForUnixBasedSystems(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        SSBInstanceUDBv71.appendStringWithSpace(buffer, CREATE_INSTANCE);
        this.appendAuthenticationType(buffer, instance, prettyPrint);
        this.appendPortName(buffer, instance, prettyPrint);
        this.appendType(buffer, instance, prettyPrint);
        this.appendWordWidth(buffer, instance, prettyPrint);
        this.appendFencedId(buffer, instance, prettyPrint);
        SSBInstanceUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instance.getName()));
        SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBInstanceUDBv71.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendAuthenticationType(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getAuthenticationType().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendStringWithSpace(buffer, AUTHENTICATION_TYPE);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getAuthenticationType());
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendPortName(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getPortName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendStringWithSpace(buffer, "-p");
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getPortName());
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendType(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getType().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, TYPE);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getType());
        }
    }

    protected void appendWordWidth(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (instance.getWordWidth() > 0) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, WORD_WIDTH);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getWordWidth());
        }
    }

    protected void appendFencedId(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getFencedId().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, "-u");
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getFencedId());
        }
    }

    protected void appendUserName(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getUserName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, "-u");
            SSBInstanceUDBv71.appendString(buffer, instance.getUserName());
            this.appendComma(buffer);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getPassword());
        }
    }

    protected void appendProfilePath(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getProfilePath().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, "-p");
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getProfilePath());
        }
    }

    protected void appendClusterName(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getClusterName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, CLUSTER_NAME);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getClusterName());
        }
    }

    protected void appendHostName(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getHostName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, HOST_NAME);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getHostName());
        }
    }

    protected void appendPortRange(StringBuffer buffer, InstanceUDBv71 instance, boolean prettyPrint) {
        if (!instance.getPortRange().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, PORT_RANGE);
            SSBInstanceUDBv71.appendStringWithSpace(buffer, instance.getPortRange());
        }
    }
}

