/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBAutoIncrementColumnUDB
extends AbstractSSBUDB {
    private static final int MAX_OBJECT_LENGTH = 30;
    private static final String TRIGGER_SUFFIX = "TRG";
    private static final String SEQUENCE_SUFFIX = "SEQ";
    private StorageDesignUDBv81 storageDesign;
    private static Set genSequenceSet = new HashSet();

    public SSBAutoIncrementColumnUDB(StorageDesignUDBv81 storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return (object instanceof TableProxyUDB || object instanceof Table) && this.storageDesign instanceof StorageDesignUDBv81;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof TableProxyUDB && ((TableProxyUDB)object).isMarkedGenerate() || object instanceof Table && ((Table)object).isMarkedGenerate()) {
            Table table = object instanceof Table ? (Table)object : (Table)((TableProxyUDB)object).getObject();
            for (Column column : table.getElementsAndNestedElementsCollection()) {
                if (!column.isAutoIncrementColumn() && !column.isIdentityColumn() && !column.isComputed().booleanValue()) continue;
                this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint);
            }
        }
    }

    public static void clearGenSequenceSet() {
        genSequenceSet.clear();
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint) {
        this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint, boolean tableCreated) {
        ColumnProxyUDB columnProxy = null;
        if (!(this.storageDesign instanceof StorageDesignUDBv81)) return;
        columnProxy = (ColumnProxyUDB)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (columnProxy == null) return;
        String autoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
        if (autoIncDDL.equalsIgnoreCase("NONE")) {
            return;
        }
        if (autoIncDDL.equalsIgnoreCase("TRIGGER")) {
            if (!tableCreated) {
                return;
            }
        } else {
            String dt;
            if (!autoIncDDL.equalsIgnoreCase("IDENTITY_CLAUSE")) return;
            if (!tableCreated) {
                return;
            }
            if (column.isIdentityColumn() && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase().indexOf("CHAR") <= -1) {
                return;
            }
        }
        String sequenceName = "";
        String triggerExpr = columnProxy.getGenerationExpression().trim();
        if ("".equals(triggerExpr)) {
            sequenceName = this.generateSequenceName(buffer, column, prettyPrint);
        }
        if (!column.isAutoIncrementGenerateTrigger()) return;
        TriggerUDB existingTrigger = null;
        String triggerName = column.getAutoIncrementTriggerName();
        if (StringUtilities.isNotEmpty(triggerName)) {
            TableProxyUDB tableProxy;
            int indexOfDot = triggerName.indexOf(46);
            if (indexOfDot > -1) {
                triggerName = triggerName.substring(indexOfDot + 1);
            }
            if ((tableProxy = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(column.getTable().getObjectID())) != null) {
                for (TriggerUDB tableTrigger : tableProxy.getTriggers()) {
                    if (!tableTrigger.getName().equalsIgnoreCase(triggerName)) continue;
                    existingTrigger = tableTrigger;
                    break;
                }
            }
        }
        if (existingTrigger != null) return;
        Settings settings = column.getDesign().getAppView().getSettings();
        triggerName = this.generateAutoIncrementObjectName(triggerName, settings.getDefaultUDBTriggerName(), TRIGGER_SUFFIX, column);
        if (!"".equals(sequenceName)) {
            this.appendAutoIncrementTrigger(triggerName, sequenceName, column, buffer, prettyPrint);
            return;
        } else {
            if ("".equals(triggerExpr)) return;
            this.appendAutoIncrementTriggerExpr(triggerName, triggerExpr, column, buffer, prettyPrint);
        }
    }

    public String generateSequenceName(StringBuffer buffer, Column column, boolean prettyPrint) {
        Settings settings = column.getDesign().getAppView().getSettings();
        String sequenceName = column.getAutoIncrementSequenceName();
        if (sequenceName != null) {
            sequenceName = sequenceName.trim();
        }
        String seqLongName = this.generateAutoIncrementObjectName(sequenceName, settings.getDefaultUDBSequenceName(), SEQUENCE_SUFFIX, column);
        SequenceUDB sequence = null;
        String userName = "";
        int dotIndex = seqLongName.indexOf(46);
        if (dotIndex == -1) {
            sequenceName = seqLongName;
        } else {
            sequenceName = seqLongName.substring(dotIndex + 1);
            userName = seqLongName.substring(0, dotIndex);
            sequence = this.storageDesign.getSequenceSet().getBySchemaAndName(userName, sequenceName);
        }
        if (sequence == null) {
            sequence = (SequenceUDB)this.storageDesign.getSequenceSet().getByName(sequenceName);
        }
        if (sequence != null) {
            return this.storageDesign.getFormatedLongNameDDL(sequence);
        }
        if (buffer != null && !genSequenceSet.contains(seqLongName)) {
            this.appendAutoIncrementSequence(seqLongName, column, buffer, prettyPrint);
            genSequenceSet.add(seqLongName);
        }
        return this.storageDesign.getFormatedName(seqLongName);
    }

    private String generateAutoIncrementObjectName(String objectName, String objectNameTemplate, String suffix, Column column) {
        Object result;
        String schema = null;
        if (StringUtilities.isNotEmpty(objectName)) {
            int dotIndex = objectName.indexOf(46);
            if (dotIndex > -1) {
                schema = objectName.substring(0, dotIndex);
                result = objectName.substring(dotIndex + 1);
            } else {
                result = objectName;
            }
        } else {
            String columnAbbr;
            String columnName;
            String tableName;
            Table table = (Table)column.getParent();
            ColumnProxyUDB columnProxy = (ColumnProxyUDB)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
            TableProxyUDB tableProxy = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            if (tableProxy == null || columnProxy == null) {
                tableName = table.getName();
                columnName = column.getShortName();
                schema = table.getSchema();
            } else {
                tableName = tableProxy.getName();
                columnName = column.getParentObject() != null ? column.getShortName() : columnProxy.getName();
                String tableLongName = tableProxy.getLongName();
                int userNameLength = tableLongName.length() - tableName.length() - 1;
                schema = userNameLength > 0 ? tableLongName.substring(0, userNameLength) : "";
            }
            String tableAbbr = table.getAbbreviation();
            if (StringUtilities.isEmpty(tableAbbr)) {
                tableAbbr = tableName;
            }
            if (StringUtilities.isEmpty(columnAbbr = column.getAbbreviation())) {
                columnAbbr = columnName;
            }
            if (StringUtilities.isNotEmpty(objectNameTemplate)) {
                tableName = tableName.replaceAll("\\$", "\\\\\\$");
                tableAbbr = tableAbbr.replaceAll("\\$", "\\\\\\$");
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                columnAbbr = columnAbbr.replaceAll("\\$", "\\\\\\$");
                result = objectNameTemplate.replaceAll("\\{table\\}", tableName).replaceAll("\\{table abbr\\}", tableAbbr).replaceAll("\\{column\\}", columnName).replaceAll("\\{column abbr\\}", columnAbbr);
                result = ((String)result).replaceAll("\\\\\\$", "\\$");
            } else {
                result = tableAbbr + "_" + columnAbbr;
                if (((String)result).length() + suffix.length() + 1 <= 30) {
                    result = (String)result + "_" + suffix;
                }
            }
        }
        result = this.getStringWithMaxLength((String)result, 30);
        if (StringUtilities.isNotEmpty(schema) && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            result = schema + "." + (String)result;
        }
        return result;
    }

    private void appendAutoIncrementSequence(String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String autoIncrementStartWith = column.getAutoIncrementStartWith();
        Integer autoIncrementIncrementBy = column.getAutoIncrementIncrementBy();
        String autoIncrementMaxValue = column.getAutoIncrementMaxValue();
        String autoIncrementMinValue = column.getAutoIncrementMinValue();
        Integer autoIncrementCache = column.getAutoIncrementCache();
        SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 0);
        SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CREATE");
        SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "SEQUENCE");
        SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequenceName));
        String advancedComment = buffer.toString();
        SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
        SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "AS");
        SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "INTEGER");
        if (autoIncrementStartWith != null && !"".equals(autoIncrementStartWith)) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "START");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "WITH");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, autoIncrementStartWith);
        }
        if (autoIncrementIncrementBy != null && autoIncrementIncrementBy != 1) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, autoIncrementIncrementBy);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "BY");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "1");
        }
        if (autoIncrementMinValue != null) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "MINVALUE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, autoIncrementMinValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "MINVALUE");
        }
        if (autoIncrementMaxValue != null) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "MAXVALUE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, autoIncrementMaxValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "MAXVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CYCLE");
        }
        if (column.isAutoIncrementDisableCache()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CACHE");
        } else if (autoIncrementCache != null) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, autoIncrementCache);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CACHE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "20");
        }
        if (column.isAutoIncrementOrder()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "ORDER");
        }
        SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBAutoIncrementColumnUDB.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBAutoIncrementColumnUDB.appendNewLine(oldbuffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    private void appendAutoIncrementTrigger(String triggerName, String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxyUDB columnProxy;
        Table table = (Table)column.getParent();
        TableProxyUDB tableProxy = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxyUDB)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableName = this.storageDesign.getFormatedName(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CASCADE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "BEFORE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "INSERT");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "ON");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, tableName);
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "FOR");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "EACH");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "ROW");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "MODE DB2SQL");
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "WHEN");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, '(');
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "IS");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NULL");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, ')');
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "SET");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, '=');
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, sequenceName + ".NEXTVAL");
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnUDB.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnUDB.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
        }
    }

    private void appendAutoIncrementTriggerExpr(String triggerName, String triggerExpr, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxyUDB columnProxy;
        Table table = (Table)column.getParent();
        TableProxyUDB tableProxy = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxyUDB)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableName = this.storageDesign.getFormatedName(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "NO");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "CASCADE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "BEFORE");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "INSERT");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "ON");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, tableName);
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "FOR");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "EACH");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "ROW");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "MODE DB2SQL");
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, "SET");
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, columnName);
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, '=');
            SSBAutoIncrementColumnUDB.appendStringWithSpace(buffer, triggerExpr);
            SSBAutoIncrementColumnUDB.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnUDB.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAutoIncrementColumnUDB.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
        }
    }
}

