/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TriggerOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerOraclev9i
extends AbstractSSBOracle {
    private StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        TriggerOraclev9i trigger = (TriggerOraclev9i)object;
        this.appendComment(oldbuffer, trigger);
        if (!trigger.getActions().trim().equalsIgnoreCase("")) {
            this.storageDesign = (StorageDesignOracle)trigger.getStorageDesign();
            this.appendCreateOrReplace(buffer, trigger);
            advancedComment = buffer.toString();
            this.appendTriggeringTime(buffer, trigger, prettyPrint);
            this.appendDMLEvent(buffer, trigger);
            this.appendReferencingClause(buffer, trigger, prettyPrint);
            this.appendCondition(buffer, trigger, prettyPrint);
            this.appendTriggeredAction(buffer, trigger, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTriggerOraclev9i.appendString(oldbuffer, '/');
            }
            SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
            if (!"".equals(trigger.getState())) {
                buffer = new StringBuffer();
                this.appendAlterTrigger(buffer, trigger);
                advancedComment = buffer.toString();
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getState());
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTriggerOraclev9i.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTrigger();
            }
            SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        } else {
            SSBTriggerOraclev9i.appendStringWithSpace(oldbuffer, "--error invalid trigger: without action - " + trigger.getLongNameDDL());
            SSBTriggerOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendCreateOrReplace(StringBuffer buffer, TriggerOraclev9i trigger) {
        this.appendCreateOrReplace(buffer);
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, "TRIGGER");
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger));
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerOraclev9i trigger, boolean prettyPrint) {
        SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getTriggerTime());
    }

    private void appendDMLEvent(StringBuffer buffer, TriggerOraclev9i trigger) {
        for (int i = 0; i < trigger.getActionSet().size(); ++i) {
            if (i > 0) {
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "OR");
            }
            String action = trigger.getActionSet().elementAt(i).toString();
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, action);
            if (!action.equals(Trigger.ACTION_TYPES[1]) || trigger.getColumns().equalsIgnoreCase("")) continue;
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, "OF");
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(trigger.getColumns()));
        }
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, "ON");
        if (trigger.getTable() != null) {
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger.getTable()));
        } else if (trigger.getView() != null) {
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger.getView()));
        }
    }

    private void appendReferencingClause(StringBuffer buffer, TriggerOraclev9i trigger, boolean prettyPrint) {
        if (!(trigger.getRef_NEW_AS().equalsIgnoreCase("") && trigger.getRef_OLD_AS().equalsIgnoreCase("") && trigger.getRef_PARENT_AS().equalsIgnoreCase(""))) {
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, "REFERENCING");
            if (!trigger.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "NEW");
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "AS");
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getRef_NEW_AS());
            }
            if (!trigger.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "OLD");
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "AS");
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getRef_OLD_AS());
            }
            if (!trigger.getRef_PARENT_AS().equalsIgnoreCase("")) {
                SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "PARENT");
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, "AS");
                SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getRef_PARENT_AS());
            }
        }
        if (trigger.isScopeForEachRow()) {
            SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getScope());
        }
    }

    private void appendCondition(StringBuffer buffer, TriggerOraclev9i trigger, boolean prettyPrint) {
        if (!trigger.getCondition().equalsIgnoreCase("")) {
            SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, "WHEN");
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, trigger.getCondition());
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerOraclev9i trigger, boolean prettyPrint) {
        SSBTriggerOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        String body = trigger.getBody().trim();
        if (body.length() == 0) {
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerOraclev9i.appendStringWithSpace(buffer, body);
            if (!body.endsWith(";")) {
                SSBTriggerOraclev9i.appendString(buffer, ';');
            }
        }
    }

    private void appendAlterTrigger(StringBuffer buffer, TriggerOraclev9i trigger) {
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, "ALTER");
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, "TRIGGER");
        SSBTriggerOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger));
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerOraclev9i && ((TriggerOraclev9i)object).isMarkedGenerate() && (((TriggerOracle)object).getTable() != null || ((TriggerOracle)object).getView() != null) && !((TriggerOraclev9i)object).isCWDGenerated();
    }

    public void doAppendTrigger(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        this.doAppend(oldbuffer, object, prettyPrint);
    }
}

