/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBIndexOraclev9i;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueSetOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableOraclev9i
extends AbstractSSBOracle {
    private SSBIndexOraclev9i ssbIndex = null;
    private StorageDesignOraclev9i storageDesign;
    private Table table;
    private TableProxyOraclev9i tableProxy = null;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyOraclev9i && ((TableProxyOracle)object).getSnapshot() == null;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        this.table = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            this.table = (Table)object;
            Design design = this.table.getDesign();
            RDBMSSite site = this.table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)this.getStorageDesign();
            this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        } else if (object instanceof TableProxyOraclev9i) {
            this.tableProxy = (TableProxyOraclev9i)object;
            this.table = (Table)this.tableProxy.getObject();
            Design design = this.table.getDesign();
            this.storageDesign = (StorageDesignOraclev9i)this.tableProxy.getStorageDesign();
        } else {
            return;
        }
        if (this.tableProxy != null && !this.tableProxy.isMarkedGenerate()) {
            this.appendIndexes(oldbuffer, this.tableProxy, prettyPrint);
            return;
        }
        if (this.table != null) {
            if (this.table.getTypeSubstitution() == null) {
                if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                    this.appendComment(oldbuffer, this.tableProxy);
                } else {
                    this.appendComment(oldbuffer, this.table);
                }
                if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                this.appendBeforeCreateScript(oldbuffer, prettyPrint, this.table);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CREATE");
                if (this.tableProxy == null) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.table));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.table, null, prettyPrint);
                    this.appendOid(buffer, this.table, null, prettyPrint);
                } else if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GLOBAL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TEMPORARY");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.tableProxy));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.table, this.tableProxy, prettyPrint);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ON");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "COMMIT");
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "PRESERVE ROWS");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DELETE ROWS");
                    }
                    this.appendOid(buffer, this.table, null, prettyPrint);
                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "CACHE");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
                    }
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(this.tableProxy));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.table, this.tableProxy, prettyPrint);
                    this.appendOid(buffer, this.table, this.tableProxy, prettyPrint);
                    this.appendCluster(buffer, this.tableProxy, prettyPrint);
                    if (!"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                        this.appendColumnProperties(buffer, this.tableProxy, prettyPrint);
                        this.appendPartitionList(buffer, this.tableProxy, prettyPrint);
                        if (this.tableProxy.getCluster() == null && !"INDEX".equals(this.tableProxy.getOrganization())) {
                            if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                                SSBTableOraclev9i.appendStringWithSpace(buffer, "CACHE");
                            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
                            }
                        }
                        if ("YES".equalsIgnoreCase(this.tableProxy.getMonitoring())) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "MONITORING");
                        }
                        if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
                            if (!"".equalsIgnoreCase(this.tableProxy.getDegree())) {
                                SSBTableOraclev9i.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                            }
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
                        }
                        this.appendRowDependency(buffer, prettyPrint);
                    } else if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
                        if (!"".equalsIgnoreCase(this.tableProxy.getDegree())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementCreateTable();
                if (!"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                    if (this.tableProxy != null) {
                        this.appendColumnCheckConstraints(oldbuffer, this.tableProxy, prettyPrint);
                        this.appendTableLevelCheckConstraints(oldbuffer, this.tableProxy, prettyPrint);
                        SSBTableOraclev9i.appendExistenceDependencyConstraints(oldbuffer, this.tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                        SSBTableOraclev9i.appendOptionalFKCheckConstraints(oldbuffer, this.tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                        if (this.getArcConstrHandler() != null) {
                            this.getArcConstrHandler().appendArcConstraints(oldbuffer, this.tableProxy, prettyPrint);
                        }
                    }
                    if (this.table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                        this.appendTableCommentOn(oldbuffer, this.table, this.tableProxy, prettyPrint);
                    }
                    if (this.tableProxy != null) {
                        this.appendIndexes(oldbuffer, this.tableProxy, prettyPrint);
                        this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
                        if (this.table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                            this.appendSubstitutionTrigger(oldbuffer, this.table, this.tableProxy, prettyPrint);
                            this.appendColumnSubstitutionTrigger(oldbuffer, this.table, this.tableProxy, prettyPrint);
                        }
                    }
                } else if (this.tableProxy != null) {
                    this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
                }
                this.appendAfterCreateScript(oldbuffer, prettyPrint, this.table);
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            } else {
                SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "-- Table " + this.table.getName() + ": is a part of type substitution hierarchy");
            }
        }
        SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
    }

    private void appendRowDependency(StringBuffer buffer, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(this.tableProxy.getRowDependency())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ROWDEPENDENCIES");
            ClusterOracle cluster = this.tableProxy.getCluster();
            if (cluster != null && !cluster.getRowDependency().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "--  ERROR: Cluster has different ROWDEPENDENCIES setting");
                DDLFileMaker.incrementErrors();
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOROWDEPENDENCIES");
        }
    }

    private void appendSubstitutionTrigger(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isBST() && table.getSubTypeSubstitutions().size() > 0) {
            Object types = "";
            Iterator it = table.getAllowedStrTypeInstances().iterator();
            boolean first = true;
            while (it.hasNext()) {
                StructuredType st = (StructuredType)it.next();
                StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                if (stp == null || !stp.getStructuredType().isInstantiable()) continue;
                String formattedLongName = this.storageDesign.getFormatedLongNameDDL(stp);
                if (first) {
                    types = st.getAllSubTypes().size() > 0 ? "ONLY " + formattedLongName : formattedLongName;
                    first = false;
                    continue;
                }
                types = (String)types + ", " + (String)(st.getAllSubTypes().size() > 0 ? "ONLY " + formattedLongName : formattedLongName);
            }
            if (!"".equals(types)) {
                ModelIDObject tableOwner;
                Object tr_name = this.storageDesign.getFormatedName("OBJ_SUBS_TR_" + this.getStringWithMaxLength(tableProxy.getName(), 18));
                if (this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (tableOwner = tableProxy.getSchemaImplementingObject()) != null) {
                    tr_name = this.storageDesign.getFormatedName(tableOwner) + "." + (String)tr_name;
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + (String)tr_name);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BEFORE INSERT ON " + this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "FOR EACH ROW");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BEGIN");
                this.appendCWDTableMeta(buffer, table, tableProxy, prettyPrint);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, " IF :new.sys_nc_rowinfo$ IS NOT OF ( " + (String)types + " ) THEN");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "  raise_application_error(-20222,' Only instances of " + ((String)types).replaceAll("ONLY ", "") + " are permitted');");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, " END IF;");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "END;");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "/");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendColumnSubstitutionTrigger(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        List columns = this.getColumnsWithManyRestrictedSubType(table);
        if (columns.size() > 0) {
            boolean first = true;
            boolean hasref = false;
            Object colnames = "";
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                ModelIDObject columnOrProxy = column;
                ColumnProxy cp = tableProxy.getColumnProxy(column.getObjectID());
                if (cp != null) {
                    columnOrProxy = cp;
                }
                names.add(columnOrProxy.getName());
                String formattedColName = this.storageDesign.getFormatedName(columnOrProxy);
                if (first) {
                    colnames = formattedColName;
                    first = false;
                } else {
                    colnames = (String)colnames + ", " + formattedColName;
                }
                if (!column.isReference()) continue;
                hasref = true;
            }
            if (!"".equals(colnames)) {
                Column column;
                ModelIDObject tableOwner;
                Object tr_name = this.storageDesign.getFormatedName(COLUMN_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 30 - COLUMN_SUBST_TR_PREFIX.length()));
                if (this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (tableOwner = tableProxy.getSchemaImplementingObject()) != null) {
                    tr_name = this.storageDesign.getFormatedName(tableOwner) + "." + (String)tr_name;
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + (String)tr_name);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BEFORE INSERT OR UPDATE OF " + (String)colnames + " ON " + this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "FOR EACH ROW");
                if (hasref) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DECLARE ");
                    for (int i = 0; i < columns.size(); ++i) {
                        column = (Column)columns.get(i);
                        if (!column.isReference()) continue;
                        StructuredType st = (StructuredType)column.getDataType();
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        String st_name = stp != null ? this.storageDesign.getFormatedLongNameDDL(stp) : this.storageDesign.getFormatedName(st);
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                        String colname = this.storageDesign.getFormatedName((String)names.get(i) + "$inst");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, " " + colname);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, st_name + ";");
                    }
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BEGIN");
                this.appendCWDColumnMeta(buffer, columns, prettyPrint);
                for (int i = 0; i < columns.size(); ++i) {
                    column = (Column)columns.get(i);
                    String colname = (String)names.get(i);
                    Object types = "";
                    Iterator it = column.getPermittedSubTypes().iterator();
                    first = true;
                    while (it.hasNext()) {
                        StructuredType st = (StructuredType)it.next();
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        if (stp == null || !stp.getStructuredType().isInstantiable()) continue;
                        String longName = this.storageDesign.getFormatedLongNameDDL(stp);
                        if (first) {
                            types = st.getAllSubTypes().size() > 0 ? "ONLY " + longName : longName;
                            first = false;
                            continue;
                        }
                        types = (String)types + ", " + (String)(st.getAllSubTypes().size() > 0 ? "ONLY " + longName : longName);
                    }
                    if (column.isReference()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, " SELECT deref(:new." + colname + ") INTO " + colname + "$inst FROM DUAL;");
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, " IF " + colname + "$inst IS NOT OF ( " + (String)types + " ) THEN");
                    } else {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, " IF :new." + colname + " IS NOT OF ( " + (String)types + " ) THEN");
                    }
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "  raise_application_error(-20222,'Column " + colname + " - Only instances of " + ((String)types).replaceAll("ONLY ", "") + " are permitted');");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, " END IF;");
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "END;");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "/");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendColumnProperties(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        ColumnProxy[] columnProxies = tableProxy.getColumnAndNestedColumnProxies();
        for (int i = 0; i < columnProxies.length; ++i) {
            ColumnProxyOraclev9i columnProxy = (ColumnProxyOraclev9i)columnProxies[i];
            Datatype datatype = columnProxy.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                    continue;
                }
                this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
        }
    }

    private void appendXMLTypeColumnProps(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        Column column = columnProxy.getColumn();
        if (column.isReference() && column.getUse() == 3) {
            return;
        }
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "XMLTYPE");
        SSBTableOraclev9i.appendStringWithSpace(buffer, "COLUMN");
        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE AS");
        if (columnProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
        } else {
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CLOB");
            String lobSegmentName = columnProxy.getLobSegmentName();
            if (lobSegmentName != null && lobSegmentName.length() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (columnProxy.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getTablespace()));
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "STORAGE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (columnProxy.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCInitialExtent());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (columnProxy.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCNextExtent());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCPctIncrease());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCMinExtents());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCMaxExtents());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && columnProxy.getSCFreelistGroups() > 1) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (columnProxy.getChunk() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CHUNK");
                SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getChunk());
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (columnProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "RETENTION");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTVERSION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getPCTVersion());
            }
            if (columnProxy.getFreepools() > 0 && columnProxy.getSCFreelistGroups() <= 1) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "FREEPOOLS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getFreepools());
            }
            this.appendStorageInRow(buffer, columnProxy.getStorageInRow(), prettyPrint);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getCache());
            if (!"CACHE".equalsIgnoreCase(columnProxy.getCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(columnProxy.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(columnProxy.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
        this.appendXMLSchemaSpec(buffer, columnProxy.getXmlSchemaUrl(), columnProxy.getXmlSchemaElement(), prettyPrint);
    }

    private void appendXMLSchemaSpec(StringBuffer buffer, String xmlSchemaUrl, String xmlSchemaElement, boolean prettyPrint) {
        if (xmlSchemaElement != null && xmlSchemaElement.length() > 0) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (xmlSchemaUrl != null && xmlSchemaUrl.length() > 0) {
                buffer.append("XMLSCHEMA").append(' ').append('\"').append(xmlSchemaUrl).append('\"');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            buffer.append("ELEMENT").append(' ').append('\"').append(xmlSchemaElement).append('\"').append(' ');
        }
    }

    private void appendVarrayColumnProp(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        if (this.hasVarrayClause(columnProxy)) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "VARRAY");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
            if (!columnProxy.getLobSegname().equals("")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE AS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "LOB");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getLobSegname()));
            }
        }
    }

    private void appendOid(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "OBJECT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "IDENTIFIER");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "IS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PRIMARY KEY");
            }
            if (!(tableProxy == null || tableProxy.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxy.getOidIndexName()))) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxy.getOidIndexName())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getOidIndexName()));
                }
                if (tableProxy.getOidIndexSegment() != null) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    this.appendSegment(buffer, (SegmentOraclev9i)tableProxy.getOidIndexSegment(), false, prettyPrint, null, "");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private void appendObjectTypeColProperties(StringBuffer buffer, Table table, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (table.isBST() && tableProxy != null) {
            boolean first = true;
            Column[] cols = (Column[])table.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Column column = cols[i];
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID());
                if (!this.shouldGenerateObjectPropDefinition(column, columnProxy)) continue;
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendString(buffer, ' ');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                this.appendColumnOptions(buffer, column, columnProxy, prettyPrint);
                this.appendColumnRefConstraint(buffer, column, columnProxy, prettyPrint);
                this.appendColumnConstraints(buffer, column, columnProxy, prettyPrint);
            }
            boolean nestedColNotNullChecksRequired = false;
            for (Column nestedColumn : table.getNestedElements()) {
                if (!nestedColumn.isMandatory()) continue;
                nestedColNotNullChecksRequired = true;
            }
            if (nestedColNotNullChecksRequired) {
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                }
                first = this.appendNestedColumnNotNullChecks(buffer, tableProxy, prettyPrint, first);
            }
            boolean TableChecksRequired = false;
            for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
                if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
                String rule = constraint.getTableConstraint().getRule();
                String cname = constraint.getName().toUpperCase();
                if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                    cname = "";
                }
                if (!"".equals(cname) || "".equals(rule)) continue;
                TableChecksRequired = true;
            }
            if (TableChecksRequired) {
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                }
                first = this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, first);
            }
            if (table.getOidPKColumns().size() > 0) {
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                this.appendPK_ObjectType(buffer, table, tableProxy, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOracle columnProxy) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String defaultValue = columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            return true;
        }
        return SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy);
    }

    private void appendPK_ObjectType(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        PKProxyOraclev9i pkProxy = this.getPKProxy(tableProxy);
        if (pkProxy != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy));
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PRIMARY KEY");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            boolean first = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID());
                if (first) {
                    first = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedName(columnProxy));
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendElementList(StringBuffer buffer, Table table, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxyOraclev9i columnProxy = null;
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        boolean ext_table = "EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization());
        if (table.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            ModelIDObject typeOrProxy = type = table.getBasedOnStructuredType();
            SSBTableOraclev9i.appendStringWithSpace(buffer, "OF");
            if (tableProxy != null && (typeProxy = (StructuredTypeProxyOracle)tableProxy.getStorageDesign().getProxy(type)) != null) {
                if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBTableOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                    SSBTableOraclev9i.appendString(buffer, '.');
                }
                typeOrProxy = typeProxy;
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeOrProxy));
            String typeName = ((ModelObject)typeOrProxy).getName();
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
                if (tableProxy != null) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "XMLTYPE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE AS");
                    if (tableProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "CLOB");
                        String lobSegmentName = tableProxy.getLobSegmentName();
                        if (lobSegmentName != null && lobSegmentName.length() > 0) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
                        }
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        if (tableProxy.getXmlTypeTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getXmlTypeTableSpace()));
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getChunk() > 0) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "CHUNK");
                            SSBTableOraclev9i.appendStringWithSpace(buffer, tableProxy.getChunk());
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (tableProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "RETENTION");
                        } else {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTVERSION");
                            SSBTableOraclev9i.appendStringWithSpace(buffer, tableProxy.getPCTVersion());
                        }
                        if (tableProxy.getFreepools() > 0) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "FREEPOOLS");
                            SSBTableOraclev9i.appendStringWithSpace(buffer, tableProxy.getFreepools());
                        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "FREEPOOLS");
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "1");
                        }
                        this.appendStorageInRow(buffer, tableProxy.getStorageInRow(), prettyPrint);
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, tableProxy.getXmlTypeCache());
                        if (!"CACHE".equalsIgnoreCase(tableProxy.getXmlTypeCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                            if ("YES".equalsIgnoreCase(tableProxy.getXmlTypeLogging())) {
                                SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(tableProxy.getXmlTypeLogging())) {
                                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                            }
                        }
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                    }
                    this.appendXMLSchemaSpec(buffer, tableProxy.getXmlSchemaUrl(), tableProxy.getXmlSchemaElement(), prettyPrint);
                }
            } else {
                if (!table.isSubstitutable()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(buffer, table, tableProxy, prettyPrint);
            }
        } else if (columns.length < 1) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "-- No Columns");
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        } else {
            HashMap<Column, ColumnProxyOraclev9i> map = new HashMap<Column, ColumnProxyOraclev9i>();
            int max = 0;
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (tableProxy == null) continue;
                columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
                String fname = this.storageDesign.getFormatedName(columnProxy);
                int l = fname.length();
                if (max < l) {
                    max = l;
                }
                map.put(column, columnProxy);
            }
            boolean first = true;
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                if (column.isOid()) continue;
                if (first) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                }
                if (tableProxy != null && (columnProxy = (ColumnProxyOraclev9i)map.get(column)) == null) {
                    columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
                }
                if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                if (this.endsWithNewline(buffer)) {
                    this.appendTab(buffer, prettyPrint, 1);
                } else {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBTableOraclev9i.appendString(buffer, ' ');
                String fname = this.storageDesign.getFormatedName(columnProxy);
                SSBTableOraclev9i.appendStringWithSpace(buffer, fname, max - fname.length() + 1);
                Object datatypeString = "";
                Datatype type = column.getDataType();
                if (type instanceof StructuredType || type instanceof CollectionType) {
                    if (!ext_table) {
                        RelationalObjectProxy proxy = this.storageDesign.getProxy(type);
                        if (proxy != null) {
                            datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                            if (column.isReference() && type instanceof StructuredType) {
                                datatypeString = "REF " + (String)datatypeString;
                            }
                        }
                    } else {
                        datatypeString = "VARCHAR2(4000)";
                    }
                }
                if (((String)datatypeString).equals("") && ((String)(datatypeString = column.getDatatypeString("Oracle9i"))).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    datatypeString = (String)datatypeString + " (4000)";
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, (String)datatypeString);
                if (((String)datatypeString).equalsIgnoreCase("unknown")) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 5);
                    DDLFileMaker.incrementErrors();
                } else if (((String)datatypeString).equals("VARCHAR2") || ((String)datatypeString).equals("NVARCHAR2") || ((String)datatypeString).equals("RAW")) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "--  ERROR: " + (String)datatypeString + " size not specified");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 5);
                    DDLFileMaker.incrementErrors();
                } else if (((String)datatypeString).equals("CHAR") || ((String)datatypeString).equals("NCHAR")) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "--  WARNING: CHAR size not specified");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 5);
                    DDLFileMaker.incrementWarnings();
                }
                if (tableProxy == null || ext_table) continue;
                this.appendColumnOptions(buffer, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                this.appendColumnConstraints(buffer, column, columnProxy, prettyPrint);
            }
            if (tableProxy != null && !ext_table) {
                this.appendNestedColumnNotNullChecks(buffer, tableProxy, prettyPrint, false);
                if ("INDEX".equalsIgnoreCase(tableProxy.getOrganization())) {
                    this.appendPKDefinitionConstraint(buffer, tableProxy, prettyPrint);
                }
                this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, false);
                this.appendSupplementalLoggings(buffer, tableProxy, prettyPrint);
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendInlineRefConstraint(StringBuffer buffer, Column column, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        this.appendWithRowid(buffer, column, columnProxy, prettyPrint);
    }

    private void appendColumnRefConstraint(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        this.appendWithRowid(buffer, column, columnProxy, prettyPrint);
    }

    private void appendWithRowid(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "WITH");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ROWID");
        }
    }

    private void appendColumnOptions(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        this.appendWithDefaultDefinition(buffer, columnProxy);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev9i.appendString(buffer, ' ');
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        boolean isSDOpen = columnProxy.getStorageDesign().isOpen();
        String defaultValue = "";
        Column column = columnProxy.getColumn();
        defaultValue = !isSDOpen ? column.getDefaultValue() : columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            String dt = column.getDatatypeString("Oracle9i");
            String df = this.addQuotesToDefault(dt, defaultValue);
            SSBTableOraclev9i.appendStringWithSpace(buffer, df);
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy) && column.isGenerateConstraintInDDL()) {
            String cname;
            String text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy), columnProxy.getStorageDesign().getRDBMSType());
            String string = cname = columnProxy.isCheckConstraintNameChanged() ? columnProxy.getCheckConstraintName() : columnProxy.getColumn().getConstraintName();
            if (!cname.equals("") && !cname.toUpperCase().startsWith("SYS_") && cname.length() <= 30) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev9i.appendString(buffer, '(');
            SSBTableOraclev9i.appendString(buffer, text);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendConstraintState(buffer, columnProxy, true, prettyPrint);
        }
    }

    private PKProxyOraclev9i getPKProxy(TableProxyOracle tableProxy) {
        KeyObject pk = ((Table)tableProxy.getObject()).getPK();
        if (pk != null) {
            return (PKProxyOraclev9i)((StorageDesignOraclev9i)tableProxy.getStorageDesign()).getPKProxySet().getProxy(pk.getObjectID());
        }
        return null;
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        PKProxyOraclev9i pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null && pk.isMarkedGenerate()) {
            Index ind = (Index)pk.getObject();
            if (!"".equalsIgnoreCase(pk.getColumns()) || !"".equals(ind.getIndexExpression())) {
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                    this.appendComment(oldbuffer, pk);
                } else if (!"".equalsIgnoreCase(ind.getComment())) {
                    this.appendComment(oldbuffer, ind);
                }
                String pkName = pk.getName();
                if (pkName.length() > tableProxy.getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ALTER");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                advancedComment = buffer.toString();
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ADD");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PRIMARY KEY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                if (!"".equals(ind.getIndexExpression())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ind.getIndexExpression());
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, pk.getColumns(this.storageDesign));
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                    this.appendUsingIndex(buffer, pk, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(pk.getEnable())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(pk.getValidate())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTableOraclev9i.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
                if (pk.getRely().equals("YES")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ALTER");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getTableProxy()));
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MODIFY");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                    advancedComment = buffer.toString();
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "RELY");
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendLineFinisher(buffer, prettyPrint);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementAlterTable();
                }
            }
        }
    }

    private void appendPKDefinitionConstraint(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        PKProxyOraclev9i pk;
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendString(buffer, ' ');
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PRIMARY KEY");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, pk.getColumns(this.storageDesign));
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            if (!("NO".equalsIgnoreCase(pk.getUsingIndex()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "BY INDEX NAME".equalsIgnoreCase(pk.getUsingIndex()) && pk.getExistingIndex() != null)) {
                this.appendUsingIndex(buffer, pk, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tableProxy.getSuplementalLogGroupName())) {
            this.appendComma(buffer);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "SUPPLEMENTAL");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "LOG");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "GROUP");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getSuplementalLogGroupName()));
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getSuplementalLogColumns()));
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ALWAYS");
            }
        }
    }

    private boolean appendTableConstraintsDefinition(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint, boolean first) {
        for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
            if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
            String rule = constraint.getTableConstraint().getRule();
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            if (!"".equals(cname) || "".equals(rule)) continue;
            if (first) {
                first = false;
            } else {
                this.appendComma(buffer);
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendString(buffer, ' ');
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev9i.appendString(buffer, '(');
            SSBTableOraclev9i.appendString(buffer, rule);
            SSBTableOraclev9i.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
        }
        return first;
    }

    private void appendTableConstraintState(StringBuffer buffer, TableCheckConstraintOracle constraint, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(constraint.getDeferrable())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(constraint.getInitially())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(constraint.getEnable())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(constraint.getEnable())) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(constraint.getValidate())) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (constraint.getExceptionsTable() != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "EXCEPTIONS");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "INTO");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(constraint.getExceptionsTable()));
        }
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = this.tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LOCAL");
                } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)pkProxy.getIndexSegment(), false, prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOSORT");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SORT");
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "REVERSE");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SORT");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        } else {
            boolean temporaryTable = this.tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(unique.getUsingIndex())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LOCAL");
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)unique.getIndexSegment(), false, prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOSORT");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "SORT");
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "REVERSE");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SORT");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                }
                if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
                }
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "RANGE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev9i)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "GLOBAL");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "RANGE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev9i)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev9i globalPartitionList, boolean prettyPrint) {
        IndexGlobalPartitionSetOraclev9i globalPartitionSet = (IndexGlobalPartitionSetOraclev9i)((StorageDesignOraclev9i)globalPartitionList.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] globalPartitionsList = globalPartitionSet.toArray();
        Arrays.sort(globalPartitionsList, new GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < globalPartitionsList.length; ++i) {
            sortedList.add(globalPartitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexGlobalPartitionOraclev9i globalPartition = (IndexGlobalPartitionOraclev9i)setIt.next();
            if (globalPartition.getIndexGlobalPartList() == null || !globalPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(globalPartitionList.toString())) continue;
            if (first) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "VALUES LESS THAN");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, globalPartition.getValueList());
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            if (globalPartition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)globalPartition.getSegment(), false, prettyPrint, globalPartition.getTableSpace(), globalPartition.getLogging());
                continue;
            }
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        block5: {
            block4: {
                if (tableProxy == null) break block4;
                if (this.storageDesign == null) {
                    this.storageDesign = (StorageDesignOraclev9i)tableProxy.getStorageDesign();
                }
                this.appendCommentOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                ColumnProxy col = null;
                for (int i = 0; i < columnProxies.length; ++i) {
                    col = columnProxies[i];
                    String comment = col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged() ? col.getCommentInRDBMS() : col.getColumn().getCommentInRDBMS();
                    if (comment.equalsIgnoreCase("")) continue;
                    String name = this.storageDesign.getFormatedLongNameDDL(tableProxy) + "." + this.storageDesign.getFormatedName(col);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    StringBuffer tempBuffer = new StringBuffer();
                    SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "COMMENT ON");
                    SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "COLUMN");
                    SSBTableOraclev9i.appendStringWithSpace(tempBuffer, name);
                    String advancedComment = tempBuffer.toString();
                    SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "IS");
                    SSBTableOraclev9i.appendString(tempBuffer, '\'');
                    SSBTableOraclev9i.appendString(tempBuffer, this.replaceSingleQuote(comment));
                    SSBTableOraclev9i.appendStringWithSpace(tempBuffer, '\'');
                    this.appendToBuffer(buffer, tempBuffer, advancedComment);
                    SSBTableOraclev9i.appendNewLine(tempBuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendLineFinisher(tempBuffer, prettyPrint);
                    this.appendToBuffer(buffer, tempBuffer, advancedComment);
                }
                break block5;
            }
            if (table == null) break block5;
            String tableComment = table.getCommentInRDBMS();
            if (tableComment != null && !"".equalsIgnoreCase(tableComment)) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                StringBuffer tempBuffer = new StringBuffer();
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "COMMENT ON");
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "TABLE");
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, this.storageDesign.getFormatedLongNameDDL(table));
                String advancedComment = tempBuffer.toString();
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "IS");
                SSBTableOraclev9i.appendString(tempBuffer, '\'');
                SSBTableOraclev9i.appendString(tempBuffer, this.replaceSingleQuote(tableComment));
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, '\'');
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
                SSBTableOraclev9i.appendNewLine(tempBuffer, prettyPrint, 0);
                SSBTableOraclev9i.appendLineFinisher(tempBuffer, prettyPrint);
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
            }
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                String columnComment = col.getCommentInRDBMS();
                if (columnComment == null || "".equalsIgnoreCase(columnComment)) continue;
                String name = this.storageDesign.getFormatedLongNameDDL(table) + "." + this.storageDesign.getFormatedName(col);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                StringBuffer tempBuffer = new StringBuffer();
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "COMMENT ON");
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "COLUMN");
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, name);
                String advancedComment = tempBuffer.toString();
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, "IS");
                SSBTableOraclev9i.appendString(tempBuffer, '\'');
                SSBTableOraclev9i.appendString(tempBuffer, this.replaceSingleQuote(columnComment));
                SSBTableOraclev9i.appendStringWithSpace(tempBuffer, '\'');
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
                SSBTableOraclev9i.appendNewLine(tempBuffer, prettyPrint, 0);
                SSBTableOraclev9i.appendLineFinisher(tempBuffer, prettyPrint);
                this.appendToBuffer(buffer, tempBuffer, advancedComment);
            }
        }
    }

    public void appendPartitionList(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            this.tableProxy = tableProxy;
            this.table = (Table)tableProxy.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev9i)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                    if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                        if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "1");
                    }
                } else {
                    this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                }
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "LIST");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITIONS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "OVERFLOW");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, tableProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "LIST");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, tableProxy, prettyPrint);
            }
        }
    }

    private void appendListSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TEMPLATE");
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                ListStorageTemplatePartitionOraclev9i temp = (ListStorageTemplatePartitionOraclev9i)templates.getElement(i);
                if (i > 0) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "VALUES");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                if (!"".equalsIgnoreCase(temp.getValueList())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, temp.getValueList());
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (tableProxy.getListStorageTemplates().size() > 0) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TEMPLATE");
            Iterator setIt = tableProxy.getListStorageTemplates().iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev9i partition = (HashPartitionOraclev9i)setIt.next();
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                this.appendPartStorage(buffer, partition, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        StorageObjectCollection lobs = null;
        AbstractStorageObjectOracle owningPartition = null;
        if (template instanceof HashPartitionOraclev9i) {
            tableSpace = ((HashPartitionOraclev9i)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev9i)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev9i)template).getLobs();
            owningPartition = ((HashPartitionOraclev9i)template).getSubPartitionOf();
        } else if (template instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpace = ((ListStorageTemplatePartitionOraclev9i)template).getTablespace();
            lobs = ((ListStorageTemplatePartitionOraclev9i)template).getLobs();
            owningPartition = ((ListStorageTemplatePartitionOraclev9i)template).getSubPartitionOf();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "OVERFLOW");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (lobs != null) {
            for (Object storageObject : lobs) {
                HashPartitionLobItemOraclev9i lobItem;
                if (storageObject instanceof LobStorageOraclev9i) {
                    LobStorageOraclev9i lobStorage = (LobStorageOraclev9i)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev9i) || (lobItem = (HashPartitionLobItemOraclev9i)storageObject).getTableSpace() == null) continue;
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                String lobSegName = lobItem.getName();
                if (owningPartition != null && (lobSegName.startsWith("SYS_LOB") || lobSegName.startsWith(lobItem.getIDPrefix()))) {
                    lobSegName = "";
                }
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), lobSegName, lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "VALUES");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getSegment(), true, prettyPrint, partition.getTablespace(), partition.getLogging());
            } else {
                String logging;
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && (logging = partition.getLogging()).length() > 0) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    if (logging.equalsIgnoreCase("YES")) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                    } else if (logging.equalsIgnoreCase("NO")) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (this.table.isSpatialTable()) continue;
            for (LobStorageOracle lob : partition.getLobStorages()) {
                this.appendLobStorage(buffer, (LobStorageOraclev9i)lob, prettyPrint);
            }
        }
        if (!first) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        StorageObjectCollection partitions = this.tableProxy.getPartitions();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator setIt = sortedList.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                Object partitionObj = setIt.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "VALUES LESS THAN");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, partition.getValueList());
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                if (partition.getSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)partition.getSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
                } else {
                    if (partition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTableSpace()));
                    }
                    if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if (partition.getLogging().equalsIgnoreCase("NO")) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if (partition.getLogging().equalsIgnoreCase("YES")) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
                if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
                } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
                }
                SegmentOracle overflowSegment = partition.getIOTOverflowSegment();
                if (overflowSegment != null) {
                    TableSpaceOracle overflowTableSpace = overflowSegment.getTableSpace();
                    if (overflowTableSpace == null) {
                        overflowTableSpace = partition.getTableSpace();
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "OVERFLOW");
                    this.appendSegment(buffer, (SegmentOraclev9i)overflowSegment, true, prettyPrint, overflowTableSpace, partition.getLogging());
                }
                if (!this.table.isSpatialTable()) {
                    for (LobStorageOracle lob : partition.getLobs()) {
                        this.appendLobStorage(buffer, (LobStorageOraclev9i)lob, prettyPrint);
                    }
                }
                if (!composite) continue;
                if (partitionList.getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH")) {
                    if (this.appendHashSubPartitions(buffer, (PartitionOraclev9i)partition, partitionList, prettyPrint) || partition.getSubPartitionsQuantity() <= 0) continue;
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, partition.getSubPartitionsQuantity());
                    if ("".equalsIgnoreCase(partition.getSubPartitionsTableSpaces())) continue;
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partition.getSubPartitionsTableSpaces()));
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (partition.getListPartitions().size() <= 0) continue;
                boolean firstListPart = true;
                Iterator listPartitions = partition.getListPartitions().iterator();
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                while (listPartitions.hasNext()) {
                    ListStorageTemplatePartitionOraclev9i listPartition = (ListStorageTemplatePartitionOraclev9i)listPartitions.next();
                    if (!firstListPart) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                    } else {
                        firstListPart = false;
                    }
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                    if (!listPartition.getName().toUpperCase().startsWith("SYS_")) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listPartition));
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "VALUES");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(buffer, listPartition.getValueList());
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                    this.appendPartStorage(buffer, listPartition, prettyPrint);
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
            if (!first) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, PartitionOraclev9i partition, PartitionListOraclev9i partitionList, boolean prettyPrint) {
        boolean result = false;
        if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            HashPartitionSetOracle hashPartitionSet = ((StorageDesignOracle)partition.getStorageDesign()).getHashPartitionSet();
            Iterator setIt = hashPartitionSet.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)setIt.next();
                if (hashPartition.getSubPartitionOf() != partition) continue;
                if (first) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                this.appendPartStorage(buffer, hashPartition, prettyPrint);
            }
            if (!first) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    private boolean appendHashPartitions(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        boolean result = false;
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)it.next();
            if (first) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOraclev9i hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOraclev9i hashPLobItemSet = (HashPartitionLobItemSetOraclev9i)((StorageDesignOraclev9i)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        for (HashPartitionLobItemOraclev9i hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        SSBTableOraclev9i.appendStringWithSpace(buffer, "LOB");
        SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                DDLFileMaker.incrementErrors();
            }
        }
        SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOraclev9i lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "LOB");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE AS");
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "STORAGE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (lobStorage.getChunk() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CHUNK");
                SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getChunk());
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "RETENTION");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTVERSION");
                SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "FREEPOOLS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            this.appendStorageInRow(buffer, lobStorage.getStorageInRow(), prettyPrint);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, lobStorage.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(lobStorage.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorage.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendStorageInRow(StringBuffer buffer, String enableDisable, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(enableDisable)) {
            if (!"INDEX".equals(this.tableProxy.getOrganization())) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "STORAGE IN ROW");
            }
        } else {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "STORAGE IN ROW");
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev9i segment, boolean pctUsed, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null && segment.isMarkedGenerate()) {
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTFREE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (pctUsed && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTUSED");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "1");
                    }
                    if (segment.getMaxTrans() > 1) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "STORAGE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendTableSpace(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        TableSpaceOracle tableSpace;
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = tableProxy.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendOrganization(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        boolean indexOrg = "INDEX".equalsIgnoreCase(tableProxy.getOrganization());
        if (indexOrg) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ORGANIZATION");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "INDEX");
        } else if ("EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization())) {
            this.appendExternalTableClause(buffer, tableProxy, prettyPrint);
            this.appendRejectLimit(buffer, tableProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() && !this.table.isBST()) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ORGANIZATION");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "HEAP");
        }
        if (!"EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization())) {
            if (tableProxy.getSegment() == null) {
                this.appendTableSpace(buffer, tableProxy, prettyPrint);
                if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(tableProxy.getLogging())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(tableProxy.getLogging())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            } else {
                this.appendSegment(buffer, (SegmentOraclev9i)tableProxy.getSegment(), !indexOrg, prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging());
            }
        }
        if (indexOrg) {
            if (tableProxy.getIOTMappingTable().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "MAPPING TABLE");
            }
            if (tableProxy.getIotPctThreshold() > 0) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                SSBTableOraclev9i.appendStringWithSpace(buffer, tableProxy.getIotPctThreshold());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "50");
            }
            if (tableProxy.getIotCompress() > 0) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, tableProxy.getIotCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            TableSpaceOracle overflowTableSpace = tableProxy.getIotOverflowTablespace();
            String overflowLogging = tableProxy.getIotOverflowLogging();
            SegmentOraclev9i overflowSegment = (SegmentOraclev9i)tableProxy.getIotOverflowSegment();
            ColumnProxy includingColumn = tableProxy.getIotIncluding();
            if (overflowTableSpace != null || !overflowLogging.equals("") || overflowSegment != null || includingColumn != null) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                if (includingColumn != null) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "INCLUDING");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(includingColumn));
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "OVERFLOW");
                if (overflowTableSpace == null) {
                    overflowTableSpace = tableProxy.getTableSpace();
                }
                if (overflowLogging.equals("")) {
                    overflowLogging = tableProxy.getLogging();
                }
                if (overflowSegment != null) {
                    this.appendSegment(buffer, overflowSegment, true, prettyPrint, overflowTableSpace, overflowLogging);
                } else {
                    if (overflowTableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                        if ("NO".equalsIgnoreCase(overflowLogging)) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if ("YES".equalsIgnoreCase(overflowLogging)) {
                            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
            }
        } else if (!"EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization())) {
            if (tableProxy.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
        }
        if ("YES".equalsIgnoreCase(tableProxy.getPartitioned())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxy.getParttitionedRowMovement())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        ClusterOraclev9i cluster = (ClusterOraclev9i)tableProxy.getCluster();
        if (cluster != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CLUSTER");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(tableProxy.getClusterColumns())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getClusterColumns()));
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendOrganization(buffer, tableProxy, prettyPrint);
            if (!this.table.isSpatialTable()) {
                for (int i = 0; i < tableProxy.getLobStorages().size(); ++i) {
                    this.appendLobStorage(buffer, (LobStorageOraclev9i)tableProxy.getLobStorages().getElement(i), prettyPrint);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null) {
            UniqueSetOraclev9i uniqueSet = (UniqueSetOraclev9i)((StorageDesignOraclev9i)tableProxy.getStorageDesign()).getUniqueSet();
            Iterator it = uniqueSet.iterator();
            while (it.hasNext()) {
                UniqueOraclev9i unique = (UniqueOraclev9i)it.next();
                Index ind = (Index)unique.getObject();
                if (unique.getTableProxy() != tableProxy || !unique.isMarkedGenerate()) continue;
                if (unique.getColumnProxies().length == 0 && "".equals(ind.getIndexExpression())) {
                    SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "-- Error - Unique Constraint " + unique.getTable() + "." + unique.getName() + " doesn't have columns");
                    DDLFileMaker.incrementErrors();
                    continue;
                }
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
                    this.appendComment(oldbuffer, unique);
                } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
                    this.appendComment(oldbuffer, unique.getObject());
                }
                String uniqueName = unique.getName();
                if (uniqueName.length() > tableProxy.getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                ColumnProxy[] columns = unique.getColumnProxies();
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ALTER");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                advancedComment = buffer.toString();
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ADD");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
                SSBTableOraclev9i.appendStringWithSpace(buffer, "UNIQUE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                if (!"".equals(ind.getIndexExpression())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ind.getIndexExpression());
                } else {
                    for (int i = 0; i < columns.length; ++i) {
                        ColumnProxy column = columns[i];
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
                        if (i >= columns.length - 1) continue;
                        SSBTableOraclev9i.appendStringWithSpace(buffer, ',');
                    }
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
                }
                if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
                    this.appendUniqueUsingIndex(buffer, unique, prettyPrint);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if ("YES".equalsIgnoreCase(unique.getEnable())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                    }
                    if ("YES".equalsIgnoreCase(unique.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                } else {
                    if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                        if ("YES".equalsIgnoreCase(unique.getValidate())) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
                    }
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTableOraclev9i.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
                if (!unique.getRely().equals("YES")) continue;
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ALTER");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getTableProxy()));
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "MODIFY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
                advancedComment = buffer.toString();
                SSBTableOraclev9i.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendLineFinisher(buffer, prettyPrint);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendNotNullDefinition(StringBuffer buffer, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String nncName = null;
        if (!this.table.getAppView().getSettings().notNullShortFormGeneration()) {
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : columnProxy.getColumn().getNotNullConstraintName();
            if (nncName != null && nncName.startsWith("SYS_")) {
                nncName = null;
            }
        }
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxy.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxy.getNncValidate()) || nncName != null && !"".equals(nncName)) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendString(buffer, ' ');
            if (nncName != null && !"".equals(nncName)) {
                if (this.tableProxy != null && nncName.length() > this.tableProxy.getMaxNameLength()) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "--  ERROR: Column " + this.tableProxy.getName() + "." + columnProxy.getName() + " check constraint name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendString(buffer, ' ');
                    DDLFileMaker.incrementErrors();
                }
                nncName = this.storageDesign.getFormatedName(nncName);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, nncName);
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT NULL");
            this.appendNotNullConstraintState(buffer, columnProxy);
        } else {
            SSBTableOraclev9i.appendString(buffer, ' ');
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT NULL");
        }
    }

    private boolean appendNestedColumnNotNullChecks(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint, boolean first) {
        for (Column nestedColumn : this.table.getNestedElements()) {
            String nncName;
            ColumnProxyOraclev9i columnProxy;
            if (!nestedColumn.isMandatory() || (columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(nestedColumn.getObjectID())) == null) continue;
            if (first) {
                first = false;
            } else {
                this.appendComma(buffer);
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendString(buffer, ' ');
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : nestedColumn.getNotNullConstraintName();
            if (nncName != null && !nncName.isEmpty() && !nncName.startsWith("SYS_")) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nncName));
            }
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            SSBTableOraclev9i.appendStringWithSpace(buffer, "IS");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT NULL");
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            this.appendNotNullConstraintState(buffer, columnProxy);
        }
        return first;
    }

    private void appendNotNullConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable())) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getNncInitially())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "INITIALLY");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
    }

    private String getPermissionsON(PermissionsOracle permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongNameDDL();
        }
        if (permissions.getColumnsTable() != null) {
            return permissions.getColumnsTable().getLongNameDDL();
        }
        return "";
    }

    private String getPermissionsTO(PermissionsOracle permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getName();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer buffer, PermissionsOracle permissions) {
        buffer.append(permissions.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        buffer.append(permissions.getPrivilegesWithGrantOption());
    }

    private void appendPermissions(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        Object advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)tableProxy.getStorageDesign()).getPermissionsSet();
        for (PermissionsOraclev9i permissions : permissionsSet) {
            if (permissions.getTable() != null && permissions.getTable().equals(tableProxy)) {
                if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendComment(buffer, permissions);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivileges(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                }
                if (!permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivilegesWithGrantOption(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                }
            }
            if (permissions.getColumnsTable() == null || !permissions.getColumnsTable().equals(tableProxy)) continue;
            for (int i = 0; i < 2; ++i) {
                List<String> colEntries = i == 0 ? permissions.getColumnEntries() : permissions.getColumnWithGrantOptionEntries();
                for (String colEntry : colEntries) {
                    int commaIndex = colEntry.indexOf(44);
                    if (commaIndex <= -1) continue;
                    String colName = colEntry.substring(0, commaIndex).trim();
                    String colPriv = colEntry.substring(commaIndex + 1).trim();
                    if (colName.length() <= 0 || colPriv.length() <= 0) continue;
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "GRANT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, colPriv);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    ColumnProxy columnProxy = tableProxy.getColumnProxyByName(colName);
                    if (columnProxy != null) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(colName));
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    if (i > 0) {
                        this.appendGrantOption(buffer, permissions);
                    }
                    advancedComments = buffer.toString();
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                }
            }
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOracle permissions, boolean prettyPrint) {
        TableProxyOracle tableProxy = permissions.getTable();
        if (tableProxy == null) {
            tableProxy = permissions.getColumnsTable();
        }
        if (tableProxy != null) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    public void appendIndexes(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        Iterator it;
        if (this.storageDesign == null) {
            this.storageDesign = (StorageDesignOraclev9i)tableProxy.getStorageDesign();
        }
        if ((it = tableProxy.getIndexes().iterator()).hasNext()) {
            PKProxyOracle pkProxy;
            KeyObject pk;
            IndexProxyOracle skipIndex = null;
            SnapshotOracle snapshot = tableProxy.getSnapshot();
            if (snapshot != null && (pk = ((Table)tableProxy.getObject()).getPK()) != null && !snapshot.shouldGenerateSnapshotPK(pk) && (pkProxy = (PKProxyOracle)this.storageDesign.getPKProxySet().getProxy(pk.getObjectID())) != null) {
                skipIndex = pkProxy.getExistingIndex();
            }
            while (it.hasNext()) {
                SSBIndexOraclev9i ssbIndex;
                Object object = it.next();
                if (object instanceof IndexProxyOracle && ((IndexProxyOracle)object).getIndex().isSpatialIndex() || object == skipIndex || !(ssbIndex = this.getSSBIndex()).canHandle(object)) continue;
                ssbIndex.doAppend(buffer, object, prettyPrint);
            }
        }
        Table table = (Table)tableProxy.getObject();
        this.appendIndexesForConstraints(buffer, table, tableProxy);
    }

    private void appendNestedTableColumnProp(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint) {
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "NESTED");
        SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
        String storageTableName = columnProxy.getNtStorageTable();
        if (storageTableName.trim().isEmpty()) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "--  WARNING: Using column name as default storage_table name for nested column " + columnProxy.getName());
            DDLFileMaker.incrementWarnings();
            storageTableName = columnProxy.getName();
        }
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "STORE AS");
        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(storageTableName));
        if (!columnProxy.getAdditionalNTS().equals("")) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getAdditionalNTS());
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
        if (!columnProxy.getNtReturn().equals("")) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "RETURN");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "AS");
            SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getNtReturn());
        }
    }

    private void appendSubstitutableColumnClause(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, boolean prettyPrint, boolean columnClause) {
        Column column = columnProxy.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (columnClause && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxy.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "IS");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "OF");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "TYPE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType st = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        if (stp != null) {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(stp));
                        } else {
                            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(st));
                        }
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, columnProxy.getElementType());
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (columnProxy.getSubtitutable().equals("YES") || columnProxy.getSubtitutable().equals("NO")) {
                    if (columnClause) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    if (columnProxy.getSubtitutable().equals("NO")) {
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (columnClause) {
                        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                        SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "AT");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "ALL");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "LEVELS");
                }
            } else {
                if (columnClause) {
                    SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev9i.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                }
                SSBTableOraclev9i.appendStringWithSpace(buffer, "NOT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "AT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ALL");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev9i columnProxy) {
        return !columnProxy.getSubtitutable().equals("") || !columnProxy.getLobSegname().equals("");
    }

    private void appendCWDTableMeta(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        List list = table.getAllSubstitutionTables();
        if (list.size() > 0) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Table tab = (Table)list.get(i);
            StructuredType st = tab.getBasedOnStructuredType();
            StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
            String name = st.getName();
            if (stp != null) {
                name = this.storageDesign.getFormatedLongNameDDL(stp);
            }
            st = tab.getBasedOnStructuredType().getParentType();
            stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
            String parentName = st.getName();
            if (stp != null) {
                parentName = this.storageDesign.getFormatedLongNameDDL(stp);
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "-- <cwd_ts_tab table=\"" + tab.getName() + "\" type=\"" + name + "\" parent_type=\"" + parentName + "\" />");
        }
    }

    private void appendCWDColumnMeta(StringBuffer buffer, List columns, boolean prettyPrint) {
        if (columns.size() > 0) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            for (StructuredType st : column.getPermittedSubTypes()) {
                StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                String name = st.getName();
                if (stp != null) {
                    name = stp.getLongNameDDL();
                }
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + name + "\" />");
            }
        }
    }

    private void appendColumnCheckConstraints(StringBuffer oldbuffer, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        ColumnProxy[] cols_pr = tableProxy.getColumnAndNestedColumnProxies();
        for (int i = 0; i < cols_pr.length; ++i) {
            String cname;
            ColumnProxyOracle columnProxy = (ColumnProxyOracle)cols_pr[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || !column.isGenerateConstraintInDDL()) continue;
            String text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy), columnProxy.getStorageDesign().getRDBMSType());
            if (text.equals("")) {
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "--  WARNING: Column " + tableProxy.getName() + "." + columnProxy.getName() + " has no check constraint defined for this database type");
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementWarnings();
                continue;
            }
            String string = cname = columnProxy.isCheckConstraintNameChanged() ? columnProxy.getCheckConstraintName() : columnProxy.getColumn().getConstraintName();
            if (cname.length() > tableProxy.getMaxNameLength()) {
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Column " + tableProxy.getName() + "." + columnProxy.getName() + " check constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy)) continue;
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ALTER");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, formattedLongName);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ADD");
            if (!cname.equals("") && !cname.toUpperCase().startsWith("SYS_") && cname.length() <= 30) {
                cname = this.storageDesign.getFormatedName(cname);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(buffer, cname);
            }
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBTableOraclev9i.appendString(buffer, text);
            SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            SSBTableOraclev10g.appendConstraintState(buffer, columnProxy, false, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + cname;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableLevelCheckConstraints(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
            if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
            String rule = constraint.getTableConstraint().getRule();
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            if ("".equals(cname) || "".equals(rule)) continue;
            SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            if (cname.length() > tableProxy.getMaxNameLength()) {
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTableOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            String formattedConstraintName = this.storageDesign.getFormatedName(constraint);
            String formattedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ALTER");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, formattedLongName);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ADD");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, formattedConstraintName);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CHECK");
            SSBTableOraclev9i.appendString(buffer, '(');
            SSBTableOraclev9i.appendString(buffer, rule);
            SSBTableOraclev9i.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + formattedConstraintName;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxyOracle tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            SnapshotOracle sn;
            Index index = (Index)keys[i];
            if (genUK && "Unique Constraint".equals(index.getIndexState()) || genFK && index.isFK()) {
                Index ind2;
                ContainedObject[] cols2 = index.getElements();
                if (cols2.length <= 0 || (ind2 = SSBTableOraclev10g.getIndexUsableForColumns(table, index, cols2, true)) != null) continue;
                if (index.isFK()) {
                    ind2 = SSBTableOraclev10g.getPK_UK_AutoIndexCoveringFK_Constr(table, index, cols2, genPK, genUK, this.storageDesign);
                }
                if (ind2 != null) continue;
                SSBIndexOraclev9i ssbIndex = this.getSSBIndex();
                ssbIndex.appendIndexForConstraint(oldbuffer, index, true);
                continue;
            }
            if (!genPK || !"Primary Constraint".equals(index.getIndexState()) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) || (sn = tableProxy.getSnapshot()) != null && !sn.shouldGenerateSnapshotPK(index) || (cols = index.getElements()).length <= 0 || (ind = SSBTableOraclev10g.getIndexUsableForColumns(table, index, cols, true)) != null) continue;
            SSBIndexOraclev9i ssbIndex = this.getSSBIndex();
            ssbIndex.appendIndexForConstraint(oldbuffer, index, true);
        }
    }

    private SSBIndexOraclev9i getSSBIndex() {
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev9i();
        }
        return this.ssbIndex;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    private void appendExternalTableClause(StringBuffer buffer, TableProxyOracle table, boolean prettyPrint) {
        String defDirName;
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "ORGANIZATION");
        SSBTableOraclev9i.appendStringWithSpace(buffer, "EXTERNAL");
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
        if (!"".equalsIgnoreCase(table.getAccessDriverType().trim())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "TYPE");
            SSBTableOraclev9i.appendStringWithSpace(buffer, table.getAccessDriverType());
        }
        if ((defDirName = table.getDefaultDirName()) != null && !defDirName.isEmpty()) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "DIRECTORY");
            SSBTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(defDirName));
        }
        if (table.getAccessParametersType().equalsIgnoreCase("Opaque Format Spec")) {
            Object spec = table.getOpaqueFormatSpec().trim();
            if ("ORACLE_HIVE".equalsIgnoreCase(this.tableProxy.getAccessDriverType())) {
                String tpname = this.tableProxy.getLongName();
                Table tab = (Table)this.tableProxy.getObject();
                String hiveName = tab.getProperty(MOHTable.HIVE_NAME);
                if (hiveName != null && !"".equals(hiveName.trim())) {
                    hiveName = hiveName.trim();
                    Object lname = hiveName;
                    String hiveSchema = tab.getProperty(MOHTable.HIVE_SCHEMA);
                    if (hiveSchema != null && !"".equals(hiveSchema.trim())) {
                        hiveSchema = hiveSchema.trim();
                        lname = hiveSchema + "." + hiveName;
                    }
                    if (!tpname.equalsIgnoreCase((String)lname)) {
                        if (!"".equalsIgnoreCase((String)spec)) {
                            if (((String)spec).indexOf("com.oracle.bigsql.tableName") == -1) {
                                spec = (String)spec + "\ncom.oracle.bigsql.tableName " + (String)lname;
                            }
                        } else {
                            spec = "com.oracle.bigsql.tableName " + (String)lname;
                        }
                    }
                }
            }
            if (!"".equalsIgnoreCase((String)spec)) {
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev9i.appendStringWithSpace(buffer, "ACCESS");
                SSBTableOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(buffer, (String)spec);
                SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else if (table.getAccessParametersType().equalsIgnoreCase("CLOB Subquery") && !"".equalsIgnoreCase(table.getClobSubquery())) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "ACCESS");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "USING");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "CLOB");
            SSBTableOraclev9i.appendStringWithSpace(buffer, table.getClobSubquery());
        }
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, "LOCATION");
        SSBTableOraclev9i.appendStringWithSpace(buffer, '(');
        if (!table.getLocation().startsWith("'")) {
            SSBTableOraclev9i.appendString(buffer, '\'');
        }
        SSBTableOraclev9i.appendString(buffer, table.getLocation());
        if (!table.getLocation().endsWith("'")) {
            SSBTableOraclev9i.appendStringWithSpace(buffer, '\'');
        }
        SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
        SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBTableOraclev9i.appendStringWithSpace(buffer, ')');
    }

    private void appendRejectLimit(StringBuffer buffer, TableProxyOracle table, boolean prettyPrint) {
        String rejectLimit = table.getRejectLimit();
        if (rejectLimit.length() > 0) {
            SSBTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev9i.appendStringWithSpace(buffer, "REJECT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, "LIMIT");
            SSBTableOraclev9i.appendStringWithSpace(buffer, rejectLimit);
        }
    }

    @Override
    public String appendConstraints(TableProxy tableProxy) {
        return this.appendConstraints(tableProxy, null);
    }

    public String appendConstraints(TableProxy tableProxy, SnapshotOracle snapshot) {
        StringBuffer sb = new StringBuffer();
        if (tableProxy instanceof TableProxyOraclev9i) {
            StorageObject genObject;
            this.tableProxy = (TableProxyOraclev9i)tableProxy;
            this.table = (Table)this.tableProxy.getObject();
            this.storageDesign = (StorageDesignOraclev9i)tableProxy.getStorageDesign();
            StorageObject storageObject = genObject = snapshot != null ? snapshot : tableProxy;
            if (genObject.isMarkedGenerate() && !"EXTERNAL".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                this.appendTableLevelCheckConstraints(sb, this.tableProxy, true);
            }
            if (snapshot != null || this.tableProxy.getSnapshot() == null) {
                if (this.table.getBasedOnStructuredType() == null && !"INDEX".equalsIgnoreCase(this.tableProxy.getOrganization())) {
                    if (snapshot == null) {
                        this.appendPKDefinition(sb, this.tableProxy, true);
                    } else {
                        KeyObject pk = this.table.getPK();
                        if (pk != null && snapshot.shouldGenerateSnapshotPK(pk)) {
                            this.appendPKDefinition(sb, this.tableProxy, true);
                        }
                    }
                }
                this.appendUniqueDefinition(sb, this.tableProxy, true);
            }
        }
        return sb.toString();
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOraclev9i)one).getPosition() > ((PartitionOraclev9i)two).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev9i)one).getPosition() < ((PartitionOraclev9i)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((IndexGlobalPartitionOraclev9i)one).getPosition() > ((IndexGlobalPartitionOraclev9i)two).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev9i)one).getPosition() < ((IndexGlobalPartitionOraclev9i)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

