/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerOraclev10g
extends AbstractSSBOracle {
    private StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        TriggerOraclev10g trigger = (TriggerOraclev10g)object;
        this.storageDesign = (StorageDesignOracle)trigger.getStorageDesign();
        if (!trigger.getActions().trim().equalsIgnoreCase("")) {
            StringBuffer buffer = new StringBuffer();
            this.appendPrompt(buffer, trigger, "TRIGGER");
            this.appendComment(oldbuffer, trigger);
            this.appendCreateOrReplace(buffer, trigger);
            String advancedComment = buffer.toString();
            this.appendTriggeringTime(buffer, trigger, prettyPrint);
            this.appendDMLEvent(buffer, trigger);
            this.appendReferencingClause(buffer, trigger, prettyPrint);
            this.appendCrossEditionClause(buffer, trigger, prettyPrint);
            String triggerState = trigger.getState();
            if (!"".equals(triggerState) && this.storageDesign instanceof StorageDesignOraclev11g) {
                SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, triggerState);
            }
            this.appendCondition(buffer, trigger, prettyPrint);
            this.appendTriggeredAction(buffer, trigger, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTriggerOraclev10g.appendString(oldbuffer, '/');
            }
            SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
            if (!"".equals(triggerState) && !(this.storageDesign instanceof StorageDesignOraclev11g)) {
                buffer = new StringBuffer();
                this.appendAlterTrigger(buffer, trigger);
                advancedComment = buffer.toString();
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, triggerState);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBTriggerOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTrigger();
            }
            SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        } else {
            SSBTriggerOraclev10g.appendStringWithSpace(oldbuffer, "--error invalid trigger: without action - " + this.storageDesign.getFormatedLongNameDDL(trigger));
            SSBTriggerOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendCreateOrReplace(StringBuffer buffer, TriggerOraclev10g trigger) {
        this.appendCreateOrReplace(buffer);
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, "TRIGGER");
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger));
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerOraclev10g trigger, boolean prettyPrint) {
        String triggerTime = trigger.getTriggerTime();
        if (triggerTime.equals("COMPOUND")) {
            triggerTime = "FOR";
        }
        SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, triggerTime);
    }

    private void appendDMLEvent(StringBuffer buffer, TriggerOraclev10g trigger) {
        for (int i = 0; i < trigger.getActionSet().size(); ++i) {
            if (i > 0) {
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "OR");
            }
            String action = trigger.getActionSet().elementAt(i).toString();
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, action);
            if (!action.equals(Trigger.ACTION_TYPES[1]) || trigger.getColumns().equalsIgnoreCase("")) continue;
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, "OF");
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(trigger.getColumns()));
        }
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, "ON");
        if (trigger.getTable() != null) {
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger.getTable()));
        } else if (trigger.getView() != null) {
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger.getView()));
        }
    }

    private void appendReferencingClause(StringBuffer buffer, TriggerOraclev10g trigger, boolean prettyPrint) {
        if (trigger.getRef_NEW_AS() != null && !trigger.getRef_NEW_AS().equalsIgnoreCase("") || trigger.getRef_OLD_AS() != null && !trigger.getRef_OLD_AS().equalsIgnoreCase("") || trigger.getRef_PARENT_AS() != null && !trigger.getRef_PARENT_AS().equalsIgnoreCase("")) {
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, "REFERENCING");
            if (!trigger.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "NEW");
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "AS");
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, trigger.getRef_NEW_AS());
            }
            if (!trigger.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "OLD");
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "AS");
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, trigger.getRef_OLD_AS());
            }
            if (!trigger.getRef_PARENT_AS().equalsIgnoreCase("")) {
                SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "PARENT");
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, "AS");
                SSBTriggerOraclev10g.appendStringWithSpace(buffer, trigger.getRef_PARENT_AS());
            }
        }
        if (trigger.isScopeForEachRow() && !trigger.getTriggerTime().equals("COMPOUND")) {
            SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, trigger.getScope());
        }
    }

    private void appendCrossEditionClause(StringBuffer buffer, TriggerOraclev10g trigger, boolean prettyPrint) {
        String crossEdition = trigger.getCrossEdition();
        if ((crossEdition.equals("FORWARD") || crossEdition.equals("REVERSE")) && trigger.getTable() != null && this.storageDesign instanceof StorageDesignOraclev11g) {
            SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, crossEdition);
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, "CROSSEDITION");
        }
    }

    private void appendCondition(StringBuffer buffer, TriggerOraclev10g trigger, boolean prettyPrint) {
        if (!trigger.getCondition().equalsIgnoreCase("")) {
            SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, "WHEN");
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, '(');
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, trigger.getCondition());
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerOraclev10g trigger, boolean prettyPrint) {
        SSBTriggerOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        Object body = trigger.getBody().trim();
        if ("COMPOUND".equals(trigger.getTriggerTime()) && !((String)body).toLowerCase().startsWith("compound trigger")) {
            body = "compound trigger\n" + (String)body;
        }
        if (((String)body).length() == 0) {
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerOraclev10g.appendStringWithSpace(buffer, (String)body);
            if (!((String)body).endsWith(";")) {
                SSBTriggerOraclev10g.appendString(buffer, ';');
            }
        }
    }

    private void appendAlterTrigger(StringBuffer buffer, TriggerOraclev10g trigger) {
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, "ALTER");
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, "TRIGGER");
        SSBTriggerOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger));
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerOraclev10g && ((TriggerOraclev10g)object).isMarkedGenerate() && (((TriggerOracle)object).getTable() != null || ((TriggerOracle)object).getView() != null) && !((TriggerOraclev10g)object).isCWDGenerated();
    }

    public void doAppendTrigger(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        this.doAppend(oldbuffer, object, prettyPrint);
    }
}

