/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAlterTableScope
extends AbstractSSBOracle {
    private StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        Design design;
        Table table = null;
        TableProxyOracle tableProxy = null;
        if (object instanceof Table) {
            table = (Table)object;
            design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)this.getStorageDesign();
            tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyOracle) {
            tableProxy = (TableProxyOracle)object;
            table = (Table)tableProxy.getObject();
            design = table.getDesign();
            this.storageDesign = (StorageDesignOracle)tableProxy.getStorageDesign();
        } else {
            return;
        }
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxy columnProxy;
            column = columns[i];
            ContainerObject scopeTable = column.getScope();
            if (!(scopeTable instanceof Table) || !(column.getDataType() instanceof StructuredType) || !column.isReference() || column.isFKColumn()) continue;
            StringBuffer buffer = new StringBuffer();
            SSBAlterTableScope.appendStringWithSpace(buffer, "ALTER");
            SSBAlterTableScope.appendStringWithSpace(buffer, "TABLE");
            ModelIDObject tableObject = tableProxy;
            if (tableObject == null) {
                tableObject = table;
            }
            SSBAlterTableScope.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableObject));
            String advancedComment = buffer.toString();
            SSBAlterTableScope.appendNewLine(buffer, prettyPrint, 1);
            SSBAlterTableScope.appendStringWithSpace(buffer, "ADD");
            SSBAlterTableScope.appendStringWithSpace(buffer, '(');
            SSBAlterTableScope.appendStringWithSpace(buffer, "SCOPE");
            SSBAlterTableScope.appendStringWithSpace(buffer, "FOR");
            SSBAlterTableScope.appendStringWithSpace(buffer, '(');
            ModelIDObject columnObject = column;
            if (tableProxy != null && (columnProxy = tableProxy.getColumnProxy(column.getObjectID())) != null) {
                columnObject = columnProxy;
            }
            SSBAlterTableScope.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnObject));
            SSBAlterTableScope.appendStringWithSpace(buffer, ')');
            SSBAlterTableScope.appendStringWithSpace(buffer, "IS");
            ModelIDObject scopeTableObject = this.storageDesign.getTableProxySet().getProxy(scopeTable.getObjectID());
            if (scopeTableObject == null) {
                scopeTableObject = scopeTable;
            }
            SSBAlterTableScope.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(scopeTableObject));
            SSBAlterTableScope.appendStringWithSpace(buffer, ')');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAlterTableScope.appendNewLine(buffer, prettyPrint, 0);
            SSBAlterTableScope.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBAlterTableScope.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyOracle && ((TableProxyOracle)object).isMarkedGenerate() && ((TableProxyOracle)object).getSnapshot() == null;
    }
}

