/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSynonymDB2v80
extends SQLStatementBuilder {
    private static final String SET_CURRENT_SQLID = "SET CURRENT SQLID";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SynonymDB2 && ((SynonymDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SynonymDB2 synonym;
        if (object instanceof SynonymDB2 && (synonym = (SynonymDB2)object) != null) {
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
            this.appendComment(buffer, synonym);
            if (synonym.getOwner() != null) {
                if (!synonym.getOwner().isNullInstance()) {
                    SSBSynonymDB2v80.appendStringWithSpace(buffer, SET_CURRENT_SQLID);
                    SSBSynonymDB2v80.appendStringWithSpace(buffer, "=");
                    buffer.append(" '");
                    SSBSynonymDB2v80.appendString(buffer, storageDesign.getFormatedName(synonym.getOwner().getName()));
                    buffer.append("'");
                    SSBSynonymDB2v80.appendLineFinisher(buffer, prettyPrint);
                } else {
                    SSBSynonymDB2v80.appendStringWithSpace(buffer, SET_CURRENT_SQLID);
                    SSBSynonymDB2v80.appendStringWithSpace(buffer, "= USER");
                    SSBSynonymDB2v80.appendLineFinisher(buffer, prettyPrint);
                }
            }
            this.appendCreate(buffer);
            SSBSynonymDB2v80.appendStringWithSpace(buffer, "SYNONYM");
            SSBSynonymDB2v80.appendStringWithSpace(buffer, storageDesign.getFormatedName(synonym.getName()));
            SSBSynonymDB2v80.appendNewLine(buffer, prettyPrint, 1);
            if (synonym.getTable() != null) {
                SSBSynonymDB2v80.appendStringWithSpace(buffer, "FOR");
                if (synonym.getTable() != null) {
                    SSBSynonymDB2v80.appendString(buffer, storageDesign.getFormatedName(synonym.getTable().getLongNameDDL()));
                }
            } else if (synonym.getView() != null) {
                SSBSynonymDB2v80.appendStringWithSpace(buffer, "FOR");
                if (synonym.getView() != null) {
                    SSBSynonymDB2v80.appendString(buffer, storageDesign.getFormatedName(synonym.getView().getLongNameDDL()));
                }
            } else if (synonym.getAlias() != null) {
                SSBSynonymDB2v80.appendStringWithSpace(buffer, "FOR");
                if (synonym.getAlias() != null) {
                    SSBSynonymDB2v80.appendString(buffer, storageDesign.getFormatedName(synonym.getAlias().getLongNameDDL()));
                }
            }
            SSBSynonymDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBSynonymDB2v80.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateSynomym();
        }
    }
}

