/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.cubeviews;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class CVExportOptions
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(200, 20);
    private JTextField tfSchema;
    private JComboBox cbMDM;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private String schema = "";

    public CVExportOptions(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        this.result = false;
        this.design = this.getApplicationView().getCurrentDesign();
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel optionsPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder(""));
        JLabel lbFormula = new JLabel(Messages.getString("CVExportOptions.DefaultSchema"));
        lbFormula.setPreferredSize(this.prefDimension);
        lbFormula.setToolTipText(Messages.getString("CVExportOptions.UsedForDimensionalObjectsAndTables"));
        this.tfSchema = new JTextField("");
        this.tfSchema.setPreferredSize(this.prefDimension);
        this.tfSchema.setToolTipText(Messages.getString("CVExportOptions.UsedForDimensionalObjectsAndTables"));
        JPanel row = this.newRow(lbFormula, this.tfSchema);
        optionsPanel.add(row);
        MultidimensionalDesign mdm = this.design.getMultidimensionalDesign();
        JLabel lbMDM = new JLabel(Messages.getString("CVExportOptions.DimensionalModel"));
        lbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM = new JComboBox<Object>(this.design.getMultidimensionalDesigns().toArray());
        this.cbMDM.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM.setSelectedItem(mdm);
        row = this.newRow(lbMDM, this.cbMDM);
        optionsPanel.add(row);
        JLabel lbRelD = new JLabel(Messages.getString("CVExportOptions.RelationalModel"));
        ArrayList rlist = new ArrayList();
        rlist.add(null);
        this.design.getRelationalDesigns().addAllElementsTo(rlist);
        lbRelD.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        this.cbRelDes.setSelectedItem(null);
        row = this.newRow(lbRelD, this.cbRelDes);
        optionsPanel.add(row);
        JLabel lbStoreD = new JLabel(Messages.getString("CVExportOptions.PhysicalDB2UDBModel"));
        lbStoreD.setPreferredSize(this.prefDimension);
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        this.cbStorage.setSelectedItem(null);
        row = this.newRow(lbStoreD, this.cbStorage);
        optionsPanel.add(row);
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ob = CVExportOptions.this.cbRelDes.getSelectedItem();
                if (ob != null && ob instanceof RelationalDesign) {
                    RelationalDesign phd = (RelationalDesign)ob;
                    ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                    rlist.add(null);
                    StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < stds.length; ++i) {
                        StorageDesign sd = stds[i];
                        if (!(sd instanceof StorageDesignUDB)) continue;
                        rlist.add(sd);
                    }
                    CVExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                } else if (ob == null) {
                    CVExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        JPanel bottom = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(Messages.getString("CVExportOptions.OK"));
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVExportOptions.this.result = CVExportOptions.this.checkSettings();
                if (CVExportOptions.this.result) {
                    CVExportOptions.this.close();
                }
            }
        });
        bottom.add(okButton);
        JButton cancelButton = new JButton(Messages.getString("CVExportOptions.Cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVExportOptions.this.result = false;
                CVExportOptions.this.close();
            }
        });
        bottom.add(cancelButton);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bottom.add(bnHelp);
        okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)optionsPanel, "Center");
        jpanel.add((Component)bottom, "South");
        this.add(jpanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("CVExportOptions.CubeViewsMetadataExportOptions"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_CUBE_VIEWS_METADATA_DIALOG";
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private boolean checkSettings() {
        this.schema = this.tfSchema.getText();
        if ("".equalsIgnoreCase(this.schema)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CVExportOptions.SetDefaultSchema"), Messages.getString("CVExportOptions.Warning"), 2);
            return false;
        }
        this.physicalDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
        this.storageDesign = (StorageDesign)this.cbStorage.getSelectedItem();
        this.multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        return true;
    }

    private JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }
}

