/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHIndex
extends ExportHandler {
    public EHIndex(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Index_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ContainerID").append(",");
        sb.append("Num_ContainerID").append(",");
        sb.append("State Type").append(",");
        sb.append("Functional").append(",");
        sb.append("Expression").append(",");
        sb.append("Engineer").append(",");
        sb.append("Table_Name").append(",");
        sb.append("Spatial_Index").append(",");
        sb.append("Spatial_Layer_Type").append(",");
        sb.append("Geodetic_Index").append(",");
        sb.append("Number_Of_Dimensions");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            for (Index index : phDesign.getGlobalIndexSet()) {
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(index.getName())).append(",");
                sb.append(index.getObjectID()).append(",");
                sb.append(index.getNumID()).append(",");
                sb.append(index.getImportedId() != null ? index.getImportedId() : "").append(",");
                sb.append(index.getContainerObject().getObjectID()).append(",");
                sb.append(index.getContainerObject().getNumID()).append(",");
                sb.append(index.getIndexState()).append(",");
                sb.append(this.replaceAndQuoteString(index.getIndexExpression())).append(",");
                sb.append(index.hasIndexExpression() ? "Y" : "N").append(",");
                sb.append(index.getShouldEngineer() ? "Y" : "N").append(",");
                sb.append(this.replaceAndQuoteString(index.getContainerObject().getName())).append(",");
                sb.append(index.isSpatialIndex() ? "Y" : "N").append(",");
                if (index.isSpatialIndex()) {
                    sb.append(index.getLayerType() != null ? index.getLayerType() : "").append(",");
                    sb.append(index.getGeodetic().charAt(0)).append(",");
                    sb.append(index.getDimensionsNumber()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                lines.add(sb.toString());
                this.getCsvExporter().addNote(index.getObjectID(), index.getNumID(), "Index", index.getNotes());
                this.getCsvExporter().addComment(index.getObjectID(), index.getNumID(), "Index", index.getComment());
                this.getCsvExporter().addCommentRDBMS(index.getObjectID(), index.getNumID(), "Index", index.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Indexes.csv";
    }
}

