/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;

public class EHDomainAVT
extends ExportHandler {
    public EHDomainAVT(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Domain_ID").append(",");
        sb.append("Num_Domain_ID").append(",");
        sb.append("Sequence").append(",");
        sb.append("Value").append(",");
        sb.append("Short_Description").append(",");
        sb.append("Domain_Name");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            if (domain.getValueList() == null) continue;
            Iterator vit = domain.getValueIterator();
            int seq = 0;
            while (vit.hasNext()) {
                ++seq;
                Object key = vit.next();
                String value = (String)domain.getValueList().getValuesDescriptionMap().get(key);
                sb = new StringBuffer();
                sb.append(domain.getObjectID()).append(",");
                sb.append(domain.getNumID()).append(",");
                sb.append(seq).append(",");
                sb.append(key).append(",");
                sb.append(this.replaceAndQuoteString(value)).append(",");
                sb.append(this.replaceAndQuoteString(domain.getName())).append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Domain_AVT.csv";
    }
}

